/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample._simple_;

import com.dxfeed.api.DXFeed;
import com.dxfeed.event.candle.Candle;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FetchDailyCandles {
    private static final int DAYS = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String baseSymbol = args[0];
        CandleSymbol candleSymbol = CandleSymbol.valueOf((String)baseSymbol, (CandleSymbolAttribute)CandlePeriod.DAY);
        long toTime = System.currentTimeMillis();
        long fromTime = toTime - 1728000000L;
        System.out.printf("Fetching last %d days of candles for %s...%n", 20, baseSymbol);
        try {
            FetchDailyCandles.fetchAndPrint(candleSymbol, toTime, fromTime);
        }
        finally {
            System.exit(0);
        }
    }

    private static void fetchAndPrint(CandleSymbol candleSymbol, long toTime, long fromTime) {
        List result = (List)DXFeed.getInstance().getTimeSeriesPromise(Candle.class, (Object)candleSymbol, fromTime, toTime).await(5L, TimeUnit.SECONDS);
        for (Candle candle : result) {
            System.out.println(candle);
        }
    }
}

