/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.console;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.Trade;
import com.dxfeed.promise.Promise;
import com.dxfeed.promise.Promises;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class LastEventsConsole {
    public static void main(String[] args) throws IOException {
        String records = "Quote,Trade,Summary,Profile";
        String symbols = "http://dxfeed.s3.amazonaws.com/masterdata/ipf/demo/mux-demo.ipf.zip";
        DXEndpoint endpoint = DXEndpoint.newBuilder().withProperty("dxfeed.qd.subscribe.ticker", records + " " + symbols).build();
        DXFeed feed = endpoint.getFeed();
        System.out.println("Type symbols to get their quote, trade, summary, and profile event snapshots");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            String symbol = in.readLine();
            Promise quotePromise = feed.getLastEventPromise(Quote.class, (Object)symbol);
            Promise tradePromise = feed.getLastEventPromise(Trade.class, (Object)symbol);
            Promise summaryPromise = feed.getLastEventPromise(Summary.class, (Object)symbol);
            ArrayList<Promise> promises = new ArrayList<Promise>();
            promises.add(quotePromise);
            promises.add(tradePromise);
            promises.add(summaryPromise);
            if (!MarketEventSymbols.hasExchangeCode((String)symbol)) {
                Promise profilePromise = feed.getLastEventPromise(Profile.class, (Object)symbol);
                promises.add(profilePromise);
            }
            if (!Promises.allOf(promises).awaitWithoutException(1L, TimeUnit.SECONDS)) {
                System.out.println("Request timed out");
            }
            Iterator iterator = promises.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Promise promise = (Promise)iterator.next();
                System.out.println(promise.getResult());
            }
            break;
        }
    }
}

