/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.sample.ui.swing;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.Trade;
import com.dxfeed.sample.ui.swing.SwingExecutor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class DXFeedQuoteTable {
    private static final List<String> SYMBOLS = DXFeedQuoteTable.readSymbols("symbols.txt");
    private static final int N = SYMBOLS.size();
    private static final Map<String, Integer> SYMBOL_IDS = new HashMap<String, Integer>();
    private JPanel form;
    private JTable quoteTable;
    private final DefaultTableModel tableModel = new DefaultTableModel();
    private final Quote[] quotes = new Quote[N];
    private final Trade[] trades = new Trade[N];
    private final Summary[] summaries = new Summary[N];
    private final Profile[] profiles = new Profile[N];

    public DXFeedQuoteTable() {
        for (int i = 0; i < N; ++i) {
            this.quotes[i] = new Quote();
            this.trades[i] = new Trade();
            this.summaries[i] = new Summary();
            this.profiles[i] = new Profile();
        }
    }

    private static int getSymbolId(MarketEvent event) {
        return SYMBOL_IDS.get(event.getEventSymbol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readSymbols(String fileName) {
        Scanner in = new Scanner(new File(fileName));
        in.useDelimiter("[,\\s]+");
        try {
            ArrayList<String> result = new ArrayList<String>();
            while (in.hasNext()) {
                result.add(in.next());
            }
            ArrayList<String> arrayList = result;
            in.close();
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        DXEndpoint.getInstance().executor((Executor)new SwingExecutor(20));
        DXFeedQuoteTable instance = new DXFeedQuoteTable();
        SwingUtilities.invokeLater(instance::go);
    }

    private void go() {
        this.setupUI();
        this.initTableModel();
        this.initListeners();
        this.createFrame();
    }

    private void createFrame() {
        JFrame frame = new JFrame("DXFeed Quote Table");
        frame.add(this.form);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void initListeners() {
        DXFeed feed = DXFeed.getInstance();
        DXFeedSubscription quoteSub = feed.createSubscription(Quote.class);
        DXFeedSubscription tradeSub = feed.createSubscription(Trade.class);
        DXFeedSubscription summarySub = feed.createSubscription(Summary.class);
        DXFeedSubscription profileSub = feed.createSubscription(Profile.class);
        quoteSub.addEventListener(events -> {
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Quote quote;
                this.quotes[DXFeedQuoteTable.getSymbolId((MarketEvent)quote)] = quote = (Quote)iterator.next();
            }
            this.updateTableModel();
        });
        tradeSub.addEventListener(events -> {
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Trade trade;
                this.trades[DXFeedQuoteTable.getSymbolId((MarketEvent)trade)] = trade = (Trade)iterator.next();
            }
            this.updateTableModel();
        });
        summarySub.addEventListener(events -> {
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Summary summary;
                this.summaries[DXFeedQuoteTable.getSymbolId((MarketEvent)summary)] = summary = (Summary)iterator.next();
            }
            this.updateTableModel();
        });
        profileSub.addEventListener(events -> {
            Iterator iterator = events.iterator();
            while (iterator.hasNext()) {
                Profile profile;
                this.profiles[DXFeedQuoteTable.getSymbolId((MarketEvent)profile)] = profile = (Profile)iterator.next();
            }
            this.updateTableModel();
        });
        quoteSub.addSymbols(SYMBOLS);
        tradeSub.addSymbols(SYMBOLS);
        summarySub.addSymbols(SYMBOLS);
        profileSub.addSymbols(SYMBOLS);
    }

    private void initTableModel() {
        this.tableModel.addColumn("Symbol");
        this.tableModel.addColumn("Last");
        this.tableModel.addColumn("LastEx");
        this.tableModel.addColumn("Change");
        this.tableModel.addColumn("Bid");
        this.tableModel.addColumn("BidEx");
        this.tableModel.addColumn("Ask");
        this.tableModel.addColumn("AskEx");
        this.tableModel.addColumn("High");
        this.tableModel.addColumn("Low");
        this.tableModel.addColumn("Open");
        this.tableModel.addColumn("Bid Size");
        this.tableModel.addColumn("Ask Size");
        this.tableModel.addColumn("Last Size");
        this.tableModel.addColumn("Volume");
        this.tableModel.addColumn("Description");
        this.updateTableModel();
        this.quoteTable.setModel(this.tableModel);
    }

    private void updateTableModel() {
        this.tableModel.setNumRows(0);
        for (int i = 0; i < N; ++i) {
            Quote quote = this.quotes[i];
            Trade trade = this.trades[i];
            Summary summary = this.summaries[i];
            Profile profile = this.profiles[i];
            this.tableModel.addRow(new Object[]{SYMBOLS.get(i), trade.getPrice(), Character.valueOf(trade.getExchangeCode()), this.formatNetChange(trade.getPrice() - summary.getPrevDayClosePrice()), quote.getBidPrice(), Character.valueOf(quote.getBidExchangeCode()), quote.getAskPrice(), Character.valueOf(quote.getAskExchangeCode()), summary.getDayHighPrice(), summary.getDayLowPrice(), summary.getDayOpenPrice(), quote.getBidSizeAsDouble(), quote.getAskSizeAsDouble(), trade.getSizeAsDouble(), trade.getDayVolumeAsDouble(), profile.getDescription()});
        }
    }

    private String formatNetChange(double netChange) {
        netChange = Math.floor(netChange * 1.0E10 + 0.5) / 1.0E10;
        String netChangeStr = Double.toString(netChange);
        return (netChange > 0.0 ? "+" : "") + netChangeStr;
    }

    private void setupUI() {
        this.form = new JPanel();
        this.form.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.form.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)scrollPane1, gbc);
        scrollPane1.setPreferredSize(new Dimension(900, 600));
        this.quoteTable = new JTable();
        scrollPane1.setViewportView(this.quoteTable);
    }

    static {
        for (int i = 0; i < N; ++i) {
            SYMBOL_IDS.put(SYMBOLS.get(i), i);
        }
    }
}

