/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme;

import com.devexperts.qd.DataIntField;
import com.devexperts.qd.DataObjField;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.DefaultRecord;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.dxfeed.api.impl.ConfigurableDataScheme;
import com.dxfeed.api.impl.VersionedRecord;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.scheme.EmbeddedTypes;
import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.SchemeLoadingOptions;
import com.dxfeed.scheme.impl.SchemeModelLoader;
import com.dxfeed.scheme.impl.properties.DXFeedPropertiesConverter;
import com.dxfeed.scheme.model.SchemeModel;
import com.dxfeed.scheme.model.SchemeRecord;
import com.dxfeed.scheme.model.SchemeRecordGenerator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class DXScheme
extends DefaultScheme
implements ConfigurableDataScheme {
    private static final boolean[] REGIONAL_RECORDS_BUILD_ORDER = new boolean[]{false, true};
    private static final Properties DEFAULT_PROPERTIES = System.getProperties();
    private final SchemeModel model;
    private final SchemeLoadingOptions options;

    public static Loader newLoader() {
        return new Loader();
    }

    private DXScheme(SchemeModel model, SchemeLoadingOptions options, Properties properties) throws SchemeException {
        super((SymbolCodec)PentaCodec.INSTANCE, DXScheme.loadRecords(model, options, properties));
        this.model = model;
        this.options = options;
    }

    @Deprecated
    public DXScheme withProperties(Properties properties) {
        if (!this.options.shouldUseDXFeedProperties()) {
            return this;
        }
        try {
            return new DXScheme(this.model, this.options, properties);
        }
        catch (SchemeException e) {
            throw new IllegalArgumentException("Can not rebuild scheme: " + e.getMessage());
        }
    }

    private static DataRecord[] loadRecords(SchemeModel model, SchemeLoadingOptions options, Properties properties) throws SchemeException {
        SchemeModel propsModel;
        SchemeModel merged = model;
        if (properties == null) {
            properties = DEFAULT_PROPERTIES;
        }
        if ((propsModel = DXFeedPropertiesConverter.convertProperties(model.getEmbeddedTypes(), properties, options)) != null) {
            merged = ((SchemeModel.Builder)SchemeModel.newBuilder().withName("<with-props>").withTypes(model.getEmbeddedTypes())).build();
            merged.override(model);
            merged.override(propsModel);
            List<SchemeException> errors = merged.validateState();
            if (!errors.isEmpty()) {
                throw new SchemeException(errors, merged.getSources());
            }
        }
        ArrayList<DataRecord> result = new ArrayList<DataRecord>();
        for (boolean regional : REGIONAL_RECORDS_BUILD_ORDER) {
            for (SchemeModel.RecordSource src : merged.getRecordGenerationSources()) {
                switch (src.getSource()) {
                    case RECORD: {
                        SchemeRecord r = merged.getRecords().get(src.getName());
                        DXScheme.buildRecord(result, merged, r, r.getName(), regional);
                        break;
                    }
                    case GENERATOR: {
                        SchemeRecordGenerator g = merged.getGenerators().get(src.getName());
                        for (SchemeRecord t : g.getTemplates()) {
                            for (String actualRecordName : g.getRecordsNames(t)) {
                                DXScheme.buildRecord(result, merged, t, actualRecordName, regional);
                            }
                        }
                        break;
                    }
                }
            }
        }
        return result.toArray(new DataRecord[0]);
    }

    private static void buildRecord(List<DataRecord> result, SchemeModel scheme, SchemeRecord r, String recordName, boolean buildRegionals) throws SchemeException {
        DataRecord dr;
        if (r.hasRegionals() && buildRegionals) {
            for (char exchange : MarketEventSymbols.SUPPORTED_EXCHANGES.toCharArray()) {
                DataRecord dr2 = DXScheme.buildOneRecord(result.size(), scheme, r, recordName + '&' + exchange, true);
                if (dr2 == null) continue;
                result.add(dr2);
            }
        } else if (!buildRegionals && (dr = DXScheme.buildOneRecord(result.size(), scheme, r, recordName, false)) != null) {
            result.add(dr);
        }
    }

    private static DataRecord buildOneRecord(int idx, SchemeModel scheme, SchemeRecord r, String actualRecordName, boolean isRegional) throws SchemeException {
        boolean hasTime;
        if (!scheme.isRecordEnabled(r, actualRecordName)) {
            return null;
        }
        ArrayList<DataIntField> intFields = new ArrayList<DataIntField>();
        ArrayList<DataObjField> objFields = new ArrayList<DataObjField>();
        String i1 = r.getIndex1();
        String i2 = r.getIndex2();
        boolean bl = hasTime = i1 != null || i2 != null;
        if (hasTime) {
            boolean hasRealTimeField = DXScheme.addIndexField(intFields, scheme, r, actualRecordName, i1, isRegional);
            boolean bl2 = hasRealTimeField = DXScheme.addIndexField(intFields, scheme, r, actualRecordName, i2, isRegional) || hasRealTimeField;
            if (!hasRealTimeField) {
                throw new SchemeException(SchemeException.formatInconsistencyMessage(r, "All index fields have been disabled"), r.getFilesList());
            }
        }
        HashMap aliases = new HashMap();
        for (SchemeRecord.Field f : r.getFields()) {
            if (f.isCompositeOnly() && isRegional || !scheme.isRecordFieldEnabled(actualRecordName, f)) continue;
            String fieldName = actualRecordName + "." + f.getMainAlias();
            aliases.put(fieldName, new ArrayList());
            for (SchemeRecord.Field.Alias alias : f.getAliases()) {
                ((List)aliases.get(fieldName)).add(alias.getValue());
            }
            ((List)aliases.get(fieldName)).add(f.getName());
            if (f.getName().equals(i1) || f.getName().equals(i2)) continue;
            SerialFieldType type = scheme.resolveType(f.getType());
            if (type.isObject()) {
                DataObjField dataObjField = type.createDefaultObjInstance(objFields.size(), fieldName);
                if (dataObjField == null) {
                    throw new SchemeException(SchemeException.formatInconsistencyMessage(f, "Cannot construct field of type " + type), f.getFilesList());
                }
                objFields.add(dataObjField);
                continue;
            }
            intFields.add(type.createDefaultIntInstance(intFields.size(), fieldName));
            if (!type.isLong()) continue;
            intFields.add(SerialFieldType.VOID.createDefaultIntInstance(intFields.size(), fieldName + "$VoidTail"));
        }
        Object rec = actualRecordName.equals("Configuration") ? new VersionedRecord(idx, actualRecordName, hasTime, intFields.toArray(new DataIntField[0]), objFields.toArray(new DataObjField[0]), "Version") : new DefaultRecord(idx, actualRecordName, hasTime, intFields.toArray(new DataIntField[0]), objFields.toArray(new DataObjField[0]));
        for (String fieldName : aliases.keySet()) {
            for (String string : (List)aliases.get(fieldName)) {
                rec.addFieldAlias(fieldName, string);
            }
        }
        return rec;
    }

    private static boolean addIndexField(List<DataIntField> fields, SchemeModel scheme, SchemeRecord r, String actualRecordName, String index, boolean isRegional) {
        boolean realField;
        SchemeRecord.Field f = null;
        if (index != null && !DXScheme.isFieldEnabled(scheme, r, actualRecordName, f = r.getField(index), isRegional)) {
            f = null;
        }
        if (f != null) {
            SerialFieldType type = scheme.resolveType(f.getType());
            fields.add(type.createDefaultIntInstance(fields.size(), actualRecordName + "." + f.getMainAlias()));
            realField = true;
        } else {
            fields.add(SerialFieldType.VOID.createDefaultIntInstance(fields.size(), actualRecordName + ".$VoidTimeField"));
            realField = false;
        }
        return realField;
    }

    private static boolean isFieldEnabled(SchemeModel scheme, SchemeRecord r, String actualRecordName, SchemeRecord.Field field, boolean isRegional) {
        return (!field.isCompositeOnly() || !isRegional) && scheme.isRecordFieldEnabled(actualRecordName, field);
    }

    public static final class Loader {
        private EmbeddedTypes embeddedTypes = SchemeModelLoader.DEFAULT_TYPES;
        private SchemeLoadingOptions options = new SchemeLoadingOptions();
        private final Properties properties = new Properties();
        private final List<URL> urls = new ArrayList<URL>();

        private Loader() {
        }

        public Loader withTypes(EmbeddedTypes embeddedTypes) {
            this.embeddedTypes = Objects.requireNonNull(embeddedTypes, "embeddedTypesProvider");
            return this;
        }

        public Loader withOptions(SchemeLoadingOptions options) {
            this.options = Objects.requireNonNull(options, "options");
            return this;
        }

        @Deprecated
        public Loader withProperties(Properties props) {
            for (String key : props.stringPropertyNames()) {
                this.withProperty(key, props.getProperty(key));
            }
            return this;
        }

        @Deprecated
        public Loader withProperty(String key, String value) {
            this.properties.setProperty(Objects.requireNonNull(key, "key"), Objects.requireNonNull(value, "value"));
            return this;
        }

        public Loader fromURL(URL url) {
            this.urls.add(Objects.requireNonNull(url, "url"));
            return this;
        }

        public Loader fromURLs(Collection<URL> urls) {
            this.urls.addAll(Objects.requireNonNull(urls, "urls"));
            return this;
        }

        public Loader fromSpecification(String specification) throws IOException {
            this.urls.addAll(SchemeModelLoader.parseSpecification(Objects.requireNonNull(specification, "specification"), this.options));
            return this;
        }

        public DXScheme load() throws IOException, SchemeException {
            if (this.urls.isEmpty()) {
                throw new IllegalStateException("Cannot load scheme without URLs");
            }
            SchemeModel model = SchemeModelLoader.loadSchemeModel(this.urls, this.options, this.embeddedTypes);
            return new DXScheme(model, this.options, this.properties);
        }
    }
}

