/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.impl.properties;

import com.devexperts.logging.Logging;
import com.devexperts.util.GlobListUtil;
import com.devexperts.util.SystemProperties;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.scheme.EmbeddedTypes;
import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.SchemeLoadingOptions;
import com.dxfeed.scheme.model.NamedEntity;
import com.dxfeed.scheme.model.SchemeModel;
import com.dxfeed.scheme.model.SchemeRecordGenerator;
import com.dxfeed.scheme.model.SchemeType;
import com.dxfeed.scheme.model.VisibilityRule;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public final class DXFeedPropertiesConverter {
    private static final Logging log = Logging.getLogging(DXFeedPropertiesConverter.class);

    public static SchemeModel convertProperties(EmbeddedTypes embeddedTypes, Properties dxFeedProps, SchemeLoadingOptions options) {
        if (!options.shouldUseSystemProperties() && !options.shouldUseDXFeedProperties()) {
            return null;
        }
        try {
            SchemeModel file = ((SchemeModel.Builder)SchemeModel.newBuilder().withTypes(embeddedTypes)).withName("<dxfeed-properties>").build();
            if (options.shouldUseSystemProperties()) {
                DXFeedPropertiesConverter.loadTypeOverrides(file);
                DXFeedPropertiesConverter.loadRegionalsVisibility(file);
                DXFeedPropertiesConverter.loadOrderFieldsVisibility(file);
                DXFeedPropertiesConverter.loadGenerators(file);
            }
            if (options.shouldUseDXFeedProperties()) {
                DXFeedPropertiesConverter.loadGenericFieldsVisibility(file, dxFeedProps);
            }
            return file.isEmpty() ? null : file;
        }
        catch (Throwable t) {
            log.error("Cannot convert properties to scheme configuration: " + t.getMessage());
            return null;
        }
    }

    private static void loadRegionalsVisibility(SchemeModel file) {
        DXFeedPropertiesConverter.loadRegionalRecordVisibility(file, "Quote");
        DXFeedPropertiesConverter.loadRegionalRecordVisibility(file, "Trade");
        DXFeedPropertiesConverter.loadRegionalRecordVisibility(file, "TradeETH");
        DXFeedPropertiesConverter.loadRegionalRecordVisibility(file, "Summary");
        DXFeedPropertiesConverter.loadRegionalRecordVisibility(file, "Fundamental");
        DXFeedPropertiesConverter.loadRegionalRecordVisibility(file, "TimeAndSale");
        DXFeedPropertiesConverter.loadRegionalRecordVisibility(file, "Book");
    }

    private static void loadRegionalRecordVisibility(SchemeModel file, String rec) {
        String toEnable = DXFeedPropertiesConverter.getExchanges(rec);
        if (toEnable == null) {
            return;
        }
        StringBuilder toDisable = new StringBuilder();
        for (char exchange : MarketEventSymbols.SUPPORTED_EXCHANGES.toCharArray()) {
            if (toEnable.indexOf(exchange) != -1) continue;
            toDisable.append(exchange);
        }
        if (toEnable.length() > 0) {
            file.addVisibilityRule(new VisibilityRule(Pattern.compile(rec + "&[" + toEnable + "]"), false, null, true, file.getName()));
        }
        if (toDisable.length() > 0) {
            file.addVisibilityRule(new VisibilityRule(Pattern.compile(rec + "&[" + toDisable + "]"), false, null, false, file.getName()));
        }
    }

    private static void loadOrderFieldsVisibility(SchemeModel file) {
        DXFeedPropertiesConverter.enableOrderField(file, "Order", "Count");
        DXFeedPropertiesConverter.enableOrderField(file, "AnalyticOrder", "Count");
        DXFeedPropertiesConverter.enableOrderField(file, "OtcMarketsOrder", "Count");
        DXFeedPropertiesConverter.enableOrderField(file, "NuamOrder", "Count");
        DXFeedPropertiesConverter.enableOrderField(file, "SpreadOrder", "Count");
        DXFeedPropertiesConverter.enableOrderField(file, "Order", "MarketMaker");
        DXFeedPropertiesConverter.enableOrderField(file, "AnalyticOrder", "MarketMaker");
        DXFeedPropertiesConverter.enableOrderField(file, "OtcMarketsOrder", "MarketMaker");
        if (SystemProperties.getBooleanProperty((String)"dxscheme.fob", (boolean)false)) {
            String suffixes = SystemProperties.getProperty((String)"com.dxfeed.event.market.impl.Order.fob.suffixes", (String)"|#NTV|#NUAM");
            DXFeedPropertiesConverter.enableFOB(file, suffixes, "Order");
            DXFeedPropertiesConverter.enableFOB(file, suffixes, "AnalyticOrder");
            DXFeedPropertiesConverter.enableFOB(file, suffixes, "OtcMarketsOrder");
            DXFeedPropertiesConverter.enableFOB(file, suffixes, "NuamOrder");
            DXFeedPropertiesConverter.enableFOB(file, suffixes, "SpreadOrder");
        }
    }

    private static void enableOrderField(SchemeModel file, String rec, String field) {
        String prop = "com.dxfeed.event.order.impl." + rec + ".suffixes." + field.toLowerCase();
        String suffixes = SystemProperties.getProperty((String)prop, null);
        if (suffixes == null) {
            return;
        }
        file.addVisibilityRule(new VisibilityRule(Pattern.compile(rec + "(|#.+)"), false, Pattern.compile(field), false, file.getName()));
        file.addVisibilityRule(new VisibilityRule(Pattern.compile(rec + (suffixes.isEmpty() ? "" : "(" + suffixes + ")")), false, Pattern.compile(field), true, file.getName()));
    }

    private static void enableFOB(SchemeModel file, String suffixes, String rec) {
        VisibilityRule vr = new VisibilityRule(Pattern.compile(rec + (suffixes.isEmpty() ? "" : "(" + suffixes + ")")), false, null, true, file.getName());
        vr.addIncludedTag("fob");
        file.addVisibilityRule(vr);
    }

    private static void loadGenerators(SchemeModel file) {
        DXFeedPropertiesConverter.loadGenerator(file, "market.impl.Order", "Order", "#");
        DXFeedPropertiesConverter.loadGenerator(file, "market.impl.AnalyticOrder", "AnalyticOrder", "#");
        DXFeedPropertiesConverter.loadGenerator(file, "market.impl.OtcMarketsOrder", "OtcMarketsOrder", "#");
        DXFeedPropertiesConverter.loadGenerator(file, "market.impl.NuamOrder", "NuamOrder", "#");
        DXFeedPropertiesConverter.loadGenerator(file, "market.impl.SpreadOrder", "SpreadOrder", "#");
        DXFeedPropertiesConverter.loadGenerator(file, "candle.impl.Candle", "Candle", "");
        DXFeedPropertiesConverter.loadGenerator(file, "candle.impl.Trade", "OldStyleCandle", "");
    }

    private static void loadGenerator(SchemeModel file, String propName, String genName, String delimiter) {
        String prop = "com.dxfeed.event." + propName + ".suffixes";
        String suffixes = SystemProperties.getProperty((String)prop, null);
        if (suffixes == null) {
            return;
        }
        SchemeRecordGenerator gen = new SchemeRecordGenerator(genName, NamedEntity.Mode.UPDATE, "Automatically created from environment, using property " + prop, file.getName());
        gen.setIteratorMode(SchemeRecordGenerator.IteratorMode.REPLACE);
        for (String s : suffixes.split("\\|")) {
            if (!delimiter.isEmpty() && s.startsWith(delimiter)) {
                s = s.substring(delimiter.length());
            }
            gen.addIteratorValue(s);
        }
        try {
            file.addGenerator(gen);
        }
        catch (SchemeException e) {
            log.error("Cannot create set of suffixes from " + prop + ": " + e.getMessage());
        }
    }

    private static void loadGenericFieldsVisibility(SchemeModel file, Properties props) {
        HashSet<String> seenPropNames = new HashSet<String>();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(objKey, objValue) -> {
            String propertyName;
            String key = (String)objKey;
            if (key.startsWith("dxscheme.enabled.") && seenPropNames.add(propertyName = key.substring("dxscheme.enabled.".length()))) {
                file.addVisibilityRule(new VisibilityRule(GlobListUtil.compile((String)((String)objValue)), true, Pattern.compile(Pattern.quote(propertyName)), true, file.getName()));
            }
        }));
        if (Boolean.parseBoolean(props.getProperty("dxscheme.nanoTime"))) {
            if (seenPropNames.add("Sequence")) {
                file.addVisibilityRule(new VisibilityRule(Pattern.compile(".*"), true, Pattern.compile(Pattern.quote("Sequence")), true, file.getName()));
            }
            if (seenPropNames.add("TimeNanoPart")) {
                file.addVisibilityRule(new VisibilityRule(Pattern.compile(".*"), true, Pattern.compile(Pattern.quote("TimeNanoPart")), true, file.getName()));
            }
        }
    }

    private static void loadTypeOverrides(SchemeModel file) throws SchemeException {
        DXFeedPropertiesConverter.overrideOneType(file, "price", "decimal", "dxscheme.price");
        DXFeedPropertiesConverter.overrideOneType(file, "size", "compact_int", "dxscheme.size");
        DXFeedPropertiesConverter.overrideOneType(file, "volume", "decimal", "dxscheme.volume", "dxscheme.size");
        DXFeedPropertiesConverter.overrideOneType(file, "turnover", "decimal", "dxscheme.turnover", "dxscheme.size");
        DXFeedPropertiesConverter.overrideOneType(file, "oi", "decimal", "dxscheme.oi");
        DXFeedPropertiesConverter.overrideOneType(file, "decimal", "tiny_decimal", new String[0]);
        DXFeedPropertiesConverter.overrideOneType(file, "int_or_decimal", "compact_int", new String[0]);
        DXFeedPropertiesConverter.overrideTimeType(file, "bid_ask_time", "time_seconds", "dxscheme.bat");
    }

    private static void overrideOneType(SchemeModel file, String name, String defaultType, String ... typeSelectors) throws SchemeException {
        String targetType = defaultType;
        String reason = null;
        if (SystemProperties.getBooleanProperty((String)"dxscheme.wide", (boolean)true)) {
            targetType = "wide_decimal";
            reason = "dxscheme.wide=true or default";
        }
        int i = typeSelectors.length;
        while (--i >= 0) {
            String selector = System.getProperty(typeSelectors[i]);
            if ("wide".equalsIgnoreCase(selector)) {
                targetType = "wide_decimal";
                reason = typeSelectors[i] + "=" + selector;
            }
            if ("tiny".equalsIgnoreCase(selector) || "decimal".equalsIgnoreCase(selector)) {
                targetType = "tiny_decimal";
                reason = typeSelectors[i] + "=" + selector;
            }
            if (!"int".equalsIgnoreCase(selector)) continue;
            targetType = "compact_int";
            reason = typeSelectors[i] + "=" + selector;
        }
        if (targetType != null) {
            file.addType(new SchemeType(name, NamedEntity.Mode.UPDATE, targetType, "Automatically created from environment, using property " + reason, file.getName()));
        }
    }

    private static void overrideTimeType(SchemeModel file, String name, String defaultType, String ... typeSelectors) throws SchemeException {
        String targetType = defaultType;
        String reason = null;
        int i = typeSelectors.length;
        while (--i >= 0) {
            String selector = System.getProperty(typeSelectors[i]);
            if ("millis".equalsIgnoreCase(selector)) {
                targetType = "time_millis";
                reason = typeSelectors[i] + "=" + selector;
            }
            if (!"seconds".equalsIgnoreCase(selector)) continue;
            targetType = "time_seconds";
            reason = typeSelectors[i] + "=" + selector;
        }
        if (targetType != null) {
            file.addType(new SchemeType(name, NamedEntity.Mode.UPDATE, targetType, "Automatically created from environment, using property " + reason, file.getName()));
        }
    }

    private static String getExchanges(String rec) {
        String prop;
        String pattern;
        String defaultPattern = null;
        if (!rec.equals("Book")) {
            defaultPattern = SystemProperties.getProperty((String)"dxscheme.exchanges", null);
        }
        return (pattern = SystemProperties.getProperty((String)(prop = "com.dxfeed.event.market.impl." + rec + ".exchanges"), (String)defaultPattern)) != null ? MarketEventSymbols.getExchangesByPattern((String)pattern) : null;
    }
}

