/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.model;

import com.dxfeed.scheme.model.SchemeEntity;
import com.dxfeed.scheme.model.SchemeRecord;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

@Deprecated
public final class VisibilityRule
extends SchemeEntity {
    private final Pattern record;
    @Deprecated
    private final boolean useEventName;
    private final Pattern field;
    private final boolean enable;
    private final Set<String> incTags = new HashSet<String>();
    private final Set<String> excTags = new HashSet<String>();

    public VisibilityRule(String record, boolean useEventName, String field, boolean enable, String file) {
        this(Pattern.compile(record), useEventName, field == null || field.isEmpty() ? null : Pattern.compile(field), enable, file);
    }

    public VisibilityRule(Pattern record, boolean useEventName, Pattern field, boolean enable, String file) {
        super(file);
        this.record = Objects.requireNonNull(record, "record");
        this.useEventName = useEventName;
        this.field = field;
        this.enable = enable;
    }

    public Type getType() {
        return this.field != null || !this.incTags.isEmpty() || !this.excTags.isEmpty() ? Type.FIELD : Type.RECORD;
    }

    public Pattern getRecord() {
        return this.record;
    }

    @Deprecated
    public boolean useEventName() {
        return this.useEventName;
    }

    public Pattern getField() {
        if (this.getType() != Type.FIELD) {
            throw new IllegalStateException("Cannot provide field pattern for record-type rule");
        }
        return this.field;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void addIncludedTag(String tag) {
        if (this.getType() != Type.FIELD) {
            throw new IllegalStateException("Cannot add tag to record-type rule");
        }
        this.incTags.add(tag);
    }

    public Set<String> getIncludedTags() {
        if (this.getType() != Type.FIELD) {
            throw new IllegalStateException("Cannot return tags for record-type rule");
        }
        return Collections.unmodifiableSet(this.incTags);
    }

    public void addExcludedTag(String tag) {
        if (this.getType() != Type.FIELD) {
            throw new IllegalStateException("Cannot add tag to record-type rule");
        }
        this.excTags.add(tag);
    }

    public Set<String> getExcludedTags() {
        if (this.getType() != Type.FIELD) {
            throw new IllegalStateException("Cannot return tags for record-type rule");
        }
        return Collections.unmodifiableSet(this.excTags);
    }

    public boolean match(SchemeRecord r, String actualRecordName) {
        if (this.getType() == Type.FIELD) {
            return false;
        }
        String recordNameToUse = this.useEventName ? r.getEventName() : actualRecordName;
        return this.record.matcher(recordNameToUse).matches();
    }

    public boolean match(String actualRecordName, SchemeRecord.Field f) {
        String fieldNameToUse;
        String recordNameToUse;
        if (this.getType() == Type.RECORD) {
            return false;
        }
        SchemeRecord r = (SchemeRecord)f.getParent();
        String string = recordNameToUse = this.useEventName ? r.getEventName() : actualRecordName;
        if (!this.record.matcher(recordNameToUse).matches()) {
            return false;
        }
        String string2 = fieldNameToUse = this.useEventName ? f.getEventName() : f.getName();
        if (this.field != null && !this.field.matcher(fieldNameToUse).matches()) {
            return false;
        }
        boolean tagMatch = true;
        Set<String> fTags = f.getTags();
        for (String t : this.incTags) {
            tagMatch &= fTags.contains(t);
        }
        for (String t : this.excTags) {
            tagMatch &= !fTags.contains(t);
        }
        return tagMatch;
    }

    public String toString() {
        return "VisibilityRule{from=" + this.getFrom() + ", record='" + this.record + '\'' + (this.field != null ? ", field='" + this.field + '\'' : "") + ", enable=" + this.enable + ", useEventName=" + this.useEventName + (this.incTags.isEmpty() ? "" : ", incTags='" + this.incTags.toString() + '\'') + (this.excTags.isEmpty() ? "" : ", excTags='" + this.excTags.toString() + '\'') + '}';
    }

    public static enum Type {
        RECORD,
        FIELD;

    }
}

