/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme;

import com.dxfeed.scheme.model.NamedEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SchemeException
extends Exception {
    private final List<SchemeException> causes;

    public SchemeException(String message, String file) {
        this(message, Collections.singletonList(file));
    }

    public SchemeException(String message, List<String> files) {
        super("Exception in scheme file" + (files.size() > 1 ? "s" : "") + " " + SchemeException.filesAsString(files) + "\n" + message);
        this.causes = Collections.emptyList();
    }

    public SchemeException(String message) {
        super(message);
        this.causes = Collections.emptyList();
    }

    public SchemeException(List<SchemeException> causes, List<String> files) {
        super("Multiple errors in scheme file" + (files.size() > 1 ? "s" : "") + " " + SchemeException.filesAsString(files), causes.get(causes.size() - 1));
        this.causes = Collections.unmodifiableList(new ArrayList<SchemeException>(causes));
    }

    public List<SchemeException> getCauses() {
        return this.causes;
    }

    public static <T extends NamedEntity<T>> String formatInconsistencyMessage(NamedEntity<T> entity, String message) {
        return "Scheme inconsistency with " + SchemeException.extractType(entity.getClass()) + " \"" + entity.getFullName() + "\": " + message;
    }

    public static <T extends NamedEntity<T>> String formatConflictMessage(NamedEntity<T> entity, String conflictFile, String message) {
        return "Conflict overriding " + SchemeException.extractType(entity.getClass()) + " \"" + entity.getFullName() + "\" with update from file \"" + conflictFile + "\": " + message;
    }

    private static String filesAsString(List<String> files) {
        return files.stream().map(s -> '\"' + s + '\"').collect(Collectors.joining(", "));
    }

    private static String extractType(Class<?> aClass) {
        String name = aClass.getSimpleName();
        return name.startsWith("Scheme") ? name.substring(6) : name;
    }
}

