/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.impl;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.DataSchemeFactory;
import com.devexperts.services.ServiceProvider;
import com.dxfeed.scheme.DXScheme;
import com.dxfeed.scheme.EmbeddedTypes;
import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.impl.DefaultEmbeddedTypes;
import java.io.IOException;

@ServiceProvider
public class DXSchemeFactory
implements DataSchemeFactory {
    protected static final String EXTERNAL_SCHEME = "ext:";
    private static final EmbeddedTypes DEFAULT_TYPES = new DefaultEmbeddedTypes();

    public DataScheme createDataScheme(String specification) {
        if (!specification.startsWith(EXTERNAL_SCHEME)) {
            return null;
        }
        specification = specification.substring(EXTERNAL_SCHEME.length());
        try {
            return DXScheme.newLoader().withTypes(DEFAULT_TYPES).fromSpecification(specification).load();
        }
        catch (SchemeException e) {
            if (e.getCauses().isEmpty()) {
                throw new IllegalArgumentException("Cannot load scheme from \"ext:" + specification + "\": " + e.getMessage(), e);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot load scheme from \"ext:").append(specification).append("\": ").append(e.getMessage()).append("\n");
            for (SchemeException cex : e.getCauses()) {
                sb.append(cex.getMessage()).append("\n");
            }
            sb.setLength(sb.length() - 1);
            throw new IllegalArgumentException(sb.toString(), e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load scheme from \"ext:" + specification + "\": " + e.getMessage(), e);
        }
    }
}

