/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.impl;

import com.devexperts.logging.Logging;
import com.dxfeed.scheme.EmbeddedTypes;
import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.SchemeLoadingOptions;
import com.dxfeed.scheme.impl.DefaultEmbeddedTypes;
import com.dxfeed.scheme.impl.SchemeModelReader;
import com.dxfeed.scheme.impl.xml.XmlSchemeModelReader;
import com.dxfeed.scheme.model.SchemeModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class SchemeModelLoader {
    private static final Logging log = Logging.getLogging(SchemeModelLoader.class);
    private static final String DXFEED_KEYWORD = "dxfeed";
    private static final String RESOURCE_SCHEME = "resource:";
    private static final String DEFAULT_URL = "resource:dxfeed.xml";
    private static final Map<String, Supplier<SchemeModelReader>> FORMATS = new HashMap<String, Supplier<SchemeModelReader>>();
    public static final EmbeddedTypes DEFAULT_TYPES;

    private SchemeModelLoader() {
    }

    public static List<URL> parseSpecification(String specification) throws IOException {
        return SchemeModelLoader.parseSpecification(specification, new SchemeLoadingOptions());
    }

    public static List<URL> parseSpecification(String specification, SchemeLoadingOptions options) throws IOException {
        URL root = new File("").toURI().toURL();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String s : specification.split("\\s*,\\s*")) {
            if (s.equals(DXFEED_KEYWORD)) {
                s = DEFAULT_URL;
                options.setDXFeedDefaults();
            }
            if (s.startsWith(RESOURCE_SCHEME)) {
                s = s.substring(RESOURCE_SCHEME.length());
                ClassLoader cl = SchemeModelLoader.resolveLoader();
                if (cl == null) {
                    throw new IOException("Cannot load scheme \"" + s + "\" from resources, class loader problem");
                }
                ArrayList<URL> resUrls = Collections.list(cl.getResources(s));
                if (resUrls.isEmpty()) {
                    throw new IOException("Cannot load scheme \"" + s + "\" from resources, not found");
                }
                if (resUrls.size() > 1) {
                    throw new IOException("Cannot load scheme \"" + s + "\" from resources, found several candidates: " + resUrls.stream().map(a -> '\"' + a.toString() + '\"').collect(Collectors.joining(", ")));
                }
                urls.add((URL)resUrls.get(0));
                continue;
            }
            if (s.startsWith("opt:")) {
                options.applyOptions(s);
                continue;
            }
            urls.add(new URL(root, s));
        }
        return urls;
    }

    public static SchemeModel loadSchemeModel(String spec) throws SchemeException, IOException {
        return SchemeModelLoader.loadSchemeModel(spec, DEFAULT_TYPES);
    }

    public static SchemeModel loadSchemeModel(String spec, EmbeddedTypes embeddedTypes) throws IOException, SchemeException {
        SchemeLoadingOptions options = new SchemeLoadingOptions();
        return SchemeModelLoader.loadSchemeModel(SchemeModelLoader.parseSpecification(spec, options), options, embeddedTypes);
    }

    public static SchemeModel loadSchemeModel(List<URL> urls, SchemeLoadingOptions options, EmbeddedTypes embeddedTypes) throws IOException, SchemeException {
        SchemeModel model = ((SchemeModel.Builder)((SchemeModel.Builder)SchemeModel.newBuilder().withName("<scheme>").withTypes(embeddedTypes)).withOptions(options)).build();
        HashSet<URL> seenFiles = new HashSet<URL>();
        for (URL url : urls) {
            SchemeModelReader reader = SchemeModelLoader.getSchemeModelReader(url);
            SchemeModelLoader.loadFileAndImports(model, reader, url, options, null, seenFiles);
        }
        if (model.mergedInCount() == 0) {
            throw new SchemeException("Cannot load anything from given files.", urls.stream().map(URL::toString).collect(Collectors.toList()));
        }
        List<SchemeException> errors = model.validateState();
        if (!errors.isEmpty()) {
            throw new SchemeException(errors, urls.stream().map(URL::toString).collect(Collectors.toList()));
        }
        return model;
    }

    private static void loadFileAndImports(SchemeModel model, SchemeModelReader reader, URL url, SchemeLoadingOptions options, String parent, Set<URL> seenFiles) throws IOException, SchemeException {
        if (!seenFiles.add(url)) {
            return;
        }
        if (options.isDebugMode()) {
            if (parent == null) {
                log.debug("Loading external scheme file \"" + url + "\"...");
            } else {
                log.debug("Loading external scheme file \"" + url + "\" imported by \"" + parent + "\"...");
            }
        }
        reader.readModel(model, parent, url.toExternalForm(), url.openStream(), (parentName, imp) -> SchemeModelLoader.loadFileAndImports(model, reader, new URL(url, imp.getUrl()), options, parentName, seenFiles));
        model.finishMergeIn(url.toExternalForm());
        if (options.isDebugMode()) {
            log.debug("Loaded external scheme file \"" + url + "\"");
        }
    }

    private static SchemeModelReader getSchemeModelReader(URL url) throws SchemeException {
        Supplier<SchemeModelReader> readerFabric = null;
        String fileName = url.getFile();
        int dot = fileName.lastIndexOf(".");
        if (dot >= 0 && dot < fileName.length() - 1) {
            String ext = fileName.substring(dot + 1).toLowerCase();
            readerFabric = FORMATS.get(ext);
        }
        if (readerFabric == null) {
            throw new SchemeException("Unknown scheme model file format \"" + url + "\"");
        }
        return (SchemeModelReader)readerFabric.get();
    }

    private static ClassLoader resolveLoader() {
        ClassLoader loader = SchemeModelLoader.class.getClassLoader();
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    static {
        FORMATS.put("xml", XmlSchemeModelReader::new);
        DEFAULT_TYPES = new DefaultEmbeddedTypes();
    }
}

