/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.impl.xml;

import com.dxfeed.scheme.impl.SchemeModelWriter;
import com.dxfeed.scheme.impl.xml.XmlSchemeModelFormat;
import com.dxfeed.scheme.model.NamedEntity;
import com.dxfeed.scheme.model.SchemeEntity;
import com.dxfeed.scheme.model.SchemeEnum;
import com.dxfeed.scheme.model.SchemeModel;
import com.dxfeed.scheme.model.SchemeRecord;
import com.dxfeed.scheme.model.SchemeRecordGenerator;
import com.dxfeed.scheme.model.SchemeType;
import com.dxfeed.scheme.model.VisibilityRule;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlSchemeModelWriter
extends XmlSchemeModelFormat
implements SchemeModelWriter {
    @Override
    public void writeModel(OutputStream out, SchemeModel model) throws IOException {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            XmlSchemeModelFormat.XMLErrorHandler errorHandler = new XmlSchemeModelFormat.XMLErrorHandler();
            db.setErrorHandler(errorHandler);
            Document doc = db.newDocument();
            Element root = doc.createElementNS("https://www.dxfeed.com/datascheme", "dxfeed");
            root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "https://www.dxfeed.com/datascheme dxfeed-schema.xsd");
            doc.appendChild(root);
            root.appendChild(doc.createTextNode("\n"));
            root.appendChild(doc.createComment(this.formatHeader(model)));
            root.appendChild(doc.createTextNode("\n\n"));
            this.serializeCollection(root, "types", model.getTypes().values(), this::typeSerializer);
            this.serializeCollection(root, "enums", model.getEnums().values(), this::enumSerializer);
            this.serializeRecordsAndGenerators(root, model);
            this.serializeCollection(root, "visibility", model.getVisibilityRules(), this::visibilityRuleSerializer);
            this.serializeDocument(out, doc);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IOException("Cannot write XML Scheme: " + e.getMessage(), e);
        }
    }

    private <T> void serializeCollection(Element root, String collectionName, Collection<T> collection, ElementSerializer<T> serializer) {
        Element ce = root.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", collectionName);
        root.appendChild(ce);
        if (collection.isEmpty()) {
            ce.appendChild(root.getOwnerDocument().createComment("No elements of this type have been defined"));
        } else {
            for (T e : collection) {
                ce.appendChild(serializer.serialize(root.getOwnerDocument(), e));
            }
        }
    }

    private Element typeSerializer(Document doc, SchemeType data) {
        Element type = doc.createElementNS("https://www.dxfeed.com/datascheme", "type");
        type.setAttribute("name", data.getName());
        type.setAttribute("base", data.getBase());
        this.addSources(type, null, data);
        if (!data.getBase().equals(data.getResolvedType())) {
            type.appendChild(doc.createComment("Resolved to " + data.getResolvedType()));
        }
        this.addDoc(type, data);
        return type;
    }

    private Element enumSerializer(Document doc, SchemeEnum data) {
        Element enm = doc.createElementNS("https://www.dxfeed.com/datascheme", "enum");
        enm.setAttribute("name", data.getName());
        this.addSources(enm, null, data);
        this.addDoc(enm, data);
        int expectedOrd = 0;
        for (SchemeEnum.Value v : data.getValuesByOrd()) {
            Element val = doc.createElementNS("https://www.dxfeed.com/datascheme", "value");
            val.setAttribute("name", v.getName());
            if (expectedOrd != v.getOrd()) {
                val.setAttribute("ord", "" + v.getOrd());
            }
            expectedOrd = v.getOrd() + 1;
            this.addSources(val, data, v);
            this.addDoc(val, v);
            enm.appendChild(val);
        }
        return enm;
    }

    private void serializeRecordsAndGenerators(Element root, SchemeModel file) {
        Element ce = root.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "records");
        if (file.getRecords().isEmpty() && file.getGenerators().isEmpty()) {
            ce.appendChild(root.getOwnerDocument().createComment("No elements of this type have been defined"));
            return;
        }
        for (SchemeRecord r : file.getRecords().values()) {
            if (r.isTemplate()) continue;
            this.serializeRecord(ce, r);
        }
        for (SchemeRecordGenerator g : file.getGenerators().values()) {
            this.serializeGenerator(ce, g);
        }
        root.appendChild(ce);
    }

    private void serializeRecord(Element root, SchemeRecord r) {
        Element rec = root.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "record");
        rec.setAttribute("name", r.getName());
        rec.setAttribute("disabled", "" + r.isDisabled());
        rec.setAttribute("regionals", "" + r.hasRegionals());
        if (!r.getEventName().equals(r.getName())) {
            rec.setAttribute("eventName", r.getEventName());
        }
        this.addSources(rec, null, r);
        this.addDoc(rec, r);
        if (r.hasBase()) {
            rec.appendChild(rec.getOwnerDocument().createComment("Record was based on \"" + r.getBase() + "\""));
        }
        if (r.hasEventFlags()) {
            Element index = rec.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "index");
            if (r.getIndex1() != null) {
                index.setAttribute("field0", r.getIndex1());
            }
            if (r.getIndex2() != null) {
                index.setAttribute("field1", r.getIndex2());
            }
            rec.appendChild(index);
        }
        for (SchemeRecord.Field f : r.getFields()) {
            this.serializeRecordField(rec, r, f);
        }
        root.appendChild(rec);
    }

    private void serializeRecordField(Element rec, SchemeRecord r, SchemeRecord.Field f) {
        Element fld = rec.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "field");
        fld.setAttribute("name", f.getName());
        fld.setAttribute("type", f.getType());
        fld.setAttribute("disabled", "" + f.isDisabled());
        fld.setAttribute("compositeOnly", "" + f.isCompositeOnly());
        if (!f.getEventName().equals(r.getEventName())) {
            fld.setAttribute("eventName", f.getEventName());
        }
        this.addSources(fld, r, f);
        this.addDoc(fld, f);
        for (SchemeRecord.Field.Alias a : f.getAliases()) {
            Element alias = fld.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "alias");
            alias.setAttribute("name", a.getValue());
            alias.setAttribute("main", "" + a.isMain());
            fld.appendChild(alias);
        }
        for (String t : f.getTags()) {
            Element tag = fld.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "tag");
            tag.setAttribute("name", t);
            fld.appendChild(tag);
        }
        if (f.hasBitfields()) {
            this.serializeCollection(fld, "bitfields", f.getBitfields(), (doc, data) -> this.bitfieldSerializer(doc, f, (SchemeRecord.Field.Bitfield)data));
        }
        rec.appendChild(fld);
    }

    private Element bitfieldSerializer(Document doc, SchemeRecord.Field f, SchemeRecord.Field.Bitfield data) {
        Element bf = doc.createElementNS("https://www.dxfeed.com/datascheme", "field");
        bf.setAttribute("name", data.getName());
        bf.setAttribute("offset", "" + data.getOffset());
        bf.setAttribute("size", "" + data.getSize());
        this.addSources(bf, f, data);
        this.addDoc(bf, data);
        return bf;
    }

    private void serializeGenerator(Element root, SchemeRecordGenerator g) {
        Element gen = root.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "generator");
        gen.setAttribute("name", g.getName());
        gen.setAttribute("type", g.getType().name().toLowerCase());
        if (!"".equals(g.getDelimiter())) {
            gen.setAttribute("delimiter", g.getDelimiter());
        }
        this.addSources(gen, null, g);
        this.addDoc(gen, g);
        Element iter = gen.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "iterator");
        iter.setAttribute("mode", SchemeRecordGenerator.IteratorMode.APPEND.name().toLowerCase());
        for (String s : g.getIterator()) {
            Element val = iter.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "value");
            if (!"".equals(s)) {
                val.appendChild(val.getOwnerDocument().createTextNode(s));
            }
            iter.appendChild(val);
        }
        gen.appendChild(iter);
        for (SchemeRecord r : g.getTemplates()) {
            this.serializeRecord(gen, r);
        }
        root.appendChild(gen);
    }

    private Element visibilityRuleSerializer(Document doc, VisibilityRule data) {
        Element vr = data.isEnable() ? doc.createElementNS("https://www.dxfeed.com/datascheme", "enable") : doc.createElementNS("https://www.dxfeed.com/datascheme", "disable");
        vr.setAttribute("record", data.getRecord().pattern());
        if (data.getType() == VisibilityRule.Type.FIELD) {
            vr.setAttribute("field", data.getField().pattern());
        }
        if (data.useEventName()) {
            vr.setAttribute("useEventName", "true");
        }
        this.addSources(vr, null, data);
        this.visibilityRuleTagsSerializer(doc, vr, "include-tags", data.getIncludedTags());
        this.visibilityRuleTagsSerializer(doc, vr, "exclude-tags", data.getExcludedTags());
        return vr;
    }

    private void visibilityRuleTagsSerializer(Document doc, Element vr, String name, Set<String> tags) {
        if (tags.isEmpty()) {
            return;
        }
        Element inc = doc.createElementNS("https://www.dxfeed.com/datascheme", name);
        for (String t : tags) {
            Element tag = doc.createElementNS("https://www.dxfeed.com/datascheme", "tag");
            tag.setTextContent(t);
            inc.appendChild(tag);
        }
        vr.appendChild(inc);
    }

    private <T extends NamedEntity<T>> void addDoc(Element root, T data) {
        if (data.getDoc() != null) {
            Element doc = root.getOwnerDocument().createElementNS("https://www.dxfeed.com/datascheme", "doc");
            doc.appendChild(root.getOwnerDocument().createTextNode(data.getDoc()));
            root.appendChild(doc);
        }
    }

    private <P extends SchemeEntity, T extends SchemeEntity> void addSources(Element root, P parent, T data) {
        List<String> sources = data.getFilesList();
        if (parent != null && parent.getFilesList().equals(sources)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (sources.size() == 1) {
            sb.append("Defined in: ");
            sb.append(sources.get(0));
        } else {
            sb.append("\nDefined in:\n");
            for (String s : sources) {
                sb.append(s).append("\n");
            }
        }
        root.appendChild(root.getOwnerDocument().createComment(sb.toString()));
    }

    private String formatHeader(SchemeModel file) {
        StringBuilder sb = new StringBuilder();
        List<String> sources = file.getSources();
        int i = 0;
        while (i < sources.size()) {
            if (sources.get(i).startsWith("<")) {
                sources.remove(i);
                continue;
            }
            ++i;
        }
        if (sources.size() == 1) {
            sb.append("\nThis file was automatically created from scheme loaded from file\n");
        } else {
            sb.append("\nThis file was automatically created from scheme loaded from files\n");
        }
        for (String f : sources) {
            sb.append(f).append("\n");
        }
        return sb.toString();
    }

    private void serializeDocument(OutputStream out, Document doc) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(out);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    @FunctionalInterface
    private static interface ElementSerializer<T> {
        public Element serialize(Document var1, T var2);
    }
}

