/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.impl.xml;

import com.devexperts.logging.Logging;
import com.dxfeed.scheme.EmbeddedTypes;
import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.impl.ImportProcessor;
import com.dxfeed.scheme.impl.SchemeModelReader;
import com.dxfeed.scheme.impl.xml.XmlSchemeModelFormat;
import com.dxfeed.scheme.model.NamedEntity;
import com.dxfeed.scheme.model.SchemeEnum;
import com.dxfeed.scheme.model.SchemeImport;
import com.dxfeed.scheme.model.SchemeModel;
import com.dxfeed.scheme.model.SchemeRecord;
import com.dxfeed.scheme.model.SchemeRecordGenerator;
import com.dxfeed.scheme.model.SchemeType;
import com.dxfeed.scheme.model.VisibilityRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlSchemeModelReader
extends XmlSchemeModelFormat
implements SchemeModelReader {
    private static final Logging log = Logging.getLogging(XmlSchemeModelReader.class);

    @Override
    public void readModel(SchemeModel model, String parent, String name, InputStream in, ImportProcessor importProcessor) throws IOException, SchemeException {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            XMLErrorHandler errorHandler = new XMLErrorHandler();
            db.setErrorHandler(errorHandler);
            Element xml = db.parse(in).getDocumentElement();
            for (SAXException sAXException : errorHandler.getExceptions()) {
                log.error("Cannot parse XML scheme model \"" + name + "\": " + sAXException.getMessage());
            }
            if (!errorHandler.getExceptions().isEmpty()) {
                throw new SchemeException("Cannot parse XML Scheme: XML Errors in \"" + name + "\"");
            }
            NodeList nl = xml.getElementsByTagNameNS("https://www.dxfeed.com/datascheme", "import");
            if (nl != null && nl.getLength() > 0) {
                this.loadImports(model, name, nl, importProcessor);
            }
            this.processChildCollection(xml, "types", a -> this.loadType(model, name, (Element)a));
            this.processChildCollection(xml, "enums", a -> this.loadEnum(model, name, (Element)a));
            this.processChildCollection(xml, "records", a -> this.loadRecordOrGenerator(model, name, (Element)a));
            this.processChildCollection(xml, "mappings", a -> this.loadMappings(model, name, (Element)a));
            this.processChildCollection(xml, "visibility", a -> this.loadVisibility(model, name, (Element)a));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SchemeException("Cannot read XML scheme model \"" + name + "\": " + e.getMessage());
        }
    }

    private void loadImports(SchemeModel model, String currentName, NodeList ximports, ImportProcessor importProcessor) throws IOException, SchemeException {
        for (int i = 0; i < ximports.getLength(); ++i) {
            SchemeImport imp = new SchemeImport(ximports.item(i).getTextContent(), currentName);
            model.addImport(imp);
            importProcessor.processImport(currentName, imp);
        }
    }

    private void loadType(SchemeModel model, String currentName, Element tpy) throws SchemeException {
        String name = tpy.getAttribute("name");
        String base = tpy.getAttribute("base");
        model.addType(new SchemeType(name, this.getCreationMode(tpy), base, this.getDoc(tpy), currentName));
    }

    private void loadEnum(SchemeModel model, String currentName, Element enm) throws SchemeException {
        String name = enm.getAttribute("name");
        SchemeEnum e = new SchemeEnum(name, this.getCreationMode(enm), this.getDoc(enm), currentName);
        NodeList vals = enm.getElementsByTagNameNS("https://www.dxfeed.com/datascheme", "value");
        for (int j = 0; vals != null && j < vals.getLength(); ++j) {
            Element val = (Element)vals.item(j);
            String valName = val.getAttribute("name");
            String valOrdStr = val.getAttribute("ord");
            int ord = "".equals(valOrdStr) ? -1 : Integer.parseInt(valOrdStr);
            e.addValue(valName, this.getCreationMode(val), ord, this.getDoc(val));
        }
        model.addEnum(e);
    }

    private void loadRecordOrGenerator(SchemeModel model, String currentName, Element rcrd) throws SchemeException {
        switch (rcrd.getLocalName()) {
            case "record": {
                this.loadRecord(model, currentName, rcrd);
                break;
            }
            case "generator": {
                this.loadGenerator(model, currentName, rcrd);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown record descriptor \"" + rcrd.getLocalName() + "\"");
            }
        }
    }

    private void loadRecord(SchemeModel model, String currentName, Element rcrd) throws SchemeException {
        model.addRecord(this.parseRecord(model, currentName, rcrd, null));
    }

    private SchemeRecord parseRecord(SchemeModel model, String currentName, Element rcrd, String parent) throws SchemeException {
        NodeList idx;
        String eventName;
        SchemeRecord r;
        String name = rcrd.getAttribute("name");
        String base = rcrd.getAttribute("copyFrom");
        if (base != null && !base.isEmpty()) {
            SchemeRecord br = model.getRecords().get(base);
            if (br == null) {
                throw new SchemeException("Unknown base record \"" + base + "\" for record \"" + name + "\"", model.getSources());
            }
            r = br.copyFrom(parent, name, this.getCreationMode(rcrd), currentName);
        } else {
            r = new SchemeRecord(name, this.getCreationMode(rcrd), parent, this.getBooleanAttr(rcrd, "regionals"), this.getDoc(rcrd), currentName);
        }
        Boolean disabled = this.getBooleanAttr(rcrd, "disabled");
        if (disabled != null) {
            r.setDisabled(disabled);
        }
        if ((eventName = rcrd.getAttribute("eventName")) != null && !eventName.isEmpty()) {
            r.setEventName(eventName);
        }
        if ((idx = rcrd.getElementsByTagNameNS("https://www.dxfeed.com/datascheme", "index")) != null && idx.getLength() > 0) {
            Element e = (Element)idx.item(0);
            r.setIndex(this.getStringAttr(e, "field0"), this.getStringAttr(e, "field1"));
        }
        this.processChildNodes(rcrd, "field", f -> this.addRecordField(model.getEmbeddedTypes(), r, (Element)f));
        return r;
    }

    private void addRecordField(EmbeddedTypes embeddedTypes, SchemeRecord r, Element fld) throws SchemeException {
        String name = fld.getAttribute("name");
        String type = this.getStringAttr(fld, "type");
        boolean hasBitfields = embeddedTypes.canHaveBitfields(type);
        Boolean disabled = this.getBooleanAttr(fld, "disabled");
        Boolean compositeOnly = this.getBooleanAttr(fld, "compositeOnly");
        SchemeRecord.Field f = r.addField(name, this.getCreationMode(fld), disabled, type, hasBitfields, compositeOnly, this.getDoc(fld));
        String eventName = fld.getAttribute("eventName");
        if (eventName != null && !eventName.isEmpty()) {
            f.setEventName(eventName);
        }
        this.processChildNodes(fld, "alias", a -> f.addAlias(a.getAttribute("name"), Boolean.parseBoolean(a.getAttribute("main")), SchemeRecord.Field.AliasOrTagMode.valueOf(a.getAttribute("mode").toUpperCase())));
        this.processChildNodes(fld, "tag", a -> f.addTag(a.getAttribute("name"), SchemeRecord.Field.AliasOrTagMode.valueOf(a.getAttribute("mode").toUpperCase())));
        if (hasBitfields) {
            this.processChildCollection(fld, "bitfields", bf -> this.addRecordFieldBitField(f, (Element)bf));
        }
    }

    private void addRecordFieldBitField(SchemeRecord.Field f, Element bf) throws SchemeException {
        String name = bf.getAttribute("name");
        Integer offset = bf.hasAttribute("offset") ? Integer.valueOf(Integer.parseInt(bf.getAttribute("offset"), 10)) : null;
        Integer size = bf.hasAttribute("size") ? Integer.valueOf(Integer.parseInt(bf.getAttribute("size"), 10)) : null;
        f.addBitfield(name, this.getCreationMode(bf), offset, size, this.getDoc(bf), f.getLastFile());
    }

    private void loadGenerator(SchemeModel model, String currentName, Element gen) throws SchemeException {
        String name = gen.getAttribute("name");
        SchemeRecordGenerator g = new SchemeRecordGenerator(name, this.getCreationMode(gen), this.getDoc(gen), currentName);
        g.setType(SchemeRecordGenerator.Type.valueOf(gen.getAttribute("type").toUpperCase()));
        g.setDelimiter(gen.getAttribute("delimiter"));
        Element iter = (Element)gen.getElementsByTagNameNS("https://www.dxfeed.com/datascheme", "iterator").item(0);
        if (iter != null) {
            g.setIteratorMode(SchemeRecordGenerator.IteratorMode.valueOf(iter.getAttribute("mode").toUpperCase()));
            this.processChildNodes(iter, "value", v -> g.addIteratorValue(v.getTextContent()));
        }
        this.processChildNodes(gen, "record", r -> g.addTemplate(this.parseRecord(model, currentName, (Element)r, name)));
        model.addGenerator(g);
    }

    private void loadMappings(SchemeModel model, String currentName, Element map) {
    }

    private void loadVisibility(SchemeModel model, String currentName, Element r) throws SchemeException {
        VisibilityRule rule;
        switch (r.getLocalName()) {
            case "enable": {
                rule = new VisibilityRule(r.getAttribute("record"), this.getBooleanAttr(r, "useEventName", false), r.getAttribute("field"), true, currentName);
                break;
            }
            case "disable": {
                rule = new VisibilityRule(r.getAttribute("record"), this.getBooleanAttr(r, "useEventName", false), r.getAttribute("field"), false, currentName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown visibility rule \"" + r.getLocalName() + "\"");
            }
        }
        this.processChildCollection(r, "include-tags", a -> rule.addIncludedTag(a.getTextContent()));
        this.processChildCollection(r, "exclude-tags", a -> rule.addExcludedTag(a.getTextContent()));
        model.addVisibilityRule(rule);
    }

    private void processChildCollection(Element xml, String collectionName, XMLConsumer<Element> loader) throws SchemeException {
        Element coll = this.findOnlyChildElement(xml, collectionName);
        if (coll == null) {
            return;
        }
        NodeList nl = coll.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !"https://www.dxfeed.com/datascheme".equals(n.getNamespaceURI())) continue;
            loader.accept((Element)n);
        }
    }

    private void processChildNodes(Element xml, String childName, XMLConsumer<Element> loader) throws SchemeException {
        NodeList nl = xml.getChildNodes();
        if (nl == null || nl.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !"https://www.dxfeed.com/datascheme".equals(n.getNamespaceURI()) || !childName.equals(n.getNodeName())) continue;
            loader.accept((Element)n);
        }
    }

    private NamedEntity.Mode getCreationMode(Element e) {
        return NamedEntity.Mode.valueOf(e.getAttribute("mode").toUpperCase());
    }

    private String getDoc(Element e) {
        Element doc = this.findOnlyChildElement(e, "doc");
        return doc == null ? null : doc.getTextContent();
    }

    private Boolean getBooleanAttr(Element e, String name) {
        if (!e.hasAttribute(name)) {
            return null;
        }
        return Boolean.valueOf(e.getAttribute(name));
    }

    private boolean getBooleanAttr(Element e, String name, boolean def) {
        if (!e.hasAttribute(name)) {
            return def;
        }
        return Boolean.parseBoolean(e.getAttribute(name));
    }

    private String getStringAttr(Element e, String name) {
        if (!e.hasAttribute(name)) {
            return null;
        }
        return e.getAttribute(name);
    }

    private Element findOnlyChildElement(Element e, String name) {
        NodeList nl = e.getChildNodes();
        if (nl == null) {
            return null;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNamespaceURI().equals("https://www.dxfeed.com/datascheme") || !n.getNodeName().equals(name)) continue;
            return (Element)n;
        }
        return null;
    }

    @FunctionalInterface
    private static interface XMLConsumer<T> {
        public void accept(T var1) throws SchemeException;
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private final List<SAXParseException> exceptions = new ArrayList<SAXParseException>();

        private XMLErrorHandler() {
        }

        public List<SAXParseException> getExceptions() {
            return this.exceptions;
        }

        @Override
        public void warning(SAXParseException exception) {
            this.exceptions.add(exception);
        }

        @Override
        public void error(SAXParseException exception) {
            this.exceptions.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.exceptions.add(exception);
        }
    }
}

