/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.scheme.model;

import com.devexperts.qd.SerialFieldType;
import com.dxfeed.scheme.EmbeddedTypes;
import com.dxfeed.scheme.SchemeException;
import com.dxfeed.scheme.SchemeLoadingOptions;
import com.dxfeed.scheme.impl.SchemeModelLoader;
import com.dxfeed.scheme.model.NamedEntity;
import com.dxfeed.scheme.model.SchemeEntity;
import com.dxfeed.scheme.model.SchemeEnum;
import com.dxfeed.scheme.model.SchemeImport;
import com.dxfeed.scheme.model.SchemeMapping;
import com.dxfeed.scheme.model.SchemeRecord;
import com.dxfeed.scheme.model.SchemeRecordGenerator;
import com.dxfeed.scheme.model.SchemeType;
import com.dxfeed.scheme.model.VisibilityRule;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Deprecated
public final class SchemeModel {
    private final EmbeddedTypes embeddedTypes;
    private final String parent;
    private final String name;
    private final List<String> sources = new ArrayList<String>();
    private final List<SchemeImport> imports = new ArrayList<SchemeImport>();
    private final Map<String, SchemeType> types = new HashMap<String, SchemeType>();
    private final Map<String, SchemeEnum> enums = new HashMap<String, SchemeEnum>();
    private final Map<String, SchemeRecord> records = new HashMap<String, SchemeRecord>();
    private final Map<String, SchemeRecordGenerator> generators = new HashMap<String, SchemeRecordGenerator>();
    private final Map<String, SchemeMapping> mappings = new HashMap<String, SchemeMapping>();
    private final List<VisibilityRule> vrules = new ArrayList<VisibilityRule>();
    private final List<RecordSource> generationOrder = new ArrayList<RecordSource>();
    private int mergedIn = 0;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Loader newLoader() {
        return new Loader();
    }

    private SchemeModel(EmbeddedTypes embeddedTypes, String name, String parent) {
        this.embeddedTypes = Objects.requireNonNull(embeddedTypes, "embeddedTypes");
        this.parent = parent;
        this.name = Objects.requireNonNull(name, "name");
        this.sources.add(name);
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public Collection<SchemeImport> getImports() {
        return Collections.unmodifiableCollection(this.imports);
    }

    public Map<String, SchemeType> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    public Map<String, SchemeEnum> getEnums() {
        return Collections.unmodifiableMap(this.enums);
    }

    public Map<String, SchemeRecord> getRecords() {
        return Collections.unmodifiableMap(this.records);
    }

    public Map<String, SchemeRecordGenerator> getGenerators() {
        return Collections.unmodifiableMap(this.generators);
    }

    public Map<String, SchemeMapping> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    public Collection<VisibilityRule> getVisibilityRules() {
        return Collections.unmodifiableCollection(this.vrules);
    }

    public Collection<RecordSource> getRecordGenerationSources() {
        return Collections.unmodifiableCollection(this.generationOrder);
    }

    public boolean isEmpty() {
        return this.imports.isEmpty() && this.types.isEmpty() && this.enums.isEmpty() && this.records.isEmpty() && this.generators.isEmpty() && this.mappings.isEmpty() && this.vrules.isEmpty();
    }

    public boolean hasType(String name) {
        return this.types.containsKey(name) || this.embeddedTypes.isKnownType(name);
    }

    public EmbeddedTypes getEmbeddedTypes() {
        return this.embeddedTypes;
    }

    public SerialFieldType resolveType(String type) {
        SchemeType t = this.types.get(type);
        if (t != null) {
            return this.embeddedTypes.getSerialType(t.getResolvedType());
        }
        return this.embeddedTypes.getSerialType(type);
    }

    public void addImport(SchemeImport imp) {
        this.imports.add(Objects.requireNonNull(imp, "imp"));
    }

    public void addType(SchemeType type) throws SchemeException {
        if (this.embeddedTypes.isKnownType(type.getName())) {
            throw new SchemeException(SchemeException.formatConflictMessage(type, this.name, "Type with name \"" + type.getName() + "\" conflicts with embedded type"), type.getFilesList());
        }
        SchemeType existingType = this.types.get(type.getName());
        if (existingType != null) {
            existingType.override(type);
        } else {
            this.types.put(type.getName(), type);
        }
        this.addNewSources(type);
    }

    public void addEnum(SchemeEnum enm) throws SchemeException {
        SchemeEnum existingEnum = this.enums.get(enm.getName());
        if (existingEnum != null) {
            existingEnum.override(enm);
        } else {
            this.enums.put(enm.getName(), enm);
        }
        this.addNewSources(enm);
    }

    public void addRecord(SchemeRecord record) throws SchemeException {
        SchemeRecord existingRecord = this.records.get(record.getName());
        if (existingRecord != null) {
            existingRecord.override(record);
        } else {
            this.records.put(record.getName(), record);
            this.generationOrder.add(new RecordSource(RecordSource.Type.RECORD, record.getName()));
        }
        this.addNewSources(record);
    }

    public void addGenerator(SchemeRecordGenerator generator) throws SchemeException {
        SchemeRecordGenerator existingGenerator = this.generators.get(generator.getName());
        if (existingGenerator != null) {
            existingGenerator.override(generator);
        } else {
            this.generators.put(generator.getName(), generator);
            this.generationOrder.add(new RecordSource(RecordSource.Type.GENERATOR, generator.getName()));
        }
        this.addNewSources(generator);
    }

    public void addMapping(SchemeMapping mapping) throws SchemeException {
        SchemeMapping existingMapping = this.mappings.get(mapping.getName());
        if (existingMapping != null) {
            existingMapping.override(mapping);
        } else {
            this.mappings.put(mapping.getName(), mapping);
        }
        this.addNewSources(mapping);
    }

    public void addVisibilityRule(VisibilityRule rule) {
        this.vrules.add(rule);
    }

    public void override(SchemeModel other) throws SchemeException {
        this.sources.addAll(other.getSources());
        this.imports.addAll(other.imports);
        this.overrideEntityCollection(this.types, other.types);
        this.overrideEntityCollection(this.enums, other.enums);
        this.overrideEntityCollection(this.records, other.records);
        this.overrideEntityCollection(this.generators, other.generators);
        this.overrideEntityCollection(this.mappings, other.mappings);
        this.vrules.addAll(other.vrules);
        HashSet<RecordSource> go = new HashSet<RecordSource>(this.generationOrder);
        for (RecordSource rs : other.generationOrder) {
            if (!go.add(rs)) continue;
            this.generationOrder.add(rs);
        }
        this.types.values().forEach(SchemeType::setUnresolved);
        ++this.mergedIn;
    }

    public int mergedInCount() {
        return this.mergedIn;
    }

    public List<SchemeException> validateState() {
        ArrayList<SchemeException> rv = new ArrayList<SchemeException>();
        this.validateCollectionState(this.types.values(), rv);
        this.validateCollectionState(this.enums.values(), rv);
        this.validateCollectionState(this.records.values(), rv);
        this.validateCollectionState(this.generators.values(), rv);
        return rv;
    }

    public boolean isRecordEnabled(SchemeRecord rec, String actualRecordName) {
        boolean enabled = !rec.isDisabled();
        for (VisibilityRule r : this.vrules) {
            if (!r.match(rec, actualRecordName)) continue;
            enabled = r.isEnable();
        }
        return enabled;
    }

    public boolean isRecordFieldEnabled(String actualRecordName, SchemeRecord.Field field) {
        boolean enabled = !field.isDisabled();
        for (VisibilityRule r : this.vrules) {
            if (!r.match(actualRecordName, field)) continue;
            enabled = r.isEnable();
        }
        return enabled;
    }

    public void finishMergeIn(String source) {
        this.addNewSourcesImpl(Collections.singletonList(source));
    }

    private <T extends SchemeEntity> void addNewSources(T entity) {
        this.addNewSourcesImpl(entity.getFilesList());
    }

    private void addNewSourcesImpl(List<String> newSources) {
        boolean add;
        if (newSources.size() == 1) {
            add = !this.sources.get(this.sources.size() - 1).equals(newSources.get(0));
        } else {
            int from = this.sources.size() - newSources.size();
            boolean bl = add = from < 0 || !this.sources.subList(from, this.sources.size()).equals(newSources);
        }
        if (add) {
            this.sources.addAll(newSources);
            this.mergedIn += newSources.size();
        }
    }

    private <T extends NamedEntity<T>> void overrideEntityCollection(Map<String, T> our, Map<String, T> their) throws SchemeException {
        for (NamedEntity t : their.values()) {
            NamedEntity o = (NamedEntity)our.get(t.getName());
            if (o == null) {
                our.put(t.getName(), t);
                continue;
            }
            o.override(t);
        }
    }

    private <T extends NamedEntity<T>> void validateCollectionState(Collection<T> collection, List<SchemeException> rv) {
        for (NamedEntity e : collection) {
            try {
                e.validateState(this);
            }
            catch (SchemeException ex) {
                rv.add(ex);
            }
        }
    }

    public static class Loader
    extends BuilderBase<Loader> {
        private final List<URL> urls = new ArrayList<URL>();

        private Loader() {
        }

        public Loader fromURL(URL url) {
            this.urls.add(Objects.requireNonNull(url, "url"));
            return this;
        }

        public Loader fromURLs(Collection<URL> urls) {
            this.urls.addAll(Objects.requireNonNull(urls, "urls"));
            return this;
        }

        public Loader fromSpecification(String specification) throws IOException {
            this.urls.addAll(SchemeModelLoader.parseSpecification(Objects.requireNonNull(specification, "specification"), this.options));
            return this;
        }

        public SchemeModel load() throws IOException, SchemeException {
            if (this.urls.isEmpty()) {
                throw new IllegalStateException("Cannot load scheme model without URLs");
            }
            return SchemeModelLoader.loadSchemeModel(this.urls, this.options, this.embeddedTypes);
        }
    }

    public static class Builder
    extends BuilderBase<Builder> {
        private String name = null;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public SchemeModel build() {
            if (this.name == null) {
                throw new IllegalStateException("Need name to build empty scheme model");
            }
            return new SchemeModel(this.embeddedTypes, this.name, this.parent);
        }
    }

    private static abstract class BuilderBase<T extends BuilderBase<T>> {
        protected EmbeddedTypes embeddedTypes = SchemeModelLoader.DEFAULT_TYPES;
        protected SchemeLoadingOptions options = new SchemeLoadingOptions();
        protected String parent = null;

        protected BuilderBase() {
        }

        public T withTypes(EmbeddedTypes embeddedTypes) {
            this.embeddedTypes = Objects.requireNonNull(embeddedTypes, "embeddedTypesProvider");
            return (T)this;
        }

        public T withDefaultTypes() {
            this.embeddedTypes = SchemeModelLoader.DEFAULT_TYPES;
            return (T)this;
        }

        public T withOptions(SchemeLoadingOptions options) {
            this.options = Objects.requireNonNull(options, "options");
            return (T)this;
        }

        public T withParent(String parent) {
            this.parent = parent;
            return (T)this;
        }
    }

    public static final class RecordSource {
        private final Type type;
        private final String name;

        private RecordSource(Type type, String name) {
            this.type = Objects.requireNonNull(type, "type");
            this.name = Objects.requireNonNull(name, "name");
        }

        public Type getSource() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordSource that = (RecordSource)o;
            return this.type == that.type && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.name});
        }

        public static enum Type {
            RECORD,
            GENERATOR;

        }
    }
}

