/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.viewer.ViewerCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

class BarGraphCellRenderer
extends ViewerCellRenderer
implements Icon {
    private double maxValue = 0.0;
    private boolean useParentColor = true;
    private int graphAlignment = 2;

    BarGraphCellRenderer(boolean useParentColor) {
        this.useParentColor = useParentColor;
        this.setIcon(this);
        this.graphAlignment = 2;
    }

    public void toggleHorizontalAlignment() {
        this.graphAlignment = this.graphAlignment == 4 ? 2 : 4;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g;
        Color col = new Color(0, 49, 91);
        Color bg = this.getBackground();
        if (this.useParentColor) {
            col = bg.brighter();
        }
        if (!col.equals(bg)) {
            g2d.setColor(col);
            int w = this.getWidth();
            double v = this.getValue();
            double zoomFactor = (double)w / this.maxValue;
            int d = (int)(v * zoomFactor);
            d = Math.min(d, w);
            g2d.fillRect(this.graphAlignment == 4 ? w - d : 0, 0, d, this.getHeight());
        }
    }

    @Override
    public int getIconWidth() {
        return 1;
    }

    @Override
    public int getIconHeight() {
        return 1;
    }

    boolean setMaxValue(double maxValue) {
        if (this.maxValue != maxValue) {
            this.maxValue = maxValue;
            return true;
        }
        return false;
    }
}

