/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.viewer.Credentials;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class PasswordDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField usernameTextField;
    private JPasswordField passwordTextField;
    private JLabel titleLabel;
    private JLabel warningLabel;
    boolean isOK = false;

    public PasswordDialog() {
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.setPreferredSize(new Dimension(300, 220));
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.usernameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PasswordDialog.this.validateTextFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PasswordDialog.this.validateTextFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PasswordDialog.this.validateTextFields();
            }
        });
        this.passwordTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PasswordDialog.this.validateTextFields();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PasswordDialog.this.validateTextFields();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PasswordDialog.this.validateTextFields();
            }
        });
        this.passwordTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PasswordDialog.this.passwordTextField.selectAll();
                super.focusGained(e);
            }
        });
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PasswordDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasswordDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onOK() {
        this.dispose();
        this.isOK = true;
    }

    private void onCancel() {
        this.dispose();
    }

    private void validateTextFields() {
        this.buttonOK.setEnabled(this.usernameTextField.getText().length() > 0 && this.passwordTextField.getPassword().length > 0);
    }

    public static Credentials showPasswordDialog(String title, Credentials credentials, JFrame parent) {
        return PasswordDialog.showPasswordDialog(title, credentials, parent, null);
    }

    public static Credentials showPasswordDialog(String title, Credentials credentials, JFrame parent, String warning) {
        Credentials result = null;
        PasswordDialog dialog = new PasswordDialog();
        dialog.titleLabel.setText(title);
        if (credentials != null) {
            dialog.usernameTextField.setText(credentials.getUsername());
            dialog.passwordTextField.setText(credentials.getPassword());
        }
        dialog.pack();
        dialog.setTitle("Please log in");
        if (warning == null) {
            dialog.warningLabel.setVisible(false);
        } else {
            dialog.warningLabel.setVisible(true);
            dialog.warningLabel.setText(warning);
        }
        dialog.setLocationRelativeTo(parent);
        if (parent != null) {
            dialog.setLocation((int)parent.getLocationOnScreen().getX() + parent.getWidth() / 2 - dialog.getSize().width / 2, (int)parent.getLocationOnScreen().getY() + parent.getHeight() / 2 - dialog.getSize().height / 2);
        }
        dialog.usernameTextField.grabFocus();
        dialog.setVisible(true);
        if (dialog.isOK) {
            result = new Credentials(dialog.usernameTextField.getText(), String.valueOf(dialog.passwordTextField.getPassword()));
        }
        return result;
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new GridBagLayout());
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.contentPane.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 3;
        panel1.add((Component)panel2, gbc);
        this.buttonOK = new JButton();
        this.buttonOK.setEnabled(false);
        this.buttonOK.setText("Connect");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 10);
        panel2.add((Component)this.buttonOK, gbc);
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        panel2.add((Component)this.buttonCancel, gbc);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.contentPane.add((Component)panel3, gbc);
        panel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.titleLabel = new JLabel();
        this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/dxfeed/viewer/icons/password.png")));
        this.titleLabel.setText("Connect to:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.gridheight = 2;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        panel3.add((Component)this.titleLabel, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Username:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        panel3.add((Component)label1, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Password: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 10);
        panel3.add((Component)label2, gbc);
        this.usernameTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel3.add((Component)this.usernameTextField, gbc);
        this.passwordTextField = new JPasswordField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel3.add((Component)this.passwordTextField, gbc);
        this.warningLabel = new JLabel();
        this.warningLabel.setFocusable(false);
        Font warningLabelFont = this.$$$getFont$$$(null, -1, 10, this.warningLabel.getFont());
        if (warningLabelFont != null) {
            this.warningLabel.setFont(warningLabelFont);
        }
        this.warningLabel.setForeground(new Color(-4521975));
        this.warningLabel.setText("Wrong username/password/ipfAddress");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        panel3.add((Component)this.warningLabel, gbc);
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

