/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.util.LogUtil;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXFeedTimeSeriesSubscription;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.event.market.Trade;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileReader;
import com.dxfeed.ipf.option.OptionChain;
import com.dxfeed.ipf.option.OptionChainsBuilder;
import com.dxfeed.ipf.option.OptionSeries;
import com.dxfeed.model.ObservableListModel;
import com.dxfeed.model.market.OrderBookModel;
import com.dxfeed.model.market.OrderBookModelFilter;
import com.dxfeed.ondemand.OnDemandService;
import com.dxfeed.viewer.BarGraphCellRenderer;
import com.dxfeed.viewer.Credentials;
import com.dxfeed.viewer.EventTableModel;
import com.dxfeed.viewer.OrderTableModel;
import com.dxfeed.viewer.PasswordDialog;
import com.dxfeed.viewer.QuoteBoardTableColumn;
import com.dxfeed.viewer.QuoteBoardTableModel;
import com.dxfeed.viewer.Stats;
import com.dxfeed.viewer.SubscriptionChangeListener;
import com.dxfeed.viewer.SuggestMenu;
import com.dxfeed.viewer.SwingExecutor;
import com.dxfeed.viewer.TickChartRendererPanel;
import com.dxfeed.viewer.TimeAndSalesTableModel;
import com.dxfeed.viewer.ViewerCellRenderer;
import com.formdev.flatlaf.intellijthemes.FlatOneDarkIJTheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableColumnModel;
import javax.swing.text.StyleContext;

public class DXFeedMarketDataViewer
implements Runnable {
    private static final String PROPERTIES_FILE = "dxviewer.cfg";
    private static final String PROPERTIES_PATH = File.separatorChar + ".dxviewer" + File.separatorChar + "dxviewer.cfg";
    private static final String NAME_PROPERTY = "name";
    private static final String ADDRESS_PROPERTY = "address";
    private static final String SYMBOLS_PROPERTY = "symbols";
    private static final String MAX_TIME_AND_SALES_PROPERTY = "maxTimeAndSalesCapacity";
    private static final String UI_REFRESH_PERIOD_PROPERTY = "uiRefreshPeriod";
    private static final String UI_SCHEME_PROPERTY = "uiScheme";
    private static final String IPF_ADDRESS = "ipfAddress";
    private static final Logging log = Logging.getLogging(DXFeedMarketDataViewer.class);
    private JPanel form;
    private JLabel mpsLabel;
    private JTable quoteBoardTable;
    private JTable timeAndSalesTable;
    private JTable bidTable;
    private JTable askTable;
    private JLabel qpsLabel;
    private JLabel tpsLabel;
    private JLabel spsLabel;
    private JLabel opsLabel;
    private JLabel tspsLabel;
    private JScrollPane timeAndSalesScrollPane;
    private JPanel tickChartPanel;
    private JTabbedPane tabbedPane;
    private JLabel bookModeLabel;
    private JLabel lotSizeLabel;
    private JTextField connectionAddressEdit;
    private JButton playButton;
    private JButton pauseButton;
    private JSlider onDemandSpeedSlider;
    private JComboBox<String> modeComboBox;
    private JToolBar addressToolbar;
    private JToolBar onDemandToolbar;
    private JSpinner onDemandTimeSpinner;
    private JLabel onDemandSpeedLabel;
    private JLabel currentTimeLabel;
    private JComboBox<String> tzComboBox;
    private JButton connectAsButton;
    private JLabel onDemandConnectionStatusLabel;
    private JLabel onDemandUsernameLabel;
    private JLabel ipfWebConnectionStatusLabel;
    private JLabel ipfWebUsernameLabel;
    private TickChartRendererPanel tickChartRendererPanel;
    private LabelFlashSupport labelFlasher;
    private SuggestMenu suggestMenu;
    private final String configFile;
    private final String name;
    private String address;
    private IpfMode ipfMode;
    private final String ipfAddress;
    private final InstrumentProfileReader ipfReader;
    private List<InstrumentProfile> instruments;
    private Map<String, OptionChain<InstrumentProfile>> chains;
    private final String symbols;
    private final int maxTimeAndSalesCapacity;
    private final int uiRefreshPeriod;
    private final SimpleDateFormat timeFormatSelectedTZ = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private Credentials onDemandCredentials;
    private Credentials ipfWebServiceCredentials;
    private DXEndpoint endpoint;
    private DXFeed feed;
    private OnDemandService onDemand;
    private boolean isInOnDemandMode = false;
    private final Stats eventStats = new Stats("Total/s");
    private final Stats quoteStats = new Stats("Q/s");
    private final Stats tradeStats = new Stats("T/s");
    private final Stats summaryStats = new Stats("OHLC/s");
    private final Stats orderStats = new Stats("Ord/s");
    private final Stats tnsStats = new Stats("TnS/s");
    private final List<DXFeedSubscription<?>> quoteBoardSubscriptions = new ArrayList();
    private DXFeedSubscription<Order> orderSubscription;
    private DXFeedTimeSeriesSubscription<TimeAndSale> timeAndSalesSubscription;
    private BarGraphCellRenderer bidSizeGraphRenderer;
    private BarGraphCellRenderer askSizeGraphRenderer;
    private final int scheme = 0;
    private final QuoteBoardTableModel quoteBoardTableModel = new QuoteBoardTableModel(new SubscriptionChangeListener(){

        @Override
        public void addSymbol(String symbol) {
            Set<String> symbols = Collections.singleton(symbol);
            for (DXFeedSubscription subscription : DXFeedMarketDataViewer.this.quoteBoardSubscriptions) {
                subscription.addSymbols(symbols);
            }
        }

        @Override
        public void removeSymbol(String symbol) {
            Set<String> symbols = Collections.singleton(symbol);
            for (DXFeedSubscription subscription : DXFeedMarketDataViewer.this.quoteBoardSubscriptions) {
                subscription.removeSymbols(symbols);
            }
        }
    });
    private final OrderBookModel orderBookModel = new OrderBookModel();
    private final OrderTableModel bidTableModel = new OrderTableModel((ObservableListModel<Order>)this.orderBookModel.getBuyOrders());
    private final OrderTableModel askTableModel = new OrderTableModel((ObservableListModel<Order>)this.orderBookModel.getSellOrders());
    private final TimeAndSalesTableModel timeAndSalesTableModel;
    private String selectedSymbol;
    private double onDemandSpeed;
    private TimezoneComboBoxSupport tzComboBoxSupport;
    private JFrame mainFrame;
    private final Action insertAction = new AbstractAction("Insert"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.addRow();
        }
    };
    private final Action removeAction = new AbstractAction("Remove"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor() != null) {
                DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor().stopCellEditing();
            }
            int rowIndex = DXFeedMarketDataViewer.this.quoteBoardTable.getSelectionModel().getMinSelectionIndex();
            4 var3_3 = this;
            synchronized (var3_3) {
                int[] selectedRows = DXFeedMarketDataViewer.this.quoteBoardTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    selectedRows[i] = DXFeedMarketDataViewer.this.quoteBoardTable.convertRowIndexToModel(selectedRows[i]);
                }
                DXFeedMarketDataViewer.this.quoteBoardTableModel.removeRows(selectedRows);
                rowIndex = Math.min(rowIndex, DXFeedMarketDataViewer.this.quoteBoardTable.getRowCount() - 1);
                DXFeedMarketDataViewer.this.quoteBoardTable.changeSelection(rowIndex, -1, false, false);
            }
            DXFeedMarketDataViewer.this.quoteBoardTable.requestFocus();
        }
    };
    private final Action upAction = new AbstractAction("Move Up"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowIndex;
            if (DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor() != null) {
                DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor().stopCellEditing();
            }
            if ((rowIndex = DXFeedMarketDataViewer.this.quoteBoardTable.getSelectionModel().getLeadSelectionIndex()) <= 0) {
                return;
            }
            DXFeedMarketDataViewer.this.quoteBoardTableModel.swapRows(rowIndex - 1, rowIndex);
            DXFeedMarketDataViewer.this.quoteBoardTable.changeSelection(rowIndex - 1, -1, false, false);
            DXFeedMarketDataViewer.this.quoteBoardTable.requestFocus();
        }
    };
    private final Action downAction = new AbstractAction("Move Down"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowIndex;
            if (DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor() != null) {
                DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor().stopCellEditing();
            }
            if ((rowIndex = DXFeedMarketDataViewer.this.quoteBoardTable.getSelectionModel().getLeadSelectionIndex()) == -1 || rowIndex >= DXFeedMarketDataViewer.this.quoteBoardTable.getRowCount() - 1) {
                return;
            }
            DXFeedMarketDataViewer.this.quoteBoardTableModel.swapRows(rowIndex, rowIndex + 1);
            DXFeedMarketDataViewer.this.quoteBoardTable.changeSelection(rowIndex + 1, -1, false, false);
            DXFeedMarketDataViewer.this.quoteBoardTable.requestFocus();
        }
    };
    private final Action editAction = new AbstractAction("Edit symbol"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor() == null) {
                DXFeedMarketDataViewer.this.quoteBoardTable.editCellAt(DXFeedMarketDataViewer.this.quoteBoardTable.getSelectionModel().getLeadSelectionIndex(), DXFeedMarketDataViewer.this.quoteBoardTable.convertColumnIndexToView(0));
                DXFeedMarketDataViewer.this.quoteBoardTable.getEditorComponent().requestFocusInWindow();
            } else {
                DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor().stopCellEditing();
                if (DXFeedMarketDataViewer.this.suggestMenu != null && DXFeedMarketDataViewer.this.suggestMenu.isShowing()) {
                    DXFeedMarketDataViewer.this.suggestMenu.setVisible(false);
                }
            }
        }
    };
    private final Action viewOptions4Strikes = new AbstractAction("View options: 4 strikes"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.addOptionsToWatchlist(4);
        }
    };
    private final Action viewOptions8Strikes = new AbstractAction("View options: 8 strikes"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.addOptionsToWatchlist(8);
        }
    };
    private final Action viewOptionsAllStrikes = new AbstractAction("View options: all strikes"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.addOptionsToWatchlist(Integer.MAX_VALUE);
        }
    };
    private final Action toggleBidSizeGraphRendererAlignment = new AbstractAction("Toggle Bid Size graph alignment"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.bidSizeGraphRenderer.toggleHorizontalAlignment();
            DXFeedMarketDataViewer.this.bidTableModel.fireTableChanged(new TableModelEvent(DXFeedMarketDataViewer.this.bidTableModel));
        }
    };
    private final Action toggleAskSizeGraphRendererAlignment = new AbstractAction("Toggle Ask Size graph alignment"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.askSizeGraphRenderer.toggleHorizontalAlignment();
            DXFeedMarketDataViewer.this.askTableModel.fireTableChanged(new TableModelEvent(DXFeedMarketDataViewer.this.askTableModel));
        }
    };
    private final Action replayFromSelectedTimeAndSale = new AbstractAction("Replay from selected time"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = DXFeedMarketDataViewer.this.timeAndSalesTable.getSelectionModel().getMinSelectionIndex();
            if (index >= 0) {
                TimeAndSale tns = (TimeAndSale)((DXFeedMarketDataViewer)DXFeedMarketDataViewer.this).timeAndSalesTableModel.events.get(index);
                if (DXFeedMarketDataViewer.this.switchToOnDemandMode()) {
                    Date date = new Date(tns.getTime());
                    DXFeedMarketDataViewer.this.onDemandTimeSpinner.setValue(date);
                    DXFeedMarketDataViewer.this.onDemand.replay(date);
                    DXFeedMarketDataViewer.this.play.actionPerformed(null);
                    DXFeedMarketDataViewer.this.forceSelectSymbol(DXFeedMarketDataViewer.this.selectedSymbol);
                }
            }
        }
    };
    private final Action pause = new AbstractAction("Freeze"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.onDemand.pause();
            DXFeedMarketDataViewer.this.quoteBoardTableModel.setFrozen(true);
            DXFeedMarketDataViewer.this.bidTableModel.setFrozen(true);
            DXFeedMarketDataViewer.this.askTableModel.setFrozen(true);
            DXFeedMarketDataViewer.this.timeAndSalesTableModel.setFrozen(true);
            DXFeedMarketDataViewer.this.pauseButton.setEnabled(false);
            DXFeedMarketDataViewer.this.playButton.setEnabled(true);
        }
    };
    private final Action play = new AbstractAction("Unfreeze"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.quoteBoardTableModel.setFrozen(false);
            DXFeedMarketDataViewer.this.bidTableModel.setFrozen(false);
            DXFeedMarketDataViewer.this.askTableModel.setFrozen(false);
            DXFeedMarketDataViewer.this.timeAndSalesTableModel.setFrozen(false);
            if (DXFeedMarketDataViewer.this.isInOnDemandMode) {
                DXFeedMarketDataViewer.this.onDemand.replay(DXFeedMarketDataViewer.this.onDemand.getTime());
            }
            DXFeedMarketDataViewer.this.pauseButton.setEnabled(true);
            DXFeedMarketDataViewer.this.playButton.setEnabled(false);
        }
    };

    private DXFeedMarketDataViewer(String configFile) {
        this.configFile = configFile;
        this.$$$setupUI$$$();
        Properties properties = this.loadConfiguration(configFile);
        this.name = properties.getProperty(NAME_PROPERTY, "");
        this.address = properties.getProperty(ADDRESS_PROPERTY, "demo.dxfeed.com:7300");
        this.symbols = properties.getProperty(SYMBOLS_PROPERTY, "");
        this.ipfAddress = properties.getProperty(IPF_ADDRESS, "securities.ipf.zip");
        this.maxTimeAndSalesCapacity = this.getIntProperty(properties.getProperty(MAX_TIME_AND_SALES_PROPERTY), 1000);
        int refreshPeriod = this.getIntProperty(properties.getProperty(UI_REFRESH_PERIOD_PROPERTY), 150);
        this.uiRefreshPeriod = refreshPeriod < 10 ? 10 : refreshPeriod;
        this.ipfReader = new InstrumentProfileReader();
        this.loadIpfAndCredentials();
        this.timeAndSalesTableModel = new TimeAndSalesTableModel(this.maxTimeAndSalesCapacity);
    }

    private int getIntProperty(String value, int defaultValue) {
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            log.error("Failed to parse integer property from string \"" + value + "\"");
        }
        return defaultValue;
    }

    private Properties loadConfiguration(String configFile) {
        Properties properties = new Properties();
        File file = new File(configFile);
        if (!file.exists()) {
            log.info(LogUtil.hideCredentials((Object)file.getAbsoluteFile()) + " file not found; will use default configuration");
            file = new File(PROPERTIES_FILE);
        }
        if (file.exists()) {
            log.info("Loading configuration from " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()));
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
            catch (IOException e) {
                log.error("Failed to load configuration from " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()) + "; will use default configuration");
            }
        }
        return properties;
    }

    private void saveConfiguration(String configFile) {
        File file = new File(configFile);
        log.info("Saving configuration into " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()));
        try {
            Properties properties = new Properties();
            properties.setProperty(NAME_PROPERTY, this.name);
            properties.setProperty(ADDRESS_PROPERTY, this.address);
            properties.setProperty(IPF_ADDRESS, this.ipfAddress);
            properties.setProperty(SYMBOLS_PROPERTY, this.quoteBoardTableModel.getSymbols());
            properties.setProperty(MAX_TIME_AND_SALES_PROPERTY, Integer.toString(this.maxTimeAndSalesCapacity));
            properties.setProperty(UI_REFRESH_PERIOD_PROPERTY, Integer.toString(this.uiRefreshPeriod));
            properties.setProperty(UI_SCHEME_PROPERTY, Integer.toString(0));
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            properties.store(new FileOutputStream(file), "dxFeed Market Data Viewer Configuration");
        }
        catch (IOException e) {
            log.error("Failed to save configuration into " + LogUtil.hideCredentials((Object)file.getAbsoluteFile()), (Throwable)e);
        }
    }

    private void loadIpfAndCredentials() {
        this.ipfWebConnectionStatusLabel.setText("NOT CONNECTED");
        this.ipfWebConnectionStatusLabel.setForeground(Color.RED.darker());
        if (this.ipfAddress.startsWith("http")) {
            this.instruments = null;
            this.chains = null;
            if (!this.showIpfWebServicePasswordDialog()) {
                this.ipfMode = IpfMode.NO_IPF;
                log.info("No credentials for " + LogUtil.hideCredentials((Object)this.ipfAddress) + ", work without instrument profiles");
            } else {
                this.ipfMode = IpfMode.WEB_SERVICE;
                log.info("Will load instrument profiles from " + LogUtil.hideCredentials((Object)this.ipfAddress) + " on demand.");
                this.ipfWebConnectionStatusLabel.setText("CONNECTED");
                this.ipfWebConnectionStatusLabel.setForeground(Color.GREEN.darker());
            }
        } else {
            try {
                log.debug("Reading instrument profiles from " + LogUtil.hideCredentials((Object)this.ipfAddress) + "...");
                this.instruments = this.ipfReader.readFromFile(this.ipfAddress);
                log.debug("done");
                log.debug("Building option chains from " + LogUtil.hideCredentials((Object)this.ipfAddress) + "...");
                this.chains = OptionChainsBuilder.build(this.instruments).getChains();
                log.debug("done");
                this.ipfMode = IpfMode.LOCAL_FILE;
            }
            catch (IOException e) {
                this.ipfMode = IpfMode.NO_IPF;
                log.debug("fail to load ipf from " + LogUtil.hideCredentials((Object)this.ipfAddress));
                log.info("Work without instrument profiles");
            }
        }
    }

    private boolean showIpfWebServicePasswordDialog() {
        boolean result;
        block3: {
            result = false;
            Credentials c = this.ipfWebServiceCredentials != null ? this.ipfWebServiceCredentials : new Credentials("demo", "demo");
            String title = "Accessing IPF service [" + LogUtil.hideCredentials((Object)this.ipfAddress) + "]";
            boolean firstIteration = true;
            while (true) {
                c = PasswordDialog.showPasswordDialog(title, c, this.mainFrame, firstIteration ? null : "Wrong username/password/ipfAddress");
                firstIteration = false;
                if (c == null) break block3;
                this.ipfWebServiceCredentials = new Credentials(c.getUsername(), c.getPassword());
                try {
                    URLConnection connection = URLInputStream.openConnection((URL)URLInputStream.resolveURL((String)InstrumentProfileReader.resolveSourceURL((String)this.ipfAddress)), (String)this.ipfWebServiceCredentials.getUsername(), (String)this.ipfWebServiceCredentials.getPassword());
                    URLInputStream.checkConnectionResponseCode((URLConnection)connection);
                }
                catch (IOException e) {
                    log.error("Cannot connect to " + LogUtil.hideCredentials((Object)this.ipfAddress) + " (are username/password correct?)", (Throwable)e);
                    continue;
                }
                break;
            }
            this.ipfWebUsernameLabel.setText("ipf: " + this.ipfWebServiceCredentials.getUsername().toLowerCase());
            result = true;
        }
        return result;
    }

    private void addOptionsToWatchlist(final int strikesAround) {
        final int rowIndex = this.quoteBoardTable.getSelectionModel().getLeadSelectionIndex();
        if (this.ipfMode == IpfMode.NO_IPF || rowIndex == -1 || rowIndex >= this.quoteBoardTable.getRowCount() - 1) {
            return;
        }
        SwingWorker<OptionChain<InstrumentProfile>, Void> worker = new SwingWorker<OptionChain<InstrumentProfile>, Void>(){

            @Override
            protected OptionChain<InstrumentProfile> doInBackground() throws Exception {
                return DXFeedMarketDataViewer.this.getOptionChain(DXFeedMarketDataViewer.this.selectedSymbol);
            }

            @Override
            protected void done() {
                try {
                    int rowIndex_ = rowIndex;
                    OptionChain chain = (OptionChain)this.get();
                    double price = ((DXFeedMarketDataViewer)DXFeedMarketDataViewer.this).quoteBoardTableModel.getRowAt((int)rowIndex_).lastPrice;
                    ArrayList<String> symbolList = new ArrayList<String>(Arrays.asList(DXFeedMarketDataViewer.this.quoteBoardTableModel.getSymbols().split(",")));
                    for (OptionSeries series : chain.getSeries()) {
                        List strikes = strikesAround == Integer.MAX_VALUE ? series.getStrikes() : series.getNStrikesAround(strikesAround, price);
                        for (Double strike : strikes) {
                            InstrumentProfile call = (InstrumentProfile)series.getCalls().get(strike);
                            InstrumentProfile put = (InstrumentProfile)series.getPuts().get(strike);
                            if (call != null) {
                                symbolList.add(++rowIndex_, call.getSymbol());
                            }
                            if (put == null) continue;
                            symbolList.add(++rowIndex_, put.getSymbol());
                        }
                    }
                    log.info(symbolList.size() + " symbols added from chains");
                    DXFeedMarketDataViewer.this.quoteBoardTableModel.setSymbols(symbolList.toString().replace("[", "").replace("]", "").replace(", ", ","));
                }
                catch (InterruptedException rowIndex_) {
                }
                catch (ExecutionException e) {
                    log.error("Cannot add options to watchlist", (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    private OptionChain<InstrumentProfile> getOptionChain(String selectedSymbol) throws IOException {
        if (this.ipfMode == IpfMode.LOCAL_FILE) {
            return this.chains.get(selectedSymbol);
        }
        if (this.ipfMode != IpfMode.WEB_SERVICE) {
            throw new IllegalStateException("Cannot extract option chain in " + (Object)((Object)this.ipfMode) + " mode");
        }
        String url = this.ipfAddress + "?types=OPTION&underlyings=" + selectedSymbol;
        List instrumentProfiles = this.ipfReader.readFromFile(url, this.ipfWebServiceCredentials.getUsername(), this.ipfWebServiceCredentials.getPassword());
        return (OptionChain)OptionChainsBuilder.build((Collection)instrumentProfiles).getChains().get(selectedSymbol);
    }

    private void updateOrderBook() {
        int index = Math.min(this.quoteBoardTable.getSelectionModel().getLeadSelectionIndex(), this.quoteBoardTable.getRowCount() - 1);
        if (index >= 0) {
            this.selectSymbol(this.quoteBoardTableModel.getRowAt((int)this.quoteBoardTable.convertRowIndexToModel((int)index)).symbol);
        }
    }

    private void forceSelectSymbol(String symbol) {
        this.selectedSymbol = symbol;
        this.orderSubscription.clear();
        this.orderBookModel.clear();
        this.timeAndSalesSubscription.clear();
        this.timeAndSalesTableModel.eventsReceived(Collections.singletonList(TimeAndSalesTableModel.CLEAR));
        if (symbol != null && symbol.length() > 0) {
            this.orderBookModel.setSymbol(symbol);
            List<String> symbols = Collections.singletonList(symbol);
            this.orderSubscription.setSymbols(symbols);
            this.timeAndSalesSubscription.setSymbols(symbols);
            this.tickChartRendererPanel.setSymbol(this.selectedSymbol);
            this.tickChartRendererPanel.setAutoZoom(true);
            this.tickChartRendererPanel.repaint();
        }
    }

    private void selectSymbol(String symbol) {
        if (this.selectedSymbol != null && this.selectedSymbol.equals(symbol)) {
            return;
        }
        this.forceSelectSymbol(symbol);
    }

    private double adjustMaxSizeForZoomFactor(double size) {
        double adjustedMaxSize = size <= 5.0 ? 10.0 : (size <= 10.0 ? 18.0 : (size <= 30.0 ? 48.0 : (size <= 55.0 ? 75.0 : (size <= 95.0 ? 130.0 : (size <= 1000.0 ? size * 1.2 : (size <= 10000.0 ? size * 1.01 : (size <= 100000.0 ? size * 1.001 : size * 1.0002)))))));
        return adjustedMaxSize;
    }

    private void calibrateGraphRendererZoomFactors() {
        double maxSize = Math.max(this.bidTableModel.getMaxSize(), this.askTableModel.getMaxSize());
        double zoomFactor = this.adjustMaxSizeForZoomFactor(maxSize);
        if (this.bidSizeGraphRenderer.setMaxValue(zoomFactor)) {
            this.bidTable.repaint();
        }
        if (this.askSizeGraphRenderer.setMaxValue(zoomFactor)) {
            this.askTable.repaint();
        }
    }

    private void addRow() {
        int rowIndex;
        if (this.quoteBoardTable.getCellEditor() != null) {
            this.quoteBoardTable.getCellEditor().stopCellEditing();
        }
        if ((rowIndex = this.quoteBoardTable.getSelectionModel().getLeadSelectionIndex()) == -1) {
            rowIndex = this.quoteBoardTable.getRowCount();
        }
        this.quoteBoardTableModel.addRow(this.quoteBoardTable.convertRowIndexToModel(rowIndex));
        this.quoteBoardTable.changeSelection(rowIndex, -1, false, false);
        this.quoteBoardTable.requestFocus();
        this.quoteBoardTable.editCellAt(rowIndex, this.quoteBoardTable.convertColumnIndexToView(QuoteBoardTableColumn.SYMBOL.ordinal()));
        this.quoteBoardTable.getEditorComponent().requestFocusInWindow();
    }

    private static void setDarkTheme() {
        ViewerCellRenderer.INSTANCE.setScheme(0);
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatOneDarkIJTheme());
            FontUIResource text = (FontUIResource)UIManager.get("defaultFont");
            Font boldFont = text.deriveFont(1, text.getSize());
            UIManager.put("defaultFont", new FontUIResource(boldFont));
            UIManager.put("Component.arrowType", "chevron");
            UIManager.put("Component.focusWidth", 1);
            UIManager.put("ScrollBar.width", 16);
            UIManager.put("ScrollBar.showButtons", true);
            UIManager.put("Table.intercellSpacing", new Dimension(1, 1));
        }
        catch (Exception e) {
            log.error("Cannot set LookAndFeel theme", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        DXFeedMarketDataViewer.setDarkTheme();
        String defaultConfigFile = System.getProperty("user.home") + PROPERTIES_PATH;
        String configFile = args.length > 0 ? args[0] : defaultConfigFile;
        SwingUtilities.invokeLater(new DXFeedMarketDataViewer(configFile));
    }

    @Override
    public void run() {
        this.createFeed();
        this.initQuoteBoard();
        this.initMarketDepth();
        this.initTimeAndSales();
        this.initTickChartRendererPanel();
        this.initStatsUpdater();
        this.createFrame();
    }

    private void createFeed() {
        if (this.endpoint != null) {
            this.endpoint.disconnectAndClear();
        } else {
            this.endpoint = DXEndpoint.create().executor((Executor)new SwingExecutor(this.uiRefreshPeriod));
            this.labelFlasher = new LabelFlashSupport(this.onDemandConnectionStatusLabel);
            this.endpoint.addStateChangeListener(e -> {
                if ("state".equals(e.getPropertyName())) {
                    String text = "";
                    Color color = Color.WHITE;
                    DXEndpoint.State state = (DXEndpoint.State)e.getNewValue();
                    this.labelFlasher.stopFlashing();
                    switch (state) {
                        case CLOSED: {
                            text = text + "CLOSED";
                            color = Color.GRAY;
                            break;
                        }
                        case CONNECTED: {
                            text = text + "CONNECTED";
                            color = Color.GREEN.darker();
                            break;
                        }
                        case CONNECTING: {
                            text = text + "Connecting...";
                            color = Color.YELLOW.darker();
                            break;
                        }
                        case NOT_CONNECTED: {
                            text = text + "NOT CONNECTED";
                            color = Color.RED.darker();
                        }
                    }
                    this.onDemandConnectionStatusLabel.setText(text);
                    this.onDemandConnectionStatusLabel.setForeground(color);
                    if (state == DXEndpoint.State.CONNECTING) {
                        this.labelFlasher.setLabel(this.onDemandConnectionStatusLabel);
                        this.labelFlasher.startFlashing();
                    }
                }
            });
            this.onDemand = OnDemandService.getInstance((DXEndpoint)this.endpoint);
            this.onDemand.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("replaySupported")) {
                    if (((Boolean)e.getNewValue()).booleanValue()) {
                        this.enableOnDemandControls();
                    } else {
                        this.disableOnDemandControls();
                    }
                }
                if (this.isInOnDemandMode && e.getPropertyName().equals("time")) {
                    this.setCurrentTimeLabel((Date)e.getNewValue());
                }
            });
        }
        this.feed = this.endpoint.getFeed();
        if (this.onDemandCredentials != null) {
            this.endpoint.user(this.onDemandCredentials.getUsername());
            this.endpoint.password(this.onDemandCredentials.getPassword());
        }
        this.endpoint.connect(this.address);
    }

    private void enableOnDemandControls() {
        this.modeComboBox.setEnabled(true);
        this.replayFromSelectedTimeAndSale.setEnabled(true);
    }

    private void disableOnDemandControls() {
        this.modeComboBox.setSelectedIndex(0);
        this.modeComboBox.setEnabled(false);
        this.replayFromSelectedTimeAndSale.setEnabled(false);
    }

    private boolean switchToOnDemandMode() {
        boolean result = false;
        if (!this.isInOnDemandMode && this.modeComboBox.isEnabled()) {
            if (this.onDemandCredentials != null || this.showOnDemandPasswordDialog()) {
                this.modeComboBox.setSelectedIndex(1);
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    private void initQuoteBoard() {
        this.initQuoteBoardTable();
        this.registerQuoteBoardActions();
        this.initQuoteBoardSubscriptions();
    }

    private void setCellRenderer(JTable table) {
        table.setGridColor(ViewerCellRenderer.DARK_SCHEME_GRID_COLOR);
        table.setDefaultRenderer(Object.class, ViewerCellRenderer.INSTANCE);
        DefaultCellEditor ed = (DefaultCellEditor)table.getDefaultEditor(Object.class);
        ed.getComponent().setBackground(ViewerCellRenderer.EDIT_BG_COLOR);
        ed.getComponent().setForeground(ViewerCellRenderer.EDIT_FG_COLOR);
    }

    private void initQuoteBoardTable() {
        this.setCellRenderer(this.quoteBoardTable);
        this.quoteBoardTable.setModel(this.quoteBoardTableModel);
        TableColumnModel columnModel = this.quoteBoardTable.getColumnModel();
        for (QuoteBoardTableColumn column : QuoteBoardTableColumn.values()) {
            columnModel.getColumn(column.ordinal()).setPreferredWidth(column.preferredWidth);
        }
        this.quoteBoardTable.getSelectionModel().addListSelectionListener(e -> this.updateOrderBook());
        this.quoteBoardTable.getModel().addTableModelListener(e -> this.updateOrderBook());
        final JTextField textField = (JTextField)((DefaultCellEditor)this.quoteBoardTable.getDefaultEditor(Object.class)).getComponent();
        textField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (DXFeedMarketDataViewer.this.ipfMode == IpfMode.NO_IPF) {
                    return;
                }
                String prefix = textField.getText() + (e.getKeyChar() <= ' ' ? "" : Character.valueOf(e.getKeyChar()));
                if (DXFeedMarketDataViewer.this.suggestMenu != null && prefix.equals(((DXFeedMarketDataViewer)DXFeedMarketDataViewer.this).suggestMenu.prefix)) {
                    return;
                }
                if (DXFeedMarketDataViewer.this.suggestMenu != null) {
                    DXFeedMarketDataViewer.this.suggestMenu.stop();
                }
                AbstractAction onSelectAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String symbolWithDescription = e.getActionCommand();
                        int space = symbolWithDescription.indexOf(32);
                        String symbol = space < 0 ? symbolWithDescription : symbolWithDescription.substring(0, space);
                        textField.setText(symbol);
                        DXFeedMarketDataViewer.this.suggestMenu.setVisible(false);
                        int lastEditedQuoteBoardRow = -1;
                        int lastEditedQuoteBoardColumn = -1;
                        if (DXFeedMarketDataViewer.this.quoteBoardTable.getEditorComponent() != null) {
                            lastEditedQuoteBoardRow = DXFeedMarketDataViewer.this.quoteBoardTable.getEditingRow();
                            lastEditedQuoteBoardColumn = DXFeedMarketDataViewer.this.quoteBoardTable.getEditingColumn();
                            DXFeedMarketDataViewer.this.quoteBoardTable.getCellEditor().stopCellEditing();
                        }
                        DXFeedMarketDataViewer.this.quoteBoardTable.setValueAt(symbol, lastEditedQuoteBoardRow, lastEditedQuoteBoardColumn);
                        DXFeedMarketDataViewer.this.quoteBoardTable.requestFocusInWindow();
                    }
                };
                if (DXFeedMarketDataViewer.this.ipfMode == IpfMode.LOCAL_FILE) {
                    DXFeedMarketDataViewer.this.suggestMenu = new SuggestMenu(prefix, onSelectAction, DXFeedMarketDataViewer.this.quoteBoardTable, textField, DXFeedMarketDataViewer.this.ipfAddress, DXFeedMarketDataViewer.this.instruments);
                } else if (DXFeedMarketDataViewer.this.ipfMode == IpfMode.WEB_SERVICE) {
                    DXFeedMarketDataViewer.this.suggestMenu = new SuggestMenu(prefix, onSelectAction, DXFeedMarketDataViewer.this.quoteBoardTable, textField, DXFeedMarketDataViewer.this.ipfAddress, DXFeedMarketDataViewer.this.instruments, DXFeedMarketDataViewer.this.ipfWebServiceCredentials.getUsername(), DXFeedMarketDataViewer.this.ipfWebServiceCredentials.getPassword());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.quoteBoardTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (DXFeedMarketDataViewer.this.suggestMenu != null && DXFeedMarketDataViewer.this.suggestMenu.isVisible()) {
                    DXFeedMarketDataViewer.this.suggestMenu.setVisible(false);
                }
            }
        });
    }

    private void registerQuoteBoardActions() {
        this.registerQuoteBoardAction(this.insertAction, KeyStroke.getKeyStroke(155, 0));
        this.registerQuoteBoardAction(this.removeAction, KeyStroke.getKeyStroke(127, 0));
        this.registerQuoteBoardAction(this.upAction, KeyStroke.getKeyStroke(38, 2));
        this.registerQuoteBoardAction(this.downAction, KeyStroke.getKeyStroke(40, 2));
        this.registerQuoteBoardAction(this.editAction, KeyStroke.getKeyStroke(10, 0));
    }

    private void registerQuoteBoardAction(Action action, KeyStroke keyStroke) {
        String key = keyStroke.toString();
        this.quoteBoardTable.getInputMap().put(keyStroke, key);
        this.quoteBoardTable.getActionMap().put(key, action);
    }

    private void initQuoteBoardSubscriptions() {
        DXFeedSubscription quoteSubscription = this.feed.createSubscription(Quote.class);
        DXFeedSubscription tradeSubscription = this.feed.createSubscription(Trade.class);
        DXFeedSubscription summarySubscription = this.feed.createSubscription(Summary.class);
        DXFeedSubscription profileSubscription = this.feed.createSubscription(Profile.class);
        quoteSubscription.addEventListener(events -> {
            this.eventStats.increment(events.size());
            this.quoteStats.increment(events.size());
            this.quoteBoardTableModel.eventsReceived(events);
        });
        tradeSubscription.addEventListener(events -> {
            this.eventStats.increment(events.size());
            this.tradeStats.increment(events.size());
            this.quoteBoardTableModel.eventsReceived(events);
        });
        summarySubscription.addEventListener(events -> {
            this.eventStats.increment(events.size());
            this.summaryStats.increment(events.size());
            this.quoteBoardTableModel.eventsReceived(events);
        });
        profileSubscription.addEventListener(events -> {
            this.eventStats.increment(events.size());
            this.quoteBoardTableModel.eventsReceived(events);
        });
        this.quoteBoardSubscriptions.add(quoteSubscription);
        this.quoteBoardSubscriptions.add(tradeSubscription);
        this.quoteBoardSubscriptions.add(summarySubscription);
        this.quoteBoardSubscriptions.add(profileSubscription);
        this.quoteBoardTableModel.setSymbols(this.symbols);
    }

    private void initMarketDepth() {
        this.initTable(this.bidTable, this.bidTableModel);
        this.initTable(this.askTable, this.askTableModel);
        this.bidSizeGraphRenderer = new BarGraphCellRenderer(true);
        this.bidTable.getColumnModel().getColumn(3).setCellRenderer(this.bidSizeGraphRenderer);
        this.askSizeGraphRenderer = new BarGraphCellRenderer(true);
        this.askTable.getColumnModel().getColumn(3).setCellRenderer(this.askSizeGraphRenderer);
        this.initMarketDepthSubscription();
        this.bidTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = DXFeedMarketDataViewer.this.bidTable.convertColumnIndexToModel(DXFeedMarketDataViewer.this.bidTable.columnAtPoint(e.getPoint()));
                if (index == 3) {
                    DXFeedMarketDataViewer.this.toggleBidSizeGraphRendererAlignment.actionPerformed(null);
                }
            }
        });
        this.askTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = DXFeedMarketDataViewer.this.askTable.convertColumnIndexToModel(DXFeedMarketDataViewer.this.askTable.columnAtPoint(e.getPoint()));
                if (index == 3) {
                    DXFeedMarketDataViewer.this.toggleAskSizeGraphRendererAlignment.actionPerformed(null);
                }
            }
        });
    }

    private void initTable(JTable table, EventTableModel<?> model) {
        table.setModel(model);
        TableColumnModel columnModel = table.getColumnModel();
        for (int i = 0; i < model.columns.length; ++i) {
            columnModel.getColumn(i).setPreferredWidth(model.columns[i].getPreferredWidth());
        }
        table.setModel(model);
        this.setCellRenderer(table);
    }

    private void initMarketDepthSubscription() {
        this.orderBookModel.attach(this.feed);
        this.orderSubscription = this.feed.createSubscription(Order.class);
        this.orderSubscription.addEventListener(events -> {
            this.eventStats.increment(events.size());
            this.orderStats.increment(events.size());
            this.calibrateGraphRendererZoomFactors();
            this.tickChartRendererPanel.repaint();
        });
    }

    private void initTimeAndSales() {
        this.initTable(this.timeAndSalesTable, this.timeAndSalesTableModel);
        this.initTimeAndSalesSubscription();
        this.timeAndSalesTable.getSelectionModel().addListSelectionListener(e -> {
            this.tickChartRendererPanel.selectTicks(this.timeAndSalesTable.getSelectionModel().getMinSelectionIndex(), this.timeAndSalesTable.getSelectionModel().getMaxSelectionIndex());
            this.tickChartRendererPanel.repaint();
        });
    }

    private void initTimeAndSalesSubscription() {
        this.timeAndSalesSubscription = this.feed.createTimeSeriesSubscription(TimeAndSale.class);
        this.timeAndSalesSubscription.setFromTime(0L);
        this.timeAndSalesSubscription.addEventListener(events -> {
            this.eventStats.increment(events.size());
            this.tnsStats.increment(events.size());
            this.timeAndSalesTableModel.eventsReceived(events);
            this.tickChartRendererPanel.repaint();
        });
    }

    private void initTickChartRendererPanel() {
        this.tickChartRendererPanel = new TickChartRendererPanel(this.timeAndSalesTableModel.events, this.bidTableModel.events, this.askTableModel.events, 0);
        this.timeAndSalesTableModel.addTableModelListener(e -> this.tickChartRendererPanel.setRepaintRequired(true));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.fill = 1;
        this.tickChartPanel.setLayout(new GridBagLayout());
        this.tickChartPanel.add((Component)this.tickChartRendererPanel, gbc);
        this.tickChartRendererPanel.addMouseWheelListener(e -> this.tickChartRendererPanel.zoom(-e.getWheelRotation() * 2));
        this.tickChartRendererPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DXFeedMarketDataViewer.this.tickChartRendererPanel.setCrosshair(e.getX(), e.getY());
                int i = DXFeedMarketDataViewer.this.tickChartRendererPanel.getTickIndexByX(e.getX());
                DXFeedMarketDataViewer.this.timeAndSalesTable.getSelectionModel().setSelectionInterval(i, DXFeedMarketDataViewer.this.timeAndSalesTable.getSelectionModel().getLeadSelectionIndex());
                DXFeedMarketDataViewer.this.timeAndSalesTable.scrollRectToVisible(DXFeedMarketDataViewer.this.timeAndSalesTable.getCellRect(i, 0, true));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                DXFeedMarketDataViewer.this.tickChartRendererPanel.setCrosshair(e.getX(), e.getY());
            }
        });
        this.tickChartRendererPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int i = DXFeedMarketDataViewer.this.tickChartRendererPanel.getTickIndexByX(e.getX());
                DXFeedMarketDataViewer.this.timeAndSalesTable.scrollRectToVisible(DXFeedMarketDataViewer.this.timeAndSalesTable.getCellRect(i, 0, true));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int i = DXFeedMarketDataViewer.this.tickChartRendererPanel.getTickIndexByX(e.getX());
                DXFeedMarketDataViewer.this.timeAndSalesTable.getSelectionModel().setSelectionInterval(i, i);
                DXFeedMarketDataViewer.this.timeAndSalesTable.getSelectionModel().setLeadSelectionIndex(i);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DXFeedMarketDataViewer.this.tickChartRendererPanel.mouseExited();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DXFeedMarketDataViewer.this.tickChartRendererPanel.mouseEntered(e.getX(), e.getY());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    private void setCurrentTimeLabel(Date time) {
        this.currentTimeLabel.setText(this.timeFormatSelectedTZ.format(time));
    }

    private void initStatsUpdater() {
        Timer timer = new Timer(1000, new ActionListener(){
            private long lastTime = System.currentTimeMillis();

            @Override
            public void actionPerformed(ActionEvent e) {
                long curTime = System.currentTimeMillis();
                long delta = curTime - this.lastTime;
                DXFeedMarketDataViewer.this.mpsLabel.setText(DXFeedMarketDataViewer.this.eventStats.update(delta));
                DXFeedMarketDataViewer.this.qpsLabel.setText(DXFeedMarketDataViewer.this.quoteStats.update(delta));
                DXFeedMarketDataViewer.this.tpsLabel.setText(DXFeedMarketDataViewer.this.tradeStats.update(delta));
                DXFeedMarketDataViewer.this.spsLabel.setText(DXFeedMarketDataViewer.this.summaryStats.update(delta));
                DXFeedMarketDataViewer.this.opsLabel.setText(DXFeedMarketDataViewer.this.orderStats.update(delta));
                DXFeedMarketDataViewer.this.tspsLabel.setText(DXFeedMarketDataViewer.this.tnsStats.update(delta));
                if (!DXFeedMarketDataViewer.this.isInOnDemandMode) {
                    DXFeedMarketDataViewer.this.setCurrentTimeLabel(new Date(curTime));
                }
                this.lastTime = curTime;
                DXFeedMarketDataViewer.this.calibrateGraphRendererZoomFactors();
            }
        });
        timer.start();
    }

    private void createFrame() {
        this.mainFrame = new JFrame("dxFeed Market Data Viewer" + (this.name.length() == 0 ? "" : ": " + this.name));
        this.mainFrame.add(this.form);
        this.mainFrame.pack();
        this.mainFrame.setLocationByPlatform(true);
        JPopupMenu quoteBoardPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Edit");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        menuItem.addActionListener(this.editAction);
        quoteBoardPopup.add(menuItem);
        menuItem = new JMenuItem("Add row");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        menuItem.addActionListener(this.insertAction);
        quoteBoardPopup.add(menuItem);
        menuItem = new JMenuItem("Remove row");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        menuItem.addActionListener(this.removeAction);
        quoteBoardPopup.add(menuItem);
        quoteBoardPopup.addSeparator();
        menuItem = new JMenuItem("Move up");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(224, 2));
        menuItem.addActionListener(this.upAction);
        quoteBoardPopup.add(menuItem);
        menuItem = new JMenuItem("Move down");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(225, 2));
        menuItem.addActionListener(this.downAction);
        quoteBoardPopup.add(menuItem);
        if (this.ipfMode != IpfMode.NO_IPF) {
            quoteBoardPopup.addSeparator();
            menuItem = new JMenuItem("View options: 4 strikes");
            menuItem.addActionListener(this.viewOptions4Strikes);
            quoteBoardPopup.add(menuItem);
            menuItem = new JMenuItem("View options: 8 strikes");
            menuItem.addActionListener(this.viewOptions8Strikes);
            quoteBoardPopup.add(menuItem);
            menuItem = new JMenuItem("View options: all strikes");
            menuItem.addActionListener(this.viewOptionsAllStrikes);
            quoteBoardPopup.add(menuItem);
        }
        this.quoteBoardTable.addMouseListener(new ShowPopupSupport(quoteBoardPopup));
        this.quoteBoardTable.getParent().addMouseListener(new ShowPopupSupport(quoteBoardPopup));
        JPopupMenu depthTablePopup = new JPopupMenu();
        menuItem = new JMenuItem("Toggle bid size chart horizontal alignment");
        menuItem.addActionListener(this.toggleBidSizeGraphRendererAlignment);
        depthTablePopup.add(menuItem);
        menuItem = new JMenuItem("Toggle ask size chart horizontal alignment");
        menuItem.addActionListener(this.toggleAskSizeGraphRendererAlignment);
        depthTablePopup.add(menuItem);
        JMenu viewSubMenu = new JMenu("View");
        depthTablePopup.add(viewSubMenu);
        ButtonGroup viewGroup = new ButtonGroup();
        menuItem = new JRadioButtonMenuItem("Composite Only");
        menuItem.addActionListener(new ChooseFilterAction(OrderBookModelFilter.COMPOSITE));
        viewSubMenu.add(menuItem);
        viewGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Regionals Only");
        menuItem.addActionListener(new ChooseFilterAction(OrderBookModelFilter.REGIONAL));
        viewSubMenu.add(menuItem);
        viewGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Aggregate (Level 2 / Price Levels) Only");
        menuItem.addActionListener(new ChooseFilterAction(OrderBookModelFilter.AGGREGATE));
        viewSubMenu.add(menuItem);
        viewGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Orders Only");
        menuItem.addActionListener(new ChooseFilterAction(OrderBookModelFilter.ORDER));
        viewSubMenu.add(menuItem);
        viewGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Composite and Regionals");
        menuItem.addActionListener(new ChooseFilterAction(OrderBookModelFilter.COMPOSITE_REGIONAL));
        viewSubMenu.add(menuItem);
        viewGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("Composite, Regionals and Aggregate (Level 2 / Price Levels)");
        menuItem.addActionListener(new ChooseFilterAction(OrderBookModelFilter.COMPOSITE_REGIONAL_AGGREGATE));
        viewSubMenu.add(menuItem);
        viewGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("All");
        menuItem.addActionListener(new ChooseFilterAction(OrderBookModelFilter.ALL));
        menuItem.setSelected(true);
        viewSubMenu.add(menuItem);
        viewGroup.add(menuItem);
        JMenu lotSizeSubMenu = new JMenu("Set Lot Size");
        depthTablePopup.add(lotSizeSubMenu);
        ButtonGroup lotSizeGroup = new ButtonGroup();
        menuItem = new JRadioButtonMenuItem("1");
        menuItem.addActionListener(new ChooseLotSizeAction(1));
        menuItem.setSelected(true);
        lotSizeSubMenu.add(menuItem);
        lotSizeGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem("100");
        menuItem.addActionListener(new ChooseLotSizeAction(100));
        lotSizeSubMenu.add(menuItem);
        lotSizeGroup.add(menuItem);
        JMenu colorSubMenu = new JMenu("Set color scheme");
        depthTablePopup.add(colorSubMenu);
        menuItem = new JMenuItem("Depth");
        menuItem.addActionListener(new ChooseSchemeAction(0));
        colorSubMenu.add(menuItem);
        menuItem = new JMenuItem("Zebra");
        menuItem.addActionListener(new ChooseSchemeAction(1));
        colorSubMenu.add(menuItem);
        menuItem = new JMenuItem("Colorful");
        menuItem.addActionListener(new ChooseSchemeAction(2));
        colorSubMenu.add(menuItem);
        menuItem = new JMenuItem("Monochrome");
        menuItem.addActionListener(new ChooseSchemeAction(3));
        colorSubMenu.add(menuItem);
        menuItem = new JMenuItem("No Color");
        menuItem.addActionListener(new ChooseSchemeAction(-1));
        colorSubMenu.add(menuItem);
        this.bidTable.addMouseListener(new ShowPopupSupport(depthTablePopup));
        this.bidTable.getParent().addMouseListener(new ShowPopupSupport(depthTablePopup));
        this.askTable.addMouseListener(new ShowPopupSupport(depthTablePopup));
        this.askTable.getParent().addMouseListener(new ShowPopupSupport(depthTablePopup));
        JPopupMenu tnsTablePopup = new JPopupMenu();
        menuItem = new JMenuItem("Replay from selected time");
        menuItem.addActionListener(this.replayFromSelectedTimeAndSale);
        tnsTablePopup.add(menuItem);
        this.timeAndSalesTable.addMouseListener(new ShowPopupSupport(tnsTablePopup));
        this.tickChartRendererPanel.addMouseListener(new ShowPopupSupport(tnsTablePopup));
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DXFeedMarketDataViewer.this.saveConfiguration(DXFeedMarketDataViewer.this.configFile);
                System.exit(0);
            }
        });
        this.pauseButton.addActionListener(this.pause);
        this.playButton.addActionListener(this.play);
        this.connectionAddressEdit.setText(this.address);
        this.connectionAddressEdit.addActionListener(e -> {
            if (this.isInOnDemandMode) {
                this.modeComboBox.setSelectedIndex(0);
                this.isInOnDemandMode = false;
            }
            this.address = this.connectionAddressEdit.getText();
            this.createFeed();
        });
        this.tzComboBoxSupport = new TimezoneComboBoxSupport(this.tzComboBox);
        this.tzComboBox.addActionListener(e -> {
            this.setOnDemandTimeSpinnerTimeZone();
            this.quoteBoardTableModel.setTimeZone(TimeZone.getTimeZone(this.tzComboBoxSupport.getSelectedTimezoneID()));
            this.askTableModel.setTimeZone(TimeZone.getTimeZone(this.tzComboBoxSupport.getSelectedTimezoneID()));
            this.bidTableModel.setTimeZone(TimeZone.getTimeZone(this.tzComboBoxSupport.getSelectedTimezoneID()));
            this.timeAndSalesTableModel.setTimeZone(TimeZone.getTimeZone(this.tzComboBoxSupport.getSelectedTimezoneID()));
        });
        this.initOnDemandTimeSpinner();
        this.onDemandSpeed = 1.0;
        this.onDemandSpeedSlider.addChangeListener(e -> {
            int value = this.onDemandSpeedSlider.getValue();
            if (value <= 5) {
                this.onDemandSpeed = 1.0 / (double)(6 - value);
                if (value == 5) {
                    this.onDemandSpeedLabel.setText("x 1");
                } else {
                    this.onDemandSpeedLabel.setText("x 1/" + (6 - value));
                }
            } else {
                this.onDemandSpeed = value - 4;
                this.onDemandSpeedLabel.setText("x " + (value - 4));
            }
            this.onDemand.setSpeed(this.onDemandSpeed);
        });
        this.onDemandTimeSpinner.addChangeListener(e -> this.onDemand.replay((Date)this.onDemandTimeSpinner.getValue(), this.onDemandSpeed));
        this.modeComboBox.addItem("Datafeed");
        this.modeComboBox.addItem("onDemand Market Replay");
        this.modeComboBox.addActionListener(e -> this.switchMode());
        this.onDemandToolbar.setVisible(false);
        this.connectAsButton.addActionListener(e -> this.showOnDemandPasswordDialog());
        this.setComponentSizes();
        this.mainFrame.setMinimumSize(new Dimension(800, 600));
        this.mainFrame.setExtendedState(this.mainFrame.getExtendedState() | 6);
        this.mainFrame.setVisible(true);
    }

    private void switchMode() {
        if (this.modeComboBox.getSelectedIndex() == 1) {
            this.onDemandToolbar.setVisible(true);
            boolean goOnDemand = true;
            if (this.onDemandCredentials == null) {
                goOnDemand = this.showOnDemandPasswordDialog();
            }
            if (goOnDemand) {
                this.isInOnDemandMode = true;
                this.onDemand.replay((Date)this.onDemandTimeSpinner.getValue(), this.onDemandSpeed);
                this.forceSelectSymbol(this.selectedSymbol);
            } else {
                this.modeComboBox.setSelectedIndex(0);
            }
        } else {
            this.onDemandToolbar.setVisible(false);
            this.onDemand.stopAndResume();
            this.forceSelectSymbol(this.selectedSymbol);
            this.isInOnDemandMode = false;
        }
    }

    private boolean showOnDemandPasswordDialog() {
        boolean result = false;
        Credentials c = this.onDemandCredentials != null ? this.onDemandCredentials : new Credentials("demo", "demo");
        if ((c = PasswordDialog.showPasswordDialog("Accessing onDemand cloud", c, this.mainFrame)) != null) {
            this.onDemandCredentials = new Credentials(c.getUsername(), c.getPassword());
            this.endpoint.user(this.onDemandCredentials.getUsername());
            this.endpoint.password(this.onDemandCredentials.getPassword());
            this.onDemandUsernameLabel.setText("on demand: " + this.onDemandCredentials.getUsername().toLowerCase());
            result = true;
        }
        return result;
    }

    private void setComponentSizes() {
        this.mpsLabel.setPreferredSize(new Dimension(70, 14));
        this.qpsLabel.setPreferredSize(new Dimension(70, 14));
        this.tpsLabel.setPreferredSize(new Dimension(70, 14));
        this.spsLabel.setPreferredSize(new Dimension(70, 14));
        this.opsLabel.setPreferredSize(new Dimension(70, 14));
        this.tspsLabel.setPreferredSize(new Dimension(70, 14));
        this.currentTimeLabel.setPreferredSize(new Dimension(100, 14));
        this.onDemandUsernameLabel.setPreferredSize(new Dimension(100, 14));
        this.ipfWebUsernameLabel.setPreferredSize(new Dimension(100, 14));
        this.onDemandConnectionStatusLabel.setPreferredSize(new Dimension(120, 14));
        this.ipfWebConnectionStatusLabel.setPreferredSize(new Dimension(120, 14));
        this.onDemandTimeSpinner.setPreferredSize(new Dimension(170, 20));
        this.onDemandTimeSpinner.setMaximumSize(new Dimension(170, 30));
        this.modeComboBox.setMinimumSize(new Dimension(170, 20));
        this.modeComboBox.setPreferredSize(new Dimension(170, 20));
        this.modeComboBox.setMaximumSize(new Dimension(170, 30));
        this.tzComboBox.setMinimumSize(new Dimension(180, 20));
        this.tzComboBox.setPreferredSize(new Dimension(180, 20));
        this.tzComboBox.setMaximumSize(new Dimension(180, 30));
    }

    private void initOnDemandTimeSpinner() {
        Calendar defaultDate = GregorianCalendar.getInstance(TimeZone.getTimeZone("America/New_York"));
        Calendar start = GregorianCalendar.getInstance(TimeZone.getTimeZone("America/New_York"));
        Calendar end = GregorianCalendar.getInstance();
        start.clear();
        defaultDate.clear();
        start.set(1, 2010);
        defaultDate.set(1, 2010);
        defaultDate.set(2, 4);
        defaultDate.set(5, 6);
        defaultDate.set(10, 14);
        defaultDate.set(12, 46);
        defaultDate.set(13, 55);
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel(defaultDate.getTime(), start.getTime(), end.getTime(), 13);
        this.onDemandTimeSpinner.setModel(spinnerDateModel);
        this.setOnDemandTimeSpinnerTimeZone();
    }

    private void setOnDemandTimeSpinnerTimeZone() {
        if (this.tzComboBoxSupport != null) {
            JSpinner.DateEditor editor = (JSpinner.DateEditor)this.onDemandTimeSpinner.getEditor();
            SimpleDateFormat format = editor.getFormat();
            TimeZone tz = TimeZone.getTimeZone(this.tzComboBoxSupport.getSelectedTimezoneID());
            this.timeFormatSelectedTZ.setTimeZone(tz);
            format.setTimeZone(tz);
            format.applyPattern(this.timeFormatSelectedTZ.toPattern());
            editor.getTextField().setText(format.format(this.onDemandTimeSpinner.getValue()));
        }
    }

    private void createUIComponents() {
    }

    private void $$$setupUI$$$() {
        this.tabbedPane = new JTabbedPane();
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        this.tabbedPane.addTab("Default view", panel1);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel1.add((Component)panel2, gbc);
        this.form = new JPanel();
        this.form.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)this.form, gbc);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        this.form.add((Component)panel3, "South");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridBagLayout());
        panel4.setToolTipText("Feed address");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 6.0;
        gbc.anchor = 17;
        gbc.fill = 3;
        panel3.add((Component)panel4, gbc);
        this.onDemandConnectionStatusLabel = new JLabel();
        this.onDemandConnectionStatusLabel.setEnabled(true);
        Font onDemandConnectionStatusLabelFont = this.$$$getFont$$$(null, 1, 10, this.onDemandConnectionStatusLabel.getFont());
        if (onDemandConnectionStatusLabelFont != null) {
            this.onDemandConnectionStatusLabel.setFont(onDemandConnectionStatusLabelFont);
        }
        this.onDemandConnectionStatusLabel.setText("Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel4.add((Component)this.onDemandConnectionStatusLabel, gbc);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        Font panel5Font = this.$$$getFont$$$(null, 1, 10, panel5.getFont());
        if (panel5Font != null) {
            panel5.setFont(panel5Font);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        panel4.add((Component)panel5, gbc);
        this.currentTimeLabel = new JLabel();
        Font currentTimeLabelFont = this.$$$getFont$$$(null, 0, 10, this.currentTimeLabel.getFont());
        if (currentTimeLabelFont != null) {
            this.currentTimeLabel.setFont(currentTimeLabelFont);
        }
        this.currentTimeLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        panel5.add((Component)this.currentTimeLabel, gbc);
        JToolBar.Separator toolBar$Separator1 = new JToolBar.Separator();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel5.add((Component)toolBar$Separator1, gbc);
        this.tzComboBox = new JComboBox();
        this.tzComboBox.setEditable(true);
        Font tzComboBoxFont = this.$$$getFont$$$(null, 0, 10, this.tzComboBox.getFont());
        if (tzComboBoxFont != null) {
            this.tzComboBox.setFont(tzComboBoxFont);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        panel5.add(this.tzComboBox, gbc);
        JSeparator separator1 = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel5.add((Component)separator1, gbc);
        JToolBar.Separator toolBar$Separator2 = new JToolBar.Separator();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel4.add((Component)toolBar$Separator2, gbc);
        this.onDemandUsernameLabel = new JLabel();
        Font onDemandUsernameLabelFont = this.$$$getFont$$$(null, 0, 10, this.onDemandUsernameLabel.getFont());
        if (onDemandUsernameLabelFont != null) {
            this.onDemandUsernameLabel.setFont(onDemandUsernameLabelFont);
        }
        this.onDemandUsernameLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel4.add((Component)this.onDemandUsernameLabel, gbc);
        this.ipfWebConnectionStatusLabel = new JLabel();
        this.ipfWebConnectionStatusLabel.setEnabled(true);
        Font ipfWebConnectionStatusLabelFont = this.$$$getFont$$$(null, 1, 10, this.ipfWebConnectionStatusLabel.getFont());
        if (ipfWebConnectionStatusLabelFont != null) {
            this.ipfWebConnectionStatusLabel.setFont(ipfWebConnectionStatusLabelFont);
        }
        this.ipfWebConnectionStatusLabel.setText("Label");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel4.add((Component)this.ipfWebConnectionStatusLabel, gbc);
        this.ipfWebUsernameLabel = new JLabel();
        Font ipfWebUsernameLabelFont = this.$$$getFont$$$(null, 0, 10, this.ipfWebUsernameLabel.getFont());
        if (ipfWebUsernameLabelFont != null) {
            this.ipfWebUsernameLabel.setFont(ipfWebUsernameLabelFont);
        }
        this.ipfWebUsernameLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        panel4.add((Component)this.ipfWebUsernameLabel, gbc);
        JSeparator separator2 = new JSeparator();
        separator2.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator2, gbc);
        JPanel panel6 = new JPanel();
        panel6.setLayout(new GridBagLayout());
        panel6.setToolTipText("Total events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel6, gbc);
        this.mpsLabel = new JLabel();
        Font mpsLabelFont = this.$$$getFont$$$(null, 0, 10, this.mpsLabel.getFont());
        if (mpsLabelFont != null) {
            this.mpsLabel.setFont(mpsLabelFont);
        }
        this.mpsLabel.setHorizontalAlignment(0);
        this.mpsLabel.setHorizontalTextPosition(0);
        this.mpsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel6.add((Component)this.mpsLabel, gbc);
        JSeparator separator3 = new JSeparator();
        separator3.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator3, gbc);
        JPanel panel7 = new JPanel();
        panel7.setLayout(new GridBagLayout());
        panel7.setToolTipText("Quote events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel7, gbc);
        this.qpsLabel = new JLabel();
        Font qpsLabelFont = this.$$$getFont$$$(null, 0, 10, this.qpsLabel.getFont());
        if (qpsLabelFont != null) {
            this.qpsLabel.setFont(qpsLabelFont);
        }
        this.qpsLabel.setHorizontalAlignment(0);
        this.qpsLabel.setHorizontalTextPosition(0);
        this.qpsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel7.add((Component)this.qpsLabel, gbc);
        JSeparator separator4 = new JSeparator();
        separator4.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator4, gbc);
        JPanel panel8 = new JPanel();
        panel8.setLayout(new GridBagLayout());
        panel8.setToolTipText("Trade events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel8, gbc);
        this.tpsLabel = new JLabel();
        Font tpsLabelFont = this.$$$getFont$$$(null, 0, 10, this.tpsLabel.getFont());
        if (tpsLabelFont != null) {
            this.tpsLabel.setFont(tpsLabelFont);
        }
        this.tpsLabel.setHorizontalAlignment(0);
        this.tpsLabel.setHorizontalTextPosition(0);
        this.tpsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel8.add((Component)this.tpsLabel, gbc);
        JSeparator separator5 = new JSeparator();
        separator5.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator5, gbc);
        JPanel panel9 = new JPanel();
        panel9.setLayout(new GridBagLayout());
        panel9.setToolTipText("Daily summary (OHLC) events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 8;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel9, gbc);
        this.spsLabel = new JLabel();
        Font spsLabelFont = this.$$$getFont$$$(null, 0, 10, this.spsLabel.getFont());
        if (spsLabelFont != null) {
            this.spsLabel.setFont(spsLabelFont);
        }
        this.spsLabel.setHorizontalAlignment(0);
        this.spsLabel.setHorizontalTextPosition(0);
        this.spsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel9.add((Component)this.spsLabel, gbc);
        JSeparator separator6 = new JSeparator();
        separator6.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 9;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator6, gbc);
        JPanel panel10 = new JPanel();
        panel10.setLayout(new GridBagLayout());
        panel10.setToolTipText("Order events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 10;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel10, gbc);
        this.opsLabel = new JLabel();
        Font opsLabelFont = this.$$$getFont$$$(null, 0, 10, this.opsLabel.getFont());
        if (opsLabelFont != null) {
            this.opsLabel.setFont(opsLabelFont);
        }
        this.opsLabel.setHorizontalAlignment(0);
        this.opsLabel.setHorizontalTextPosition(0);
        this.opsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel10.add((Component)this.opsLabel, gbc);
        JSeparator separator7 = new JSeparator();
        separator7.setOrientation(1);
        gbc = new GridBagConstraints();
        gbc.gridx = 11;
        gbc.gridy = 0;
        gbc.fill = 1;
        panel3.add((Component)separator7, gbc);
        JPanel panel11 = new JPanel();
        panel11.setLayout(new GridBagLayout());
        panel11.setToolTipText("Time&Sale events per second");
        gbc = new GridBagConstraints();
        gbc.gridx = 12;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel3.add((Component)panel11, gbc);
        this.tspsLabel = new JLabel();
        Font tspsLabelFont = this.$$$getFont$$$(null, 0, 10, this.tspsLabel.getFont());
        if (tspsLabelFont != null) {
            this.tspsLabel.setFont(tspsLabelFont);
        }
        this.tspsLabel.setHorizontalAlignment(0);
        this.tspsLabel.setHorizontalTextPosition(0);
        this.tspsLabel.setText("");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel11.add((Component)this.tspsLabel, gbc);
        JPanel panel12 = new JPanel();
        panel12.setLayout(new GridBagLayout());
        this.form.add((Component)panel12, "Center");
        JSplitPane splitPane1 = new JSplitPane();
        splitPane1.setOneTouchExpandable(true);
        splitPane1.setOrientation(0);
        splitPane1.setResizeWeight(0.3);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel12.add((Component)splitPane1, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setPreferredSize(new Dimension(800, 200));
        splitPane1.setLeftComponent(scrollPane1);
        this.quoteBoardTable = new JTable();
        scrollPane1.setViewportView(this.quoteBoardTable);
        JSplitPane splitPane2 = new JSplitPane();
        splitPane2.setOneTouchExpandable(true);
        splitPane2.setOrientation(0);
        splitPane2.setResizeWeight(0.5);
        splitPane1.setRightComponent(splitPane2);
        JPanel panel13 = new JPanel();
        panel13.setLayout(new GridBagLayout());
        splitPane2.setRightComponent(panel13);
        JSplitPane splitPane3 = new JSplitPane();
        splitPane3.setOneTouchExpandable(true);
        splitPane3.setOrientation(0);
        splitPane3.setResizeWeight(1.0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel13.add((Component)splitPane3, gbc);
        this.tickChartPanel = new JPanel();
        this.tickChartPanel.setLayout(new GridBagLayout());
        this.tickChartPanel.setPreferredSize(new Dimension(800, 200));
        splitPane3.setLeftComponent(this.tickChartPanel);
        this.timeAndSalesScrollPane = new JScrollPane();
        this.timeAndSalesScrollPane.setPreferredSize(new Dimension(800, 100));
        splitPane3.setRightComponent(this.timeAndSalesScrollPane);
        this.timeAndSalesScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.timeAndSalesTable = new JTable();
        this.timeAndSalesScrollPane.setViewportView(this.timeAndSalesTable);
        JPanel panel14 = new JPanel();
        panel14.setLayout(new GridBagLayout());
        splitPane2.setLeftComponent(panel14);
        JPanel panel15 = new JPanel();
        panel15.setLayout(new GridBagLayout());
        panel15.setPreferredSize(new Dimension(800, 200));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel14.add((Component)panel15, gbc);
        JLabel label1 = new JLabel();
        label1.setText("Bid");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        panel15.add((Component)label1, gbc);
        JPanel spacer1 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel15.add((Component)spacer1, gbc);
        JLabel label2 = new JLabel();
        label2.setText("Ask");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        panel15.add((Component)label2, gbc);
        JScrollPane scrollPane2 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel15.add((Component)scrollPane2, gbc);
        this.bidTable = new JTable();
        scrollPane2.setViewportView(this.bidTable);
        JScrollPane scrollPane3 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel15.add((Component)scrollPane3, gbc);
        this.askTable = new JTable();
        scrollPane3.setViewportView(this.askTable);
        this.bookModeLabel = new JLabel();
        Font bookModeLabelFont = this.$$$getFont$$$(null, 0, 9, this.bookModeLabel.getFont());
        if (bookModeLabelFont != null) {
            this.bookModeLabel.setFont(bookModeLabelFont);
        }
        this.bookModeLabel.setHorizontalAlignment(2);
        this.bookModeLabel.setText("Book display mode: All orders");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 3;
        panel14.add((Component)this.bookModeLabel, gbc);
        this.lotSizeLabel = new JLabel();
        Font lotSizeLabelFont = this.$$$getFont$$$(null, 0, 9, this.lotSizeLabel.getFont());
        if (lotSizeLabelFont != null) {
            this.lotSizeLabel.setFont(lotSizeLabelFont);
        }
        this.lotSizeLabel.setHorizontalAlignment(4);
        this.lotSizeLabel.setText("Book display lot size: 1");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 3;
        panel14.add((Component)this.lotSizeLabel, gbc);
        JPanel panel16 = new JPanel();
        panel16.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel12.add((Component)panel16, gbc);
        this.addressToolbar = new JToolBar();
        this.addressToolbar.setBorderPainted(true);
        this.addressToolbar.setFloatable(false);
        Font addressToolbarFont = this.$$$getFont$$$(null, 0, 9, this.addressToolbar.getFont());
        if (addressToolbarFont != null) {
            this.addressToolbar.setFont(addressToolbarFont);
        }
        this.addressToolbar.setRollover(false);
        this.addressToolbar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        panel16.add((Component)this.addressToolbar, gbc);
        this.playButton = new JButton();
        this.playButton.setEnabled(false);
        this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/com/dxfeed/viewer/icons/play-icon.png")));
        this.playButton.setInheritsPopupMenu(true);
        this.playButton.setText("");
        this.playButton.setToolTipText("Connect/Replay");
        this.playButton.putClientProperty("hideActionText", Boolean.FALSE);
        this.addressToolbar.add(this.playButton);
        this.pauseButton = new JButton();
        this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/com/dxfeed/viewer/icons/pause-icon.png")));
        this.pauseButton.setText("");
        this.pauseButton.setToolTipText("Pause");
        this.addressToolbar.add(this.pauseButton);
        JToolBar.Separator toolBar$Separator3 = new JToolBar.Separator();
        this.addressToolbar.add(toolBar$Separator3);
        JLabel label3 = new JLabel();
        Font label3Font = this.$$$getFont$$$(null, -1, -1, label3.getFont());
        if (label3Font != null) {
            label3.setFont(label3Font);
        }
        label3.setText("Connect to: ");
        this.addressToolbar.add(label3);
        this.modeComboBox = new JComboBox();
        Font modeComboBoxFont = this.$$$getFont$$$(null, -1, -1, this.modeComboBox.getFont());
        if (modeComboBoxFont != null) {
            this.modeComboBox.setFont(modeComboBoxFont);
        }
        this.modeComboBox.setForeground(new Color(-1));
        DefaultComboBoxModel defaultComboBoxModel1 = new DefaultComboBoxModel();
        this.modeComboBox.setModel(defaultComboBoxModel1);
        this.modeComboBox.setToolTipText("Connection mode");
        this.addressToolbar.add(this.modeComboBox);
        this.connectionAddressEdit = new JTextField();
        this.connectionAddressEdit.setColumns(0);
        this.connectionAddressEdit.setEditable(true);
        Font connectionAddressEditFont = this.$$$getFont$$$(null, -1, -1, this.connectionAddressEdit.getFont());
        if (connectionAddressEditFont != null) {
            this.connectionAddressEdit.setFont(connectionAddressEditFont);
        }
        this.connectionAddressEdit.setForeground(new Color(-1));
        this.connectionAddressEdit.setToolTipText("Connection address");
        this.addressToolbar.add(this.connectionAddressEdit);
        this.connectAsButton = new JButton();
        this.connectAsButton.setText("  Connect as... ");
        this.addressToolbar.add(this.connectAsButton);
        this.onDemandToolbar = new JToolBar();
        this.onDemandToolbar.setEnabled(false);
        this.onDemandToolbar.setFloatable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        panel16.add((Component)this.onDemandToolbar, gbc);
        JLabel label4 = new JLabel();
        Font label4Font = this.$$$getFont$$$(null, -1, -1, label4.getFont());
        if (label4Font != null) {
            label4.setFont(label4Font);
        }
        label4.setText("Go to: ");
        this.onDemandToolbar.add(label4);
        this.onDemandTimeSpinner = new JSpinner();
        Font onDemandTimeSpinnerFont = this.$$$getFont$$$(null, -1, -1, this.onDemandTimeSpinner.getFont());
        if (onDemandTimeSpinnerFont != null) {
            this.onDemandTimeSpinner.setFont(onDemandTimeSpinnerFont);
        }
        this.onDemandToolbar.add(this.onDemandTimeSpinner);
        JToolBar.Separator toolBar$Separator4 = new JToolBar.Separator();
        this.onDemandToolbar.add(toolBar$Separator4);
        JLabel label5 = new JLabel();
        Font label5Font = this.$$$getFont$$$(null, -1, -1, label5.getFont());
        if (label5Font != null) {
            label5.setFont(label5Font);
        }
        label5.setText("Replay speed:");
        this.onDemandToolbar.add(label5);
        JToolBar.Separator toolBar$Separator5 = new JToolBar.Separator();
        this.onDemandToolbar.add(toolBar$Separator5);
        this.onDemandSpeedLabel = new JLabel();
        this.onDemandSpeedLabel.setEnabled(true);
        Font onDemandSpeedLabelFont = this.$$$getFont$$$(null, -1, -1, this.onDemandSpeedLabel.getFont());
        if (onDemandSpeedLabelFont != null) {
            this.onDemandSpeedLabel.setFont(onDemandSpeedLabelFont);
        }
        this.onDemandSpeedLabel.setText("x 1");
        this.onDemandToolbar.add(this.onDemandSpeedLabel);
        JToolBar.Separator toolBar$Separator6 = new JToolBar.Separator();
        this.onDemandToolbar.add(toolBar$Separator6);
        this.onDemandSpeedSlider = new JSlider();
        Font onDemandSpeedSliderFont = this.$$$getFont$$$(null, 0, 8, this.onDemandSpeedSlider.getFont());
        if (onDemandSpeedSliderFont != null) {
            this.onDemandSpeedSlider.setFont(onDemandSpeedSliderFont);
        }
        this.onDemandSpeedSlider.setMajorTickSpacing(1);
        this.onDemandSpeedSlider.setMaximum(10);
        this.onDemandSpeedSlider.setMinimum(1);
        this.onDemandSpeedSlider.setPaintLabels(false);
        this.onDemandSpeedSlider.setPaintTicks(false);
        this.onDemandSpeedSlider.setPaintTrack(true);
        this.onDemandSpeedSlider.setSnapToTicks(true);
        this.onDemandSpeedSlider.setValue(5);
        this.onDemandSpeedSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.onDemandSpeedSlider.putClientProperty("Slider.paintThumbArrowShape", Boolean.TRUE);
        this.onDemandToolbar.add(this.onDemandSpeedSlider);
        this.mpsLabel.setLabelFor(this.timeAndSalesScrollPane);
        label3.setLabelFor(this.modeComboBox);
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.tabbedPane;
    }

    private String getBookModeLabelText(OrderBookModelFilter filter) {
        String text = "";
        switch (filter) {
            case ALL: {
                text = "All orders";
                break;
            }
            case COMPOSITE: {
                text = "Composite only";
                break;
            }
            case REGIONAL: {
                text = "Regionals only";
                break;
            }
            case AGGREGATE: {
                text = "Aggregate only";
                break;
            }
            case ORDER: {
                text = "Orders only";
                break;
            }
            case COMPOSITE_REGIONAL: {
                text = "Composite & Regionals";
                break;
            }
            case COMPOSITE_REGIONAL_AGGREGATE: {
                text = "Composite, Regionals & Aggregate";
            }
        }
        return "Book display mode: " + text;
    }

    static enum IpfMode {
        WEB_SERVICE,
        LOCAL_FILE,
        NO_IPF;

    }

    private static class TimezoneComboBoxSupport {
        private final ArrayList<String> tzDisplayNames = new ArrayList();
        private final ArrayList<String> tzIDs = new ArrayList();
        private final JComboBox<String> tzComboBox;
        private final JTextField tzComboBoxTextField;
        private int selectedIndex = -1;

        TimezoneComboBoxSupport(JComboBox<String> tzComboBox) {
            this.tzComboBox = tzComboBox;
            this.tzComboBoxTextField = (JTextField)tzComboBox.getEditor().getEditorComponent();
            TimeZone defaultTz = TimeZone.getDefault();
            for (String tzID : TimeZone.getAvailableIDs()) {
                if (tzID.startsWith("Etc") || tzID.startsWith("SystemV")) continue;
                if (tzID.equals(defaultTz.getID())) {
                    this.selectedIndex = this.tzIDs.size();
                }
                this.addTimeZone(TimeZone.getTimeZone(tzID));
            }
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.tzIDs.size();
                this.addTimeZone(TimeZone.getDefault());
            }
            tzComboBox.setSelectedIndex(this.selectedIndex);
            this.tzComboBoxTextField.addActionListener(e -> this.doSearch());
            this.tzComboBoxTextField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    this.doSearch();
                    super.focusLost(e);
                }

                @Override
                public void focusGained(FocusEvent e) {
                    tzComboBoxTextField.selectAll();
                    super.focusGained(e);
                }
            });
        }

        private void addTimeZone(TimeZone tz) {
            int offset = tz.getRawOffset() / 1000;
            int hour = offset / 3600;
            int minutes = offset % 3600 / 60;
            String tzDisplayName = String.format("(GMT%+03d:%02d) %s", hour, minutes, tz.getID().replace("_", " "));
            this.tzComboBox.addItem(tzDisplayName);
            this.tzDisplayNames.add(tzDisplayName);
            this.tzIDs.add(tz.getID());
        }

        private String getSelectedTimezoneID() {
            return this.tzIDs.get(this.selectedIndex);
        }

        private void doSearch() {
            String searchText = this.tzComboBoxTextField.getText().toLowerCase();
            for (int i = 0; i < this.tzDisplayNames.size(); ++i) {
                String tzDisplayName = this.tzDisplayNames.get(i).toLowerCase();
                if (!tzDisplayName.contains(searchText) && !searchText.contains(tzDisplayName)) continue;
                this.selectedIndex = i;
                break;
            }
            this.tzComboBox.setSelectedIndex(this.selectedIndex);
            this.tzComboBoxTextField.setText(this.tzDisplayNames.get(this.selectedIndex));
            this.tzComboBoxTextField.selectAll();
        }
    }

    private static class LabelFlashSupport {
        private JLabel label;
        private Color baseColor;
        private Color darkerColor;
        private boolean darker = false;
        private final Timer timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = darker ? darkerColor : baseColor;
                darker = !darker;
                label.setForeground(c);
            }
        });

        LabelFlashSupport(JLabel label) {
            this.setLabel(label);
        }

        private void setLabel(JLabel label) {
            this.label = label;
            this.baseColor = label.getForeground();
            this.darkerColor = this.baseColor.darker();
        }

        private void startFlashing() {
            this.timer.start();
        }

        private void stopFlashing() {
            this.timer.stop();
        }
    }

    private static class ShowPopupSupport
    extends MouseAdapter {
        private final JPopupMenu menu;

        private ShowPopupSupport(JPopupMenu menu) {
            this.menu = menu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class ChooseLotSizeAction
    extends AbstractAction {
        private final int lotSize;

        private ChooseLotSizeAction(int lotSize) {
            this.lotSize = lotSize;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.orderBookModel.setLotSize(this.lotSize);
            DXFeedMarketDataViewer.this.lotSizeLabel.setText("Book display lot size: " + this.lotSize);
        }
    }

    private class ChooseFilterAction
    extends AbstractAction {
        private final OrderBookModelFilter filter;

        private ChooseFilterAction(OrderBookModelFilter filter) {
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.orderBookModel.setFilter(this.filter);
            DXFeedMarketDataViewer.this.bookModeLabel.setText(DXFeedMarketDataViewer.this.getBookModeLabelText(this.filter));
        }
    }

    private class ChooseSchemeAction
    extends AbstractAction {
        private final int colorScheme;

        private ChooseSchemeAction(int colorScheme) {
            this.colorScheme = colorScheme;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DXFeedMarketDataViewer.this.bidTableModel.setScheme(this.colorScheme);
            DXFeedMarketDataViewer.this.askTableModel.setScheme(this.colorScheme);
            DXFeedMarketDataViewer.this.tickChartRendererPanel.setScheme(this.colorScheme);
        }
    }
}

