/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexerFunction;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.Trade;
import com.dxfeed.viewer.QuoteBoardTableColumn;
import com.dxfeed.viewer.QuoteBoardTableRow;
import com.dxfeed.viewer.SubscriptionChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

class QuoteBoardTableModel
implements TableModel {
    private final ArrayList<QuoteBoardTableRow> rows = new ArrayList();
    private final IndexedSet<String, QuoteBoardTableRow> rowsBySymbol = IndexedSet.create((IndexerFunction & Serializable)row -> row.symbol);
    private final Set<TableModelListener> modelListeners = new HashSet<TableModelListener>();
    private final SubscriptionChangeListener subscriptionChangeListener;
    private TimeZone timeZone = TimeZone.getDefault();
    private boolean frozen = false;
    private int prevMinIndex = Integer.MAX_VALUE;
    private int prevMaxIndex = Integer.MIN_VALUE;

    QuoteBoardTableModel(SubscriptionChangeListener subscriptionChangeListener) {
        this.subscriptionChangeListener = subscriptionChangeListener;
    }

    public void setSymbols(String symbolsStr) {
        this.clearInternal();
        if (symbolsStr == null || symbolsStr.isEmpty()) {
            return;
        }
        for (String symbol : symbolsStr.split(",")) {
            this.addRowInternal(this.rows.size(), symbol);
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public String getSymbols() {
        if (this.rows.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (QuoteBoardTableRow row : this.rows) {
            result.append(row.symbol).append(',');
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    public void clear() {
        this.clearInternal();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addRow(int rowIndex) {
        this.addRowInternal(rowIndex, "");
        this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, -1, 1));
    }

    public QuoteBoardTableRow getRowAt(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public void removeRows(int[] rowIndexes) {
        if (rowIndexes.length == 0) {
            return;
        }
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.removeRowInternal(rowIndexes[i]);
        }
        this.fireTableChanged(new TableModelEvent(this, rowIndexes[0], rowIndexes[rowIndexes.length - 1], -1, -1));
    }

    public void swapRows(int row1, int row2) {
        if (row1 == row2) {
            return;
        }
        QuoteBoardTableRow row = this.rows.get(row1);
        this.rows.set(row1, this.rows.get(row2));
        this.rows.set(row2, row);
        this.updateRowIndexes();
        this.fireTableChanged(new TableModelEvent(this, Math.min(row1, row2), Math.max(row1, row2)));
    }

    private void clearInternal() {
        while (!this.rows.isEmpty()) {
            this.removeRowInternal(this.rows.size() - 1);
        }
    }

    private void addRowInternal(int rowIndex, String symbol) {
        QuoteBoardTableRow row = (QuoteBoardTableRow)this.rowsBySymbol.getByKey((Object)symbol);
        if (row == null) {
            row = new QuoteBoardTableRow(symbol);
            this.rowsBySymbol.add((Object)row);
            if (symbol.length() > 0) {
                this.subscriptionChangeListener.addSymbol(symbol);
            }
        }
        this.rows.add(rowIndex, row);
        this.updateRowIndexes();
    }

    private void removeRowInternal(int rowIndex) {
        QuoteBoardTableRow row = this.rows.remove(rowIndex);
        if (row.indexes.size() < 2) {
            this.rowsBySymbol.removeValue((Object)row);
            if (row.symbol.length() > 0) {
                this.subscriptionChangeListener.removeSymbol(row.symbol);
            }
        }
        this.updateRowIndexes();
    }

    private void updateRowIndexes() {
        for (QuoteBoardTableRow row : this.rowsBySymbol) {
            row.indexes.clear();
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            this.rows.get((int)i).indexes.add(i);
        }
    }

    private void fireTableChanged(TableModelEvent event) {
        for (TableModelListener listener : this.modelListeners) {
            listener.tableChanged(event);
        }
    }

    public void eventsReceived(List<? extends MarketEvent> events) {
        if (this.frozen) {
            return;
        }
        long curTime = System.currentTimeMillis();
        int minRowIndex = Integer.MAX_VALUE;
        int maxRowIndex = Integer.MIN_VALUE;
        for (MarketEvent marketEvent : events) {
            QuoteBoardTableRow row = (QuoteBoardTableRow)this.rowsBySymbol.getByKey((Object)marketEvent.getEventSymbol());
            if (row == null) continue;
            Class<?> eventClass = marketEvent.getClass();
            if (eventClass == Quote.class) {
                row.updateQuote((Quote)marketEvent, curTime);
            } else if (eventClass == Trade.class) {
                row.updateTrade((Trade)marketEvent, curTime);
            } else if (eventClass == Summary.class) {
                row.updateSummary((Summary)marketEvent, curTime);
            } else if (eventClass == Profile.class) {
                row.updateProfile((Profile)marketEvent);
            }
            for (int index : row.indexes) {
                minRowIndex = Math.min(minRowIndex, index);
                maxRowIndex = Math.max(maxRowIndex, index);
            }
        }
        int oldMinIndex = this.prevMinIndex;
        int n = this.prevMaxIndex;
        this.prevMinIndex = minRowIndex;
        this.prevMaxIndex = maxRowIndex;
        minRowIndex = Math.min(minRowIndex, oldMinIndex);
        maxRowIndex = Math.max(maxRowIndex, n);
        if (minRowIndex != Integer.MAX_VALUE) {
            this.fireTableChanged(new TableModelEvent(this, minRowIndex, maxRowIndex));
        }
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return QuoteBoardTableColumn.values().length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return QuoteBoardTableColumn.values()[columnIndex].caption;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == QuoteBoardTableColumn.SYMBOL.ordinal();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return QuoteBoardTableColumn.values()[columnIndex].getValue(this.rows.get(rowIndex), this.timeZone);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != QuoteBoardTableColumn.SYMBOL.ordinal()) {
            return;
        }
        String symbol = (String)aValue;
        if (symbol.equals(symbol.toLowerCase())) {
            symbol = symbol.toUpperCase();
        }
        this.removeRowInternal(rowIndex);
        this.addRowInternal(rowIndex, symbol);
        this.fireTableChanged(new TableModelEvent(this, rowIndex));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.modelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.modelListeners.remove(l);
    }

    boolean isFrozen() {
        return this.frozen;
    }

    void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    TimeZone getTimeZone() {
        return this.timeZone;
    }

    void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.fireTableChanged(new TableModelEvent(this));
    }
}

