/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SwingExecutor
implements Executor {
    private final ConcurrentLinkedQueue<Runnable> commands = new ConcurrentLinkedQueue();
    private final int delay;

    public SwingExecutor(int delay) {
        this.delay = delay;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingExecutor.this.createTimer();
            }
        });
    }

    private void createTimer() {
        Timer timer = new Timer(this.delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable command;
                while ((command = (Runnable)SwingExecutor.this.commands.poll()) != null) {
                    command.run();
                }
            }
        });
        timer.start();
    }

    @Override
    public void execute(Runnable command) {
        this.commands.add(command);
    }
}

