/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer.tickchart;

import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.viewer.tickchart.VolumeAtPriceBar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class VolumeAtPriceChart {
    private Color buyColor;
    private Color sellColor;
    private Color undefinedColor;
    private double maxPrice;
    private double minPrice;
    private int height;
    private int width;
    private int barHeight;
    private double maxSize;
    private double priceStep;
    private ArrayList<VolumeAtPriceBar> volumeAtPrice;

    public VolumeAtPriceChart(double maxPrice, double minPrice, int width, int height, int barHeight, Color buyColor, Color sellColor, Color undefinedColor) {
        this.maxPrice = maxPrice;
        this.minPrice = minPrice;
        this.maxSize = Double.NEGATIVE_INFINITY;
        this.height = height;
        this.width = width;
        int n = barHeight < 3 ? 3 : (this.barHeight = barHeight > height ? height : barHeight);
        while (this.barHeight > 3 && height % this.barHeight > 1) {
            --this.barHeight;
        }
        int numIntervals = height / this.barHeight;
        this.priceStep = (maxPrice - minPrice) / (double)numIntervals;
        this.volumeAtPrice = new ArrayList(numIntervals);
        for (int i = 0; i < numIntervals; ++i) {
            this.volumeAtPrice.add(null);
        }
        this.buyColor = buyColor;
        this.sellColor = sellColor;
        this.undefinedColor = undefinedColor;
    }

    public void add(TimeAndSale timeAndSale) {
        VolumeAtPriceBar volumeAtPriceBar;
        int i = (int)((this.maxPrice - timeAndSale.getPrice()) / this.priceStep);
        if (i >= this.volumeAtPrice.size()) {
            i = this.volumeAtPrice.size() - 1;
        }
        if ((volumeAtPriceBar = this.volumeAtPrice.get(i)) == null) {
            volumeAtPriceBar = new VolumeAtPriceBar();
            this.volumeAtPrice.set(i, volumeAtPriceBar);
        }
        volumeAtPriceBar.add(timeAndSale);
        if (this.maxSize < volumeAtPriceBar.getMaxSize()) {
            this.maxSize = volumeAtPriceBar.getMaxSize();
        }
    }

    public VolumeAtPriceBar getVolumeAtY(int y) {
        int i = y / this.barHeight;
        if (i >= this.volumeAtPrice.size()) {
            i = this.volumeAtPrice.size() - 1;
        }
        return this.volumeAtPrice.get(i);
    }

    public void paint(Graphics2D g2d, int x, int y) {
        double zoomFactor = (double)this.width / (2.0 * this.maxSize);
        for (int i = 0; i < this.volumeAtPrice.size(); ++i) {
            int barWidth;
            VolumeAtPriceBar volumeAtPriceBar = this.volumeAtPrice.get(i);
            int undefinedBarWidth = 0;
            if (volumeAtPriceBar == null) continue;
            if (volumeAtPriceBar.getUndefinedSize() > 0.0) {
                g2d.setColor(this.undefinedColor);
                undefinedBarWidth = (int)(volumeAtPriceBar.getUndefinedSize() * zoomFactor);
                g2d.fillRect(x + this.width / 2, y + i * this.barHeight, undefinedBarWidth + 1, this.barHeight - 1);
            }
            if (volumeAtPriceBar.getBuySize() > 0.0) {
                g2d.setColor(this.buyColor);
                barWidth = (int)(volumeAtPriceBar.getBuySize() * zoomFactor);
                g2d.fillRect(x + this.width / 2 + undefinedBarWidth, y + i * this.barHeight, barWidth + 1, this.barHeight - 1);
            }
            if (!(volumeAtPriceBar.getSellSize() > 0.0)) continue;
            g2d.setColor(this.sellColor);
            barWidth = (int)(volumeAtPriceBar.getSellSize() * zoomFactor);
            g2d.fillRect(x + this.width / 2 - barWidth - 1, y + i * this.barHeight, barWidth + 1, this.barHeight - 1);
        }
    }
}

