/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.viewer.QuoteBoardCellSupport;
import com.dxfeed.viewer.QuoteBoardTableRow;
import com.dxfeed.viewer.ViewerCellValue;
import java.util.TimeZone;

enum QuoteBoardTableColumn {
    SYMBOL("Symbol", 70){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            double netChange = quoteTableRow.lastPrice - quoteTableRow.prevClosePrice;
            QuoteBoardCellSupport.State state = QuoteBoardTableRow.stateFor(netChange);
            if (!(state != QuoteBoardCellSupport.State.NOT_AVAILABLE || Double.isNaN(quoteTableRow.lastPrice) && Double.isNaN(quoteTableRow.bidPrice) && Double.isNaN(quoteTableRow.askPrice))) {
                state = QuoteBoardCellSupport.State.COMMON;
            }
            return QuoteBoardCellSupport.textValue(quoteTableRow.symbol, state, true, 2);
        }
    }
    ,
    DESCRIPTION("Description", 150){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            QuoteBoardCellSupport.State state;
            String description;
            if (quoteTableRow.description == null) {
                description = "N/A";
                state = QuoteBoardCellSupport.State.NOT_AVAILABLE;
            } else {
                description = quoteTableRow.description;
                state = QuoteBoardCellSupport.State.INFO;
            }
            return QuoteBoardCellSupport.textValue(description, state, false, 2);
        }
    }
    ,
    LAST("Last", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.lastPrice, quoteTableRow.lastState, quoteTableRow.lastUpdateTime);
        }
    }
    ,
    LAST_SIZE("LSize", 10){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.sizeValue(quoteTableRow.lastSize, quoteTableRow.lastUpdateTime);
        }
    }
    ,
    LAST_EXCHANGE("LX", 1){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.exchangeValue(quoteTableRow.lastExchange, quoteTableRow.lastUpdateTime);
        }
    }
    ,
    CHANGE("NetChg", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            String netChangeStr;
            double netChange = quoteTableRow.lastPrice - quoteTableRow.prevClosePrice;
            if (Double.isNaN(netChange)) {
                netChangeStr = "N/A";
            } else {
                netChangeStr = ViewerCellValue.formatPrice(Math.floor(netChange * 1.0E10 + 0.5) / 1.0E10);
                if (netChange > 0.0) {
                    netChangeStr = "+" + netChangeStr;
                }
            }
            return QuoteBoardCellSupport.textValue(netChangeStr, QuoteBoardTableRow.stateFor(netChange), Math.max(quoteTableRow.lastUpdateTime, quoteTableRow.prevCloseUpdateTime), 4);
        }
    }
    ,
    BID("Bid", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.bidPrice, quoteTableRow.bidState, quoteTableRow.bidUpdateTime);
        }
    }
    ,
    BID_SIZE("BSize", 10){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.sizeValue(quoteTableRow.bidSize, quoteTableRow.bidUpdateTime);
        }
    }
    ,
    BID_EXCHANGE("BX", 1){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.exchangeValue(quoteTableRow.bidExchange, quoteTableRow.bidUpdateTime);
        }
    }
    ,
    ASK("Ask", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.askPrice, quoteTableRow.askState, quoteTableRow.askUpdateTime);
        }
    }
    ,
    ASK_SIZE("ASize", 10){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.sizeValue(quoteTableRow.askSize, quoteTableRow.askUpdateTime);
        }
    }
    ,
    ASK_EXCHANGE("AX", 1){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.exchangeValue(quoteTableRow.askExchange, quoteTableRow.askUpdateTime);
        }
    }
    ,
    VOLUME("Volume", 50){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.sizeValue(quoteTableRow.volume, quoteTableRow.volumeUpdateTime);
        }
    }
    ,
    OPEN("Open", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.openPrice, QuoteBoardCellSupport.State.COMMON, quoteTableRow.openUpdateTime);
        }
    }
    ,
    HIGH("High", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.highPrice, QuoteBoardCellSupport.State.COMMON, quoteTableRow.highUpdateTime);
        }
    }
    ,
    LOW("Low", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.lowPrice, QuoteBoardCellSupport.State.COMMON, quoteTableRow.lowUpdateTime);
        }
    }
    ,
    CLOSE("Close", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.closePrice, QuoteBoardCellSupport.State.COMMON, quoteTableRow.closeUpdateTime);
        }
    }
    ,
    CLOSE_DATE("Close Day", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.dayIdValue(quoteTableRow.dayId, quoteTableRow.closeUpdateTime);
        }
    }
    ,
    PREV_CLOSE("Prev.Close", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.prevClosePrice, QuoteBoardCellSupport.State.COMMON, quoteTableRow.prevCloseUpdateTime);
        }
    }
    ,
    PREV_CLOSE_DAY("Prev.Close Day", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.dayIdValue(quoteTableRow.prevDayId, quoteTableRow.closeUpdateTime);
        }
    }
    ,
    OPEN_INTEREST("Open Interest", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.sizeValue(quoteTableRow.openInterest, quoteTableRow.openInterestTime);
        }
    }
    ,
    HALTED("Halted", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.boolValue(quoteTableRow.tradingHalted, quoteTableRow.closeUpdateTime);
        }
    }
    ,
    HALT_REASON("Halt Reason", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.textValue(quoteTableRow.haltStatusReason, QuoteBoardCellSupport.State.COMMON, false, 2);
        }
    }
    ,
    HALT_START_TIME("Halt Start", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.timeValue(quoteTableRow.haltStartTime, quoteTableRow.closeUpdateTime, timeZone);
        }
    }
    ,
    HALT_END_TIME("Halt End", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.timeValue(quoteTableRow.haltEndTime, quoteTableRow.closeUpdateTime, timeZone);
        }
    }
    ,
    LOW_LIMIT_PRICE("Low Limit Price", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.lowLimitPrice, QuoteBoardCellSupport.State.COMMON, 0L);
        }
    }
    ,
    HIGH_LIMIT_PRICE("High Limit Price", 30){

        @Override
        public ViewerCellValue getValue(QuoteBoardTableRow quoteTableRow, TimeZone timeZone) {
            return QuoteBoardCellSupport.priceValue(quoteTableRow.highLimitPrice, QuoteBoardCellSupport.State.COMMON, 0L);
        }
    };

    final String caption;
    final int preferredWidth;

    private QuoteBoardTableColumn(String caption, int preferredWidth) {
        this.caption = caption;
        this.preferredWidth = preferredWidth;
    }

    public abstract ViewerCellValue getValue(QuoteBoardTableRow var1, TimeZone var2);
}

