/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.devexperts.util.TimeFormat;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.viewer.OrderCellSupport;
import com.dxfeed.viewer.ViewerCellValue;
import com.dxfeed.viewer.tickchart.VolumeAtPriceBar;
import com.dxfeed.viewer.tickchart.VolumeAtPriceChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;

public class TickChartRendererPanel
extends JPanel {
    private static final Color COLOR_TICK_INVALID = Color.GRAY;
    private static final Color COLOR_TICK_UP = Color.GREEN;
    private static final Color COLOR_TICK_DOWN = Color.RED;
    private static final Color COLOR_TICK_SAME = Color.YELLOW;
    private static final Color COLOR_BID = new Color(125, 2, 183);
    private static final Color COLOR_ASK = new Color(162, 25, 154);
    private static final Color COLOR_BIDASK = new Color(58, 32, 81, 192);
    private static final Color COLOR_INVALID_BIDASK = new Color(119, 0, 17, 192);
    private static final Color COLOR_VOLUME = new Color(0, 88, 195);
    private static final Color COLOR_VOLUME_SELL = new Color(195, 0, 88);
    private static final Color COLOR_VOLUME_BUY = new Color(0, 195, 88);
    private static final Color COLOR_SELECTION = new Color(255, 204, 0, 64);
    private static final Color COLOR_AXIS = new Color(105, 105, 105);
    private static final Color COLOR_SYMBOL = new Color(200, 200, 200);
    private static final Color COLOR_CROSSHAIR = new Color(203, 160, 0, 192);
    private static final Color COLOR_CROSSHAIR_TEXT = COLOR_CROSSHAIR.brighter().brighter();
    private static final Color COLOR_CURSOR = COLOR_CROSSHAIR.brighter().brighter();
    private static final Color COLOR_VERTICAL_BOOK_BBO_TEXT = Color.WHITE;
    private static final Color COLOR_VERTICAL_BOOK_TEXT = new Color(180, 180, 180);
    private static final Color COLOR_VERTICAL_BOOK_BBO_LINE = new Color(200, 200, 200);
    private static final int TIMELINE_PROTRUSION_D = 4;
    private static final int TIMELINE_PROTRUSION_H = 3;
    private static final int TIMELINE_PROTRUSION_M = 2;
    private static final int TIMELINE_PROTRUSION_S = 1;
    private static final int TIMELINE_PROTRUSION_MS = 0;
    private static final int[] TIMELINE_PROTRUSIONS = new int[]{0, 1, 2, 3, 4};
    private static final int TIMELINE_PROTRUSION_MULTIPLIER = 10;
    private static final Color[] COLOR_TRADE_TIMELINE = new Color[]{new Color(32, 32, 32), new Color(32, 32, 32), new Color(52, 52, 52), new Color(72, 72, 72), new Color(92, 92, 92)};
    private static final int[][] STRING_TIMELINE_INTERVAL = new int[][]{{16, 19}, {13, 15}, {11, 13}, {9, 11}, {0, 8}};
    private static final String[] STRING_TIME_AXIS_LABEL = new String[]{"", "seconds", "minutes", "hours", "days"};
    private static final int TITLE_HEIGHT = 20;
    private static final int CHART_TOP_MARGIN = 23;
    private static final int CHART_BOTTOM_MARGIN = 65;
    private static final int VERTICAL_BOOK_WIDTH = 80;
    private static final int CHART_RIGHT_MARGIN = 130;
    private static final int LEFT_MARGIN = 2;
    private static final int VOLUME_AT_PRICE_CHART_WIDTH = 60;
    private static final int CHART_LEFT_MARGIN = 112;
    private static final int AXIS_TEXT_MARGIN = 3;
    private static final int MIN_HEIGHT_EX_MARGINS = 10;
    private static final int MIN_WIDTH_EX_MARGINS = 90;
    private static final double SIZE_CHART_HEIGHT_PERCENT = 0.1;
    private static final double PRICE_CHART_HEIGHT_PERCENT = 0.87;
    private static final int MIN_TICK_DISPLAY_WIDTH = 3;
    private static final BasicStroke SIMPLE_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke DASHED_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{1.5f}, 0.0f);
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 9);
    private BufferedImage chartImage;
    private Graphics2D chartG2D;
    private ArrayList<TimeAndSale> timeAndSales = null;
    private ArrayList<Order> bidOrders = null;
    private ArrayList<Order> askOrders = null;
    private int scheme;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private boolean repaintRequired = true;
    private boolean drawCrosshairX = false;
    private boolean drawCrosshairY = false;
    private double minPrice = Double.POSITIVE_INFINITY;
    private double maxPrice = Double.NEGATIVE_INFINITY;
    private double minSize = Double.POSITIVE_INFINITY;
    private double maxSize = Double.NEGATIVE_INFINITY;
    private int totalTickCount = 0;
    private int visibleTickCount = 0;
    private int chartHeightExMargins = 0;
    private int chartWidthExMargins = 0;
    private int tickDisplayWidth = 3;
    private boolean autoZoom = true;
    private double zoomFactorForPriceChart = 1.0;
    private double zoomFactorForSizeChart = 1.0;
    private int x_crossHair = 0;
    private int y_crossHair = 0;
    private boolean mouseInside = false;
    private int[] x_lastTimeLineProtrusion = new int[5];
    private int maxProtrusionLevel = -1;
    private VolumeAtPriceChart volumeAtPriceChart;
    private int selectionStart = -1;
    private int selectionEnd = -1;
    private String symbol = "";
    private int sizeChartHeight;
    private int priceChartHeight;
    private double maxBuySize;
    private double maxSellSize;

    public TickChartRendererPanel(List<? extends TimeAndSale> timeAndSales, List<? extends Order> bidOrders, List<? extends Order> askOrders, int scheme) {
        this.setBackground(Color.BLACK);
        this.timeAndSales = (ArrayList)timeAndSales;
        this.bidOrders = (ArrayList)bidOrders;
        this.askOrders = (ArrayList)askOrders;
        this.scheme = scheme;
        this.setCursor();
    }

    public TickChartRendererPanel(List<? extends TimeAndSale> timeAndSales, List<? extends Order> bidOrders, List<? extends Order> askOrders, String title, int scheme) {
        this(timeAndSales, bidOrders, askOrders, scheme);
        this.symbol = title;
    }

    private static String price2String(double price) {
        return String.format("%.2f", price);
    }

    private static String size2String(double size) {
        return size == (double)((long)size) ? Long.toString((long)size) : String.format("%.2f", size);
    }

    public void selectTicks(int start, int end) {
        this.selectionStart = start;
        this.selectionEnd = end;
        this.setRepaintRequired(true);
    }

    public int getTickIndexByX(int x) {
        int tickIndex = -1;
        if (x > 112 && x < 112 + this.chartWidthExMargins && this.visibleTickCount > 0 && (tickIndex = (112 + this.chartWidthExMargins - x) / this.tickDisplayWidth) > this.visibleTickCount - 1) {
            tickIndex = -1;
        }
        return tickIndex;
    }

    public void setCrosshair(int x, int y) {
        this.x_crossHair = x;
        this.y_crossHair = y;
        this.setDrawCrosshair(x, y);
        this.repaint();
    }

    public void mouseEntered(int x, int y) {
        this.mouseInside = true;
        this.setDrawCrosshair(x, y);
    }

    public void mouseExited() {
        this.mouseInside = false;
        this.setDrawCrosshair(-1, -1);
        this.setRepaintRequired(true);
        this.repaint();
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public int getScheme() {
        return this.scheme;
    }

    public void setScheme(int scheme) {
        this.scheme = scheme;
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public void setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
    }

    public void zoom(int amount) {
        this.autoZoom = false;
        int w = this.tickDisplayWidth;
        if ((w += amount) > this.chartWidthExMargins) {
            w = this.chartWidthExMargins;
        }
        if (w < 3) {
            w = 3;
        }
        this.tickDisplayWidth = w;
        this.setRepaintRequired(true);
        this.repaint();
    }

    void setRepaintRequired(boolean repaintRequired) {
        this.repaintRequired = repaintRequired;
        if (repaintRequired) {
            this.setDrawCrosshair(this.x_crossHair, this.y_crossHair);
        } else {
            this.lastWidth = this.getWidth();
            this.lastHeight = this.getHeight();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isRepaintRequired()) {
            this.clear();
            this.clearTimelines();
            this.computeChartSize();
            this.computeTotalTickCountAndTicksVisible();
            this.computeChartZoomFactors();
            this.drawTitle();
            if (this.totalTickCount > 0 && this.chartHeightExMargins > 10 && this.chartWidthExMargins > 90) {
                TimeAndSale curTimeAndSale;
                this.drawVerticalBook();
                TimeAndSale priorTimeAndSale = curTimeAndSale = this.timeAndSales.get(0);
                int y_curTickPrice = this.getChartYCoordinateForPrice(curTimeAndSale.getPrice());
                int y_curTickBid = this.getChartYCoordinateForPrice(curTimeAndSale.getBidPrice());
                int y_curTickAsk = this.getChartYCoordinateForPrice(curTimeAndSale.getAskPrice());
                if (this.visibleTickCount > 1) {
                    int x = 112 + this.chartWidthExMargins - this.tickDisplayWidth;
                    TimeAndSale lastValidTimeAndSale = curTimeAndSale;
                    int x_lastValidTick = -1;
                    int y_lastValidTick = -1;
                    if (curTimeAndSale.isValidTick()) {
                        x_lastValidTick = x;
                        y_lastValidTick = y_curTickPrice;
                    }
                    this.drawPriceAxisAndLabels(y_curTickPrice, y_curTickBid, y_curTickAsk, this.timeAndSales.get(1), curTimeAndSale);
                    this.volumeAtPriceChart = new VolumeAtPriceChart(this.maxPrice, this.minPrice, 60, this.priceChartHeight, (int)((double)this.tickDisplayWidth * (1.5 * (double)this.chartHeightExMargins / (double)this.chartWidthExMargins)), COLOR_VOLUME_BUY, COLOR_VOLUME_SELL, COLOR_VOLUME);
                    for (int i = 0; i < this.visibleTickCount; ++i) {
                        if (i < this.visibleTickCount - 1) {
                            priorTimeAndSale = this.timeAndSales.get(i + 1);
                        }
                        this.volumeAtPriceChart.add(curTimeAndSale);
                        if (priorTimeAndSale.getTime() != curTimeAndSale.getTime()) {
                            this.drawTimeLine(x, priorTimeAndSale, curTimeAndSale);
                        }
                        int y_priorTickPrice = this.getChartYCoordinateForPrice(priorTimeAndSale.getPrice());
                        int y_priorTickBid = this.getChartYCoordinateForPrice(priorTimeAndSale.getBidPrice());
                        int y_priorTickAsk = this.getChartYCoordinateForPrice(priorTimeAndSale.getAskPrice());
                        int curTickSizeBarHeight = this.getChartBarHeightForSize(curTimeAndSale.getSizeAsDouble());
                        this.selectSizeColor(curTimeAndSale);
                        if (curTimeAndSale.getAggressorSide() == Side.SELL) {
                            this.chartG2D.fillRect(x, 23 + this.chartHeightExMargins - this.sizeChartHeight / 2, this.tickDisplayWidth - 1, curTickSizeBarHeight);
                        } else {
                            this.chartG2D.fillRect(x, 23 + this.chartHeightExMargins - this.sizeChartHeight / 2 - curTickSizeBarHeight, this.tickDisplayWidth - 1, curTickSizeBarHeight);
                        }
                        if (y_curTickBid > y_curTickAsk) {
                            this.chartG2D.setColor(COLOR_BIDASK);
                            this.chartG2D.fillRect(x, y_curTickAsk, this.tickDisplayWidth, y_curTickBid - y_curTickAsk);
                        } else if (y_curTickBid < y_curTickAsk) {
                            this.chartG2D.setColor(COLOR_INVALID_BIDASK);
                            this.chartG2D.fillRect(x, y_curTickBid, this.tickDisplayWidth, y_curTickAsk - y_curTickBid);
                        }
                        if (!Double.isNaN(curTimeAndSale.getBidPrice())) {
                            this.chartG2D.setColor(COLOR_BID);
                            this.chartG2D.drawLine(x, y_curTickBid, x + this.tickDisplayWidth, y_curTickBid);
                        }
                        if (!Double.isNaN(curTimeAndSale.getAskPrice())) {
                            this.chartG2D.setColor(COLOR_ASK);
                            this.chartG2D.drawLine(x, y_curTickAsk, x + this.tickDisplayWidth, y_curTickAsk);
                        }
                        this.selectTickColor(priorTimeAndSale, curTimeAndSale);
                        if (!priorTimeAndSale.isValidTick() && curTimeAndSale.isValidTick() || !curTimeAndSale.isValidTick()) {
                            this.chartG2D.drawLine(x, y_curTickPrice, x + this.tickDisplayWidth, y_curTickPrice);
                        } else {
                            this.chartG2D.drawLine(x, y_priorTickPrice, x + this.tickDisplayWidth, y_curTickPrice);
                        }
                        if (curTimeAndSale.isValidTick() && !priorTimeAndSale.isValidTick()) {
                            lastValidTimeAndSale = curTimeAndSale;
                            x_lastValidTick = x;
                            y_lastValidTick = y_curTickPrice;
                        } else if (!curTimeAndSale.isValidTick() && priorTimeAndSale.isValidTick() && x_lastValidTick >= 0) {
                            this.selectTickColor(priorTimeAndSale, lastValidTimeAndSale);
                            Stroke oldStroke = this.chartG2D.getStroke();
                            this.chartG2D.setStroke(DASHED_STROKE);
                            this.chartG2D.drawLine(x, y_priorTickPrice, x_lastValidTick, y_lastValidTick);
                            this.chartG2D.setStroke(oldStroke);
                        }
                        if (this.selectionStart <= i && i <= this.selectionEnd) {
                            this.chartG2D.setColor(COLOR_SELECTION);
                            this.chartG2D.fillRect(x, 23, this.tickDisplayWidth, this.chartHeightExMargins);
                        }
                        x -= this.tickDisplayWidth;
                        y_curTickPrice = y_priorTickPrice;
                        y_curTickAsk = y_priorTickAsk;
                        y_curTickBid = y_priorTickBid;
                        curTimeAndSale = priorTimeAndSale;
                    }
                    this.drawTimeLineProtrusionAxises();
                } else {
                    this.chartImage.setRGB(112 + this.chartWidthExMargins - 1, y_curTickBid, COLOR_BID.getRGB());
                    this.chartImage.setRGB(112 + this.chartWidthExMargins - 1, y_curTickPrice, COLOR_TICK_SAME.getRGB());
                    this.chartImage.setRGB(112 + this.chartWidthExMargins - 1, y_curTickAsk, COLOR_ASK.getRGB());
                    this.drawPriceAxisAndLabels(y_curTickPrice, y_curTickBid, y_curTickAsk, curTimeAndSale, curTimeAndSale);
                }
            }
            this.setRepaintRequired(false);
        }
        if (this.volumeAtPriceChart != null) {
            this.volumeAtPriceChart.paint(this.chartG2D, 2, 23);
        }
        g.drawImage(this.chartImage, 0, 0, null);
        if (this.visibleTickCount > 0 && this.chartHeightExMargins > 10 && this.chartWidthExMargins > 90 && (this.drawCrosshairX || this.drawCrosshairY)) {
            this.drawCrosshair(g);
        }
    }

    private void setCursor() {
        BufferedImage cursorImg = new BufferedImage(32, 32, 2);
        Graphics2D g2d = (Graphics2D)cursorImg.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setColor(COLOR_CURSOR);
        g2d.drawLine(0, 8, 16, 8);
        g2d.drawLine(8, 0, 8, 16);
        this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(8, 8), "Crosshair cursor"));
    }

    private void createEmptyImage() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.chartImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.chartG2D = (Graphics2D)this.chartImage.getGraphics();
            this.chartG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.chartG2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.chartG2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            this.chartG2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.chartG2D.setFont(DEFAULT_FONT);
            this.setRepaintRequired(true);
        }
    }

    private void setDrawCrosshair(int x, int y) {
        this.drawCrosshairX = this.mouseInside && x > 112 && x < 112 + this.chartWidthExMargins;
        this.drawCrosshairY = y > 23 && (double)y < 23.0 + (double)this.chartHeightExMargins * 0.87;
    }

    private void clear() {
        if (this.chartImage == null || this.chartImage.getWidth() != this.getWidth() || this.chartImage.getHeight() != this.getHeight()) {
            this.createEmptyImage();
        } else {
            this.chartG2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.volumeAtPriceChart = null;
        this.setRepaintRequired(true);
    }

    private void clearTimelines() {
        Arrays.fill(this.x_lastTimeLineProtrusion, 0);
        this.maxProtrusionLevel = -1;
    }

    private void computeChartSize() {
        this.chartHeightExMargins = this.getHeight() - 23 - 65;
        this.chartWidthExMargins = this.getWidth() - 112 - 130;
    }

    private void computeTotalTickCountAndTicksVisible() {
        this.totalTickCount = this.timeAndSales.size();
        if (this.totalTickCount > 0) {
            if (this.autoZoom) {
                this.doAutoZoom();
            }
            this.visibleTickCount = this.chartWidthExMargins / this.tickDisplayWidth;
        }
        if (this.visibleTickCount > this.totalTickCount) {
            this.visibleTickCount = this.totalTickCount;
        }
    }

    private void computeChartZoomFactors() {
        this.minPrice = Double.POSITIVE_INFINITY;
        this.maxPrice = Double.NEGATIVE_INFINITY;
        this.minSize = Double.POSITIVE_INFINITY;
        this.maxSize = Double.NEGATIVE_INFINITY;
        this.maxBuySize = Double.NEGATIVE_INFINITY;
        this.maxSellSize = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.visibleTickCount; ++i) {
            TimeAndSale timeAndSale = this.timeAndSales.get(i);
            double price = timeAndSale.getPrice();
            double bidPrice = timeAndSale.getBidPrice();
            double askPrice = timeAndSale.getAskPrice();
            Side side = timeAndSale.getAggressorSide();
            double size = timeAndSale.getSizeAsDouble();
            if (this.minPrice > price) {
                this.minPrice = price;
            }
            if (this.minPrice > bidPrice) {
                this.minPrice = bidPrice;
            }
            if (this.minPrice > askPrice) {
                this.minPrice = askPrice;
            }
            if (this.minSize > size) {
                this.minSize = size;
            }
            if (this.maxPrice < price) {
                this.maxPrice = price;
            }
            if (this.maxPrice < bidPrice) {
                this.maxPrice = bidPrice;
            }
            if (this.maxPrice < askPrice) {
                this.maxPrice = askPrice;
            }
            if (this.maxSize < size) {
                this.maxSize = size;
            }
            if (side == Side.SELL) {
                if (!(this.maxSellSize < size)) continue;
                this.maxSellSize = size;
                continue;
            }
            if (!(this.maxBuySize < size)) continue;
            this.maxBuySize = size;
        }
        this.priceChartHeight = (int)(0.87 * (double)this.chartHeightExMargins);
        this.sizeChartHeight = (int)(0.1 * (double)this.chartHeightExMargins);
        this.zoomFactorForPriceChart = 0.87 * (double)this.chartHeightExMargins / (this.maxPrice - this.minPrice);
        this.zoomFactorForSizeChart = 0.1 * (double)this.chartHeightExMargins / (2.0 * this.maxSize);
    }

    private void drawTitle() {
        if (this.symbol.length() > 0) {
            String period;
            if (this.timeAndSales.size() > 1) {
                TimeAndSale firstEvent = this.timeAndSales.get(this.timeAndSales.size() - 1);
                TimeAndSale lastEvent = this.timeAndSales.get(0);
                period = "showing " + this.visibleTickCount + " of " + this.timeAndSales.size() + " last ticks from " + TimeFormat.DEFAULT.withMillis().format(firstEvent.getTime()) + " to " + TimeFormat.DEFAULT.withMillis().format(lastEvent.getTime());
            } else {
                period = this.timeAndSales.size() == 1 ? "single tick at " + TimeFormat.DEFAULT.withMillis().format(this.timeAndSales.get(0).getTime()) : "waiting for data...";
            }
            FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
            Rectangle2D bounds = metrics.getStringBounds(this.symbol, null);
            this.chartG2D.setColor(COLOR_SYMBOL);
            this.chartG2D.drawString(this.symbol, 1, (int)bounds.getHeight() + 2);
            this.chartG2D.setColor(COLOR_AXIS);
            this.chartG2D.drawString(period, 1 + (int)bounds.getWidth() + 4, (int)bounds.getHeight() + 2);
        }
    }

    private void selectTickColor(TimeAndSale priorTimeAndSale, TimeAndSale curTimeAndSale) {
        if (!curTimeAndSale.isValidTick()) {
            this.chartG2D.setColor(COLOR_TICK_INVALID);
        } else if (curTimeAndSale.getPrice() > priorTimeAndSale.getPrice()) {
            this.chartG2D.setColor(COLOR_TICK_UP);
        } else if (curTimeAndSale.getPrice() == priorTimeAndSale.getPrice()) {
            this.chartG2D.setColor(COLOR_TICK_SAME);
        } else {
            this.chartG2D.setColor(COLOR_TICK_DOWN);
        }
    }

    private void selectSizeColor(TimeAndSale timeAndSale) {
        if (!timeAndSale.isValidTick()) {
            this.chartG2D.setColor(COLOR_TICK_INVALID);
        } else if (timeAndSale.getAggressorSide() == Side.SELL) {
            this.chartG2D.setColor(COLOR_VOLUME_SELL);
        } else if (timeAndSale.getAggressorSide() == Side.BUY) {
            this.chartG2D.setColor(COLOR_VOLUME_BUY);
        } else if (timeAndSale.getAggressorSide() == Side.UNDEFINED) {
            this.chartG2D.setColor(COLOR_VOLUME);
        }
    }

    private int getChartYCoordinateForPrice(double price) {
        int y = price == 0.0 || Double.isNaN(price) ? (int)((this.maxPrice - this.minPrice) * this.zoomFactorForPriceChart) : (int)((this.maxPrice - price) * this.zoomFactorForPriceChart);
        return y + 23;
    }

    private double getPriceByY(int y) {
        double price = 0.0;
        if (this.zoomFactorForPriceChart > 0.0) {
            price = this.maxPrice - (double)(y - 23) / this.zoomFactorForPriceChart;
        }
        return price;
    }

    private int getChartBarHeightForSize(double size) {
        int y = (int)Math.floor(size * this.zoomFactorForSizeChart);
        if (size > 0.0 && y == 0) {
            y = 1;
        }
        return y;
    }

    private void doAutoZoom() {
        this.autoZoom = true;
        this.tickDisplayWidth = Math.max(this.chartWidthExMargins / this.totalTickCount, 3);
        this.setRepaintRequired(true);
        this.repaint();
    }

    private void drawVerticalBook() {
        if (this.bidOrders.size() > 0 && this.askOrders.size() > 0) {
            double bidMaxSize = this.getMaxAggregatedSize(this.bidOrders);
            double askMaxSize = this.getMaxAggregatedSize(this.askOrders);
            double maxSize = Math.max(bidMaxSize, askMaxSize);
            double sizeZoomFactor = 78.0 / maxSize;
            int askIndex = 0;
            double askBestPrice = this.askOrders.get(askIndex).getPrice();
            double askSize = this.askOrders.get(askIndex).getSizeAsDouble();
            while (askIndex + 1 < this.askOrders.size() && this.askOrders.get(askIndex + 1).getPrice() == askBestPrice) {
                askSize += this.askOrders.get(askIndex + 1).getSizeAsDouble();
                ++askIndex;
            }
            int bidIndex = 0;
            double bidBestPrice = this.bidOrders.get(bidIndex).getPrice();
            double bidSize = this.bidOrders.get(bidIndex).getSizeAsDouble();
            while (bidIndex + 1 < this.bidOrders.size() && this.bidOrders.get(bidIndex + 1).getPrice() == bidBestPrice) {
                bidSize += this.bidOrders.get(bidIndex + 1).getSizeAsDouble();
                ++bidIndex;
            }
            int y_price = this.getChartYCoordinateForPrice(askBestPrice);
            int y_nextPrice = this.getChartYCoordinateForPrice(bidBestPrice);
            if (y_price < 23) {
                y_price = 23;
            }
            if (y_nextPrice > this.priceChartHeight + 23) {
                y_nextPrice = this.priceChartHeight + 23;
            }
            int h = y_nextPrice - y_price;
            Color color = OrderCellSupport.selectBackground(1, this.scheme).darker();
            this.chartG2D.setColor(color);
            this.chartG2D.fillRect(this.getWidth() - 80 - 2, y_price, 80, h);
            this.chartG2D.setColor(color.brighter());
            int askSizeBarWidth = (int)(askSize * sizeZoomFactor) - 1;
            if (askSizeBarWidth > 78) {
                askSizeBarWidth = 78;
            }
            if (askSizeBarWidth == 0 && askSize > 0.0) {
                askSizeBarWidth = 1;
            }
            this.chartG2D.fillRect(this.getWidth() - 80 - 1, y_price + 2, askSizeBarWidth, h / 2 - 2);
            int bidSizeBarWidth = (int)(bidSize * sizeZoomFactor) - 1;
            if (bidSizeBarWidth > 78) {
                bidSizeBarWidth = 78;
            }
            if (bidSizeBarWidth == 0 && bidSize > 0.0) {
                bidSizeBarWidth = 1;
            }
            this.chartG2D.fillRect(this.getWidth() - 80 - 1, y_price + h / 2 + 1, bidSizeBarWidth, h / 2 - 1);
            this.chartG2D.drawLine(this.getWidth() - 80 - 4, y_nextPrice, this.getWidth() - 3, y_nextPrice);
            this.chartG2D.drawLine(this.getWidth() - 80 - 4, y_price, this.getWidth() - 3, y_price);
            this.chartG2D.setColor(COLOR_VERTICAL_BOOK_BBO_LINE);
            this.chartG2D.drawLine(this.getWidth() - 80 - 4, y_price + h / 2, this.getWidth() - 3, y_price + h / 2);
            this.chartG2D.setColor(COLOR_VERTICAL_BOOK_BBO_TEXT);
            String strPrice = ViewerCellValue.formatPrice(bidBestPrice);
            String strSize = ViewerCellValue.formatSize(bidSize);
            FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
            Rectangle2D bounds = metrics.getStringBounds(strPrice, null);
            if ((int)bounds.getHeight() < h - 4) {
                this.chartG2D.drawString(strPrice, this.getWidth() - 80 - 2, y_price + h - (int)bounds.getHeight() / 2 + 3);
            }
            if ((int)(bounds = metrics.getStringBounds(strSize, null)).getHeight() < h - 4) {
                this.chartG2D.drawString(strSize, this.getWidth() - (int)bounds.getWidth() - 2, y_price + h - (int)bounds.getHeight() / 2 + 3);
            }
            strPrice = ViewerCellValue.formatPrice(askBestPrice);
            strSize = ViewerCellValue.formatSize(askSize);
            bounds = metrics.getStringBounds(strPrice, null);
            if ((int)bounds.getHeight() < h - 4) {
                this.chartG2D.drawString(strPrice, this.getWidth() - 80 - 2, y_price + (int)bounds.getHeight() / 2 + 4);
            }
            if ((int)(bounds = metrics.getStringBounds(strSize, null)).getHeight() < h - 4) {
                this.chartG2D.drawString(strSize, this.getWidth() - (int)bounds.getWidth() - 2, y_price + (int)bounds.getHeight() / 2 + 4);
            }
            if (bidIndex < this.bidOrders.size() - 1) {
                this.drawVerticalBookBidOrAsk(true, this.bidOrders, bidIndex, sizeZoomFactor);
            }
            if (askIndex < this.askOrders.size() - 1) {
                this.drawVerticalBookBidOrAsk(false, this.askOrders, askIndex, sizeZoomFactor);
            }
        }
    }

    private double getMaxAggregatedSize(List<? extends Order> orders) {
        double maxSize = 0.0;
        if (orders.size() > 0) {
            double curSize = 0.0;
            double curPrice = 0.0;
            for (Order order : orders) {
                if (order.getPrice() != curPrice) {
                    if (curSize > maxSize) {
                        maxSize = curSize;
                    }
                    curPrice = order.getPrice();
                    curSize = order.getSizeAsDouble();
                } else {
                    curSize += order.getSizeAsDouble();
                }
                if (!(order.getPrice() < this.minPrice) && !(order.getPrice() > this.maxPrice)) continue;
                break;
            }
            if (curSize > maxSize) {
                maxSize = curSize;
            }
        }
        return maxSize;
    }

    private void drawVerticalBookBidOrAsk(boolean isBid, List<? extends Order> orders, int startIndex, double sizeZoomFactor) {
        int y_nextPrice = 24;
        int priceGroup = 1;
        if (orders.size() > 0) {
            double price = orders.get(startIndex).getPrice();
            int y_price = this.getChartYCoordinateForPrice(price);
            for (int i = startIndex + 1; i < orders.size() && y_nextPrice < this.priceChartHeight + 23 && y_nextPrice > 23; ++i) {
                Order o = orders.get(i);
                double nextPrice = o.getPrice();
                y_nextPrice = this.getChartYCoordinateForPrice(nextPrice);
                if (price != nextPrice) {
                    ++priceGroup;
                }
                if (isBid) {
                    if (y_price < 23 || y_price > this.priceChartHeight + 23) {
                        y_price = this.priceChartHeight + 23;
                    }
                    if (y_nextPrice < 23 || y_nextPrice > this.priceChartHeight + 23) {
                        y_nextPrice = this.priceChartHeight + 23;
                    }
                } else {
                    if (y_price < 23 || y_price > this.priceChartHeight + 23) {
                        y_price = 23;
                    }
                    if (y_nextPrice < 23 || y_nextPrice > this.priceChartHeight + 23) {
                        y_nextPrice = 23;
                    }
                }
                Color color = OrderCellSupport.selectBackground(priceGroup, this.scheme).darker();
                this.chartG2D.setColor(color);
                int h = (isBid ? y_nextPrice - y_price : y_price - y_nextPrice) - 1;
                int y_curPrice = isBid ? y_price : y_nextPrice;
                this.chartG2D.fillRect(this.getWidth() - 80 - 2, y_curPrice + 1, 80, h);
                this.chartG2D.setColor(color.brighter());
                int sizeBarWidth = (int)(o.getSizeAsDouble() * sizeZoomFactor) - 1;
                if (sizeBarWidth > 78) {
                    sizeBarWidth = 78;
                }
                if (sizeBarWidth == 0 && o.getSizeAsDouble() > 0.0) {
                    sizeBarWidth = 1;
                }
                this.chartG2D.fillRect(this.getWidth() - 80 - 1, y_curPrice + 2, sizeBarWidth, h - 2);
                if (nextPrice >= this.minPrice && nextPrice < this.maxPrice) {
                    this.chartG2D.drawLine(this.getWidth() - 80 - 5, y_nextPrice, this.getWidth() - 3, y_nextPrice);
                }
                this.chartG2D.setColor(COLOR_VERTICAL_BOOK_TEXT);
                String strPrice = ViewerCellValue.formatPrice(nextPrice);
                String strSize = ViewerCellValue.formatSize(o.getSizeAsDouble());
                FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
                Rectangle2D bounds = metrics.getStringBounds(strPrice, null);
                if ((int)bounds.getHeight() < h - 4) {
                    this.chartG2D.drawString(strPrice, this.getWidth() - 80 - 2, isBid ? y_price + 1 + h - (int)bounds.getHeight() + 10 : y_nextPrice + 1 + (int)bounds.getHeight() - 2);
                }
                if ((int)(bounds = metrics.getStringBounds(strSize, null)).getHeight() < h - 4) {
                    this.chartG2D.drawString(strSize, this.getWidth() - (int)bounds.getWidth() - 2, isBid ? y_price + 1 + h - (int)bounds.getHeight() + 10 : y_nextPrice + 1 + (int)bounds.getHeight() - 2);
                }
                y_price = y_nextPrice;
                price = nextPrice;
            }
        }
    }

    private void drawCrosshair(Graphics g) {
        Rectangle2D bounds;
        g.setFont(DEFAULT_FONT);
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        if (this.drawCrosshairX) {
            g.setColor(COLOR_CROSSHAIR);
            g.drawLine(this.x_crossHair, 23, this.x_crossHair, this.getHeight() - 14);
            int tickIndexAtCrosshair = this.getTickIndexByX(this.x_crossHair);
            if (tickIndexAtCrosshair >= 0) {
                g.setColor(COLOR_CROSSHAIR_TEXT);
                TimeAndSale curTimeAndSale = this.timeAndSales.get(tickIndexAtCrosshair);
                String strTimeAtCrosshair = TimeFormat.DEFAULT.withMillis().format(curTimeAndSale.getTime());
                bounds = metrics.getStringBounds(strTimeAtCrosshair, null);
                int x_text = this.x_crossHair - (int)bounds.getWidth() / 2;
                if (x_text < (int)bounds.getWidth() / 2) {
                    x_text = this.x_crossHair;
                } else if (x_text > 112 + this.chartWidthExMargins - (int)bounds.getWidth() / 2) {
                    x_text = this.x_crossHair - metrics.stringWidth(strTimeAtCrosshair);
                }
                g.drawString(strTimeAtCrosshair, x_text, this.getHeight() - 4);
                int y_curTickPrice = this.getChartYCoordinateForPrice(curTimeAndSale.getPrice()) + (int)bounds.getHeight() / 2 - 2;
                int y_curTickBid = this.getChartYCoordinateForPrice(curTimeAndSale.getBidPrice()) + (int)bounds.getHeight() + 2;
                int y_curTickAsk = this.getChartYCoordinateForPrice(curTimeAndSale.getAskPrice());
                if (curTimeAndSale.getBidPrice() > 0.0) {
                    this.drawCrosshairLabel(g, TickChartRendererPanel.price2String(curTimeAndSale.getBidPrice()), this.x_crossHair, y_curTickBid, COLOR_BID);
                }
                if (curTimeAndSale.getAskPrice() > 0.0) {
                    this.drawCrosshairLabel(g, TickChartRendererPanel.price2String(curTimeAndSale.getAskPrice()), this.x_crossHair, y_curTickAsk, COLOR_ASK);
                }
                int y_curTickSize = 23 + this.chartHeightExMargins - this.sizeChartHeight / 2;
                y_curTickSize = curTimeAndSale.getAggressorSide() == Side.SELL ? (y_curTickSize += this.getChartBarHeightForSize(curTimeAndSale.getSizeAsDouble()) + (int)bounds.getHeight() + 1) : (y_curTickSize -= this.getChartBarHeightForSize(curTimeAndSale.getSizeAsDouble()) + 1);
                this.selectSizeColor(curTimeAndSale);
                this.drawCrosshairLabel(g, TickChartRendererPanel.size2String(curTimeAndSale.getSizeAsDouble()), this.x_crossHair, y_curTickSize, this.chartG2D.getColor());
                if (tickIndexAtCrosshair < this.visibleTickCount - 1) {
                    this.selectTickColor(this.timeAndSales.get(tickIndexAtCrosshair + 1), curTimeAndSale);
                    g.setColor(this.chartG2D.getColor());
                } else {
                    g.setColor(COLOR_TICK_SAME);
                }
                this.drawCrosshairLabel(g, TickChartRendererPanel.price2String(curTimeAndSale.getPrice()), this.x_crossHair, y_curTickPrice, g.getColor());
            }
        }
        if (this.drawCrosshairY) {
            VolumeAtPriceBar volumeAtPriceBar;
            g.setColor(COLOR_CROSSHAIR);
            g.drawLine(112, this.y_crossHair, 112 + this.chartWidthExMargins, this.y_crossHair);
            g.drawLine(2, this.y_crossHair, 62, this.y_crossHair);
            g.drawLine(this.getWidth() - 80 - 5, this.y_crossHair, this.getWidth() - 2, this.y_crossHair);
            g.setColor(COLOR_CROSSHAIR_TEXT);
            String strPriceAtCrosshair = TickChartRendererPanel.price2String(this.getPriceByY(this.y_crossHair));
            bounds = metrics.getStringBounds(strPriceAtCrosshair, null);
            g.drawString(strPriceAtCrosshair, 112 + this.chartWidthExMargins + 3, this.y_crossHair + (int)bounds.getHeight() / 2 - 2);
            g.drawString(strPriceAtCrosshair, 109 - (int)bounds.getWidth(), this.y_crossHair + (int)bounds.getHeight() / 2 - 2);
            if (this.volumeAtPriceChart != null && (volumeAtPriceBar = this.volumeAtPriceChart.getVolumeAtY(this.y_crossHair - 23)) != null) {
                if (volumeAtPriceBar.getBuySize() + volumeAtPriceBar.getUndefinedSize() > 0.0) {
                    String strBuyVolumeAtCrosshair = TickChartRendererPanel.size2String(volumeAtPriceBar.getBuySize());
                    String strUndefinedVolumeAtCrosshair = TickChartRendererPanel.size2String(volumeAtPriceBar.getUndefinedSize());
                    bounds = metrics.getStringBounds(strUndefinedVolumeAtCrosshair, null);
                    int buyVolumeWidth = (int)bounds.getWidth();
                    if (volumeAtPriceBar.getUndefinedSize() > 0.0) {
                        this.drawCrosshairLabel(g, strUndefinedVolumeAtCrosshair, 30, this.y_crossHair + (int)bounds.getHeight() / 2, COLOR_VOLUME);
                    } else {
                        buyVolumeWidth = -3;
                    }
                    if (volumeAtPriceBar.getBuySize() > 0.0) {
                        bounds = metrics.getStringBounds(strBuyVolumeAtCrosshair, null);
                        this.drawCrosshairLabel(g, strBuyVolumeAtCrosshair, 30 + buyVolumeWidth + 3, this.y_crossHair + (int)bounds.getHeight() / 2, COLOR_VOLUME_BUY);
                    }
                }
                if (volumeAtPriceBar.getSellSize() > 0.0) {
                    String strSellVolumeAtCrosshair = TickChartRendererPanel.size2String(volumeAtPriceBar.getSellSize());
                    bounds = metrics.getStringBounds(strSellVolumeAtCrosshair, null);
                    this.drawCrosshairLabel(g, strSellVolumeAtCrosshair, 32 - (int)bounds.getWidth() - 5, this.y_crossHair + (int)bounds.getHeight() / 2, COLOR_VOLUME_SELL);
                }
            }
        }
    }

    private void drawCrosshairLabel(Graphics g, String label, int x, int y, Color color) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        Rectangle2D bounds = metrics.getStringBounds(label, null);
        Color c = color.darker().darker().darker();
        g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 192));
        g.fillRect(x + 2, y - (int)bounds.getHeight() - 1, (int)bounds.getWidth() + 2, (int)bounds.getHeight() + 2);
        g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 192));
        g.drawRect(x + 2, y - (int)bounds.getHeight() - 1, (int)bounds.getWidth() + 2, (int)bounds.getHeight() + 2);
        g.drawString(label, x + 4, y - 2);
    }

    private boolean isRepaintRequired() {
        return this.repaintRequired || this.lastWidth != this.getWidth() || this.lastHeight != this.getHeight();
    }

    private void drawTimeLineProtrusionAxises() {
        FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
        for (int protrusionLevel : TIMELINE_PROTRUSIONS) {
            if (protrusionLevel == 0 || protrusionLevel > this.maxProtrusionLevel) continue;
            this.chartG2D.setColor(COLOR_TRADE_TIMELINE[protrusionLevel]);
            int y_timeLine = 23 + this.chartHeightExMargins + 2 + protrusionLevel * 10;
            this.chartG2D.drawLine(112, y_timeLine, 112 + this.chartWidthExMargins, y_timeLine);
            String strTimeLineAxisLabel = STRING_TIME_AXIS_LABEL[protrusionLevel];
            Rectangle2D bounds = metrics.getStringBounds(strTimeLineAxisLabel, null);
            this.chartG2D.drawString(strTimeLineAxisLabel, 112 + this.chartWidthExMargins + 2, y_timeLine + (int)bounds.getHeight() / 2 - 1);
        }
    }

    private void drawTimeLine(int x, TimeAndSale priorTimeAndSale, TimeAndSale curTimeAndSale) {
        String strPriorTime = TimeFormat.DEFAULT.withMillis().format(priorTimeAndSale.getTime());
        String strCurTime = TimeFormat.DEFAULT.withMillis().format(curTimeAndSale.getTime());
        FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
        Stroke oldStroke = this.chartG2D.getStroke();
        for (int protrusionLevel : TIMELINE_PROTRUSIONS) {
            if (!strPriorTime.regionMatches(0, strCurTime, 0, STRING_TIMELINE_INTERVAL[protrusionLevel][1])) {
                String strTimeAxisLabel = strCurTime.substring(STRING_TIMELINE_INTERVAL[protrusionLevel][0], STRING_TIMELINE_INTERVAL[protrusionLevel][1]);
                this.chartG2D.setStroke(protrusionLevel == 0 ? DASHED_STROKE : SIMPLE_STROKE);
                this.chartG2D.setColor(COLOR_TRADE_TIMELINE[protrusionLevel]);
                int y_timeLine = 23 + this.chartHeightExMargins + 2 + protrusionLevel * 10;
                this.chartG2D.drawLine(x, 23, x, y_timeLine);
                if (protrusionLevel == 0) continue;
                int x_last = this.x_lastTimeLineProtrusion[protrusionLevel];
                Rectangle2D bounds = metrics.getStringBounds(strTimeAxisLabel, null);
                if (x_last != 0 && x_last - x <= (int)bounds.getWidth() / 2 + 4) continue;
                this.chartG2D.setColor(COLOR_TRADE_TIMELINE[protrusionLevel].brighter().brighter());
                this.chartG2D.drawString(strTimeAxisLabel, x - (int)bounds.getWidth() / 2 + 1, y_timeLine + (int)bounds.getHeight() - 2);
                this.x_lastTimeLineProtrusion[protrusionLevel] = x;
                continue;
            }
            this.maxProtrusionLevel = Math.max(this.maxProtrusionLevel, protrusionLevel - 1);
            break;
        }
        this.chartG2D.setStroke(oldStroke);
    }

    private void drawPriceAxisAndLabels(int y_priceLabel, int y_bidPriceLabel, int y_askPriceLabel, TimeAndSale priorTimeAndSale, TimeAndSale curTimeAndSale) {
        String strLastTickPrice = Double.toString(curTimeAndSale.getPrice());
        String strMinPrice = TickChartRendererPanel.price2String(this.minPrice);
        String strMaxPrice = TickChartRendererPanel.price2String(this.maxPrice);
        String strLastTickBid = "";
        String strLastTickAsk = "";
        if (!Double.isNaN(curTimeAndSale.getBidPrice())) {
            strLastTickBid = TickChartRendererPanel.price2String(curTimeAndSale.getBidPrice());
        }
        if (!Double.isNaN(curTimeAndSale.getAskPrice())) {
            strLastTickAsk = TickChartRendererPanel.price2String(curTimeAndSale.getAskPrice());
        }
        String strMaxBuySize = "";
        String strMaxSellSize = "";
        if (this.maxBuySize > 0.0) {
            strMaxBuySize = TickChartRendererPanel.size2String(this.maxBuySize);
        }
        if (this.maxSellSize > 0.0) {
            strMaxSellSize = TickChartRendererPanel.size2String(this.maxSellSize);
        }
        String strLastTickSize = TickChartRendererPanel.size2String(curTimeAndSale.getSizeAsDouble());
        FontMetrics metrics = this.chartG2D.getFontMetrics(this.chartG2D.getFont());
        Stroke oldStroke = this.chartG2D.getStroke();
        this.chartG2D.setStroke(SIMPLE_STROKE);
        this.drawPriceAxis();
        this.drawSizeAxis();
        this.chartG2D.setStroke(oldStroke);
        this.drawSizeLabels(strMaxBuySize, strMaxSellSize, strLastTickSize, curTimeAndSale, metrics);
        this.drawPriceLabels(y_priceLabel, y_bidPriceLabel, y_askPriceLabel, priorTimeAndSale, curTimeAndSale, strLastTickPrice, strMinPrice, strMaxPrice, strLastTickBid, strLastTickAsk, metrics);
    }

    private void drawPriceAxis() {
        int x1 = 112;
        int x2 = 112 + this.chartWidthExMargins;
        int y1 = 23;
        int y2 = 23 + (int)((double)this.chartHeightExMargins * 0.87);
        this.chartG2D.setColor(COLOR_AXIS);
        this.chartG2D.drawLine(112, 23, 112, y2);
        this.chartG2D.drawLine(x2, 23, x2, y2);
    }

    private void drawSizeAxis() {
        int x1 = 112 + this.chartWidthExMargins;
        int x2 = 112;
        int y1 = 23 + this.chartHeightExMargins - this.sizeChartHeight;
        int y2 = 23 + this.chartHeightExMargins - this.sizeChartHeight / 2;
        int y3 = 23 + this.chartHeightExMargins;
        this.chartG2D.setColor(COLOR_VOLUME);
        this.chartG2D.drawLine(x1, y1, x1, y2 - 1);
        this.chartG2D.drawLine(112, y1, 112, y2 - 1);
        this.chartG2D.setColor(COLOR_VOLUME_SELL);
        this.chartG2D.drawLine(x1, y2 + 1, x1, y3);
        this.chartG2D.drawLine(112, y2 + 1, 112, y3);
    }

    private void drawSizeLabels(String strMaxBuySize, String strMaxSellSize, String strLastTickSize, TimeAndSale curTimeAndSale, FontMetrics metrics) {
        this.chartG2D.setColor(COLOR_VOLUME);
        Rectangle2D bounds = metrics.getStringBounds(strMaxBuySize, null);
        int x1 = 112 + this.chartWidthExMargins + 3;
        int x2 = 109 - (int)bounds.getWidth();
        int y = 23 + this.chartHeightExMargins - this.sizeChartHeight + (int)bounds.getHeight() - 4;
        this.chartG2D.drawString(strMaxBuySize, x1, y);
        this.chartG2D.drawString(strMaxBuySize, x2, y);
        this.chartG2D.setColor(COLOR_VOLUME_SELL);
        bounds = metrics.getStringBounds(strMaxSellSize, null);
        x2 = 109 - (int)bounds.getWidth();
        y = 23 + this.chartHeightExMargins + (int)bounds.getHeight() - 4;
        this.chartG2D.drawString(strMaxSellSize, x1, y);
        this.chartG2D.drawString(strMaxSellSize, x2, y);
        this.selectSizeColor(curTimeAndSale);
        bounds = metrics.getStringBounds(strLastTickSize, null);
        y = 23 + this.chartHeightExMargins - this.sizeChartHeight / 2 + (int)bounds.getHeight() / 2 - 2;
        this.chartG2D.drawString(strLastTickSize, x1, y);
    }

    private void drawPriceLabels(int y_priceLabel, int y_bidPriceLabel, int y_askPriceLabel, TimeAndSale priorTimeAndSale, TimeAndSale curTimeAndSale, String strLastTickPrice, String strMinPrice, String strMaxPrice, String strLastTickBid, String strLastTickAsk, FontMetrics metrics) {
        this.chartG2D.setColor(COLOR_AXIS);
        int x1 = 112 + this.chartWidthExMargins + 3;
        int x2 = 109;
        Rectangle2D bounds = metrics.getStringBounds(strMinPrice, null);
        int y = 23 + (int)((double)this.chartHeightExMargins * 0.87) + (int)bounds.getHeight() / 2 - 2;
        this.chartG2D.drawString(strMinPrice, x1, y);
        this.chartG2D.drawString(strMinPrice, 109 - (int)bounds.getWidth(), y);
        bounds = metrics.getStringBounds(strMaxPrice, null);
        this.chartG2D.drawString(strMaxPrice, x1, 23 + (int)bounds.getHeight() / 2 - 2);
        this.chartG2D.drawString(strMaxPrice, 109 - (int)bounds.getWidth(), 23 + (int)bounds.getHeight() / 2 - 2);
        this.chartG2D.setColor(COLOR_BID);
        bounds = metrics.getStringBounds(strLastTickBid, null);
        this.chartG2D.drawString(strLastTickBid, x1, y_bidPriceLabel + (int)bounds.getHeight() / 2 - 2);
        this.chartG2D.setColor(COLOR_ASK);
        bounds = metrics.getStringBounds(strLastTickAsk, null);
        this.chartG2D.drawString(strLastTickAsk, x1, y_askPriceLabel + (int)bounds.getHeight() / 2 - 2);
        this.selectTickColor(priorTimeAndSale, curTimeAndSale);
        bounds = metrics.getStringBounds(strLastTickPrice, null);
        this.chartG2D.drawString(strLastTickPrice, x1, y_priceLabel + (int)bounds.getHeight() / 2 - 2);
    }

    private void drawCurrentTickTime(String strLastTickTime, FontMetrics metrics) {
        this.chartG2D.setColor(COLOR_AXIS);
        Rectangle2D bounds = metrics.getStringBounds(strLastTickTime, null);
        this.chartG2D.drawString(strLastTickTime, 112 + this.chartWidthExMargins - metrics.stringWidth(strLastTickTime), 23 + this.chartHeightExMargins + (int)bounds.getHeight());
    }
}

