/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.viewer.EventTableModel;
import com.dxfeed.viewer.TimeAndSalesTableColumn;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.TableModelEvent;

class TimeAndSalesTableModel
extends EventTableModel<TimeAndSale> {
    static final TimeAndSale CLEAR = new TimeAndSale();
    private static final Comparator<TimeAndSale> TIME_AND_SALES_BY_EVENT_ID = (t1, t2) -> -Long.compare(t1.getIndex(), t2.getIndex());
    private final TreeSet<TimeAndSale> timeAndSales = new TreeSet<TimeAndSale>(TIME_AND_SALES_BY_EVENT_ID);
    private final Set<TimeAndSale> updatedTimeAndSales = new HashSet<TimeAndSale>();
    private int maxCapacity;

    TimeAndSalesTableModel(int maxCapacity) {
        super(TimeAndSalesTableColumn.values());
        this.maxCapacity = maxCapacity;
    }

    @Override
    public void eventsReceived(List<TimeAndSale> timeAndSaleEvents) {
        if (this.frozen) {
            return;
        }
        boolean updated = false;
        boolean isComplexUpdate = false;
        for (TimeAndSale timeAndSale : timeAndSaleEvents) {
            updated = true;
            if (timeAndSale == CLEAR) {
                this.timeAndSales.clear();
                this.updatedTimeAndSales.clear();
                isComplexUpdate = true;
                continue;
            }
            this.timeAndSales.add(timeAndSale);
            this.updatedTimeAndSales.add(timeAndSale);
            isComplexUpdate |= this.timeAndSales.first() != timeAndSale;
        }
        if (!updated) {
            this.clearUpdates();
            return;
        }
        int removed = Math.max(0, this.timeAndSales.size() - this.maxCapacity);
        while (this.timeAndSales.size() > this.maxCapacity) {
            this.timeAndSales.remove(this.timeAndSales.last());
        }
        this.events.clear();
        this.events.addAll(this.timeAndSales);
        this.isUpdated.clear();
        this.isDisabled.clear();
        this.tags.clear();
        for (TimeAndSale timeAndSale : this.events) {
            this.isUpdated.add(this.updatedTimeAndSales.contains(timeAndSale));
            this.tags.add(0);
            this.isDisabled.add(false);
        }
        if (isComplexUpdate) {
            this.fireTableChanged(new TableModelEvent(this));
        } else {
            this.fireTableChanged(new TableModelEvent(this, 0, this.updatedTimeAndSales.size() - 1, -1, 1));
            if (removed > 0) {
                this.fireTableChanged(new TableModelEvent(this, this.maxCapacity, this.maxCapacity + removed - 1, -1, -1));
            }
        }
        this.updatedTimeAndSales.clear();
    }
}

