/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.viewer;

import com.dxfeed.viewer.ViewerCellValue;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

class ViewerCellRenderer
extends DefaultTableCellRenderer {
    public static final ViewerCellRenderer INSTANCE = new ViewerCellRenderer();
    public static final Color DARK_SCHEME_GRID_COLOR = new Color(0x2F2F2F);
    public static final Color DARK_SCHEME_BACKGROUND_COLOR_1 = Color.BLACK;
    public static final Color DARK_SCHEME_BACKGROUND_COLOR_2 = new Color(0x202020);
    public static final Color LIGHT_SCHEME_GRID_COLOR = new Color(0xE0E0E0);
    public static final Color LIGHT_SCHEME_BACKGROUND_COLOR_1 = new Color(0xF5F5F5);
    public static final Color LIGHT_SCHEME_BACKGROUND_COLOR_2 = Color.WHITE;
    public static final Color SELECTED_BG_COLOR = new Color(0xFFCC00);
    public static final Color SELECTED_FG_COLOR = Color.BLACK;
    public static final Color EDIT_BG_COLOR = new Color(0xAA8800);
    public static final Color EDIT_FG_COLOR = Color.WHITE;
    public static final Border EMPTY_BORDER = new EmptyBorder(0, 2, 0, 2);
    public static final Border FOCUS_BORDER = new LineBorder(EDIT_BG_COLOR, 2);
    public static final int DARK_SCHEME = 0;
    public static final int LIGHT_SCHEME = 1;
    public static final int DEFAULT_SCHEME = 0;
    private int scheme = 0;
    private double value;

    ViewerCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ViewerCellValue cellValue = (ViewerCellValue)value;
        this.setText(cellValue.getText());
        this.setValue(cellValue.getValue());
        if (isSelected) {
            this.setForeground(SELECTED_FG_COLOR);
            this.setBackground(SELECTED_BG_COLOR);
        } else {
            this.setForeground(cellValue.getColor());
            if (cellValue.getBackground() == null) {
                if (this.scheme == 0) {
                    this.setBackground((row & 1) == 0 ? DARK_SCHEME_BACKGROUND_COLOR_1 : DARK_SCHEME_BACKGROUND_COLOR_2);
                } else {
                    this.setBackground((row & 1) == 0 ? LIGHT_SCHEME_BACKGROUND_COLOR_1 : LIGHT_SCHEME_BACKGROUND_COLOR_2);
                }
            } else {
                this.setBackground(cellValue.getBackground());
            }
        }
        this.setBorder(hasFocus ? FOCUS_BORDER : EMPTY_BORDER);
        this.setFont(table.getFont());
        this.setHorizontalAlignment(cellValue.getAlignment());
        return this;
    }

    void setValue(double value) {
        this.value = value;
    }

    double getValue() {
        return this.value;
    }

    public void setScheme(int scheme) {
        this.scheme = scheme;
    }
}

