/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.rest;

import com.devexperts.annotation.Description;
import com.devexperts.logging.Logging;
import com.devexperts.qd.QDFilter;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimePeriod;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.osub.IndexedEventSubscriptionSymbol;
import com.dxfeed.api.osub.TimeSeriesSubscriptionSymbol;
import com.dxfeed.event.EventType;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.promise.Promise;
import com.dxfeed.promise.PromiseHandler;
import com.dxfeed.promise.Promises;
import com.dxfeed.webservice.DXFeedContext;
import com.dxfeed.webservice.EventSymbolMap;
import com.dxfeed.webservice.rest.Events;
import com.dxfeed.webservice.rest.Format;
import com.dxfeed.webservice.rest.HelpOrder;
import com.dxfeed.webservice.rest.HttpErrorException;
import com.dxfeed.webservice.rest.Param;
import com.dxfeed.webservice.rest.ParamInfo;
import com.dxfeed.webservice.rest.ParamType;
import com.dxfeed.webservice.rest.Path;
import com.dxfeed.webservice.rest.PathInfo;
import com.dxfeed.webservice.rest.SSEConnection;
import com.dxfeed.webservice.rest.Secure;
import com.dxfeed.webservice.rest.SubResponse;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class EventsResource {
    public static final String HELP_PATH = "/help";
    public static final String DEFAULT_SESSION = "DEFAULT_EVENT_SOURCE";
    public static final long DEFAULT_TIMEOUT = TimePeriod.valueOf((String)SystemProperties.getProperty(EventsResource.class, (String)"defaultTimeout", (String)"3s")).getTime();
    public static final Map<String, PathInfo> PATHS = new LinkedHashMap<String, PathInfo>();
    public static final Map<String, ParamInfo> PARAMS = new LinkedHashMap<String, ParamInfo>();
    private final HttpServletRequest req;
    private final HttpServletResponse resp;
    private final Format format;
    private final Logging log;
    @Param(value="event")
    @Description(value="The type of event (like \"Quote\", \"Trade\", etc).")
    public List<String> eventList;
    @Param(value="symbol")
    @Description(value="The symbol (like \"IBM\", \"MSFT\", etc).")
    public List<String> symbolList;
    @Param(value="fromTime")
    @Description(value="The time from which to return events.")
    public Date fromTime;
    @Param(value="source")
    @Description(value="The source for indexed events.")
    public List<String> sourceList;
    @Param(value="indent")
    @Description(value="The result is indented for better readability when this parameter is set.")
    public String indent;
    private static final AtomicLong REQUEST_ID;

    public EventsResource(HttpServletRequest req, HttpServletResponse resp, Format format) {
        this.req = req;
        this.resp = resp;
        this.format = format;
        for (Map.Entry<String, ParamInfo> entry : PARAMS.entrySet()) {
            try {
                ParamInfo paramInfo = entry.getValue();
                paramInfo.field.set(this, this.getRequestValue(paramInfo));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.log = new Logging(EventsResource.class.getName()){

            protected String decorateLogMessage(String msg) {
                return "(" + EventsResource.this.req.getRemoteAddr() + ") " + msg;
            }
        };
    }

    Object getRequestValue(ParamInfo paramInfo) {
        return paramInfo.type.getValue(paramInfo.name, this.req);
    }

    @Path(value="/help")
    @Secure(value=Secure.SecureRole.NONE)
    @HelpOrder(value=0)
    @Description(value="Shows human-readable help.")
    public void doHelp() throws ServletException, IOException {
        this.req.getRequestDispatcher("/jsp/rest/help.jsp").forward((ServletRequest)this.req, (ServletResponse)this.resp);
    }

    @Path(value="/events")
    @Secure(value=Secure.SecureRole.AUTH_REQUEST)
    @HelpOrder(value=1)
    @Description(value="Returns a snapshot of events.")
    public void doEvents(@Description(name="toTime", value="The time to which to return events.\n                It is optional for time series events and is ignored for other types of events.") Date toTime, @Description(name="timeout", value="The maximal time to wait events from the data sources.\n                Use timeout=0 to return results from memory cache, given that the subscription was already established.") TimePeriod timeout) throws HttpErrorException {
        if (timeout != null && timeout.getTime() == 0L) {
            this.doEventsWithoutTimeout(toTime);
            return;
        }
        ArrayList promiseList = new ArrayList(this.eventList.size() * this.symbolList.size());
        EventSymbolMap symbolMap = new EventSymbolMap();
        this.buildPromisesList(toTime, promiseList, symbolMap);
        AsyncContext async = this.req.startAsync();
        Promise allPromises = Promises.allOf(promiseList);
        long timeoutMillis = timeout == null ? DEFAULT_TIMEOUT : timeout.getTime();
        EventRequestHandler requestHandler = new EventRequestHandler(async, promiseList, (Promise<Void>)allPromises, symbolMap, timeoutMillis);
        this.log.info("Processing " + requestHandler);
        async.addListener((AsyncListener)requestHandler);
        async.setTimeout(timeoutMillis);
        allPromises.whenDone((PromiseHandler)requestHandler);
    }

    private void buildPromisesList(Date toTime, List<Promise<?>> promiseList, EventSymbolMap symbolMap) throws HttpErrorException {
        DXFeed feed = this.getFeed(this.getFilter());
        List<OrderSource> sourceList = this.resolveSourceList(Collections.singletonList(OrderSource.DEFAULT));
        for (String evt : this.eventList) {
            Class<? extends EventType<?>> et = DXFeedContext.INSTANCE.getEventTypes().get(evt);
            if (et == null) {
                throw this.unknownEventType(evt);
            }
            if (TimeSeriesEvent.class.isAssignableFrom(et) && this.fromTime != null) {
                long fromTimeL = this.fromTime.getTime();
                long toTimeL = toTime == null ? Long.MAX_VALUE : toTime.getTime();
                for (String sym : this.symbolList) {
                    promiseList.add(feed.getTimeSeriesPromise(et, symbolMap.resolveEventSymbolMapping(et, sym), fromTimeL, toTimeL));
                }
                continue;
            }
            if (LastingEvent.class.isAssignableFrom(et)) {
                promiseList.addAll(feed.getLastEventsPromises(et, symbolMap.resolveEventSymbolMappings(et, this.symbolList)));
                continue;
            }
            if (IndexedEvent.class.isAssignableFrom(et)) {
                for (String sym : this.symbolList) {
                    for (OrderSource src : sourceList) {
                        promiseList.add(feed.getIndexedEventsPromise(et, symbolMap.resolveEventSymbolMapping(et, sym), (IndexedEventSource)src));
                    }
                }
                continue;
            }
            Promise fail = new Promise();
            fail.complete(null);
            promiseList.add(fail);
        }
    }

    private void doEventsWithoutTimeout(Date toTime) throws HttpErrorException {
        int requestSize = this.eventList.size() * this.symbolList.size();
        ArrayList eventsList = new ArrayList(requestSize);
        EventSymbolMap symbolMap = new EventSymbolMap();
        boolean ok = this.buildEventsList(toTime, eventsList, symbolMap);
        Events result = new Events();
        result.setStatus(ok ? Events.Status.OK : Events.Status.NOT_SUBSCRIBED);
        result.setEvents(eventsList);
        result.setSymbolMap(symbolMap);
        String logRespReason = "event request [size=" + requestSize + ", timeout=0] with " + eventsList.size() + " events (" + (Object)((Object)result.getStatus()) + ")";
        if (this.writeResponse(result, logRespReason)) {
            this.log.info("Sent response for " + logRespReason);
        }
    }

    private boolean buildEventsList(Date toTime, List<EventType<?>> eventsList, EventSymbolMap symbolMap) throws HttpErrorException {
        boolean ok = true;
        DXFeed feed = this.getFeed(this.getFilter());
        List<OrderSource> sourceList = this.resolveSourceList(Collections.singletonList(OrderSource.DEFAULT));
        for (String evt : this.eventList) {
            Class<? extends EventType<?>> et = DXFeedContext.INSTANCE.getEventTypes().get(evt);
            if (et == null) {
                throw this.unknownEventType(evt);
            }
            if (TimeSeriesEvent.class.isAssignableFrom(et) && this.fromTime != null) {
                long fromTimeL = this.fromTime.getTime();
                long toTimeL = toTime == null ? Long.MAX_VALUE : toTime.getTime();
                for (String sym : this.symbolList) {
                    List events = feed.getTimeSeriesIfSubscribed(et, symbolMap.resolveEventSymbolMapping(et, sym), fromTimeL, toTimeL);
                    if (events == null) {
                        ok = false;
                        continue;
                    }
                    eventsList.addAll(events);
                }
                continue;
            }
            if (LastingEvent.class.isAssignableFrom(et)) {
                for (String sym : this.symbolList) {
                    LastingEvent event = feed.getLastEventIfSubscribed(et, symbolMap.resolveEventSymbolMapping(et, sym));
                    if (event == null) {
                        ok = false;
                        continue;
                    }
                    eventsList.add((EventType<?>)event);
                }
                continue;
            }
            if (IndexedEvent.class.isAssignableFrom(et)) {
                for (String sym : this.symbolList) {
                    for (OrderSource src : sourceList) {
                        List events = feed.getIndexedEventsIfSubscribed(et, symbolMap.resolveEventSymbolMapping(et, sym), (IndexedEventSource)src);
                        if (events == null) {
                            ok = false;
                            continue;
                        }
                        eventsList.addAll(events);
                    }
                }
                continue;
            }
            throw this.getNotSupported(evt);
        }
        return ok;
    }

    private List<OrderSource> resolveSourceList(List<OrderSource> defList) {
        if (this.sourceList.isEmpty()) {
            return defList;
        }
        ArrayList<OrderSource> result = new ArrayList<OrderSource>(this.sourceList.size());
        for (String s : this.sourceList) {
            result.add(OrderSource.valueOf((String)s));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Path(value="/eventSource")
    @Secure(value=Secure.SecureRole.AUTH_SESSION)
    @HelpOrder(value=2)
    @Description(value="Subscribes to event updates and returns a stream of Server-Sent Events.")
    public void doEventSource(@Description(name="session", value="Session name. When set, then new web session is created (cookie is set) if needed and this\n                     subscription is stored into the session under a name specified in this parameter, so that this subscription\n                     can be later modified. The value of \"DEFAULT_EVENT_SOURCE\" is used by default when \"session\" parameter is set\n                     to an empty string.\n                     Please notice that the new web session is not created and session ID cookie is not returned\n                     if the request already contains a valid cookie for existing session ID.") String session, @Description(name="reconnect", value="Reconnect flag. When set, then existing session is recovered with its subscription.\n                     \"session\" parameter is implied when \"reconnect\" is set.") String reconnect) throws IOException, HttpErrorException {
        EventConnection conn;
        String name = session == null || session.isEmpty() ? DEFAULT_SESSION : session;
        QDFilter filter = this.getFilter();
        if (reconnect != null) {
            HttpSession httpSession = this.req.getSession(false);
            if (httpSession == null) {
                throw this.sessionNotFound("httpSession is null");
            }
            Object attr = httpSession.getAttribute(name);
            if (!(attr instanceof EventConnection)) throw this.sessionNotFound("no connection " + name);
            conn = (EventConnection)attr;
            if (!filter.toString().equals(conn.filter.toString())) {
                this.log.warn("Filters in " + name + " differ: " + filter + " vs. " + conn.filter);
                throw this.sessionNotFound("bad filters in " + name);
            }
        } else {
            conn = new EventConnection(this.getFeed(filter), filter);
        }
        this.updateSubscription(SubOp.ADD_SUB, conn);
        this.req.getSession(true).setAttribute(name, (Object)conn);
        boolean wasActive = conn.start(this.req.startAsync(), this.format, this.indent);
        this.log.info((reconnect != null ? "Restarted " : "Started ") + (wasActive ? "active " : "") + conn);
        conn.heartbeat();
    }

    @Path(value="/addSubscription")
    @Secure(value=Secure.SecureRole.AUTH_REQUEST)
    @HelpOrder(value=3)
    @Description(value="Adds subscription to the previously created event stream.")
    public void doAddSubscription(@Description(name="session", value="Session name.") String session) throws HttpErrorException, IOException {
        HttpSession httpSession = this.req.getSession(false);
        if (httpSession == null) {
            throw this.sessionNotFound("httpSession is null");
        }
        String name = session == null || session.isEmpty() ? DEFAULT_SESSION : session;
        EventConnection conn = (EventConnection)httpSession.getAttribute(name);
        if (conn == null) {
            throw this.sessionNotFound("no connection " + name);
        }
        this.updateSubscription(SubOp.ADD_SUB, conn);
        if (this.writeResponse(new SubResponse(SubResponse.Status.OK), conn)) {
            this.log.info("Added subscription to " + conn);
        }
    }

    @Path(value="/removeSubscription")
    @Secure(value=Secure.SecureRole.AUTH_REQUEST)
    @HelpOrder(value=4)
    @Description(value="Removes subscription from the previously created event stream (use same parameters as for subscription).")
    public void doRemoveSubscription(@Description(name="session", value="Session name.") String session) throws HttpErrorException, IOException {
        HttpSession httpSession = this.req.getSession(false);
        if (httpSession == null) {
            throw this.sessionNotFound("httpSession is null");
        }
        String name = session == null || session.isEmpty() ? DEFAULT_SESSION : session;
        EventConnection conn = (EventConnection)httpSession.getAttribute(name);
        if (conn == null) {
            throw this.sessionNotFound("no connection " + name);
        }
        this.updateSubscription(SubOp.REMOVE_SUB, conn);
        if (this.writeResponse(new SubResponse(SubResponse.Status.OK), conn)) {
            this.log.info("Removed subscription from " + conn);
        }
    }

    private void updateSubscription(SubOp subOp, EventConnection conn) throws HttpErrorException {
        ArrayList<Object> symbols = new ArrayList<Object>();
        for (String evt : this.eventList) {
            Class<? extends EventType<?>> et = DXFeedContext.INSTANCE.getEventTypes().get(evt);
            if (et == null) {
                throw this.unknownEventType(evt);
            }
            DXFeedSubscription sub = (DXFeedSubscription)conn.subscriptions.get(et);
            if (sub == null && subOp == SubOp.ADD_SUB) {
                sub = conn.createSubSync(et);
            }
            if (sub == null) continue;
            if (TimeSeriesEvent.class.isAssignableFrom(et) && this.fromTime != null) {
                long fromTimeL = this.fromTime.getTime();
                for (String sym : this.symbolList) {
                    symbols.add(new TimeSeriesSubscriptionSymbol(conn.symbolMap.resolveEventSymbolMapping(et, sym), fromTimeL));
                }
            } else if (LastingEvent.class.isAssignableFrom(et)) {
                symbols.addAll(conn.symbolMap.resolveEventSymbolMappings(et, this.symbolList));
            } else if (IndexedEvent.class.isAssignableFrom(et)) {
                if (this.sourceList.isEmpty()) {
                    symbols.addAll(this.symbolList);
                } else {
                    for (String sym : this.symbolList) {
                        for (String src : this.sourceList) {
                            symbols.add(new IndexedEventSubscriptionSymbol(conn.symbolMap.resolveEventSymbolMapping(et, sym), (IndexedEventSource)OrderSource.valueOf((String)src)));
                        }
                    }
                }
            } else {
                symbols.addAll(conn.symbolMap.resolveEventSymbolMappings(et, this.symbolList));
            }
            if (subOp == SubOp.ADD_SUB) {
                sub.addSymbols(symbols);
            } else {
                sub.removeSymbols(symbols);
            }
            symbols.clear();
        }
    }

    @Nonnull
    private HttpErrorException unknownEventType(String evt) {
        return new HttpErrorException(400, "Unknown event type: " + evt);
    }

    @Nonnull
    private HttpErrorException getNotSupported(String evt) {
        return new HttpErrorException(400, "GET method not supported for event type: " + evt);
    }

    @Nonnull
    private HttpErrorException sessionNotFound(String message) {
        return new HttpErrorException(412, "Session not found: " + message);
    }

    private boolean writeResponse(Object result, Object logErrReason) {
        this.resp.setHeader("Content-Type", this.format.mediaType);
        try {
            this.format.writeTo(result, (OutputStream)this.resp.getOutputStream(), this.indent);
            return true;
        }
        catch (IOException e) {
            this.log.warn("Failed to write response for " + logErrReason, (Throwable)e);
            try {
                this.resp.sendError(500, "Failed to write response");
            }
            catch (IOException | IllegalStateException exception) {
                // empty catch block
            }
            return false;
        }
    }

    private QDFilter getFilter() {
        QDFilter filter = (QDFilter)this.req.getAttribute(DXFeedContext.FILTER_PARAM);
        return filter != null ? filter : QDFilter.ANYTHING;
    }

    private DXFeed getFeed(QDFilter filter) {
        return DXFeedContext.INSTANCE.getFeed(filter);
    }

    static /* synthetic */ AtomicLong access$500() {
        return REQUEST_ID;
    }

    static {
        ArrayList<PathInfo> pathInfos = new ArrayList<PathInfo>();
        for (Method method : EventsResource.class.getDeclaredMethods()) {
            Path path = method.getAnnotation(Path.class);
            if (path == null) continue;
            pathInfos.add(new PathInfo(method));
        }
        Collections.sort(pathInfos);
        for (PathInfo pathInfo : pathInfos) {
            PATHS.put(pathInfo.path, pathInfo);
        }
        for (Field field : EventsResource.class.getFields()) {
            Param param = field.getAnnotation(Param.class);
            if (param == null) continue;
            String name = param.value();
            PARAMS.put(name, new ParamInfo(name, ParamType.forClass(field.getType()), field.getAnnotation(Description.class).value(), field));
        }
        REQUEST_ID = new AtomicLong();
    }

    private static class EventConnection
    extends SSEConnection
    implements DXFeedEventListener<EventType<?>> {
        private static final long serialVersionUID = 0L;
        private final Map<Class<? extends EventType<?>>, DXFeedSubscription<EventType<?>>> subscriptions = new ConcurrentHashMap();
        private final EventSymbolMap symbolMap = new EventSymbolMap();
        private final QDFilter filter;
        private final DXFeed feed;
        @GuardedBy(value="this")
        private Format format;
        @GuardedBy(value="this")
        private String indent;

        public EventConnection(@Nonnull DXFeed feed, @Nonnull QDFilter filter) {
            this.feed = feed;
            this.filter = filter;
        }

        private synchronized DXFeedSubscription<EventType<?>> createSubSync(Class<? extends EventType<?>> et) {
            DXFeedSubscription sub = this.subscriptions.get(et);
            if (sub != null) {
                return sub;
            }
            sub = new DXFeedSubscription(et);
            sub.addEventListener((DXFeedEventListener)this);
            this.subscriptions.put(et, sub);
            if (this.isActive()) {
                this.feed.attachSubscription(sub);
            }
            return sub;
        }

        public synchronized boolean start(AsyncContext async, Format format, String indent) throws IOException {
            this.format = format;
            this.indent = indent;
            return this.start(async);
        }

        @Override
        @GuardedBy(value="this")
        protected void startImpl() {
            for (DXFeedSubscription<EventType<?>> sub : this.subscriptions.values()) {
                this.feed.attachSubscription(sub);
            }
        }

        @Override
        @GuardedBy(value="this")
        protected void stopImpl() {
            for (DXFeedSubscription<EventType<?>> sub : this.subscriptions.values()) {
                this.feed.detachSubscription(sub);
            }
        }

        @Override
        public void heartbeatImpl() {
            this.writeEvents(Collections.emptyList());
        }

        public void eventsReceived(List<EventType<?>> eventsList) {
            this.writeEvents(eventsList);
        }

        private void writeEvents(List<EventType<?>> eventsList) {
            block6: {
                if (!this.isActive()) {
                    return;
                }
                Events result = new Events();
                result.setStatus(Events.Status.OK);
                result.setEvents(eventsList);
                result.setSymbolMap(this.symbolMap);
                try {
                    if (!this.writeObject(result)) {
                        return;
                    }
                }
                catch (EOFException e) {
                    if (this.stop()) {
                        this.log.info("Stopped, because connection terminated for " + this);
                    }
                }
                catch (IOException e) {
                    if (!this.stop()) break block6;
                    this.log.warn("Stopped, because failed to write events for " + this, (Throwable)e);
                }
            }
        }

        private synchronized boolean writeObject(Events result) throws IOException {
            if (!this.isActive()) {
                return false;
            }
            this.format.writeTo(result, this.out, this.indent);
            this.out.endMessage();
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("event connection #");
            sb.append(this.id);
            sb.append(", filter=");
            sb.append(this.filter);
            sb.append(" [");
            int i = 0;
            for (Map.Entry<Class<EventType<?>>, DXFeedSubscription<EventType<?>>> entry : this.subscriptions.entrySet()) {
                if (i > 0) {
                    sb.append(',');
                }
                ++i;
                sb.append(entry.getKey().getSimpleName());
                sb.append('=');
                sb.append(entry.getValue().getSymbols().size());
            }
            sb.append(']');
            return sb.toString();
        }
    }

    static enum SubOp {
        ADD_SUB,
        REMOVE_SUB;

    }

    private class EventRequestHandler
    implements AsyncListener,
    PromiseHandler<Void> {
        private final long id = EventsResource.access$500().incrementAndGet();
        private final AsyncContext async;
        private final List<Promise<?>> promiseList;
        private final Promise<Void> allPromises;
        private final EventSymbolMap symbolMap;
        private final long timeoutMillis;
        private final AtomicBoolean responded = new AtomicBoolean();

        EventRequestHandler(AsyncContext async, List<Promise<?>> promiseList, Promise<Void> allPromises, EventSymbolMap symbolMap, long timeoutMillis) {
            this.async = async;
            this.promiseList = promiseList;
            this.allPromises = allPromises;
            this.symbolMap = symbolMap;
            this.timeoutMillis = timeoutMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void buildResponse(String reason) {
            if (!this.responded.compareAndSet(false, true)) {
                return;
            }
            try {
                ArrayList eventsList = new ArrayList();
                boolean ok = true;
                for (Promise<?> p : this.promiseList) {
                    Object promiseResult = p.getResult();
                    if (promiseResult instanceof List) {
                        eventsList.addAll((List)promiseResult);
                        continue;
                    }
                    if (promiseResult != null) {
                        eventsList.add((EventType)promiseResult);
                        continue;
                    }
                    ok = false;
                }
                Events result = new Events();
                result.setStatus(ok ? Events.Status.OK : Events.Status.TIMED_OUT);
                result.setEvents(eventsList);
                result.setSymbolMap(this.symbolMap);
                String logRespReason = this + " with " + eventsList.size() + " events (" + (Object)((Object)result.getStatus()) + ") on " + reason;
                if (EventsResource.this.writeResponse(result, logRespReason)) {
                    EventsResource.this.log.info("Sent response for " + logRespReason);
                }
            }
            finally {
                this.async.complete();
            }
        }

        public void promiseDone(Promise<? extends Void> promise) {
            this.buildResponse("done");
        }

        public void onComplete(AsyncEvent event) throws IOException {
            this.allPromises.cancel();
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            try {
                this.buildResponse("timeout");
            }
            finally {
                this.allPromises.cancel();
            }
        }

        public void onError(AsyncEvent event) throws IOException {
            this.allPromises.cancel();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public String toString() {
            return "event request #" + this.id + " [size=" + this.promiseList.size() + ", timeout=" + this.timeoutMillis + "ms]";
        }
    }
}

