/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.comet;

import com.devexperts.annotation.Description;
import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.mars.common.MARSNode;
import com.devexperts.qd.monitoring.MonitoringEndpoint;
import com.dxfeed.webservice.comet.CometDMonitoringMXBean;
import com.dxfeed.webservice.comet.SessionStats;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerSession;

public class CometDMonitoring
implements CometDMonitoringMXBean {
    public static final String STATS_ATTR = "sessionStats";
    public static final String TMP_STATS_ATTR = "tmpSessionStats";
    private static final Logging log = Logging.getLogging(CometDMonitoring.class);
    private String name;
    private BayeuxServer server;
    private volatile boolean detailed;
    private MonitoringEndpoint monitoring;
    private MARSNode sessionsNode;
    private MARSNode readNode;
    private MARSNode writeNode;
    private long startTime;
    private long lastTime;
    private int numSessions;
    private SessionStats totals = new SessionStats();
    private SessionStats currentTotals = new SessionStats();

    public void init(String name, BayeuxServer server, boolean detailed) {
        this.name = name;
        this.server = server;
        this.detailed = detailed;
        this.startTime = this.lastTime = System.currentTimeMillis();
        MARSNode rootNode = MARSNode.getRoot().subNode(name);
        this.sessionsNode = rootNode.subNode("sessions", "Number of sessions");
        this.readNode = rootNode.subNode("read", "Number of received packets");
        this.writeNode = rootNode.subNode("write", "Number of sent packets");
        Management.registerMBean((Object)this, CometDMonitoringMXBean.class, (String)("com.devexperts.qd.monitoring:type=CometD,name=" + name));
        this.monitoring = MonitoringEndpoint.newBuilder().withProperty("name", name).acquire();
        this.monitoring.registerMonitoringTask(() -> {
            long currentTime = System.currentTimeMillis();
            double period = (double)(currentTime - this.lastTime) / 1000.0;
            StringBuilder buff = new StringBuilder();
            this.currentTotals.clear();
            this.collectStatistics(this.currentTotals, buff, period, this.isDetailed(), currentTime);
            this.numSessions = this.currentTotals.numSessions;
            this.sessionsNode.setIntValue(this.numSessions);
            this.readNode.setDoubleValue(SessionStats.getRated(this.totals.read, period));
            this.writeNode.setDoubleValue(SessionStats.getRated(this.totals.write, period));
            this.totals.accumulate(this.currentTotals, true);
            String message = this.totals.getTotalRated(this.numSessions, period) + buff.toString();
            log.info("\b{" + name + "} (total) " + message);
            this.totals.clear();
            this.totals.accumulate(this.currentTotals, false);
            this.lastTime = currentTime;
        });
    }

    public void destroy() {
        this.monitoring.release();
    }

    @Override
    public int getNumSessions() {
        return this.numSessions;
    }

    @Override
    public boolean isDetailed() {
        return this.detailed;
    }

    @Override
    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }

    @Override
    public String dumpAllSessionsAverage() {
        return this.dumpSessionsAverage("id", Integer.MAX_VALUE);
    }

    @Override
    public String dumpSessionsAverage(String sortColumn, int limit) {
        long currentTime = System.currentTimeMillis();
        double period = (double)(currentTime - this.startTime) / 1000.0;
        SessionStats currentTotals = new SessionStats();
        StringBuilder buff = new StringBuilder();
        this.collectStatistics().stream().sorted(SessionStats.getComparator(sortColumn)).limit(limit).forEach(stats -> {
            currentTotals.accumulate((SessionStats)stats, true);
            stats.dumpStats(buff, period, currentTime);
        });
        String message = "sort: " + sortColumn + "; limit: " + (limit != Integer.MAX_VALUE ? Integer.valueOf(limit) : "max") + "; ";
        message = message + currentTotals.getTotalRated(currentTotals.numSessions, period) + buff.toString();
        log.info("\bDump Sessions Average {" + this.name + "} " + message);
        return message;
    }

    @Override
    public String dumpAllSessionsTotal() {
        return this.dumpSessionsTotal("id", Integer.MAX_VALUE);
    }

    @Override
    public String dumpSessionsTotal(String sortColumn, int limit) {
        long currentTime = System.currentTimeMillis();
        double period = 1.0;
        SessionStats currentTotals = new SessionStats();
        StringBuilder buff = new StringBuilder();
        this.collectStatistics().stream().sorted(SessionStats.getComparator(sortColumn)).limit(limit).forEach(stats -> {
            currentTotals.accumulate((SessionStats)stats, true);
            stats.dumpStats(buff, period, currentTime);
        });
        String message = "sort: " + sortColumn + "; limit: " + (limit != Integer.MAX_VALUE ? Integer.valueOf(limit) : "max") + "; ";
        message = message + currentTotals.getTotalRated(1, period) + buff.toString();
        message = message.replaceAll("mps", "msg").replaceAll("pps", "pkt");
        log.info("\bDump Sessions Total {" + this.name + "} " + message);
        return message;
    }

    @Override
    public void terminateSession(@Description(value="Session ID") String sessionId) {
        ServerSession session = this.server.getSession(sessionId);
        SessionStats stats = (SessionStats)session.getAttribute(STATS_ATTR);
        if (stats == null) {
            log.warn("Terminate session '" + sessionId + "': failed, session not found");
            return;
        }
        log.info("Terminate session '" + sessionId + "': ok");
        session.disconnect();
    }

    protected void collectStatistics(SessionStats totalStats, StringBuilder buff, double period, boolean printSessions, long currentTime) {
        this.server.getSessions().forEach(session -> {
            SessionStats stats = (SessionStats)session.getAttribute(STATS_ATTR);
            if (stats == null) {
                return;
            }
            totalStats.accumulate(stats, true);
            if (printSessions) {
                SessionStats sessionTemp = (SessionStats)session.getAttribute(TMP_STATS_ATTR);
                if (sessionTemp == null) {
                    return;
                }
                sessionTemp.accumulate(stats, true);
                sessionTemp.dumpStats(buff, period, currentTime);
                sessionTemp.clear();
                sessionTemp.accumulate(stats, false);
            }
        });
    }

    protected List<SessionStats> collectStatistics() {
        return this.server.getSessions().stream().map(session -> (SessionStats)session.getAttribute(STATS_ATTR)).filter(Objects::nonNull).map(SessionStats::clone).collect(Collectors.toList());
    }
}

