/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.rest;

import com.devexperts.annotation.Description;
import com.dxfeed.webservice.rest.EventsResource;
import com.dxfeed.webservice.rest.HelpOrder;
import com.dxfeed.webservice.rest.Param;
import com.dxfeed.webservice.rest.ParamInfo;
import com.dxfeed.webservice.rest.ParamType;
import com.dxfeed.webservice.rest.Path;
import com.dxfeed.webservice.rest.Secure;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PathInfo
implements Comparable<PathInfo> {
    public final Method method;
    public final String path;
    public final int helpOrder;
    public final String description;
    public final ParamInfo[] args;
    public final int nArgs;
    public final Secure.SecureRole secure;

    public PathInfo(Method method) {
        this.method = method;
        this.path = method.getAnnotation(Path.class).value();
        this.helpOrder = method.getAnnotation(HelpOrder.class).value();
        this.description = method.getAnnotation(Description.class).value();
        this.secure = method.getAnnotation(Secure.class).value();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        this.nArgs = parameterTypes.length;
        this.args = new ParamInfo[this.nArgs];
        for (int i = 0; i < this.nArgs; ++i) {
            Param param = null;
            Description description = null;
            for (Annotation annotation : parameterAnnotations[i]) {
                if (annotation instanceof Param) {
                    param = (Param)annotation;
                }
                if (!(annotation instanceof Description)) continue;
                description = (Description)annotation;
            }
            String paramName = param != null ? param.value() : description.name();
            this.args[i] = new ParamInfo(paramName, ParamType.forClass(parameterTypes[i]), description.value(), null);
        }
    }

    @Override
    public int compareTo(PathInfo o) {
        return this.helpOrder - o.helpOrder;
    }

    public void invokeFor(EventsResource resource) throws InvocationTargetException {
        Object[] values = new Object[this.nArgs];
        for (int i = 0; i < this.nArgs; ++i) {
            values[i] = resource.getRequestValue(this.args[i]);
        }
        try {
            this.method.invoke((Object)resource, values);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

