/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.rest;

import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimePeriod;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public enum ParamType {
    STRING("Any string value."),
    TIME("Date and time in full ISO8601 format \"YYYY-MM-DD'T'HH:MM:SS[.SSS]Z\", or a shorter versions of it like \"YYYYMMDD-HHMMSSZ\"."),
    PERIOD("Time interval in full ISO801 format \"'PT'XXX('S'|'M'|'H')\" or a short version of it without prefix, like \"3s\"."),
    LIST("A list of strings. Multiple values can be specified by using repeated parameters or by giving a comma-separated list of values to a parameter using a name with an additional \"s\" at the end. A standard x-www-form-urlencoded approach using a name with an additional \"s[]\" at the end is also supported. For example, to specify multiple events, use multiple \"event\" parameters, or use \"events\" parameter with a comma-separated list, or use multiple \"events[]\" parameters.");

    public final String description;

    private ParamType(String description) {
        this.description = description;
    }

    public static ParamType forClass(Class<?> c) {
        if (c == String.class) {
            return STRING;
        }
        if (c == Date.class) {
            return TIME;
        }
        if (c == TimePeriod.class) {
            return PERIOD;
        }
        if (c == List.class) {
            return LIST;
        }
        throw new IllegalArgumentException(c.toString());
    }

    public Object getValue(String name, HttpServletRequest req) {
        String value = req.getParameter(name);
        switch (this) {
            case STRING: {
                return value;
            }
            case TIME: {
                return value == null || value.isEmpty() ? null : TimeFormat.DEFAULT.parse(value);
            }
            case PERIOD: {
                return value == null || value.isEmpty() ? null : TimePeriod.valueOf((String)value);
            }
            case LIST: {
                String[] valuesPlain = req.getParameterValues(name);
                String[] valuesArr = req.getParameterValues(name + "s[]");
                String commaSeparated = req.getParameter(name + "s");
                ArrayList<String> result = new ArrayList<String>();
                if (valuesPlain != null) {
                    this.addNonEmpty(valuesPlain, result);
                }
                if (valuesArr != null) {
                    this.addNonEmpty(valuesArr, result);
                }
                if (commaSeparated != null && !commaSeparated.isEmpty()) {
                    this.commaSplit(commaSeparated, result);
                }
                return result;
            }
        }
        throw new AssertionError();
    }

    private void addNonEmpty(String[] a, List<String> result) {
        for (String s : a) {
            if (s == null || s.isEmpty()) continue;
            result.add(s);
        }
    }

    private void commaSplit(String s, List<String> result) {
        int level = 0;
        int prev = 0;
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '{': {
                    ++level;
                    continue block5;
                }
                case '}': {
                    if (level <= 0) continue block5;
                    --level;
                    continue block5;
                }
                case ',': {
                    if (level != 0) continue block5;
                    result.add(s.substring(prev, i));
                    prev = i + 1;
                }
            }
        }
        result.add(s.substring(prev));
    }
}

