/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice.comet;

import com.devexperts.logging.Logging;
import com.devexperts.util.SystemProperties;
import com.dxfeed.webservice.comet.CometReflectionUtil;
import java.util.List;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.websocket.common.AbstractWebSocketEndPoint;
import org.cometd.server.websocket.jetty.JettyWebSocketEndPoint;
import org.cometd.server.websocket.jetty.JettyWebSocketTransport;

public class WebSocketTransportExtension
extends JettyWebSocketTransport {
    private static final Logging log = Logging.getLogging(WebSocketTransportExtension.class);
    private static final int DEFAULT_MAX_FLUSHER_QUEUE_SIZE = 100;
    private static final int MAX_FLUSHER_QUEUE_SIZE = SystemProperties.getIntProperty(WebSocketTransportExtension.class, (String)"maxFlusherQueueSize", (int)100, (int)10, (int)1000000000);
    private static FlusherQueueOverflowHandler overflowHandler;

    public static void setOverflowHandler(FlusherQueueOverflowHandler overflowHandler) {
        if (WebSocketTransportExtension.overflowHandler != null) {
            log.warn("OverflowHandler is already initialized, overwriting it.");
        }
        WebSocketTransportExtension.overflowHandler = overflowHandler;
    }

    public WebSocketTransportExtension(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    protected Object newWebSocketEndPoint(BayeuxContext bayeuxContext) {
        return new EndPointWithQueueCheck(bayeuxContext);
    }

    private class EndPointWithQueueCheck
    extends JettyWebSocketEndPoint {
        private final Object flusher;
        @GuardedBy(value="flusher")
        private final Queue<?> flusherQueue;

        public EndPointWithQueueCheck(BayeuxContext bayeuxContext) {
            super((JettyWebSocketTransport)WebSocketTransportExtension.this, bayeuxContext);
            this.flusher = CometReflectionUtil.extractFlusher((AbstractWebSocketEndPoint)this);
            this.flusherQueue = CometReflectionUtil.extractFlusherQueue((AbstractWebSocketEndPoint)this);
            if (this.flusher == null) {
                throw new IllegalStateException("Flusher instance is null in AbstractWebSocketEndPoint");
            }
            if (this.flusherQueue == null) {
                throw new IllegalStateException("Queue instance is null in Flusher of AbstractWebSocketEndPoint");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleFlusherQueueOverflow() {
            int size;
            if (overflowHandler == null) {
                log.warn("Flusher queue overflow handler is not initialized.");
                return;
            }
            ServerSessionImpl session = CometReflectionUtil.extractSessionInstance((AbstractWebSocketEndPoint)this);
            if (session == null) {
                return;
            }
            Object object = this.flusher;
            synchronized (object) {
                size = this.flusherQueue.size();
            }
            if (size > MAX_FLUSHER_QUEUE_SIZE) {
                overflowHandler.toggleMessageProcessingDelaying(session, true);
                object = this.flusher;
                synchronized (object) {
                    size = this.flusherQueue.size();
                }
            }
            if (size < MAX_FLUSHER_QUEUE_SIZE / 2) {
                overflowHandler.toggleMessageProcessingDelaying(session, false);
            }
        }

        protected void writeComplete(AbstractWebSocketEndPoint.Context context, List<ServerMessage> messages) {
            super.writeComplete(context, messages);
            this.handleFlusherQueueOverflow();
        }

        protected void flush(AbstractWebSocketEndPoint.Context context, Promise<Void> promise) {
            super.flush(context, promise);
            this.handleFlusherQueueOverflow();
        }
    }

    @FunctionalInterface
    public static interface FlusherQueueOverflowHandler {
        public void toggleMessageProcessingDelaying(ServerSessionImpl var1, boolean var2);
    }
}

