/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.webservice;

import com.dxfeed.event.EventType;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.webservice.DataMessageSerializer;
import com.dxfeed.webservice.EventBeanSerializer;
import com.dxfeed.webservice.comet.DataMessage;
import com.dxfeed.webservice.rest.Events;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.util.BeanUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

public class DXFeedJson {
    private static final DataModule DATA_MODULE = new DataModule();
    private static final String[] EMPTY_SORT_ORDER = new String[0];
    private static final EventsIntrospector ANNOTATION_INTROSPECTOR = new EventsIntrospector();
    public static final ObjectMapper MAPPER = DXFeedJson.newMapper(false);
    public static final ObjectMapper MAPPER_INDENT = DXFeedJson.newMapper(true);
    private static final SerializerFactory SER_FACTORY = MAPPER.getSerializerFactory();
    private static final SerializerProvider SER_PROVIDER = ((DefaultSerializerProvider)MAPPER.getSerializerProvider()).createInstance(MAPPER.getSerializationConfig(), SER_FACTORY);

    public static void writeTo(Object result, OutputStream out, String indent) throws IOException {
        DXFeedJson.mapper(indent).writeValue(out, result);
    }

    public static Object readFrom(InputStream in, Class valueType) throws IOException {
        return MAPPER.readValue(in, valueType);
    }

    private static ObjectMapper mapper(String indent) {
        return indent != null ? MAPPER_INDENT : MAPPER;
    }

    public static List<String> getProperties(Class<?> typeClass) throws JsonMappingException {
        ArrayList<String> list = new ArrayList<String>();
        for (BeanPropertyWriter property : DXFeedJson.getProps(typeClass)) {
            list.add(property.getName());
        }
        return list;
    }

    private static BeanPropertyWriter[] getProps(Class<?> typeClass) throws JsonMappingException {
        return new EventBeanSerializer((BeanSerializer)SER_FACTORY.createSerializer(SER_PROVIDER, MAPPER.constructType(typeClass))).getProps();
    }

    private static ObjectMapper newMapper(boolean indent) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DATA_MODULE);
        if (indent) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        mapper.setAnnotationIntrospector((AnnotationIntrospector)ANNOTATION_INTROSPECTOR);
        return mapper;
    }

    private static Map<String, Map<Object, List<EventType<?>>>> toEventsMap(List<EventType<?>> events) {
        TreeMap typeMap = new TreeMap();
        for (EventType<?> event : events) {
            ArrayList list;
            String name = event.getClass().getSimpleName();
            HashMap symbolMap = (HashMap)typeMap.get(name);
            if (symbolMap == null) {
                symbolMap = new HashMap();
                typeMap.put(name, symbolMap);
            }
            if ((list = (ArrayList)symbolMap.get(event.getEventSymbol())) == null) {
                list = new ArrayList();
                symbolMap.put(event.getEventSymbol(), list);
            }
            list.add(event);
        }
        return typeMap;
    }

    static class DoubleSerializer
    extends JsonSerializer<Double> {
        DoubleSerializer() {
        }

        public void serialize(Double value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if ((double)value.longValue() == value) {
                jgen.writeNumber(value.longValue());
            } else {
                jgen.writeNumber(value.doubleValue());
            }
        }
    }

    static class NullSafeCharSerializer
    extends JsonSerializer<Character> {
        NullSafeCharSerializer() {
        }

        public void serialize(Character value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.charValue() == '\u0000' ? "" : value.toString());
        }
    }

    static class EventsSerializer
    extends JsonSerializer<Events> {
        EventsSerializer() {
        }

        public void serialize(Events events, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            Map typeMap = DXFeedJson.toEventsMap(events.getEvents());
            jgen.writeStartObject();
            jgen.writeObjectField("status", (Object)events.getStatus());
            for (Map.Entry typeEntry : typeMap.entrySet()) {
                jgen.writeObjectFieldStart((String)typeEntry.getKey());
                for (Map.Entry symbolEntry : ((Map)typeEntry.getValue()).entrySet()) {
                    boolean array;
                    Object symbolObject = symbolEntry.getKey();
                    String symbolString = events.getSymbolMap().get(symbolObject);
                    List list = (List)symbolEntry.getValue();
                    EventType event0 = (EventType)list.get(0);
                    boolean bl = array = list.size() > 1 || IndexedEvent.class.isInstance(event0);
                    if (array) {
                        jgen.writeArrayFieldStart(symbolString);
                        for (EventType event : list) {
                            jgen.writeObject((Object)event);
                        }
                        jgen.writeEndArray();
                        continue;
                    }
                    jgen.writeObjectField(symbolString, (Object)event0);
                }
                jgen.writeEndObject();
            }
            jgen.writeEndObject();
        }
    }

    static class DataModule
    extends SimpleModule {
        private DataModule() {
            this.addSerializer(Events.class, new EventsSerializer());
            this.addSerializer(DataMessage.class, (JsonSerializer)new DataMessageSerializer());
            this.addSerializer(CandleSymbol.class, (JsonSerializer)new ToStringSerializer());
            this.addSerializer(IndexedEventSource.class, (JsonSerializer)new ToStringSerializer());
            this.addSerializer(Character.TYPE, new NullSafeCharSerializer());
            this.addSerializer(Double.TYPE, new DoubleSerializer());
        }
    }

    static class PropertiesMapper
    extends PropertyNamingStrategy {
        private final Map<Method, String> map = new HashMap<Method, String>();

        PropertiesMapper(AnnotatedClass ac) {
            HashSet<String> removed = new HashSet<String>();
            HashMap<String, String> renamed = new HashMap<String, String>();
            for (AnnotatedMethod am : ac.memberMethods()) {
                String propertyName = this.getDefaultPropertyName(am);
                this.map.put(am.getAnnotated(), propertyName);
                if (removed.contains(propertyName)) continue;
                if (am.getAnnotation(XmlTransient.class) != null) {
                    removed.add(propertyName);
                    continue;
                }
                XmlElement ele = (XmlElement)am.getAnnotation(XmlElement.class);
                if (ele == null || "##default".equals(ele.name())) continue;
                String old = (String)renamed.get(propertyName);
                if (old != null && !old.equals(ele.name())) {
                    throw new IllegalArgumentException("Conflicting names for " + propertyName + ": " + old + " with " + ele.name());
                }
                renamed.put(propertyName, ele.name());
            }
            Iterator<Object> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                String pName = (String)(e = (Map.Entry)iterator.next()).getValue();
                e.setValue(removed.contains(pName) ? pName + "Removed123456" : renamed.getOrDefault(pName, pName));
            }
        }

        private String getDefaultPropertyName(AnnotatedMethod am) {
            String s = BeanUtil.okNameForMutator((AnnotatedMethod)am, (String)"get", (boolean)true);
            if (s == null) {
                s = BeanUtil.okNameForMutator((AnnotatedMethod)am, (String)"is", (boolean)true);
            }
            if (s == null) {
                s = BeanUtil.okNameForMutator((AnnotatedMethod)am, (String)"set", (boolean)true);
            }
            return s != null ? s : am.getName();
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.map.get(method.getAnnotated());
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.map.get(method.getAnnotated());
        }
    }

    static class EventsIntrospector
    extends JacksonAnnotationIntrospector {
        private final Map<Class<?>, PropertiesMapper> names = new ConcurrentHashMap();
        private final Map<Class<?>, String[]> orders = new ConcurrentHashMap();

        EventsIntrospector() {
        }

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            if (m.getAnnotation(XmlTransient.class) != null) {
                return true;
            }
            return super.hasIgnoreMarker(m);
        }

        public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
            String[] result = this.orders.computeIfAbsent(ac.getAnnotated(), clazz -> {
                ArrayList<XmlType> types = new ArrayList<XmlType>(5);
                while (clazz != null) {
                    XmlType type = clazz.getAnnotation(XmlType.class);
                    if (type != null) {
                        types.add(type);
                    }
                    clazz = clazz.getSuperclass();
                }
                Collections.reverse(types);
                String[] order = (String[])types.stream().flatMap(xmlType -> Stream.of(xmlType.propOrder())).map(name -> name.toUpperCase().equals(name) ? name.toLowerCase() : name).toArray(String[]::new);
                return order.length > 0 ? order : EMPTY_SORT_ORDER;
            });
            return result.length > 0 ? result : null;
        }

        public Object findNamingStrategy(AnnotatedClass ac) {
            return this.names.computeIfAbsent(ac.getAnnotated(), clazz -> new PropertiesMapper(ac));
        }
    }
}

