/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.StringCache;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class StringCacheTest {
    private static final String[] randoms = new String[10000];
    private static final String[] collisions;

    @Test
    public void testSpecial() {
        StringCache sc = new StringCache();
        Assert.assertNull((Object)sc.get((String)null, false));
        Assert.assertNull((Object)sc.get((String)null, true));
        Assert.assertNull((Object)sc.get((CharSequence)null));
        Assert.assertNull((Object)sc.get((char[])null));
        Assert.assertNull((Object)sc.getASCII((byte[])null));
        Assert.assertNull((Object)sc.getShortString(0L));
        Assert.assertSame((Object)"", (Object)sc.get(new String(), false));
        Assert.assertSame((Object)"", (Object)sc.get(new String(), true));
        Assert.assertSame((Object)"", (Object)sc.get(new String("01234567890"), 5, 0));
        Assert.assertSame((Object)"", (Object)sc.get((CharSequence)new StringBuilder()));
        Assert.assertSame((Object)"", (Object)sc.get((CharSequence)new StringBuilder("01234567890"), 5, 0));
        Assert.assertSame((Object)"", (Object)sc.get(new char[0]));
        Assert.assertSame((Object)"", (Object)sc.get(new char[10], 5, 0));
        Assert.assertSame((Object)"", (Object)sc.getASCII(new byte[0]));
        Assert.assertSame((Object)"", (Object)sc.getASCII(new byte[10], 5, 0));
        Assert.assertSame((Object)"a", (Object)new StringCache().get("a", false));
        Assert.assertNotSame((Object)"a", (Object)new StringCache().get("a", true));
    }

    @Test
    public void testPerformance() {
        int count = 4000;
        int repeat = 10;
        this.performanceTest(1, 1, count, repeat);
        this.performanceTest(1, 2, count, repeat);
        this.performanceTest(1, 4, count, repeat);
        this.performanceTest(1, 8, count, repeat);
        this.performanceTest(997, 1, count, repeat);
        this.performanceTest(997, 2, count, repeat);
        this.performanceTest(997, 4, count, repeat);
        this.performanceTest(997, 8, count, repeat);
        this.performanceTest(1994, 1, count, repeat);
        this.performanceTest(1994, 2, count, repeat);
        this.performanceTest(1994, 4, count, repeat);
        this.performanceTest(3988, 1, count, repeat);
        this.performanceTest(3988, 2, count, repeat);
        this.performanceTest(7976, 1, count, repeat);
    }

    public void performanceTest(int number, int size, int count, int repeat) {
        count = Math.min(count, randoms.length);
        StringCache sc = new StringCache(number, size);
        long time = System.currentTimeMillis();
        for (int n = 0; n < repeat; ++n) {
            for (int i = 0; i < count; ++i) {
                Assert.assertEquals((Object)sc.get(randoms[i], false), (Object)randoms[i]);
            }
        }
        System.out.println("Performance [" + number + ", " + size + ", " + count + ", " + repeat + "] = " + (long)(count * repeat) * 1000L / Math.max(System.currentTimeMillis() - time, 1L) + " ops in " + (System.currentTimeMillis() - time) + " ms = " + sc);
    }

    @Test
    public void testAccess() {
        this.accessTest(1, 1, 10000);
        this.accessTest(1, 4, 10000);
        this.accessTest(997, 1, 10000);
        this.accessTest(997, 4, 10000);
    }

    public void accessTest(int number, int size, int count) {
        count = Math.min(count, randoms.length);
        StringCache sc1 = new StringCache(number, size);
        StringCache sc2 = new StringCache(number, size);
        StringCache sc3 = new StringCache(number, size);
        StringCache sc4 = new StringCache(number, size);
        StringCache sc5 = new StringCache(number, size);
        Random r = new Random(0L);
        byte[] b = new byte[100];
        char[] c = new char[b.length];
        for (int i = 0; i < count; ++i) {
            String s = randoms[i];
            Assert.assertEquals((Object)sc1.get(s, false), (Object)s);
            Assert.assertEquals((Object)sc2.get((CharSequence)new StringBuilder(s)), (Object)s);
            int length = s.length();
            int offset = r.nextInt((b.length - length) / 2);
            s.getChars(0, length, c, offset);
            Assert.assertEquals((Object)sc3.get(c, offset, length), (Object)s);
            for (int j = 0; j < length; ++j) {
                b[offset + j] = (byte)c[offset + j];
                int n = offset + j;
                c[n] = (char)(c[n] & 0x7F);
            }
            Assert.assertEquals((Object)sc4.getASCII(b, offset, length), (Object)new String(c, offset, length));
            long code = 0L;
            int k = 0;
            for (int j = 0; j < Math.min(length, 8); ++j) {
                char cc = (char)(s.charAt(j) & 0xFF);
                code = code << 8 | (long)cc;
                if (cc == '\u0000') continue;
                c[k++] = cc;
            }
            Assert.assertEquals((Object)sc5.getShortString(code), (Object)(k == 0 ? null : new String(c, 0, k)));
        }
    }

    @Test
    public void testCaching() {
        for (int k = 1; k < collisions.length; ++k) {
            int i;
            StringCache sc = new StringCache(997, k);
            for (i = 0; i < k; ++i) {
                Assert.assertSame((Object)collisions[i], (Object)sc.get(collisions[i], false));
            }
            for (i = 0; i < 1000; ++i) {
                Assert.assertSame((Object)collisions[i % k], (Object)sc.get(new String(collisions[i % k]), false));
            }
        }
    }

    @Test
    public void testLeastRecentlyUsed() {
        for (int k = 1; k < collisions.length - 1; ++k) {
            int i;
            StringCache sc = new StringCache(997, k);
            for (i = 0; i < k; ++i) {
                Assert.assertSame((Object)collisions[i], (Object)sc.get(collisions[i], false));
            }
            Assert.assertSame((Object)collisions[k], (Object)sc.get(collisions[k], false));
            for (i = 1; i < k; ++i) {
                Assert.assertSame((Object)collisions[i], (Object)sc.get(new String(collisions[i]), false));
            }
            Assert.assertNotSame((Object)collisions[0], (Object)sc.get(new String(collisions[0]), false));
        }
    }

    static {
        Random r = new Random(0L);
        char[] c = new char[64];
        for (int i = 0; i < randoms.length; ++i) {
            int length = r.nextInt(c.length);
            for (int j = 0; j < length; ++j) {
                c[j] = (char)r.nextInt(2048);
            }
            StringCacheTest.randoms[i] = new String(c, 0, length);
        }
        collisions = new String[]{"aaaaaaaaaa", "aaaaaaaabB", "aaaaaaabBa", "aaaaaabBaa", "aaaaabBaaa", "aaaabBaaaa", "aaabBaaaaa", "aabBaaaaaa", "abBaaaaaaa", "bBaaaaaaaa"};
    }
}

