/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.InvalidFormatException;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimePeriod;
import com.devexperts.util.TimeUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;

public class TimeFormatTest {
    private final TimeFormat GMT = TimeFormat.GMT;
    private final TimeFormat MSK = TimeFormat.getInstance((TimeZone)TimeUtil.getTimeZone((String)"GMT+03:00"));

    @Test
    public void testZoneStability() {
        Assert.assertEquals((long)1197450000000L, (long)this.GMT.parse("2007-12-12T12+0300").getTime());
        Assert.assertEquals((Object)"20140618-130218+0000", (Object)this.GMT.withTimeZone().format(new Date(1403096538000L)));
    }

    @Test
    public void testTimePeriods() throws InvalidFormatException {
        Assert.assertEquals((long)0L, (long)TimePeriod.valueOf((String)"0").getTime());
        Assert.assertEquals((long)1000L, (long)TimePeriod.valueOf((String)"1s").getTime());
        Assert.assertEquals((long)123L, (long)TimePeriod.valueOf((String)".123456789").getTime());
        Assert.assertEquals((Object)"PT1.235S", (Object)TimePeriod.valueOf((String)"1.23456789").toString());
        Assert.assertEquals((Object)TimePeriod.valueOf((String)"1.23456789"), (Object)TimePeriod.valueOf((String)"0d0h0m1.235s"));
    }

    @Test
    public void testEqualTimePeriods() throws InvalidFormatException {
        ArrayList<TimePeriod> equalPeriods = new ArrayList<TimePeriod>();
        equalPeriods.add(TimePeriod.valueOf((long)873000000L));
        equalPeriods.add(TimePeriod.valueOf((String)Long.valueOf(873000L).toString()));
        equalPeriods.add(TimePeriod.valueOf((String)"P10DT2H30M"));
        equalPeriods.add(TimePeriod.valueOf((String)"10DT2H29M60.00"));
        equalPeriods.add(TimePeriod.valueOf((String)"p10DT1H90M"));
        equalPeriods.add(TimePeriod.valueOf((String)"9DT26H1800S"));
        equalPeriods.add(TimePeriod.valueOf((String)"P10DT2H30M.0"));
        equalPeriods.add(TimePeriod.valueOf((String)"p10d2H29m59.9995s"));
        this.assertPeriodsAreEqual(equalPeriods, "P10DT2H30M0S");
    }

    @Test
    public void testBadTimePeriods() {
        String[] badValues;
        for (String s : badValues = new String[]{"t1d", "p", "", "P2D3T", "P10DT2H30MS", ".", "p1mt", "239e-3", " PT1S", "pt1s2m", "PT1s ", "239ss", "t1,5s", "1,5"}) {
            try {
                TimePeriod.valueOf((String)s);
                Assert.fail((String)("Parsed bad value: " + s));
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGoodTimePeriods() {
        String[] goodValues;
        for (String s : goodValues = new String[]{"P1234DT12H30M0S", "p1", "t239", "PT0S", "1.5", "436243.2346235275477676256255256", "1m", "2h", "3d", "1h2s", "p1dt"}) {
            try {
                TimePeriod.valueOf((String)s);
            }
            catch (InvalidFormatException e) {
                Assert.fail((String)("Couldn't parse: " + s));
            }
        }
    }

    @Test
    public void testEqualDateTimes1() {
        this.assertEqual(this.GMT.parse("20071114-170523"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.GMT.parse("2007-11-14 17:05:23"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("20071114-200523+0300"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("20071114-170523 GMT"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.GMT.parse("20071114 060523-1100"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("20071115t000523GMT+07:00"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.GMT.parse("2007-11-14T060523-1100"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("20071114-12:05:23GMT-05:00"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("2007-11-14T12:05:23.000-05"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("2007-11-14T12:05:23.000-05:00"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("2007-11-14T17:05:23Z"), "20071114-170523+0000", this.GMT);
        this.assertEqual(this.MSK.parse("1195059923000"), "20071114-170523+0000", this.GMT);
    }

    @Test
    public void testEqualDateTimes2() {
        this.assertEqual(this.GMT.parse("20060101"), "20060101-000000+0000", this.GMT);
        this.assertEqual(this.GMT.parse("2006-01-01"), "20060101-000000+0000", this.GMT);
        this.assertEqual(this.GMT.parse("2006-01-01 00:00:00"), "20060101-000000+0000", this.GMT);
        this.assertEqual(this.MSK.parse("2006-01-01-03:00:00+0300"), "20060101-000000+0000", this.GMT);
        this.assertEqual(this.GMT.parse("2005-12-31T24:00:00"), "20060101-000000+0000", this.GMT);
        this.assertEqual(this.MSK.parse("2005-12-31 24:00:00GMT"), "20060101-000000+0000", this.GMT);
        this.assertEqual(this.MSK.parse("20051231t190000GMT-05:00"), "20060101-000000+0000", this.GMT);
        this.assertEqual(this.GMT.parse("1136073600000"), "20060101-000000+0000", this.GMT);
    }

    @Test
    public void testEqualDateTimes3() {
        Date parsedToday = this.MSK.parse("t12:34:56");
        Calendar today = Calendar.getInstance(this.MSK.getTimeZone());
        today.setTime(parsedToday);
        Assert.assertEquals((long)12L, (long)today.get(11));
        Assert.assertEquals((long)34L, (long)today.get(12));
        Assert.assertEquals((long)56L, (long)today.get(13));
        this.assertEqual(parsedToday, this.MSK.withTimeZone().format(today.getTime()), this.MSK);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        df.setTimeZone(this.MSK.getTimeZone());
        String curDateInMSK = df.format(new Date());
        this.assertEqual(this.GMT.parse(curDateInMSK + "-123456+0300"), this.MSK.withTimeZone().format(today.getTime()), this.MSK);
        this.assertEqual(this.GMT.parse(curDateInMSK + "T12:34:56+0300"), this.MSK.withTimeZone().format(today.getTime()), this.MSK);
    }

    @Test
    public void testBadDateTimes() {
        String[] badValues;
        for (String s : badValues = new String[]{"2007-1102-12:34:56", "20070101-1234:56", "200711-02-12:34", "t12:34:5", "12:3456", "1234:56", "2008-1-10", "2004-12-12t", "2005-12-31 210", "-P10DT2H30MS", "1234567", "20010101t", "t1234567", "-", "", "1", "t12::34:56", "t12:", "123", "T", "P1234DT12H30M0S"}) {
            try {
                this.GMT.parse(s);
                Assert.fail((String)("Parsed bad value: " + s));
            }
            catch (InvalidFormatException invalidFormatException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGoodDateTimes() {
        String[] goodValues;
        for (String s : goodValues = new String[]{"2007-11-02-12:34:56", "20070101-123456", "2007-11-02-123456", "t12:34:56", "2005-12-31 21:00:00", "2007-11-02", "2007-12-12t123456", "20071212-12:34", "2007-12-12T12MSK", "20000101 2200", "01:01", "12:12:12 +0300", "-123456", "12", "1234", "123456", "20010101", "123456789", "12+1200", "1234+1234", "-P1234DT12H30M0S"}) {
            try {
                this.GMT.parse(s);
            }
            catch (InvalidFormatException e) {
                Assert.fail((String)("Couldn't parse: " + s));
            }
        }
    }

    @Test
    public void testDateAsLong() {
        Date a1 = this.GMT.parse("20010101");
        Date a2 = this.GMT.parse("2001-01-01");
        Assert.assertEquals((Object)a1, (Object)a2);
        Date b1 = this.GMT.parse("121212");
        Date b2 = this.GMT.parse("T12:12:12");
        Assert.assertEquals((Object)b1, (Object)b2);
        Date c1 = this.GMT.parse("1234567890");
        Date c2 = new Date(1234567890L);
        Assert.assertEquals((Object)c1, (Object)c2);
    }

    @Test
    public void testNPE() {
        Assert.assertThrows((String)"NPE expected", NullPointerException.class, () -> this.GMT.parse(null));
        Assert.assertThrows((String)"NPE expected", NullPointerException.class, () -> TimePeriod.valueOf(null));
        Assert.assertThrows((String)"NPE expected", NullPointerException.class, () -> ((TimePeriod)null).toString());
        Assert.assertThrows((String)"NPE expected", NullPointerException.class, () -> this.GMT.format(null));
        Assert.assertThrows((String)"NPE expected", NullPointerException.class, () -> this.GMT.withTimeZone().format(null));
    }

    @Test
    public void testNoTimeZoneFormat() {
        Date d1 = new Date();
        String s = TimeFormat.DEFAULT.format(d1);
        s = s + TimeZone.getDefault().getDisplayName(TimeZone.getDefault().inDaylightTime(d1), 0);
        Date d2 = this.GMT.parse(s);
        Assert.assertEquals((Object)this.GMT.withTimeZone().format(d1), (Object)this.GMT.withTimeZone().format(d2));
    }

    @Test
    public void testDateOutsideIsoRangeFormat() {
        Date d1 = new Date(Long.MIN_VALUE);
        Assert.assertEquals((Object)Long.toString(Long.MIN_VALUE), (Object)TimeFormat.GMT.format(d1));
        Date d2 = new Date(Long.MAX_VALUE);
        Assert.assertEquals((Object)Long.toString(Long.MAX_VALUE), (Object)TimeFormat.GMT.format(d2));
        Date d3 = new Date(371085174374400000L);
        Assert.assertEquals((Object)Long.toString(d3.getTime()), (Object)TimeFormat.GMT.format(d3));
    }

    @Test
    public void testIsoFormat() {
        this.assertEqual(TimeFormat.GMT.parse("2002-05-30T09:30:10-06:00"), "20020530-153010+0000", TimeFormat.GMT);
        this.assertEqual(TimeFormat.GMT.parse("2002-05-30T09:30:10+06:00"), "20020530-033010+0000", TimeFormat.GMT);
        this.assertEqual(TimeFormat.GMT.parse("2002-05-30T09:30:10Z"), "20020530-093010+0000", TimeFormat.GMT);
        Assert.assertEquals((Object)"2002-05-30T09:30:10.000-06:00", (Object)TimeFormat.getInstance((TimeZone)TimeUtil.getTimeZone((String)"GMT-06:00")).asFullIso().format(TimeFormat.GMT.parse("20020530-153010")));
        Assert.assertEquals((Object)"2002-05-30T09:30:10.000+06:00", (Object)TimeFormat.getInstance((TimeZone)TimeUtil.getTimeZone((String)"GMT+06:00")).asFullIso().format(TimeFormat.GMT.parse("20020530-033010")));
        Assert.assertEquals((Object)"2002-05-30T09:30:10.000Z", (Object)TimeFormat.GMT.asFullIso().format(TimeFormat.GMT.parse("20020530-093010")));
    }

    private void assertEqual(Date d, String canonicalValue, TimeFormat format) {
        Assert.assertEquals((Object)canonicalValue, (Object)format.withTimeZone().format(d));
    }

    private void assertPeriodsAreEqual(List<TimePeriod> equalPeriods, String canonicalValue) {
        for (TimePeriod t : equalPeriods) {
            Assert.assertEquals((Object)canonicalValue, (Object)t.toString());
        }
    }

    @Test
    public void testTimeWithoutTimeZone() {
        TimeFormat MSD = TimeFormat.getInstance((TimeZone)TimeUtil.getTimeZone((String)"Europe/Moscow"));
        Date withoutTZ = MSD.parse("20120406-182355");
        Assert.assertEquals((Object)MSD.parse("20120406-182355+0400"), (Object)withoutTZ);
    }

    @Test
    public void testTimeWithMillis() {
        TimeFormat MSD = TimeFormat.getInstance((TimeZone)TimeUtil.getTimeZone((String)"Europe/Moscow"));
        Assert.assertEquals((long)1333737666231L, (long)MSD.parse("20120406-224106.231").getTime());
        Assert.assertEquals((long)1333737666231L, (long)MSD.parse("20120406-224106.231+0400").getTime());
    }

    @Test
    public void testZero() {
        Assert.assertEquals((long)0L, (long)this.GMT.parse("0").getTime());
        Assert.assertEquals((Object)"0", (Object)this.GMT.withTimeZone().format(new Date(0L)));
        Assert.assertEquals((Object)"0", (Object)this.GMT.withMillis().format(new Date(0L)));
        Assert.assertEquals((Object)"0", (Object)this.GMT.withTimeZone().withMillis().format(new Date(0L)));
        Assert.assertEquals((Object)"0", (Object)this.GMT.format(new Date(0L)));
    }

    @Test
    public void testEquivalence() throws ParseException {
        for (String tzName : "GMT,GMT+01:30,GMT-01:30,Europe/Moscow,America/Chicago".split(",")) {
            TimeZone tz = TimeUtil.getTimeZone((String)tzName);
            TimeFormat format = TimeFormat.getInstance((TimeZone)tz);
            Assert.assertSame((Object)format.withMillis().withTimeZone(), (Object)format.withTimeZone().withMillis());
            Assert.assertSame((Object)format.asFullIso(), (Object)format.withMillis().asFullIso());
            Assert.assertSame((Object)format.asFullIso(), (Object)format.withTimeZone().asFullIso());
            Assert.assertSame((Object)format.asFullIso(), (Object)format.withMillis().withTimeZone().asFullIso());
            this.doTestEquivalence(format, "yyyyMMdd-HHmmss", false);
            this.doTestEquivalence(format.withMillis(), "yyyyMMdd-HHmmss.SSS", true);
            this.doTestEquivalence(format.withTimeZone(), "yyyyMMdd-HHmmssZ", false);
            this.doTestEquivalence(format.withMillis().withTimeZone(), "yyyyMMdd-HHmmss.SSSZ", true);
            this.doTestEquivalence(format.asFullIso(), "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", true);
        }
    }

    private void doTestEquivalence(TimeFormat format, String pattern, boolean withMillis) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        TimeZone tz = format.getTimeZone();
        sdf.setTimeZone(tz);
        Random random = new Random(20170608L);
        for (int i = 0; i < 1000; ++i) {
            long expected = random.nextLong() >> 20;
            if (!withMillis) {
                expected = (expected >> 10) * 1000L;
            }
            this.checkConversionEquivalence(format, pattern, sdf, tz, expected);
        }
    }

    @Test
    public void testDSTEquivalence() throws ParseException {
        TimeZone chicagoTz = TimeUtil.getTimeZone((String)"America/Chicago");
        TimeFormat format = TimeFormat.getInstance((TimeZone)chicagoTz);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        sdf.setTimeZone(chicagoTz);
        Assert.assertSame((Object)format.withMillis().withTimeZone(), (Object)format.withTimeZone().withMillis());
        Assert.assertSame((Object)format.asFullIso(), (Object)format.withMillis().asFullIso());
        Assert.assertSame((Object)format.asFullIso(), (Object)format.withTimeZone().asFullIso());
        Assert.assertSame((Object)format.asFullIso(), (Object)format.withMillis().withTimeZone().asFullIso());
        long begin = sdf.parse("20200307-230000").getTime();
        long end = sdf.parse("20200308-040000").getTime();
        Assert.assertTrue((chicagoTz.getOffset(begin) != chicagoTz.getOffset(end) ? 1 : 0) != 0);
        int step = 30000;
        this.checkEquivalenceOnRange(format, "yyyyMMdd-HHmmss", false, begin, end, step);
        this.checkEquivalenceOnRange(format.withMillis(), "yyyyMMdd-HHmmss.SSS", true, begin, end, step);
        this.checkEquivalenceOnRange(format.withTimeZone(), "yyyyMMdd-HHmmssZ", false, begin, end, step);
        this.checkEquivalenceOnRange(format.withMillis().withTimeZone(), "yyyyMMdd-HHmmss.SSSZ", true, begin, end, step);
        this.checkEquivalenceOnRange(format.asFullIso(), "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", true, begin, end, step);
        begin = sdf.parse("20201101-000000").getTime();
        end = sdf.parse("20201101-040000").getTime();
        Assert.assertTrue((chicagoTz.getOffset(begin) != chicagoTz.getOffset(end) ? 1 : 0) != 0);
        this.checkEquivalenceOnRange(format, "yyyyMMdd-HHmmss", false, begin, end, step);
        this.checkEquivalenceOnRange(format.withMillis(), "yyyyMMdd-HHmmss.SSS", true, begin, end, step);
        this.checkEquivalenceOnRange(format.withTimeZone(), "yyyyMMdd-HHmmssZ", false, begin, end, step);
        this.checkEquivalenceOnRange(format.withMillis().withTimeZone(), "yyyyMMdd-HHmmss.SSSZ", true, begin, end, step);
        this.checkEquivalenceOnRange(format.asFullIso(), "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", true, begin, end, step);
    }

    @Test
    public void testWeirdOffset() throws ParseException {
        TimeZone moscowTz = TimeUtil.getTimeZone((String)"Europe/Moscow");
        TimeFormat format = TimeFormat.getInstance((TimeZone)moscowTz);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
        sdf.setTimeZone(moscowTz);
        long begin = sdf.parse("19190701-000000").getTime();
        Assert.assertNotEquals((long)0L, (long)(moscowTz.getOffset(begin) % 60000));
        long end = sdf.parse("19190701-040000").getTime();
        Assert.assertEquals((long)0L, (long)(moscowTz.getOffset(end) % 60000));
        int step = 5000;
        this.checkEquivalenceOnRange(format, "yyyyMMdd-HHmmss", false, begin, end, step);
        this.checkEquivalenceOnRange(format.withMillis(), "yyyyMMdd-HHmmss.SSS", true, begin, end, step);
        this.checkEquivalenceOnRange(format.withTimeZone(), "yyyyMMdd-HHmmssZ", false, begin, end, step);
        this.checkEquivalenceOnRange(format.withMillis().withTimeZone(), "yyyyMMdd-HHmmss.SSSZ", true, begin, end, step);
        this.checkEquivalenceOnRange(format.asFullIso(), "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", true, begin, end, step);
    }

    private void checkEquivalenceOnRange(TimeFormat format, String pattern, boolean withMillis, long begin, long end, long step) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        TimeZone tz = format.getTimeZone();
        sdf.setTimeZone(tz);
        long expected = begin;
        if (withMillis) {
            expected += (long)(100 + ThreadLocalRandom.current().nextInt(900));
        }
        while (expected < end) {
            this.checkConversionEquivalence(format, pattern, sdf, tz, expected);
            expected += step;
        }
    }

    private void checkConversionEquivalence(TimeFormat format, String pattern, SimpleDateFormat sdf, TimeZone tz, long expected) throws ParseException {
        String canonical = sdf.format(expected);
        long reversed = sdf.parse(canonical).getTime();
        Assert.assertEquals((Object)canonical, (Object)format.format(expected));
        Assert.assertEquals((Object)canonical, (Object)format.format(new Date(expected)));
        Assert.assertEquals((long)reversed, (long)format.parse(canonical).getTime());
        if (expected != reversed && tz.getOffset(expected) % 60000 == 0 && tz.getOffset(expected) == tz.getOffset(reversed)) {
            Assert.fail((String)String.format("Reversed time differ from original time - \nExpected %d = %s = %s, offset %d\nReversed %d = %s = %s, offset %d\nPattern %s, time zone %s", expected, sdf.format(expected), format.format(expected), tz.getOffset(expected), reversed, sdf.format(reversed), format.format(reversed), tz.getOffset(reversed), pattern, tz));
        }
    }
}

