/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.TypedKey;
import com.devexperts.util.TypedMap;
import org.junit.Assert;
import org.junit.Test;

public class TypedMapTest {
    private static final TypedKey<Boolean> KEY1 = new TypedKey("toBe");
    private static final TypedKey<Boolean> KEY2 = new TypedKey("notToBe");
    private static final TypedKey<Boolean> TRUE_KEY = new TypedKey("key");
    private static final TypedKey<Boolean> FALSE_KEY = new TypedKey("key");
    private static final TypedKey<Boolean> UNNAMED_KEY = new TypedKey();

    @Test
    public void testNamedKeysToString() {
        TypedMap map = new TypedMap();
        map.set(KEY1, (Object)true);
        map.set(KEY2, (Object)false);
        Assert.assertTrue((boolean)map.toString().contains("toBe=true"));
        Assert.assertTrue((boolean)map.toString().contains("notToBe=false"));
    }

    @Test
    public void testSameNamedKeysString() {
        TypedMap map = new TypedMap();
        map.set(TRUE_KEY, (Object)true);
        map.set(FALSE_KEY, (Object)false);
        Assert.assertTrue((boolean)((Boolean)map.get(TRUE_KEY)));
        Assert.assertFalse((boolean)((Boolean)map.get(FALSE_KEY)));
        Assert.assertTrue((boolean)map.toString().contains("key=true"));
        Assert.assertTrue((boolean)map.toString().contains("key=false"));
    }

    @Test
    public void testUnnamedKeysString() {
        TypedMap map = new TypedMap();
        map.set(UNNAMED_KEY, (Object)true);
        Assert.assertTrue((boolean)map.toString().matches("\\{" + this.getClass().getName() + ".*=true\\}"));
    }
}

