/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedInputPart;
import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkedInput;
import com.devexperts.io.StreamInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class BufferedInputMarkTest {
    private static final int SIZE = 17;

    private ByteArrayInput createByteArrayInput() {
        byte[] bytes = new byte[17];
        for (int i = 0; i < 17; ++i) {
            bytes[i] = (byte)i;
        }
        ByteArrayInput in = new ByteArrayInput(bytes);
        return in;
    }

    @Test
    public void testByteArrayInput() throws IOException {
        ByteArrayInput in = this.createByteArrayInput();
        this.check((BufferedInput)in);
    }

    @Test
    public void testByteArrayInputPart() throws IOException {
        ByteArrayInput in = this.createByteArrayInput();
        in.mark();
        BufferedInputPart part = new BufferedInputPart();
        part.setInput((BufferedInput)in, 17L);
        this.check((BufferedInput)part);
    }

    @Test
    public void testByteArrayInputPart2() throws IOException {
        ByteArrayInput in = this.createByteArrayInput();
        in.mark();
        BufferedInputPart part = new BufferedInputPart();
        part.setInput((BufferedInput)in, 17L);
        part.mark();
        BufferedInputPart part2 = new BufferedInputPart();
        part2.setInput((BufferedInput)part, 17L);
        this.check((BufferedInput)part2);
    }

    @Test
    public void testStreamInput() throws IOException {
        ByteArrayInput in = this.createByteArrayInput();
        StreamInput sin = new StreamInput((InputStream)in);
        this.check((BufferedInput)sin);
    }

    @Test
    public void testStreamInputPart() throws IOException {
        ByteArrayInput in = this.createByteArrayInput();
        StreamInput sin = new StreamInput((InputStream)in);
        sin.mark();
        BufferedInputPart part = new BufferedInputPart();
        part.setInput((BufferedInput)sin, 17L);
        this.check((BufferedInput)part);
    }

    @Test
    public void testChunkedInputPart() throws IOException {
        Random r = new Random(20100213L);
        for (int repeat = 0; repeat < 20; ++repeat) {
            int length;
            int pre = r.nextInt(6);
            int post = r.nextInt(6);
            byte[] bytes = new byte[pre + 17 + post];
            for (int i = 0; i < 17; ++i) {
                bytes[i + pre] = (byte)i;
            }
            ChunkedInput in = new ChunkedInput();
            for (int offset = 0; offset < bytes.length; offset += length) {
                length = Math.min(r.nextInt(3) + 1, bytes.length - offset);
                Chunk chunk = Chunk.wrap((byte[])bytes, (int)offset, (int)length, (Object)this);
                in.addToInput(chunk, (Object)this);
            }
            Assert.assertEquals((long)pre, (long)in.skip((long)pre));
            in.mark();
            BufferedInputPart part = new BufferedInputPart();
            part.setInput((BufferedInput)in, 17L);
            this.check((BufferedInput)part);
        }
    }

    private void check(BufferedInput in) throws IOException {
        in.mark();
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)1L, (long)in.read());
        Assert.assertEquals((long)2L, (long)in.read());
        in.reset();
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)1L, (long)in.read());
        Assert.assertEquals((long)2L, (long)in.read());
        in.mark();
        Assert.assertEquals((long)3L, (long)in.read());
        Assert.assertEquals((long)4L, (long)in.read());
        Assert.assertEquals((long)5L, (long)in.read());
        in.rewind(2L);
        Assert.assertEquals((long)4L, (long)in.read());
        Assert.assertEquals((long)5L, (long)in.read());
        Assert.assertEquals((long)6L, (long)in.read());
        Assert.assertEquals((long)7L, (long)in.read());
        in.reset();
        Assert.assertEquals((long)3L, (long)in.read());
        Assert.assertEquals((long)4L, (long)in.read());
        Assert.assertEquals((long)5L, (long)in.read());
        in.mark();
        Assert.assertEquals((long)6L, (long)in.read());
        Assert.assertEquals((long)7L, (long)in.read());
        Assert.assertEquals((long)8L, (long)in.read());
        Assert.assertEquals((long)9L, (long)in.read());
        in.rewind(4L);
        Assert.assertEquals((long)6L, (long)in.read());
        Assert.assertEquals((long)7L, (long)in.read());
        Assert.assertEquals((long)8L, (long)in.read());
        in.rewind(1L);
        Assert.assertEquals((long)8L, (long)in.read());
        Assert.assertEquals((long)9L, (long)in.read());
        in.unmark();
        Assert.assertEquals((long)10L, (long)in.read());
        Assert.assertEquals((long)11L, (long)in.read());
        in.mark();
        Assert.assertEquals((long)12L, (long)in.read());
        Assert.assertEquals((long)13L, (long)in.read());
        in.mark();
        Assert.assertEquals((long)14L, (long)in.read());
        Assert.assertEquals((long)15L, (long)in.read());
        in.reset();
        Assert.assertEquals((long)14L, (long)in.read());
        Assert.assertEquals((long)15L, (long)in.read());
        Assert.assertEquals((long)16L, (long)in.read());
    }
}

