/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedInputPart;
import com.devexperts.io.ByteArrayInput;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class BufferedInputPartTest {
    private static final int SIZE = 127;

    private ByteArrayInput createByteArrayInput() {
        byte[] bytes = new byte[127];
        for (int i = 0; i < 127; ++i) {
            bytes[i] = (byte)i;
        }
        return new ByteArrayInput(bytes);
    }

    @Test
    public void testReadByteBufferLimitOverflow() throws IOException {
        ByteArrayInput in = this.createByteArrayInput();
        BufferedInputPart bip = new BufferedInputPart();
        this.doTestReadByteOverflow(in, bip, 0);
        this.doTestReadByteOverflow(in, bip, 63);
    }

    private void doTestReadByteOverflow(ByteArrayInput in, BufferedInputPart bip, int pos) throws IOException {
        in.setPosition(pos);
        in.mark();
        bip.setInput((BufferedInput)in, 2L);
        this.readBytesByOne(bip, pos, 2);
        Assert.assertThrows(IOException.class, () -> this.readBytesByOne(bip, pos + 1, 1));
    }

    @Test
    public void testReadBufferLimitOverflow() throws IOException {
        ByteArrayInput in = this.createByteArrayInput();
        BufferedInputPart bip = new BufferedInputPart();
        this.doTestReadOverflow(in, bip, 0);
        this.doTestReadOverflow(in, bip, 63);
    }

    private void doTestReadOverflow(ByteArrayInput in, BufferedInputPart bip, int pos) throws IOException {
        in.setPosition(pos);
        in.mark();
        bip.setInput((BufferedInput)in, 10L);
        this.readBytes(bip, pos, 5, 5);
        this.readBytes(bip, pos + 5, 10, 5);
        this.readBytes(bip, pos + 10, 10, -1);
    }

    private void readBytesByOne(BufferedInputPart bip, int base, int count) throws IOException {
        for (int i = base; i < base + count; ++i) {
            Assert.assertEquals((long)((byte)i), (long)bip.readByte());
        }
    }

    private void readBytes(BufferedInputPart bip, int base, int count, int expected) throws IOException {
        byte[] buf = new byte[count];
        int n = bip.read(buf);
        Assert.assertEquals((long)expected, (long)n);
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((long)((byte)(i + base)), (long)buf[i]);
        }
    }
}

