/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.IndexedMap;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.Indexer;
import com.devexperts.util.IndexerFunction;
import com.devexperts.util.SynchronizedIndexedSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class IndexedSetTest {
    private static final IndexerFunction<String, Integer> STRING_INTEGER_INDEXER = Object::toString;
    private static final IndexerFunction.LongKey<String> LONG_STRING_INDEXER = Long::valueOf;
    private static final IndexerFunction.IdentityKey<String, String> STRING_IDENTITY_INDEXER = String::toString;
    static final IndexerFunction<String, StrItem> STR_ITEM_INDEXER = (IndexerFunction & Serializable)t -> t.val;
    static final IndexerFunction<StrItem, StrItem> STR_ITEM_WEIRD_INDEXER = new IndexerFunction<StrItem, StrItem>(){

        public StrItem getObjectKey(StrItem t) {
            return t;
        }

        public int hashCodeByKey(StrItem key) {
            return key == null || key.val == null ? 0 : key.val.hashCode();
        }

        public boolean matchesByKey(StrItem key, StrItem value) {
            return key == null || key.val == null ? this.getObjectKey((StrItem)value).val == null : key.val.equals(this.getObjectKey((StrItem)value).val);
        }
    };

    @Test
    public void testIndexerFunction() {
        IndexedSet set = IndexedSet.create(Object::getClass);
        set.add((Object)"HABA");
        set.add((Object)1);
        Assert.assertTrue((boolean)set.containsKey(String.class));
        Assert.assertTrue((boolean)set.containsKey(Integer.class));
    }

    @Test
    public void testLongIndexerFunction() {
        IndexedSet set = IndexedSet.createLong(Long::longValue);
        set.add((Object)1L);
        set.add((Object)2L);
        Assert.assertTrue((boolean)set.containsKey(1L));
        Assert.assertTrue((boolean)set.containsKey(2L));
    }

    @Test
    public void testIntIndexerFunction() {
        IndexedSet set = IndexedSet.createInt(Integer::intValue);
        set.add((Object)1);
        set.add((Object)2);
        Assert.assertTrue((boolean)set.containsKey(1));
        Assert.assertTrue((boolean)set.containsKey(2));
    }

    @Test
    public void testCollector() {
        this.doTestCollector(IndexedSet.class, IndexedSet.collector());
        this.doTestCollector(IndexedSet.class, IndexedSet.collector(Object::toString));
        this.doTestCollector(IndexedSet.class, IndexedSet.collectorInt(Object::hashCode));
        this.doTestCollector(SynchronizedIndexedSet.class, SynchronizedIndexedSet.collector());
        this.doTestCollector(SynchronizedIndexedSet.class, SynchronizedIndexedSet.collector(Object::toString));
        this.doTestCollector(SynchronizedIndexedSet.class, SynchronizedIndexedSet.collectorInt(Object::hashCode));
    }

    private void doTestCollector(Class<?> setClass, Collector<Object, ?, ? extends IndexedSet<?, Object>> collector) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < 100; ++i) {
            list.add(new Object());
        }
        IndexedSet<?, Object> set = list.stream().collect(collector);
        Assert.assertSame(set.getClass(), setClass);
        Assert.assertEquals(new HashSet(list), new HashSet(set));
    }

    @Test
    public void testMapCollector() {
        this.doTestMapCollector(IndexedMap.class, IndexedMap.collector(), o -> o);
        this.doTestMapCollector(IndexedMap.class, IndexedMap.collector(Object::toString), Object::toString);
        this.doTestMapCollector(IndexedMap.class, IndexedMap.collectorInt(Object::hashCode), Object::hashCode);
    }

    private <K> void doTestMapCollector(Class<?> mapClass, Collector<Object, ?, ? extends IndexedMap<K, Object>> collector, Function<Object, K> keyFunction) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < 100; ++i) {
            list.add(new Object());
        }
        IndexedMap<K, Object> map = list.stream().collect(collector);
        Assert.assertSame(map.getClass(), mapClass);
        Assert.assertEquals(list.stream().collect(Collectors.toMap(keyFunction, o -> o)), map);
    }

    @Test
    public void testBoxedLongs() {
        IndexedSet set = new IndexedSet();
        set.add((Object)1L);
        set.add((Object)2L);
        Assert.assertTrue((boolean)set.containsKey(1L));
        Assert.assertTrue((boolean)set.containsKey(2L));
        Assert.assertTrue((boolean)set.containsValue((Object)1L));
        Assert.assertTrue((boolean)set.containsValue((Object)2L));
    }

    @Test
    public void testBoxedLongKeys() {
        IndexedSet set = IndexedSet.createLong((IndexerFunction.LongKey & Serializable)value -> value[0]);
        set.add((Object)new Long[]{1L});
        set.add((Object)new Long[]{2L});
        Assert.assertTrue((boolean)set.containsKey(1L));
        Assert.assertTrue((boolean)set.containsKey(2L));
        Assert.assertTrue((boolean)set.containsValue((Object)new Long[]{1L}));
        Assert.assertTrue((boolean)set.containsValue((Object)new Long[]{2L}));
    }

    @Test
    public void testIdentityFunction() {
        IndexedSet set = IndexedSet.create((IndexerFunction)(IndexerFunction.IdentityKey & Serializable)s -> s);
        String s1 = "ONE";
        String s2 = new String(s1);
        Assert.assertTrue((s1 != s2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)set.add((Object)s1));
        Assert.assertTrue((boolean)set.add((Object)s2));
        Assert.assertTrue((boolean)set.containsKey((Object)s1));
        Assert.assertTrue((boolean)set.containsKey((Object)s2));
        Assert.assertTrue((s1 == set.getByKey((Object)s1) ? 1 : 0) != 0);
        Assert.assertTrue((s2 == set.getByKey((Object)s2) ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultIndexer() {
        Assert.assertTrue((String)"IndexerFunction.DEFAULT != null", (IndexerFunction.DEFAULT != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Indexer.DEFAULT != null", (Indexer.DEFAULT != null ? 1 : 0) != 0);
    }

    @Test
    public void testNull() {
        IndexedSet set = IndexedSet.create((IndexerFunction & Serializable)value -> value[0]);
        Assert.assertFalse((boolean)set.containsKey(null));
        Assert.assertFalse((boolean)set.containsValue((Object)new Object[]{null}));
        Assert.assertTrue((set.getByKey(null) == null ? 1 : 0) != 0);
        Object[] nul = new Object[]{null};
        set.put((Object)nul);
        Assert.assertTrue((set.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((set.keyIterator().next() == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)set.containsKey(null));
        Assert.assertTrue((boolean)set.containsValue((Object)new Object[]{null}));
        Assert.assertTrue((set.getByKey(null) == nul ? 1 : 0) != 0);
        for (int i = 0; i < 1000; ++i) {
            String key = String.valueOf(i);
            Object[] value2 = new Object[]{key};
            set.put((Object)value2);
            Assert.assertTrue((set.size() == i + 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)set.containsKey((Object)key));
            Assert.assertTrue((boolean)set.containsValue((Object)new Object[]{key}));
            Assert.assertTrue((set.getByKey((Object)key) == value2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)set.containsKey(null));
            Assert.assertTrue((boolean)set.containsValue((Object)new Object[]{null}));
            Assert.assertTrue((set.getByKey(null) == nul ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConcurrentModification() {
        this.doTestConcurrentModification((IndexedSet<String, Integer>)IndexedSet.create(STRING_INTEGER_INDEXER));
        this.doTestConcurrentModification((IndexedSet<String, Integer>)SynchronizedIndexedSet.create(STRING_INTEGER_INDEXER));
    }

    private void doTestConcurrentModification(IndexedSet<String, Integer> is) {
        for (int i = 0; i < 100; ++i) {
            is.put((Object)i);
            for (Integer v : is) {
                is.put((Object)new Integer(v));
            }
        }
    }

    @Test
    public void testPutIfAbsent() {
        this.doTestPutIfAbsent((IndexedSet<String, Integer>)IndexedSet.create(STRING_INTEGER_INDEXER));
        this.doTestPutIfAbsent((IndexedSet<String, Integer>)SynchronizedIndexedSet.create(STRING_INTEGER_INDEXER));
    }

    private void doTestPutIfAbsent(IndexedSet<String, Integer> is) {
        Integer v1 = new Integer(42);
        Integer v2 = new Integer(42);
        Assert.assertTrue((v1 != v2 ? 1 : 0) != 0);
        Integer pv1 = (Integer)is.putIfAbsentAndGet((Object)v1);
        Assert.assertTrue((pv1 == v1 ? 1 : 0) != 0);
        Assert.assertTrue((is.getByValue((Object)v1) == v1 ? 1 : 0) != 0);
        Assert.assertTrue((is.getByValue((Object)v2) == v1 ? 1 : 0) != 0);
        Assert.assertTrue((is.size() == 1 ? 1 : 0) != 0);
        Integer pv2 = (Integer)is.putIfAbsentAndGet((Object)v2);
        Assert.assertTrue((pv2 == v1 ? 1 : 0) != 0);
        Assert.assertTrue((is.getByValue((Object)v1) == v1 ? 1 : 0) != 0);
        Assert.assertTrue((is.getByValue((Object)v2) == v1 ? 1 : 0) != 0);
        Assert.assertTrue((is.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleOps() {
        this.doTestSimpleOps((IndexedSet<String, Integer>)IndexedSet.create(STRING_INTEGER_INDEXER));
        this.doTestSimpleOps((IndexedSet<String, Integer>)SynchronizedIndexedSet.create(STRING_INTEGER_INDEXER));
    }

    private void doTestSimpleOps(IndexedSet<String, Integer> is) {
        Assert.assertFalse((boolean)is.containsKey((Object)"1"));
        Assert.assertFalse((boolean)is.containsKey((Object)"2"));
        Assert.assertFalse((boolean)is.containsValue((Object)1));
        Assert.assertFalse((boolean)is.containsValue((Object)2));
        Assert.assertTrue((boolean)is.add((Object)1));
        Assert.assertTrue((boolean)is.add((Object)2));
        Assert.assertTrue((boolean)is.containsKey((Object)"1"));
        Assert.assertTrue((boolean)is.containsKey((Object)"2"));
        Assert.assertTrue((boolean)is.containsValue((Object)1));
        Assert.assertTrue((boolean)is.containsValue((Object)2));
        Assert.assertFalse((boolean)is.add((Object)1));
        Assert.assertFalse((boolean)is.add((Object)2));
        Assert.assertEquals((Object)1, (Object)is.getByKey((Object)"1"));
        Assert.assertEquals((Object)2, (Object)is.getByKey((Object)"2"));
        Assert.assertEquals((Object)1, (Object)is.getByValue((Object)1));
        Assert.assertEquals((Object)2, (Object)is.getByValue((Object)2));
        Assert.assertTrue((boolean)this.checkSerial(is));
        HashSet<Integer> hs = new HashSet<Integer>();
        Assert.assertFalse((boolean)hs.equals(is));
        Assert.assertFalse((boolean)is.equals(hs));
        hs.add(1);
        hs.add(2);
        Assert.assertTrue((boolean)hs.equals(is));
        Assert.assertTrue((boolean)is.equals(hs));
        Assert.assertEquals((long)is.hashCode(), (long)hs.hashCode());
        IndexedMap im = new IndexedMap(is, false);
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        hm.put("1", 1);
        hm.put("2", 2);
        Assert.assertTrue((boolean)hm.equals(im));
        Assert.assertTrue((boolean)im.equals(hm));
        Assert.assertTrue((boolean)this.checkSerial(im));
        Assert.assertTrue((boolean)im.values().equals(hs));
        Assert.assertTrue((boolean)hs.equals(im.values()));
        Assert.assertTrue((boolean)im.values().equals(is));
        Assert.assertTrue((boolean)is.equals((Object)im.values()));
        Assert.assertTrue((boolean)hm.keySet().equals(im.keySet()));
        Assert.assertTrue((boolean)im.keySet().equals(hm.keySet()));
    }

    @Test
    public void testBig() {
        this.doTestBig((IndexedSet<Long, String>)IndexedSet.createLong(LONG_STRING_INDEXER));
        this.doTestBig((IndexedSet<Long, String>)SynchronizedIndexedSet.createLong(LONG_STRING_INDEXER));
    }

    private void doTestBig(IndexedSet<Long, String> is) {
        int cnt = 10000;
        Assert.assertTrue((boolean)is.isEmpty());
        String[] va = new String[cnt];
        for (int k = 0; k < cnt; ++k) {
            String v;
            if (k == 100) {
                is.ensureCapacity(600);
            }
            va[k] = v = String.valueOf(k);
            Assert.assertFalse((boolean)is.containsKey(k));
            Assert.assertFalse((boolean)is.containsValue((Object)v));
            Assert.assertTrue((boolean)is.add((Object)v));
            Assert.assertTrue((boolean)is.containsKey(k));
            Assert.assertTrue((boolean)is.containsValue((Object)v));
            Assert.assertEquals((long)(k + 1), (long)is.size());
            Assert.assertFalse((boolean)is.isEmpty());
        }
        String[] a = (String[])is.toArray((Object[])new String[is.size()]);
        Assert.assertEquals((long)cnt, (long)a.length);
        Assert.assertTrue((boolean)Arrays.equals(this.scopy(a), this.scopy(va)));
        Assert.assertTrue((boolean)this.checkSerial(is));
        int cnt2 = cnt / 5;
        for (int k = 0; k < cnt - cnt2; ++k) {
            String v = String.valueOf(k);
            Assert.assertTrue((boolean)is.containsKey(k));
            Assert.assertTrue((boolean)is.containsValue((Object)v));
            switch (k % 4) {
                case 0: {
                    Assert.assertTrue((boolean)is.remove((Object)v));
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)v, (Object)is.removeValue((Object)v));
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)v, (Object)is.removeKey(k));
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)v, (Object)is.removeKey((Object)k));
                }
            }
            Assert.assertFalse((boolean)is.containsKey(k));
            Assert.assertFalse((boolean)is.containsValue((Object)v));
            Assert.assertEquals((long)(cnt - k - 1), (long)is.size());
            Assert.assertFalse((boolean)is.isEmpty());
        }
        Assert.assertTrue((boolean)this.checkSerial(is));
        a = (String[])is.toArray((Object[])new String[is.size()]);
        Assert.assertEquals((long)cnt2, (long)a.length);
        Assert.assertTrue((boolean)Arrays.equals(this.scopy(a), this.scopy(va, cnt - cnt2, cnt2)));
        IndexedSet is2 = new IndexedSet(is);
        is.trimToSize();
        a = (String[])is.toArray((Object[])new String[is.size()]);
        Assert.assertEquals((long)cnt2, (long)a.length);
        Assert.assertTrue((boolean)Arrays.equals(this.scopy(a), this.scopy(va, cnt - cnt2, cnt2)));
        is.clear();
        Assert.assertTrue((boolean)is.isEmpty());
        a = (String[])is.toArray((Object[])new String[is.size()]);
        Assert.assertEquals((long)0L, (long)a.length);
        a = (String[])is2.toArray((Object[])new String[is2.size()]);
        Assert.assertEquals((long)cnt2, (long)a.length);
        Assert.assertTrue((boolean)Arrays.equals(this.scopy(a), this.scopy(va, cnt - cnt2, cnt2)));
        Assert.assertTrue((boolean)this.checkSerial(is2));
        int cnt3 = 0;
        Iterator it = is2.keyIterator();
        while (it.hasNext()) {
            if ((Long)it.next() % 5L != 0L) {
                it.remove();
                continue;
            }
            ++cnt3;
        }
        for (int i = 0; i < cnt; ++i) {
            Assert.assertEquals((Object)(i >= cnt - cnt2 && i % 5 == 0 ? 1 : 0), (Object)is2.containsKey((Object)i));
        }
        Assert.assertEquals((long)cnt3, (long)is2.size());
        Assert.assertTrue((boolean)this.checkSerial(is2));
    }

    @Test
    public void testRemoveAllShortParam() {
        IndexedSet set = IndexedSet.create(STR_ITEM_INDEXER);
        set.add((Object)new StrItem(null));
        set.add((Object)new StrItem("a"));
        set.add((Object)new StrItem("b"));
        set.add((Object)new StrItem("c"));
        Assert.assertTrue((boolean)set.removeAll(Arrays.asList(new StrItem(null), new StrItem("a"), new StrItem("b"))));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"c"));
    }

    @Test
    public void testRemoveAllLongParam() {
        IndexedSet set = IndexedSet.create(STR_ITEM_INDEXER);
        set.add((Object)new StrItem(null));
        set.add((Object)new StrItem("a"));
        set.add((Object)new StrItem("d"));
        Assert.assertTrue((boolean)set.removeAll(Arrays.asList(new StrItem(null), new StrItem("a"), new StrItem("b"), new StrItem("c"))));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"d"));
    }

    @Test
    public void testRemoveAllLongSetParam() {
        IndexedSet set = IndexedSet.create(STR_ITEM_INDEXER);
        set.add((Object)new StrItem(null));
        set.add((Object)new StrItem("a"));
        set.add((Object)new StrItem("d"));
        List<StrItem> c = Arrays.asList(new StrItem(null), new StrItem("a"), new StrItem("b"), new StrItem("c"));
        Assert.assertTrue((boolean)set.removeAll((Collection)IndexedSet.create(STR_ITEM_INDEXER).withElements(c)));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"d"));
    }

    @Test
    public void testRetainAll() {
        IndexedSet set = IndexedSet.create(STR_ITEM_INDEXER);
        set.add((Object)new StrItem(null));
        set.add((Object)new StrItem("a"));
        set.add((Object)new StrItem("b"));
        set.add((Object)new StrItem("c"));
        Assert.assertTrue((boolean)set.retainAll(Arrays.asList(new StrItem("b"), new StrItem("d"), new StrItem("e"))));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"b"));
    }

    @Test
    public void testRetainAllWithSet() {
        IndexedSet set = IndexedSet.create(STR_ITEM_INDEXER);
        set.add((Object)new StrItem(null));
        set.add((Object)new StrItem("a"));
        set.add((Object)new StrItem("b"));
        set.add((Object)new StrItem("c"));
        List<StrItem> c = Arrays.asList(new StrItem("b"), new StrItem("d"), new StrItem("e"));
        Assert.assertTrue((boolean)set.retainAll((Collection)IndexedSet.create(STR_ITEM_INDEXER).withElements(c)));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"b"));
    }

    @Test
    public void testEntrySetRemoveAllShortParam() {
        IndexedMap set = IndexedMap.create(STR_ITEM_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("b"));
        set.put((Object)new StrItem("c"));
        set.put((Object)new StrItem("d"));
        Map<String, StrItem> itemMap = Stream.of(new StrItem(null), new StrItem("a"), new StrItem("b"), new StrItem("c")).collect(Collectors.toMap(arg_0 -> STR_ITEM_INDEXER.getObjectKey(arg_0), i -> i));
        Assert.assertTrue((boolean)set.entrySet().removeAll(itemMap.entrySet()));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"d"));
    }

    @Test
    public void testEntrySetRemoveAllLongParam() {
        IndexedMap set = IndexedMap.create(STR_ITEM_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("d"));
        Map<String, StrItem> itemMap = Stream.of(new StrItem(null), new StrItem("a"), new StrItem("b"), new StrItem("c")).collect(Collectors.toMap(arg_0 -> STR_ITEM_INDEXER.getObjectKey(arg_0), i -> i));
        Assert.assertTrue((boolean)set.entrySet().removeAll(itemMap.entrySet()));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"d"));
    }

    @Test
    public void testEntrySetRetainAll() {
        IndexedMap set = IndexedMap.create(STR_ITEM_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("b"));
        set.put((Object)new StrItem("c"));
        Map<String, StrItem> itemMap = Stream.of(new StrItem("b"), new StrItem("d"), new StrItem("e")).collect(Collectors.toMap(arg_0 -> STR_ITEM_INDEXER.getObjectKey(arg_0), i -> i));
        Assert.assertTrue((boolean)set.entrySet().retainAll(itemMap.entrySet()));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"b"));
    }

    @Test
    public void testEntrySetRemoveIf() {
        IndexedMap set = IndexedMap.create(STR_ITEM_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("b"));
        set.put((Object)new StrItem("c"));
        Assert.assertTrue((boolean)set.entrySet().removeIf(entry -> !"b".equals(entry.getKey())));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)"b"));
    }

    @Test
    public void testKeySetRemoveAllShortParam() {
        IndexedMap set = IndexedMap.create(STR_ITEM_WEIRD_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("b"));
        set.put((Object)new StrItem("c"));
        set.put((Object)new StrItem("d"));
        Assert.assertTrue((boolean)set.keySet().removeAll(Arrays.asList(new StrItem(null), new StrItem("a"), new StrItem("b"), new StrItem("c"))));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)new StrItem("d")));
    }

    @Test
    public void testKeySetRemoveAllLongParam() {
        IndexedMap set = IndexedMap.create(STR_ITEM_WEIRD_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("d"));
        Assert.assertTrue((boolean)set.keySet().removeAll(Arrays.asList(new StrItem(null), new StrItem("a"), new StrItem("b"), new StrItem("c"))));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)new StrItem("d")));
    }

    @Test
    public void testKeySetRetainAll() {
        IndexedMap set = IndexedMap.create(STR_ITEM_WEIRD_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("b"));
        set.put((Object)new StrItem("c"));
        Assert.assertTrue((boolean)set.keySet().retainAll(Arrays.asList(new StrItem("b"), new StrItem("d"), new StrItem("e"))));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)new StrItem("b")));
    }

    @Test
    public void testKeySetRemoveIf() {
        IndexedMap set = IndexedMap.create(STR_ITEM_WEIRD_INDEXER);
        set.put((Object)new StrItem(null));
        set.put((Object)new StrItem("a"));
        set.put((Object)new StrItem("b"));
        set.put((Object)new StrItem("c"));
        Assert.assertTrue((boolean)set.keySet().removeIf(key -> key == null || !"b".equals(key.val)));
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.containsKey((Object)new StrItem("b")));
    }

    @Test
    public void testIdentitySet() {
        this.doTestIdentitySet((IndexedSet<String, String>)IndexedSet.create(STRING_IDENTITY_INDEXER));
        this.doTestIdentitySet((IndexedSet<String, String>)SynchronizedIndexedSet.create(STRING_IDENTITY_INDEXER));
    }

    private void doTestIdentitySet(IndexedSet<String, String> is) {
        String s1 = new String("HABA");
        String s2 = new String("HABA");
        Assert.assertTrue((boolean)is.add((Object)s1));
        Assert.assertTrue((boolean)is.add((Object)s2));
        Assert.assertEquals((long)2L, (long)is.size());
        Assert.assertTrue((s1 == is.getByKey((Object)s1) ? 1 : 0) != 0);
        Assert.assertTrue((s2 == is.getByKey((Object)s2) ? 1 : 0) != 0);
        Assert.assertTrue((s1 == is.getByValue((Object)s1) ? 1 : 0) != 0);
        Assert.assertTrue((s2 == is.getByValue((Object)s2) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.checkSerial(is));
    }

    private boolean checkSerial(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object p = ois.readObject();
            boolean eq1 = p.equals(o);
            boolean eq2 = o.equals(p);
            Assert.assertTrue((eq1 == eq2 ? 1 : 0) != 0);
            return eq1;
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
            return false;
        }
    }

    private String[] scopy(String[] a) {
        return this.scopy(a, 0, a.length);
    }

    private String[] scopy(String[] a, int ofs, int len) {
        Object[] r = new String[len];
        System.arraycopy(a, ofs, r, 0, len);
        Arrays.sort(r);
        return r;
    }

    static class StrItem {
        public String val;

        public StrItem(String val) {
            this.val = val;
        }
    }
}

