/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging.test;

import com.devexperts.logging.LogFormatter;
import com.devexperts.test.isolated.Isolated;
import com.devexperts.test.isolated.IsolatedRunner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=IsolatedRunner.class)
@Isolated(value={"com.devexperts.logging", "org.apache.logging", "org.apache.log4j"})
public abstract class LogFormatterTestBase {
    protected final String REGEX = "D \\d{6}? \\d{6}?\\.\\d{3}? \\[_ThreadName_\\] MyCategory \\- My message((\\r)|(\\n))+";
    protected LogFormatter formatter;

    protected static String loadFile(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()));
    }

    protected String getLog4jFormattedString(String threadName) {
        return this.formatter.format('D', System.currentTimeMillis(), threadName, "MyCategory", "My message");
    }

    protected String getJULFormattedString(String threadName) {
        LogRecord record = new LogRecord(Level.FINE, "My message");
        record.setLoggerName("MyCategory");
        String currentThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(threadName);
        String formattedString = this.formatter.format(record);
        Thread.currentThread().setName(currentThreadName);
        return formattedString;
    }

    protected String getPattern(String threadName) {
        return "D \\d{6}? \\d{6}?\\.\\d{3}? \\[_ThreadName_\\] MyCategory \\- My message((\\r)|(\\n))+".replace("_ThreadName_", Pattern.quote(threadName));
    }

    protected void checkResultMatches(String originalThreadName, String formattedThreadName) {
        String log4jFormattedString = this.getLog4jFormattedString(originalThreadName);
        String julFormattedString = this.getJULFormattedString(originalThreadName);
        String pattern = this.getPattern(formattedThreadName);
        Assert.assertTrue((String)("Obtained string '" + log4jFormattedString + "' does not match regexp '" + pattern + "'"), (boolean)log4jFormattedString.matches(pattern));
        Assert.assertTrue((String)("Obtained string '" + julFormattedString + "' does not match regexp '" + pattern + "'"), (boolean)julFormattedString.matches(pattern));
    }

    protected void checkResultDoesNotMatch(String originalThreadName, String formattedThreadName) {
        String log4jFormattedString = this.getLog4jFormattedString(originalThreadName);
        String julFormattedString = this.getJULFormattedString(originalThreadName);
        String pattern = this.getPattern(formattedThreadName);
        Assert.assertFalse((String)("Obtained string '" + log4jFormattedString + "' should not match regexp '" + pattern + "'"), (boolean)log4jFormattedString.matches(pattern));
        Assert.assertFalse((String)("Obtained string '" + julFormattedString + "' should not match regexp '" + pattern + "'"), (boolean)julFormattedString.matches(pattern));
    }
}

