/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.management.test;

import com.devexperts.management.Management;
import com.devexperts.management.test.SampleBean;
import com.devexperts.management.test.SampleMXBean;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.junit.Assert;
import org.junit.Test;

public class ManagementTest {
    @Test
    public void testAnnotations() throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        SampleBean bean = new SampleBean();
        Management.Registration registration = Management.registerMBean((Object)bean, SampleMXBean.class, (String)"test:name=TestBean");
        Assert.assertFalse((boolean)registration.hasExisted());
        Assert.assertFalse((boolean)registration.hasFailed());
        ObjectName objectName = registration.getInstance().getObjectName();
        MBeanInfo info = ManagementFactory.getPlatformMBeanServer().getMBeanInfo(objectName);
        int seen = 0;
        for (MBeanOperationInfo op : info.getOperations()) {
            MBeanParameterInfo[] sig;
            if (op.getName().equals("setPrevDayClose")) {
                Assert.assertEquals((String)op.getDescription(), (Object)"Sets new values for prev day close data", (Object)op.getDescription());
                sig = op.getSignature();
                Assert.assertEquals((long)3L, (long)sig.length);
                Assert.assertEquals((Object)"symbol", (Object)sig[0].getName());
                Assert.assertEquals((Object)"the symbol", (Object)sig[0].getDescription());
                Assert.assertEquals((Object)"date", (Object)sig[1].getName());
                Assert.assertEquals((Object)"the prevDayId in yyyyMMdd format", (Object)sig[1].getDescription());
                Assert.assertEquals((Object)"price", (Object)sig[2].getName());
                Assert.assertEquals((Object)"the prevDayClosePrice", (Object)sig[2].getDescription());
                ++seen;
            }
            if (op.getName().equals("removeDeadSymbols")) {
                Assert.assertEquals((Object)"Removes all data for all symbols that were inactive for a specified time period", (Object)op.getDescription());
                sig = op.getSignature();
                Assert.assertEquals((long)1L, (long)sig.length);
                Assert.assertEquals((Object)"ttlMillis", (Object)sig[0].getName());
                Assert.assertEquals((Object)"inactivity period in milliseconds", (Object)sig[0].getDescription());
                ++seen;
            }
            if (op.getName().equals("removeSymbol")) {
                Assert.assertEquals((Object)"Removes all data for specified symbol", (Object)op.getDescription());
                sig = op.getSignature();
                Assert.assertEquals((long)1L, (long)sig.length);
                Assert.assertEquals((Object)"symbol", (Object)sig[0].getName());
                Assert.assertEquals((Object)"the symbol", (Object)sig[0].getDescription());
                ++seen;
            }
            if (op.getName().equals("scan")) {
                Assert.assertEquals((Object)"Tests that string arrays are supported", (Object)op.getDescription());
                sig = op.getSignature();
                Assert.assertEquals((long)1L, (long)sig.length);
                Assert.assertEquals((Object)"symbols", (Object)sig[0].getName());
                Assert.assertEquals((Object)"the symbols", (Object)sig[0].getDescription());
                ++seen;
            }
            if (!op.getName().equals("avoid")) continue;
            Assert.assertEquals((Object)"Tests that primitive arrays are supported", (Object)op.getDescription());
            sig = op.getSignature();
            Assert.assertEquals((long)1L, (long)sig.length);
            Assert.assertEquals((Object)"indices", (Object)sig[0].getName());
            Assert.assertEquals((Object)"the indices", (Object)sig[0].getDescription());
            ++seen;
        }
        Assert.assertEquals((long)5L, (long)seen);
        registration.unregister();
    }
}

