/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.IOUtil;
import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import com.devexperts.io.MarshallingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ObjectUtilTest {
    static final int[] INT1234_BYTES = new int[]{128, 81, 172, 237, -1, -1, 115, 114, 0, 17, 106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 73, 110, 116, 101, 103, 101, 114, 18, 226, 160, 164, 247, 129, 135, 56, 2, 0, 1, 73, 0, 5, 118, 97, 108, 117, 101, 120, 114, 0, 16, 106, 97, 118, 97, 46, 108, 97, 110, 103, 46, 78, 117, 109, 98, 101, 114, 134, 172, 149, 29, 11, 148, 224, 139, 2, 0, 0, 120, 112, 0, 0, 4, 210};
    static final int INT1234_LEN = INT1234_BYTES.length;
    static final int DATA_OFFSET = 2;

    @Test
    public void testReadWrite() throws IOException {
        ObjectUtilTest.checkReadWrite(null);
        ObjectUtilTest.checkReadWrite(1.0);
        ObjectUtilTest.checkReadWrite("test");
        ObjectUtilTest.checkReadWrite(ObjectUtilTest.bigObject(1L));
        ObjectUtilTest.checkReadWrite(ObjectUtilTest.bigObject(2L));
    }

    @Test
    public void testToFromBytes() throws IOException {
        ObjectUtilTest.checkToFromBytes(null);
        ObjectUtilTest.checkToFromBytes(1.0);
        ObjectUtilTest.checkToFromBytes("test");
        ObjectUtilTest.checkToFromBytes(ObjectUtilTest.bigObject(1L));
        ObjectUtilTest.checkToFromBytes(ObjectUtilTest.bigObject(2L));
    }

    private static Object bigObject(long seed) {
        Random r = new Random(seed);
        int n = r.nextInt(10000) + 10000;
        ArrayList<Object> result = new ArrayList<Object>(n);
        block5: for (int i = 0; i < n; ++i) {
            switch (r.nextInt(3)) {
                case 0: {
                    result.add(r.nextInt(1000));
                    continue block5;
                }
                case 1: {
                    result.add(Long.valueOf(r.nextInt(1000)));
                    continue block5;
                }
                case 2: {
                    result.add(String.valueOf(r.nextInt(1000)));
                }
            }
        }
        return result;
    }

    private static void checkReadWrite(Object value) throws IOException {
        byte[] bytes = ObjectUtilTest.writeToBytes(value);
        Object result = ObjectUtilTest.readFromBytes(bytes);
        Assert.assertEquals((Object)value, (Object)result);
    }

    private static void checkToFromBytes(Object value) throws IOException {
        byte[] bytes = IOUtil.objectToBytes((Object)value);
        Object result = IOUtil.bytesToObject((byte[])bytes);
        Assert.assertEquals((Object)value, (Object)result);
    }

    private static Object readFromBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        return IOUtil.readObject((DataInput)dis);
    }

    private static byte[] writeToBytes(Object value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        IOUtil.writeObject((DataOutput)dos, (Object)value);
        return baos.toByteArray();
    }

    @Test
    public void testCompatibleWrite() throws IOException {
        byte[] bytes = ObjectUtilTest.writeToBytes(1234);
        int n = bytes.length;
        Assert.assertEquals((long)n, (long)INT1234_LEN);
        for (int i = 0; i < n; ++i) {
            if (INT1234_BYTES[i] < 0) continue;
            Assert.assertEquals((long)INT1234_BYTES[i], (long)(0xFF & bytes[i]));
        }
    }

    @Test
    public void testCompatibleToBytes() throws IOException {
        byte[] bytes = IOUtil.objectToBytes((Object)1234);
        int n = bytes.length;
        Assert.assertEquals((long)n, (long)(INT1234_LEN - 2));
        for (int i = 0; i < n; ++i) {
            if (INT1234_BYTES[i + 2] < 0) continue;
            Assert.assertEquals((long)INT1234_BYTES[i + 2], (long)(0xFF & bytes[i]));
        }
    }

    @Test
    public void testObjectsToFromBytes() throws IOException {
        ObjectUtilTest.checkObjectsToFromBytes(new Class[]{Void.TYPE}, new Object[]{null});
        ObjectUtilTest.checkObjectsToFromBytes(new Class[0], new Object[0]);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(-1);
        list.add(null);
        list.add(Integer.MAX_VALUE);
        ObjectUtilTest.checkObjectsToFromBytes(new Class[]{Integer.TYPE, List.class, byte[][].class, String[].class, String.class, Long.class, Date.class, Boolean[][][].class}, new Object[]{123, list, new byte[][]{{123, 45}, null, new byte[0]}, new String[]{"abc", null, "def"}, null, 1234567890123456789L, new Date(564623246L), new Boolean[][][]{null, {null, {true, false, null}}}});
        ObjectUtilTest.checkObjectsToFromBytes(new Class[]{Integer.TYPE, String.class, Boolean.TYPE}, new Object[]{1234567890, "Hello! =)", true});
        ObjectUtilTest.checkObjectsToFromBytes(new Class[]{Integer.class, File.class, Date.class, Object.class}, new Object[]{1234567890, new File("some_file.dat"), new Date(7777777L), list});
    }

    @Test
    public void testObjectsToFromBytesFailures() {
        ObjectUtilTest.checkToFromTypesMismatch(new Class[]{Integer.class}, new Class[]{Integer.TYPE}, new Object[]{123});
        ObjectUtilTest.checkToFromTypesMismatch(new Class[]{Long.TYPE}, new Class[]{Integer.TYPE}, new Object[]{12345678901234567L});
        ObjectUtilTest.checkToFromTypesMismatch(new Class[]{boolean[][].class}, new Class[]{Object[].class}, new Object[]{new boolean[0][0]});
        ObjectUtilTest.checkToFromTypesMismatch(new Class[]{Object.class}, new Class[]{String.class}, new Object[]{"hello"});
        ObjectUtilTest.checkIllegalObjectsToBytesArguments(new Class[]{String.class}, new Object[]{5});
        ObjectUtilTest.checkIllegalObjectsToBytesArguments(new Class[]{Object[][].class}, new Object[]{new Object[2]});
        ObjectUtilTest.checkIllegalObjectsToBytesArguments(new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{1, 2, 3});
        ObjectUtilTest.checkIllegalObjectsToBytesArguments(new Class[]{Integer.TYPE, Date.class}, new Object[]{new Date(123L), 123});
    }

    private static void checkIllegalObjectsToBytesArguments(Class[] types, Object[] objects) {
        Assert.assertThrows(MarshallingException.class, () -> Marshalled.forObject((Object)objects, (Marshaller)Marshaller.forClasses((Class[])types)).getBytes());
    }

    private static void checkToFromTypesMismatch(Class[] writeTypes, Class[] readTypes, Object[] objects) {
        Assert.assertThrows(MarshallingException.class, () -> {
            byte[] bytes = Marshalled.forObject((Object)objects, (Marshaller)Marshaller.forClasses((Class[])writeTypes)).getBytes();
            Marshalled.forBytes((byte[])bytes, (Marshaller)Marshaller.forClasses((Class[])readTypes)).getObject();
        });
    }

    private static void checkObjectsToFromBytes(Class[] types, Object[] objects) {
        Assert.assertEquals((long)types.length, (long)objects.length);
        byte[] bytes = Marshalled.forObject((Object)objects, (Marshaller)Marshaller.forClasses((Class[])types)).getBytes();
        Object[] results = (Object[])Marshalled.forBytes((byte[])bytes, (Marshaller)Marshaller.forClasses((Class[])types)).getObject();
        for (int i = 0; i < types.length; ++i) {
            ObjectUtilTest.assertDeepEquals(objects[i], results[i]);
        }
    }

    public static void assertDeepEquals(Object expected, Object actual) {
        if (expected == actual) {
            return;
        }
        Class<?> ec = expected.getClass();
        Class<?> ac = actual.getClass();
        if (ec.isArray()) {
            int n;
            if (!ac.isArray()) {
                Assert.fail((String)"Array expected");
            }
            if ((n = Array.getLength(expected)) != Array.getLength(actual)) {
                Assert.fail((String)"Array length mismatch");
            }
            for (int i = 0; i < n; ++i) {
                ObjectUtilTest.assertDeepEquals(Array.get(expected, i), Array.get(actual, i));
            }
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testCompression() throws Exception {
        this.compressionTest(false);
        this.compressionTest(true);
    }

    private void compressionTest(boolean compression) throws Exception {
        boolean oldCompression = IOUtil.isCompressionEnabled();
        IOUtil.setCompressionEnabled((boolean)compression);
        System.out.println("compression = " + compression + ", old = " + oldCompression);
        HashMap<Object, Object> original = new HashMap<Object, Object>(System.getProperties());
        for (int i = 0; i < 5000; ++i) {
            original.put(i, i);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(original);
        oos.flush();
        byte[] bytes = baos.toByteArray();
        byte[] ioBytes = IOUtil.objectToBytes(original);
        this.print(bytes, "bytes");
        this.print(ioBytes, "ioBytes");
        if (!compression) {
            Assert.assertArrayEquals((byte[])bytes, (byte[])ioBytes);
        }
        Assert.assertEquals(original, (Object)IOUtil.bytesToObject((byte[])bytes));
        Assert.assertEquals(original, (Object)IOUtil.bytesToObject((byte[])ioBytes));
        Class[] types = new Class[]{Integer.TYPE, original.getClass()};
        Object[] params = new Object[]{305419896, original};
        byte[] declared = Marshalled.forObject((Object)params, (Marshaller)Marshaller.forClasses((Class[])types)).getBytes();
        byte[] declared2 = IOUtil.deflate((byte[])declared, (int)1);
        this.print(declared, "declared");
        this.print(declared2, "declared2");
        ObjectUtilTest.assertDeepEquals(params, Marshalled.forBytes((byte[])declared, (Marshaller)Marshaller.forClasses((Class[])new Class[]{Integer.TYPE, original.getClass()})).getObject());
        ObjectUtilTest.assertDeepEquals(params, Marshalled.forBytes((byte[])declared2, (Marshaller)Marshaller.forClasses((Class[])new Class[]{Integer.TYPE, original.getClass()})).getObject());
        baos = new ByteArrayOutputStream();
        IOUtil.writeObject((DataOutput)new DataOutputStream(baos), original);
        byte[] written = baos.toByteArray();
        baos = new ByteArrayOutputStream();
        IOUtil.writeByteArray((DataOutput)new DataOutputStream(baos), (byte[])ioBytes);
        Assert.assertTrue((boolean)Arrays.equals(baos.toByteArray(), written));
        byte[] deflated = IOUtil.deflate((byte[])bytes, (int)1);
        byte[] deflated2 = IOUtil.deflate((byte[])deflated, (int)1);
        this.print(deflated, "deflated");
        this.print(deflated2, "deflated2");
        Assert.assertFalse((boolean)Arrays.equals(bytes, deflated));
        Assert.assertFalse((boolean)Arrays.equals(bytes, deflated2));
        Assert.assertFalse((boolean)Arrays.equals(deflated, deflated2));
        Assert.assertTrue((boolean)Arrays.equals(bytes, IOUtil.inflate((byte[])deflated)));
        Assert.assertTrue((boolean)Arrays.equals(deflated, IOUtil.inflate((byte[])deflated2)));
        Assert.assertTrue((boolean)Arrays.equals(bytes, IOUtil.decompress((byte[])deflated)));
        Assert.assertTrue((boolean)Arrays.equals(bytes, IOUtil.decompress((byte[])deflated2)));
        byte[] compressed = IOUtil.compress((byte[])bytes);
        byte[] compressed2 = IOUtil.compress((byte[])compressed);
        this.print(compressed, "compressed");
        this.print(compressed2, "compressed2");
        Assert.assertTrue((bytes == compressed != compression ? 1 : 0) != 0);
        Assert.assertTrue((Arrays.equals(bytes, compressed) != compression ? 1 : 0) != 0);
        Assert.assertTrue((compressed == compressed2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(bytes, IOUtil.decompress((byte[])compressed)));
        Assert.assertTrue((boolean)Arrays.equals(bytes, IOUtil.decompress((byte[])compressed2)));
        IOUtil.setCompressionEnabled((boolean)oldCompression);
    }

    private void print(byte[] b, String m) throws IOException {
        ByteArrayInput bai = new ByteArrayInput(b);
        System.out.println(m + " = " + b + " [" + b.length + "] = " + Integer.toHexString(bai.readInt()) + ", " + Integer.toHexString(bai.readInt()) + ", " + Integer.toHexString(bai.readInt()) + ", " + Integer.toHexString(bai.readInt()) + ", " + Integer.toHexString(bai.readInt()) + ", " + Integer.toHexString(bai.readInt()) + ", " + Integer.toHexString(bai.readInt()) + ", " + Integer.toHexString(bai.readInt()));
    }
}

