/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import com.devexperts.io.ChunkedInput;
import com.devexperts.io.ChunkedOutput;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class TotalPositionTest {
    private static final int CNT = 30000;
    private static final int REP = 5;

    @Test
    public void testByteArrayOutputTotalPosition() throws IOException {
        ByteArrayOutput out = new ByteArrayOutput();
        for (int i = 0; i < 5; ++i) {
            this.checkOutputTotalPosition((BufferedOutput)out, 0L);
            byte[] buffer = out.getBuffer();
            ByteArrayInput in = new ByteArrayInput(buffer);
            this.checkInputTotalPosition((BufferedInput)in);
            out.clear();
        }
    }

    @Test
    public void testChunkedOutputTotalPosition() throws IOException {
        ChunkedOutput out = new ChunkedOutput();
        for (int i = 0; i < 5; ++i) {
            this.checkOutputTotalPosition((BufferedOutput)out, 0L);
            ChunkList chunks = out.getOutput((Object)this);
            ChunkedInput in = new ChunkedInput();
            in.addAllToInput(chunks, (Object)this);
            this.checkInputTotalPosition((BufferedInput)in);
            out.clear();
        }
    }

    @Test
    public void testChunkedOutputTotalPositionKeep() throws IOException {
        ChunkedOutput out = new ChunkedOutput();
        for (int i = 0; i < 5; ++i) {
            this.checkOutputTotalPosition((BufferedOutput)out, i * 30000);
            long wasTotalPosition = out.totalPosition();
            ChunkList chunks = out.getOutput((Object)this);
            Assert.assertEquals((long)wasTotalPosition, (long)out.totalPosition());
            ChunkedInput in = new ChunkedInput();
            in.addAllToInput(chunks, (Object)this);
            this.checkInputTotalPosition((BufferedInput)in);
        }
    }

    @Test
    public void testChunkedOutputFromChunkListWrapped() throws IOException {
        ChunkedOutput out = new ChunkedOutput();
        for (int i = 0; i < 5; ++i) {
            long wasTotalPosition = out.totalPosition();
            ChunkList chunks = ChunkPool.DEFAULT.getChunkList((Object)this);
            int nBytes = 42;
            Chunk chunk = Chunk.wrap((byte[])new byte[nBytes], (Object)this);
            chunks.add(chunk, (Object)this);
            out.writeAllFromChunkList(chunks, (Object)this);
            Assert.assertEquals((long)(wasTotalPosition + (long)nBytes), (long)out.totalPosition());
        }
    }

    @Test
    public void testChunkedOutputFromChunkListPooled() throws IOException {
        ChunkedOutput out = new ChunkedOutput();
        for (int i = 0; i < 5; ++i) {
            long wasTotalPosition = out.totalPosition();
            ChunkList chunks = ChunkPool.DEFAULT.getChunkList((Object)this);
            int nBytes = 42;
            Chunk chunk = ChunkPool.DEFAULT.getChunk((Object)this);
            chunk.setRange(3, nBytes, (Object)this);
            chunks.add(chunk, (Object)this);
            out.writeAllFromChunkList(chunks, (Object)this);
            Assert.assertEquals((long)(wasTotalPosition + (long)nBytes), (long)out.totalPosition());
        }
    }

    private void checkOutputTotalPosition(BufferedOutput out, long basePosition) throws IOException {
        for (int i = 0; i < 30000; ++i) {
            Assert.assertEquals((long)(basePosition + (long)i), (long)out.totalPosition());
            out.write(i & 0xFF);
        }
        Assert.assertEquals((long)(basePosition + 30000L), (long)out.totalPosition());
    }

    private void checkInputTotalPosition(BufferedInput in) throws IOException {
        for (int i = 0; i < 30000; ++i) {
            Assert.assertEquals((long)i, (long)in.totalPosition());
            Assert.assertEquals((long)(i & 0xFF), (long)in.read());
        }
        Assert.assertEquals((long)30000L, (long)in.totalPosition());
    }
}

