/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.TimeUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;

public class TimeUtilTest {
    private static final ZoneId BERLIN_ZONE_ID = ZoneId.of("Europe/Berlin");
    private static final ZoneOffset SUMMER_OFFSET = ZoneOffset.of("+02");
    private static final ZoneOffset WINTER_OFFSET = ZoneOffset.of("+01");

    @Test
    public void testSimpleZones() {
        Assert.assertEquals((Object)"GMT", (Object)TimeUtil.getTimeZoneGmt().getID());
        Assert.assertEquals((Object)"UTC", (Object)TimeUtil.getTimeZone((String)"UTC").getID());
        Assert.assertEquals((Object)"PST", (Object)TimeUtil.getTimeZone((String)"PST").getID());
        Assert.assertEquals((Object)"EST", (Object)TimeUtil.getTimeZone((String)"EST").getID());
        Assert.assertEquals((Object)"America/Chicago", (Object)TimeUtil.getTimeZone((String)"America/Chicago").getID());
        Assert.assertEquals((Object)"America/New_York", (Object)TimeUtil.getTimeZone((String)"America/New_York").getID());
    }

    @Test
    public void testOffsetZones() {
        Assert.assertEquals((Object)"GMT+00:00", (Object)TimeUtil.getTimeZone((String)"GMT+00:00").getID());
        Assert.assertEquals((Object)"GMT-00:00", (Object)TimeUtil.getTimeZone((String)"GMT-00:00").getID());
        Assert.assertEquals((Object)"GMT+06:00", (Object)TimeUtil.getTimeZone((String)"GMT+06:00").getID());
        Assert.assertEquals((Object)"GMT-06:00", (Object)TimeUtil.getTimeZone((String)"GMT-06:00").getID());
    }

    @Test
    public void testInvalidZones() {
        Assert.assertThrows(IllegalArgumentException.class, () -> TimeUtil.getTimeZone((String)"Atlantis/Underwater_Town"));
        Assert.assertThrows(IllegalArgumentException.class, () -> TimeUtil.getTimeZone((String)"GMT+6:00"));
        Assert.assertThrows(IllegalArgumentException.class, () -> TimeUtil.getTimeZone((String)"Z"));
    }

    @Test
    public void testCheckDelay() {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(defaultTimeZone);
        calendar.set(2023, 5, 9);
        calendar.set(11, 1);
        calendar.set(12, 0);
        calendar.set(13, 1);
        calendar.set(14, 0);
        long currentTime = calendar.getTimeInMillis();
        IntStream.range(0, 24).forEach(hour -> IntStream.iterate(0, operand -> operand + 10).limit(6L).forEach(minutes -> {
            Calendar currentCalendar = (Calendar)calendar.clone();
            currentCalendar.set(11, hour);
            currentCalendar.set(12, minutes);
            currentCalendar.set(13, 0);
            if (currentCalendar.before(calendar)) {
                currentCalendar.add(5, 1);
            }
            long dailyTime1 = currentCalendar.getTimeInMillis();
            try {
                long dailyTime2 = TimeUtil.computeDailyTime((long)currentTime, (LocalTime)LocalTime.of(hour, minutes, 0), (ZoneId)defaultTimeZone.toZoneId());
                Assert.assertEquals((long)dailyTime1, (long)dailyTime2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Test
    public void testWinterToSummerTimeShift() {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-03-25T03:00:00"), WINTER_OFFSET, BERLIN_ZONE_ID);
        long epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(2, 15, 0), 23L, 0L);
        this.check(epochMillis, LocalTime.of(2, 20, 0), 23L, 0L);
        this.check(epochMillis, LocalTime.of(2, 50, 0), 23L, 0L);
        zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-03-26T00:00:00"), WINTER_OFFSET, BERLIN_ZONE_ID);
        epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(0, 0, 0), 23L, 0L);
        this.check(epochMillis, LocalTime.of(1, 0, 0), 1L, 0L);
        this.check(epochMillis, LocalTime.of(2, 0, 0), 2L, 0L);
        this.check(epochMillis, LocalTime.of(2, 15, 0), 2L, 0L);
        this.check(epochMillis, LocalTime.of(2, 30, 0), 2L, 0L);
        this.check(epochMillis, LocalTime.of(2, 45, 0), 2L, 0L);
        this.check(epochMillis, LocalTime.of(3, 0, 0), 2L, 0L);
        this.check(epochMillis, LocalTime.of(4, 15, 0), 3L, 15L);
        this.check(epochMillis, LocalTime.of(23, 15, 0), 22L, 15L);
        zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-03-26T03:00:00"), SUMMER_OFFSET, BERLIN_ZONE_ID);
        epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(2, 0, 0), 23L, 0L);
        this.check(epochMillis, LocalTime.of(2, 15, 0), 23L, 15L);
        this.check(epochMillis, LocalTime.of(2, 30, 0), 23L, 30L);
        this.check(epochMillis, LocalTime.of(2, 45, 0), 23L, 45L);
        zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-03-26T03:30:00"), SUMMER_OFFSET, BERLIN_ZONE_ID);
        epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(2, 15, 0), 22L, 45L);
    }

    @Test
    public void testSummerToWinterTimeShift() {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-10-29T00:00:00"), SUMMER_OFFSET, BERLIN_ZONE_ID);
        long epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(0, 0, 0), 25L, 0L);
        this.check(epochMillis, LocalTime.of(1, 0, 0), 1L, 0L);
        this.check(epochMillis, LocalTime.of(2, 0, 0), 2L, 0L);
        this.check(epochMillis, LocalTime.of(2, 15, 0), 2L, 15L);
        this.check(epochMillis, LocalTime.of(2, 30, 0), 2L, 30L);
        this.check(epochMillis, LocalTime.of(2, 45, 0), 2L, 45L);
        this.check(epochMillis, LocalTime.of(3, 0, 0), 4L, 0L);
        this.check(epochMillis, LocalTime.of(4, 0, 0), 5L, 0L);
        this.check(epochMillis, LocalTime.of(23, 15, 0), 24L, 15L);
        zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-10-29T02:00:00"), SUMMER_OFFSET, BERLIN_ZONE_ID);
        epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(2, 0, 0), 25L, 0L);
        this.check(epochMillis, LocalTime.of(2, 15, 0), 0L, 15L);
        this.check(epochMillis, LocalTime.of(2, 30, 0), 0L, 30L);
        this.check(epochMillis, LocalTime.of(2, 45, 0), 0L, 45L);
        zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-10-29T02:30:00"), SUMMER_OFFSET, BERLIN_ZONE_ID);
        epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(2, 15, 0), 24L, 45L);
        this.check(epochMillis, LocalTime.of(2, 30, 0), 25L, 0L);
        zonedDateTime = ZonedDateTime.ofStrict(LocalDateTime.parse("2023-10-29T02:00:00"), WINTER_OFFSET, BERLIN_ZONE_ID);
        epochMillis = zonedDateTime.toInstant().toEpochMilli();
        this.check(epochMillis, LocalTime.of(2, 0, 0), 24L, 0L);
        this.check(epochMillis, LocalTime.of(2, 15, 0), 24L, 15L);
        this.check(epochMillis, LocalTime.of(2, 30, 0), 24L, 30L);
        this.check(epochMillis, LocalTime.of(2, 45, 0), 24L, 45L);
    }

    private void check(long timeMiles, LocalTime localTime, long hours, long minutes) {
        long dailyTime = TimeUtil.computeDailyTime((long)timeMiles, (LocalTime)localTime, (ZoneId)BERLIN_ZONE_ID);
        long actualMinutes = TimeUnit.MILLISECONDS.toMinutes(Instant.ofEpochMilli(dailyTime).toEpochMilli() - timeMiles);
        Assert.assertEquals((long)(TimeUnit.HOURS.toMinutes(hours) + minutes), (long)actualMinutes);
    }

    @Test
    public void testComputeDaily() {
        LocalTime _00_00 = LocalTime.of(0, 0, 0);
        LocalTime _01_30 = LocalTime.of(1, 30, 0);
        LocalTime _02_00 = LocalTime.of(2, 0, 0);
        LocalTime _02_01 = LocalTime.of(2, 1, 0);
        LocalTime _02_59 = LocalTime.of(2, 59, 0);
        LocalTime _03_00 = LocalTime.of(3, 0, 0);
        LocalTime _08_30 = LocalTime.of(8, 30, 0);
        LocalTime _23_59 = LocalTime.of(23, 59, 0);
        this.checkComputeDaily(_00_00, "2023-01-09 00:00", "2023-01-10 00:00", "2023-01-11 00:00", "2023-01-12 00:00");
        this.checkComputeDaily(_01_30, "2023-01-09 01:30", "2023-01-10 01:30", "2023-01-11 01:30", "2023-01-12 01:30");
        this.checkComputeDaily(_02_00, "2023-01-09 02:00", "2023-01-10 02:00", "2023-01-11 02:00", "2023-01-12 02:00");
        this.checkComputeDaily(_02_01, "2023-01-09 02:01", "2023-01-10 02:01", "2023-01-11 02:01", "2023-01-12 02:01");
        this.checkComputeDaily(_02_59, "2023-01-09 02:59", "2023-01-10 02:59", "2023-01-11 02:59", "2023-01-12 02:59");
        this.checkComputeDaily(_03_00, "2023-01-09 03:00", "2023-01-10 03:00", "2023-01-11 03:00", "2023-01-12 03:00");
        this.checkComputeDaily(_08_30, "2023-01-09 08:30", "2023-01-10 08:30", "2023-01-11 08:30", "2023-01-12 08:30");
        this.checkComputeDaily(_23_59, "2023-01-09 23:59", "2023-01-10 23:59", "2023-01-11 23:59", "2023-01-12 23:59");
        this.checkComputeDaily(_00_00, "2023-03-24 00:00", "2023-03-25 00:00", "2023-03-26 00:00", "2023-03-27 00:00");
        this.checkComputeDaily(_01_30, "2023-03-24 01:30", "2023-03-25 01:30", "2023-03-26 01:30", "2023-03-27 01:30");
        this.checkComputeDaily(_02_00, "2023-03-24 02:00", "2023-03-25 02:00", "2023-03-26 02:00", "2023-03-27 02:00");
        this.checkComputeDaily(_02_01, "2023-03-24 02:01", "2023-03-25 02:01", "2023-03-26 02:00", "2023-03-27 02:01");
        this.checkComputeDaily(_02_59, "2023-03-24 02:59", "2023-03-25 02:59", "2023-03-26 02:00", "2023-03-27 02:59");
        this.checkComputeDaily(_03_00, "2023-03-24 03:00", "2023-03-25 03:00", "2023-03-26 02:00", "2023-03-27 03:00");
        this.checkComputeDaily(_08_30, "2023-03-24 08:30", "2023-03-25 08:30", "2023-03-26 07:30", "2023-03-27 08:30");
        this.checkComputeDaily(_23_59, "2023-03-24 23:59", "2023-03-25 23:59", "2023-03-26 22:59", "2023-03-27 23:59");
        this.checkComputeDaily(_00_00, "2023-07-09 00:00", "2023-07-10 00:00", "2023-07-11 00:00", "2023-07-12 00:00");
        this.checkComputeDaily(_01_30, "2023-07-09 01:30", "2023-07-10 01:30", "2023-07-11 01:30", "2023-07-12 01:30");
        this.checkComputeDaily(_02_00, "2023-07-09 02:00", "2023-07-10 02:00", "2023-07-11 02:00", "2023-07-12 02:00");
        this.checkComputeDaily(_02_01, "2023-07-09 02:01", "2023-07-10 02:01", "2023-07-11 02:01", "2023-07-12 02:01");
        this.checkComputeDaily(_02_59, "2023-07-09 02:59", "2023-07-10 02:59", "2023-07-11 02:59", "2023-07-12 02:59");
        this.checkComputeDaily(_03_00, "2023-07-09 03:00", "2023-07-10 03:00", "2023-07-11 03:00", "2023-07-12 03:00");
        this.checkComputeDaily(_08_30, "2023-07-09 08:30", "2023-07-10 08:30", "2023-07-11 08:30", "2023-07-12 08:30");
        this.checkComputeDaily(_23_59, "2023-07-09 23:59", "2023-07-10 23:59", "2023-07-11 23:59", "2023-07-12 23:59");
        this.checkComputeDaily(_00_00, "2023-10-27 00:00", "2023-10-28 00:00", "2023-10-29 00:00", "2023-10-30 00:00");
        this.checkComputeDaily(_01_30, "2023-10-27 01:30", "2023-10-28 01:30", "2023-10-29 01:30", "2023-10-30 01:30");
        this.checkComputeDaily(_02_00, "2023-10-27 02:00", "2023-10-28 02:00", "2023-10-29 02:00", "2023-10-30 02:00");
        this.checkComputeDaily(_02_01, "2023-10-27 02:01", "2023-10-28 02:01", "2023-10-29 02:01", "2023-10-30 02:01");
        this.checkComputeDaily(_02_59, "2023-10-27 02:59", "2023-10-28 02:59", "2023-10-29 02:59", "2023-10-30 02:59");
        this.checkComputeDaily(_03_00, "2023-10-27 03:00", "2023-10-28 03:00", "2023-10-29 04:00", "2023-10-30 03:00");
        this.checkComputeDaily(_08_30, "2023-10-27 08:30", "2023-10-28 08:30", "2023-10-29 09:30", "2023-10-30 08:30");
        this.checkComputeDaily(_23_59, "2023-10-27 23:59", "2023-10-28 23:59", "2023-10-29 24:59", "2023-10-30 23:59");
    }

    private void checkComputeDaily(LocalTime localTime, String ... points) {
        long[] times = Arrays.stream(points).mapToLong(TimeUtilTest::parsePoint).toArray();
        for (int i = 1; i < times.length; ++i) {
            long delta = times[i] - times[i - 1];
            Assert.assertTrue((String)"bad test points", (delta >= 82800000L && delta <= 90000000L ? 1 : 0) != 0);
            for (long currentTime = times[i - 1]; currentTime < times[i]; currentTime += 600000L) {
                long computed = TimeUtil.computeDailyTime((long)currentTime, (LocalTime)localTime, (ZoneId)BERLIN_ZONE_ID);
                if (computed == times[i]) continue;
                Assert.assertEquals((String)("computeDailyTime(" + TimeUtilTest.formatTime(currentTime) + ", " + localTime + ")"), (Object)TimeUtilTest.formatTime(times[i]), (Object)TimeUtilTest.formatTime(computed));
            }
        }
    }

    private static long parsePoint(String point) {
        Assert.assertTrue((String)("bad point format " + point), (boolean)point.matches("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}"));
        int[] v = Arrays.stream(point.split("[^0-9]")).mapToInt(Integer::parseInt).toArray();
        ZonedDateTime z = ZonedDateTime.of(v[0], v[1], v[2], 0, 0, 0, 0, BERLIN_ZONE_ID);
        return (z.toEpochSecond() + (long)(v[3] * 3600) + (long)(v[4] * 60)) * 1000L;
    }

    private static String formatTime(long time) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), BERLIN_ZONE_ID).toString();
    }
}

