/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.StreamCompression;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class StreamCompressionTest {
    @Test
    public void testString() {
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.valueOf((String)"NONE"));
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.valueOf((String)"None"));
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.valueOf((String)"none"));
        Assert.assertEquals((Object)StreamCompression.GZIP, (Object)StreamCompression.valueOf((String)"GZIP"));
        Assert.assertEquals((Object)StreamCompression.GZIP, (Object)StreamCompression.valueOf((String)"GZip"));
        Assert.assertEquals((Object)StreamCompression.GZIP, (Object)StreamCompression.valueOf((String)"gzip"));
        Assert.assertEquals((Object)StreamCompression.ZIP, (Object)StreamCompression.valueOf((String)"ZIP"));
        Assert.assertEquals((Object)StreamCompression.ZIP, (Object)StreamCompression.valueOf((String)"Zip"));
        Assert.assertEquals((Object)StreamCompression.ZIP, (Object)StreamCompression.valueOf((String)"zip"));
        Assert.assertEquals((Object)"none", (Object)StreamCompression.NONE.toString());
        Assert.assertEquals((Object)"gzip", (Object)StreamCompression.GZIP.toString());
        Assert.assertEquals((Object)"zip", (Object)StreamCompression.ZIP.toString());
        Assert.assertEquals((Object)"zip[level=5]", (Object)StreamCompression.valueOf((String)"zip[level=5]").toString());
        Assert.assertEquals((Object)"gzip[level=8]", (Object)StreamCompression.valueOf((String)"gzip[level=8]").toString());
        Assert.assertEquals((Object)"gzip[level=1]", (Object)StreamCompression.valueOf((String)"gzip[level=1]").toString());
    }

    @Test
    public void testMimeType() {
        Assert.assertNull((Object)StreamCompression.NONE.getMimeType());
        Assert.assertEquals((Object)"application/gzip", (Object)StreamCompression.GZIP.getMimeType());
        Assert.assertEquals((Object)"application/zip", (Object)StreamCompression.ZIP.getMimeType());
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.detectCompressionByMimeType((String)"text/plain"));
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.detectCompressionByMimeType((String)"application/octet-stream"));
        Assert.assertEquals((Object)StreamCompression.GZIP, (Object)StreamCompression.detectCompressionByMimeType((String)"application/x-gzip"));
        Assert.assertEquals((Object)StreamCompression.GZIP, (Object)StreamCompression.detectCompressionByMimeType((String)"application/gzip"));
        Assert.assertEquals((Object)StreamCompression.ZIP, (Object)StreamCompression.detectCompressionByMimeType((String)"application/zip"));
    }

    @Test
    public void testExtension() {
        Assert.assertEquals((Object)"", (Object)StreamCompression.NONE.getExtension());
        Assert.assertEquals((Object)".gz", (Object)StreamCompression.GZIP.getExtension());
        Assert.assertEquals((Object)".zip", (Object)StreamCompression.ZIP.getExtension());
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.detectCompressionByExtension((String)"filename"));
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.detectCompressionByExtension((String)"file.txt"));
        Assert.assertEquals((Object)StreamCompression.NONE, (Object)StreamCompression.detectCompressionByExtension((String)"file.bin"));
        Assert.assertEquals((Object)StreamCompression.GZIP, (Object)StreamCompression.detectCompressionByExtension((String)"file.gz"));
        Assert.assertEquals((Object)StreamCompression.ZIP, (Object)StreamCompression.detectCompressionByExtension((String)"file.zip"));
    }

    @Test
    public void testNoneCompression() throws IOException {
        this.checkCompression(StreamCompression.NONE, "This is a test");
        this.checkCompression(StreamCompression.NONE, "");
    }

    @Test
    public void testGZipCompression() throws IOException {
        this.checkCompression(StreamCompression.GZIP, "This is a test");
        this.checkCompression(StreamCompression.GZIP, "");
    }

    @Test
    public void testZipCompression() throws IOException {
        this.checkCompression(StreamCompression.ZIP, "This is a test");
        this.checkCompression(StreamCompression.ZIP, "");
    }

    private void checkCompression(StreamCompression compression, String testString) throws IOException {
        int r;
        byte[] testBytes = testString.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutput out = new ByteArrayOutput();
        OutputStream cOut = compression.compress((OutputStream)out, "test");
        cOut.write(testBytes);
        cOut.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray()){

            @Override
            public synchronized int read(byte[] b, int off, int len) {
                return super.read(b, off, len > 0 ? 1 : len);
            }
        };
        Assert.assertEquals((Object)compression, (Object)StreamCompression.detectCompressionByHeader((InputStream)in));
        InputStream cIn = compression.decompress((InputStream)in);
        byte[] readBytes = new byte[testBytes.length * 2];
        int readNoBytes = 0;
        while ((r = cIn.read(readBytes, readNoBytes, readBytes.length - readNoBytes)) > 0 && (readNoBytes += r) < readBytes.length) {
        }
        Assert.assertEquals((long)testBytes.length, (long)readNoBytes);
        Assert.assertEquals((Object)testString, (Object)new String(readBytes, 0, readNoBytes, StandardCharsets.UTF_8));
        Assert.assertEquals((long)-1L, (long)cIn.read());
        cIn.close();
    }
}

