/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.CSVFormatException;
import com.devexperts.io.CSVReader;
import com.devexperts.io.CSVWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CSVTest {
    @Test
    public void testReader() {
        CSVReader r;
        try {
            r = new CSVReader((Reader)new StringReader("aaa,\"bbb\"\n,ccc,\n\nddd\r\"\"\r\nfff"));
            Assert.assertTrue((r.getLineNumber() == 1 && r.getRecordNumber() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)r.readField(), (Object)"aaa");
            Assert.assertEquals((Object)r.readField(), (Object)"bbb");
            Assert.assertNull((Object)r.readField());
            Assert.assertNull((Object)r.readField());
            Assert.assertTrue((r.getLineNumber() == 1 && r.getRecordNumber() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals(r.readRecord(), new String[0]));
            Assert.assertTrue((r.getLineNumber() == 2 && r.getRecordNumber() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals(r.readRecord(), new String[]{"", "ccc", ""}));
            Assert.assertTrue((r.getLineNumber() == 3 && r.getRecordNumber() == 3 ? 1 : 0) != 0);
            Assert.assertEquals((Object)r.readField(), (Object)"");
            Assert.assertNull((Object)r.readField());
            Assert.assertNull((Object)r.readField());
            Assert.assertTrue((r.getLineNumber() == 3 && r.getRecordNumber() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals(r.readRecord(), new String[0]));
            Assert.assertTrue((r.getLineNumber() == 4 && r.getRecordNumber() == 4 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals(r.readRecord(), new String[]{"ddd"}));
            Assert.assertTrue((r.getLineNumber() == 5 && r.getRecordNumber() == 5 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals(r.readRecord(), new String[]{""}));
            Assert.assertTrue((r.getLineNumber() == 6 && r.getRecordNumber() == 6 ? 1 : 0) != 0);
            Assert.assertEquals((Object)r.readField(), (Object)"fff");
            Assert.assertNull((Object)r.readField());
            Assert.assertTrue((r.getLineNumber() == 6 && r.getRecordNumber() == 6 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals(r.readRecord(), new String[0]));
            Assert.assertTrue((r.getLineNumber() == 6 && r.getRecordNumber() == 7 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Arrays.equals(r.readRecord(), null));
            Assert.assertTrue((r.getLineNumber() == 6 && r.getRecordNumber() == 7 ? 1 : 0) != 0);
            r.close();
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            r = new CSVReader((Reader)new StringReader("aaa,bbb\"ccc\",ddd"));
            Assert.assertEquals((Object)r.readField(), (Object)"aaa");
            r.readField();
            Assert.fail();
        }
        catch (CSVFormatException r2) {
        }
        catch (IOException ee) {
            Assert.fail();
        }
        try {
            r = new CSVReader((Reader)new StringReader("aaa,\"bbb\"ccc,ddd"));
            Assert.assertEquals((Object)r.readField(), (Object)"aaa");
            r.readField();
            Assert.fail();
        }
        catch (CSVFormatException r3) {
        }
        catch (IOException ee) {
            Assert.fail();
        }
    }

    @Test
    public void testWriter() {
        try {
            StringWriter sw = new StringWriter();
            CSVWriter w = new CSVWriter((Writer)sw);
            Assert.assertTrue((w.getLineNumber() == 1 && w.getRecordNumber() == 1 ? 1 : 0) != 0);
            w.writeField("aaa");
            w.writeField("bbb");
            Assert.assertTrue((w.getLineNumber() == 1 && w.getRecordNumber() == 1 ? 1 : 0) != 0);
            w.writeRecord(null);
            Assert.assertTrue((w.getLineNumber() == 1 && w.getRecordNumber() == 2 ? 1 : 0) != 0);
            w.writeRecord(new String[]{"", "ccc", null});
            Assert.assertTrue((w.getLineNumber() == 2 && w.getRecordNumber() == 3 ? 1 : 0) != 0);
            w.writeField(null);
            w.writeRecord(new String[0]);
            Assert.assertTrue((w.getLineNumber() == 3 && w.getRecordNumber() == 4 ? 1 : 0) != 0);
            w.writeRecord(new String[]{"ddd"});
            Assert.assertTrue((w.getLineNumber() == 4 && w.getRecordNumber() == 5 ? 1 : 0) != 0);
            w.writeField("fff");
            Assert.assertTrue((w.getLineNumber() == 5 && w.getRecordNumber() == 5 ? 1 : 0) != 0);
            w.writeRecord(null);
            Assert.assertTrue((w.getLineNumber() == 5 && w.getRecordNumber() == 6 ? 1 : 0) != 0);
            w.close();
            Assert.assertEquals((Object)sw.toString(), (Object)"aaa,bbb\r\n,ccc,\r\n\r\nddd\r\nfff");
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void testPipe() {
        this.testPipe("", 1);
        this.testPipe("\r\n", 2);
        this.testPipe(",", 1);
        this.testPipe(",,,", 1);
        this.testPipe(",,\r\n", 2);
        this.testPipe("aaa,bbb\r\n,ccc,\r\n\r\nddd\r\nfff", 5);
    }

    private void testPipe(String s, int count) {
        try {
            CSVReader r = new CSVReader((Reader)new StringReader(s));
            List records = r.readAll();
            r.close();
            Assert.assertEquals((long)records.size(), (long)count);
            StringWriter sw = new StringWriter();
            CSVWriter w = new CSVWriter((Writer)sw);
            w.writeAll(records);
            w.close();
            Assert.assertEquals((Object)sw.toString(), (Object)s);
        }
        catch (IOException e) {
            Assert.fail();
        }
    }
}

