/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import com.devexperts.io.ChunkedInput;
import com.devexperts.io.ChunkedOutput;
import java.io.IOException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ChunkedInputOutputTest {
    private static final int MAGIC = (int)Math.round((Math.sqrt(5.0) - 1.0) / 2.0 * 4.294967296E9);
    public static final int CHUNK_SIZE = 8192;
    private static final int ITERATIONS = 1000;

    @Test
    public void testInputBytes() throws IOException {
        ChunkedInput in = new ChunkedInput();
        Random r0 = new Random(20121226L);
        Random r1 = new Random(20121226L);
        Random r2 = new Random(20121226L);
        int total = 0;
        int checked = 0;
        for (int i = 0; i < 1000; ++i) {
            Chunk chunk = ChunkPool.DEFAULT.getChunk((Object)this);
            byte[] bytes = chunk.getBytes();
            Assert.assertEquals((long)0L, (long)chunk.getOffset());
            Assert.assertEquals((long)8192L, (long)chunk.getLength());
            Assert.assertEquals((long)8192L, (long)bytes.length);
            int ofs = r0.nextInt(8190);
            int len = r0.nextInt(8192 - ofs - 1) + 1;
            for (int j = 0; j < len; ++j) {
                bytes[ofs + j] = (byte)r1.nextInt(256);
            }
            chunk.setRange(ofs, len, (Object)this);
            in.addToInput(chunk, (Object)this);
            Assert.assertEquals((long)checked, (long)in.totalPosition());
            Assert.assertEquals((long)((total += len) - checked), (long)in.available());
            Assert.assertEquals((Object)(total - checked != 0 ? 1 : 0), (Object)in.hasAvailable());
            int checkLen = i == 999 ? total - checked : r0.nextInt(total - checked + 1);
            for (int j = 0; j < checkLen; ++j) {
                Assert.assertEquals((long)r2.nextInt(256), (long)in.read());
            }
            Assert.assertEquals((long)(checked += checkLen), (long)in.totalPosition());
            Assert.assertEquals((long)(total - checked), (long)in.available());
            Assert.assertEquals((Object)(total - checked != 0 ? 1 : 0), (Object)in.hasAvailable());
        }
    }

    @Test
    public void testInputMark() throws IOException {
        ChunkedInput in = new ChunkedInput();
        int size1 = 28672;
        in.addToInput(this.fill(new byte[size1], 0), 0, size1);
        Assert.assertEquals((long)size1, (long)in.available());
        Assert.assertEquals((long)0L, (long)in.totalPosition());
        in.mark();
        byte[] buf1 = new byte[size1];
        in.readFully(buf1);
        Assert.assertEquals((long)0L, (long)in.available());
        Assert.assertEquals((long)size1, (long)in.totalPosition());
        this.verifyFillAndClear(buf1, 0);
        in.reset();
        Assert.assertEquals((long)size1, (long)in.available());
        Assert.assertEquals((long)0L, (long)in.totalPosition());
        in.readFully(buf1);
        Assert.assertEquals((long)0L, (long)in.available());
        Assert.assertEquals((long)size1, (long)in.totalPosition());
        this.verifyFillAndClear(buf1, 0);
        in.reset();
        Assert.assertEquals((long)size1, (long)in.available());
        Assert.assertEquals((long)0L, (long)in.totalPosition());
        in.readFully(buf1);
        Assert.assertEquals((long)0L, (long)in.available());
        Assert.assertEquals((long)size1, (long)in.totalPosition());
        this.verifyFillAndClear(buf1, 0);
        int size2 = size1 / 2;
        byte[] buf2 = new byte[size2];
        in.reset();
        Assert.assertEquals((long)size1, (long)in.available());
        Assert.assertEquals((long)0L, (long)in.totalPosition());
        in.readFully(buf2);
        Assert.assertEquals((long)size2, (long)in.available());
        Assert.assertEquals((long)size2, (long)in.totalPosition());
        this.verifyFillAndClear(buf2, 0);
        in.mark();
        Assert.assertEquals((long)size2, (long)in.available());
        Assert.assertEquals((long)size2, (long)in.totalPosition());
        in.readFully(buf2);
        Assert.assertEquals((long)0L, (long)in.available());
        Assert.assertEquals((long)size1, (long)in.totalPosition());
        this.verifyFillAndClear(buf2, size2);
        in.reset();
        Assert.assertEquals((long)size2, (long)in.available());
        Assert.assertEquals((long)size2, (long)in.totalPosition());
        in.readFully(buf2);
        Assert.assertEquals((long)0L, (long)in.available());
        Assert.assertEquals((long)size1, (long)in.totalPosition());
        this.verifyFillAndClear(buf2, size2);
        in.reset();
        Assert.assertEquals((long)size2, (long)in.available());
        Assert.assertEquals((long)size2, (long)in.totalPosition());
        in.readFully(buf2);
        Assert.assertEquals((long)0L, (long)in.available());
        Assert.assertEquals((long)size1, (long)in.totalPosition());
        this.verifyFillAndClear(buf2, size2);
    }

    @Test
    public void testWriteChunks() throws IOException {
        ChunkedOutput out1 = new ChunkedOutput();
        ChunkedOutput out2 = new ChunkedOutput();
        int size1 = 28672;
        out1.write(this.fill(new byte[size1], 0));
        Assert.assertEquals((long)size1, (long)out1.totalPosition());
        int size2 = 18841;
        out2.write(this.fill(new byte[size2], size1));
        Assert.assertEquals((long)size2, (long)out2.totalPosition());
        ChunkList chunks = out2.getOutput((Object)this);
        Assert.assertEquals((long)size2, (long)chunks.getTotalLength());
        out1.writeAllFromChunkList(chunks, (Object)this);
        Assert.assertEquals((long)(size1 + size2), (long)out1.totalPosition());
        Assert.assertEquals((long)size2, (long)out2.totalPosition());
        int size3 = 17203;
        out1.write(this.fill(new byte[size3], size1 + size2));
        Assert.assertEquals((long)(size1 + size2 + size3), (long)out1.totalPosition());
        ChunkedInput in = new ChunkedInput();
        chunks = out1.getOutput((Object)this);
        Assert.assertEquals((long)(size1 + size2 + size3), (long)chunks.getTotalLength());
        in.addAllToInput(chunks, (Object)this);
        Assert.assertEquals((long)(size1 + size2 + size3), (long)out1.totalPosition());
        Assert.assertEquals((long)(size1 + size2 + size3), (long)in.available());
        byte[] buf = new byte[size1 + size2 + size3];
        in.readFully(buf);
        this.verifyFillAndClear(buf, 0);
    }

    private byte[] fill(byte[] buf, int offset) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = ChunkedInputOutputTest.rndByteAtOffset(i + offset);
        }
        return buf;
    }

    private void verifyFillAndClear(byte[] buf, int offset) {
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            byte x = ChunkedInputOutputTest.rndByteAtOffset(i + offset);
            if (b != x) {
                Assert.fail((String)("buf[" + i + "]: " + b + " != " + x));
            }
            buf[i] = 0;
        }
    }

    private static byte rndByteAtOffset(int offset) {
        return (byte)(offset * MAGIC >>> 24);
    }
}

