/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.BufferedInput;
import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.ChunkPool;
import com.devexperts.io.ChunkedInput;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.io.StreamInput;
import com.devexperts.io.StreamOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class IOTest {
    @Test
    public void testIO() throws IOException {
        List<Item> items = IOTest.makeItems();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(baos);
        for (Item item : items) {
            item.writeDataOutput(dout);
        }
        byte[] bytes = baos.toByteArray();
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(bytes));
        for (Item item : items) {
            item.readDataInput(din);
        }
        ByteArrayOutput bout = new ByteArrayOutput();
        dout = new DataOutputStream((OutputStream)bout);
        for (Item item : items) {
            item.writeDataOutput(dout);
        }
        IOTest.assertArrayEquals(bytes, bout.toByteArray());
        din = new DataInputStream((InputStream)new ByteArrayInput(bytes));
        for (Item item : items) {
            item.readDataInput(din);
        }
        bout = new ByteArrayOutput();
        for (Item item : items) {
            item.writeBufferedOutput((BufferedOutput)bout);
        }
        IOTest.assertArrayEquals(bytes, bout.toByteArray());
        ByteArrayInput byteArrayInput = new ByteArrayInput(bytes);
        for (Item item : items) {
            item.readBufferedInput((BufferedInput)byteArrayInput);
        }
        baos = new ByteArrayOutputStream();
        StreamOutput streamOutput = new StreamOutput((OutputStream)baos);
        for (Item item : items) {
            item.writeBufferedOutput((BufferedOutput)streamOutput);
        }
        streamOutput.flush();
        IOTest.assertArrayEquals(bytes, baos.toByteArray());
        StreamInput streamInput = new StreamInput((InputStream)new ByteArrayInputStream(bytes));
        for (Item item : items) {
            item.readBufferedInput((BufferedInput)streamInput);
        }
        ChunkedOutput chunkedOutput = new ChunkedOutput(ChunkPool.DEFAULT);
        for (Item item : items) {
            item.writeBufferedOutput((BufferedOutput)chunkedOutput);
        }
        ChunkedInput chunkedInput = new ChunkedInput();
        chunkedInput.addAllToInput(chunkedOutput.getOutput((Object)this), (Object)this);
        chunkedInput.mark();
        bout = new ByteArrayOutput();
        Assert.assertEquals((long)bytes.length, (long)chunkedInput.readToOutputStream((OutputStream)bout, (long)bytes.length));
        Assert.assertFalse((boolean)chunkedInput.hasAvailable());
        IOTest.assertArrayEquals(bytes, bout.toByteArray());
        chunkedInput.rewind((long)bytes.length);
        for (Item item : items) {
            item.readBufferedInput((BufferedInput)chunkedInput);
        }
    }

    private static List<Item> makeItems() {
        int i;
        Random r = new Random(20081221L);
        ArrayList<Item> items = new ArrayList<Item>();
        IOTest.addLong(items, 0L);
        IOTest.addLong(items, Long.MAX_VALUE);
        IOTest.addLong(items, Long.MIN_VALUE);
        IOTest.addInt(items, 0);
        IOTest.addInt(items, Integer.MAX_VALUE);
        IOTest.addInt(items, Integer.MIN_VALUE);
        items.add(new UTFChar(0));
        items.add(new UTFChar(0x10FFFF));
        for (i = 0; i < 10000; ++i) {
            int len = r.nextInt(62) + 1;
            long num = (r.nextLong() & (1L << len) - 1L | 1L << len) * (long)(r.nextInt(2) * 2 - 1);
            IOTest.addLong(items, num);
            int inum = (int)num;
            if ((long)inum != num) continue;
            IOTest.addInt(items, inum);
            if (inum < 0 || inum > 0x10FFFF) continue;
            items.add(new UTFChar(inum));
        }
        IOTest.addString(items, null);
        IOTest.addString(items, "");
        for (i = 0; i < 100; ++i) {
            int slen = r.nextInt(100);
            StringBuilder sb = new StringBuilder(slen);
            for (int j = 0; j < slen; ++j) {
                int len = r.nextInt(15) + 1;
                char ch = (char)(r.nextInt(1 << len) | 1 << len);
                sb.append(ch);
            }
            String s = sb.toString();
            IOTest.addString(items, s);
        }
        items.add(new ByteArray(null));
        items.add(new ByteArray(new byte[0]));
        items.add(new ByteArray(new byte[]{1, 0, -1, 111, 127, -128}));
        items.add(new ObjectItem(null));
        items.add(new ObjectItem(123));
        items.add(new ObjectItem("hi there!"));
        items.add(new ObjectItem(Arrays.asList(1, 2, 3, Integer.MAX_VALUE, -1, 0, Integer.MIN_VALUE)));
        Collections.shuffle(items, r);
        return items;
    }

    private static void addString(List<Item> items, String s) {
        if (s != null) {
            items.add(new UTF(s));
        }
        items.add(new UTFString(s));
        items.add(new CharArray(s));
        items.add(new CharArrayString(s));
    }

    private static void addInt(List<Item> items, int inum) {
        items.add(new CompactInt(inum));
        items.add(new PlainInt(inum));
    }

    private static void addLong(List<Item> items, long num) {
        items.add(new CompactLong(num));
        items.add(new PlainLong(num));
    }

    private static void assertArrayEquals(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return;
        }
        Assert.assertEquals((long)a1.length, (long)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            Assert.assertEquals((long)a1[i], (long)a2[i]);
        }
    }

    private static void assertArrayEquals(char[] a1, char[] a2) {
        if (a1 == a2) {
            return;
        }
        Assert.assertEquals((long)a1.length, (long)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            Assert.assertEquals((long)a1[i], (long)a2[i]);
        }
    }

    @Test
    public void testPropertiesIO() throws IOException {
        ByteArrayOutput out = new ByteArrayOutput();
        LinkedHashMap<String, String> source = new LinkedHashMap<String, String>();
        source.put("k1", "v1");
        source.put("k2", "v2");
        out.writeProperties(source);
        out.writeCompactInt(42);
        ByteArrayInput in = new ByteArrayInput(out.toByteArray());
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("xxx", "yyy");
        in.readProperties(props);
        Assert.assertEquals((long)(source.size() + 1), (long)props.size());
        Iterator it = props.entrySet().iterator();
        Map.Entry entry = it.next();
        Assert.assertEquals((Object)"xxx", entry.getKey());
        Assert.assertEquals((Object)"yyy", entry.getValue());
        source.entrySet().forEach(e -> Assert.assertEquals((Object)e, it.next()));
        Assert.assertEquals((long)42L, (long)in.readCompactInt());
    }

    private static class ObjectItem
    extends Item {
        final Object o;

        ObjectItem(Object o) {
            this.o = o;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeObject((DataOutput)out, (Object)this.o);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeObject(this.o);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((Object)this.o, (Object)IOUtil.readObject((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((Object)this.o, (Object)in.readObject());
        }
    }

    private static class CharArrayString
    extends Item {
        final String s;

        CharArrayString(String s) {
            this.s = s;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeCharArray((DataOutput)out, (String)this.s);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            IOUtil.writeCharArray((DataOutput)out, (String)this.s);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((Object)this.s, (Object)IOUtil.readCharArrayString((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((Object)this.s, (Object)IOUtil.readCharArrayString((DataInput)in));
        }
    }

    private static class CharArray
    extends Item {
        final char[] chars;

        CharArray(String s) {
            this.chars = s == null ? null : s.toCharArray();
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeCharArray((DataOutput)out, (char[])this.chars);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            IOUtil.writeCharArray((DataOutput)out, (char[])this.chars);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            IOTest.assertArrayEquals(this.chars, IOUtil.readCharArray((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            IOTest.assertArrayEquals(this.chars, IOUtil.readCharArray((DataInput)in));
        }
    }

    private static class ByteArray
    extends Item {
        final byte[] b;

        ByteArray(byte[] b) {
            this.b = b;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeByteArray((DataOutput)out, (byte[])this.b);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeByteArray(this.b);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            IOTest.assertArrayEquals(this.b, IOUtil.readByteArray((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            IOTest.assertArrayEquals(this.b, in.readByteArray());
        }
    }

    private static class UTFString
    extends Item {
        final String s;

        UTFString(String s) {
            this.s = s;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeUTFString((DataOutput)out, (String)this.s);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeUTFString(this.s);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((Object)this.s, (Object)IOUtil.readUTFString((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((Object)this.s, (Object)in.readUTFString());
        }
    }

    private static class UTF
    extends Item {
        final String s;

        UTF(String s) {
            this.s = s;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            out.writeUTF(this.s);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeUTF(this.s);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((Object)this.s, (Object)in.readUTF());
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((Object)this.s, (Object)in.readUTF());
        }
    }

    private static class CompactLong
    extends Item {
        final long l;

        CompactLong(long l) {
            this.l = l;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeCompactLong((DataOutput)out, (long)this.l);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeCompactLong(this.l);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((long)this.l, (long)IOUtil.readCompactLong((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((long)this.l, (long)in.readCompactLong());
        }
    }

    private static class PlainLong
    extends Item {
        final long l;

        PlainLong(long l) {
            this.l = l;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            out.writeLong(this.l);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeLong(this.l);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((long)this.l, (long)in.readLong());
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((long)this.l, (long)in.readLong());
        }
    }

    private static class UTFChar
    extends Item {
        final int i;

        UTFChar(int i) {
            this.i = i;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeUTFChar((DataOutput)out, (int)this.i);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeUTFChar(this.i);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((long)this.i, (long)IOUtil.readUTFChar((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((long)this.i, (long)in.readUTFChar());
        }
    }

    private static class CompactInt
    extends Item {
        final int i;

        CompactInt(int i) {
            this.i = i;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            IOUtil.writeCompactInt((DataOutput)out, (int)this.i);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeCompactInt(this.i);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((long)this.i, (long)IOUtil.readCompactInt((DataInput)in));
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((long)this.i, (long)in.readCompactInt());
        }
    }

    private static class PlainInt
    extends Item {
        final int i;

        PlainInt(int i) {
            this.i = i;
        }

        @Override
        void writeDataOutput(DataOutput out) throws IOException {
            out.writeInt(this.i);
        }

        @Override
        void writeBufferedOutput(BufferedOutput out) throws IOException {
            out.writeInt(this.i);
        }

        @Override
        void readDataInput(DataInput in) throws IOException {
            Assert.assertEquals((long)this.i, (long)in.readInt());
        }

        @Override
        void readBufferedInput(BufferedInput in) throws IOException {
            Assert.assertEquals((long)this.i, (long)in.readInt());
        }
    }

    private static abstract class Item {
        Item() {
        }

        abstract void writeDataOutput(DataOutput var1) throws IOException;

        abstract void writeBufferedOutput(BufferedOutput var1) throws IOException;

        abstract void readDataInput(DataInput var1) throws IOException;

        abstract void readBufferedInput(BufferedInput var1) throws IOException;
    }
}

