/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.logging.test;

import com.devexperts.logging.Logging;
import com.devexperts.logging.test.LogFormatterTestBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JavaUtilLoggingCompatibilityTest
extends LogFormatterTestBase {
    private static final Level DEBUG = Level.FINE;
    private static final Level ERROR = Level.SEVERE;
    private static final Level TRACE = Level.FINEST;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File logFile;

    @Before
    public void setUp() throws Exception {
        System.setProperty("log.className", "com.devexperts.logging.DefaultLogging");
        this.initLogFormatter();
        try (InputStream cfgIS = this.getClass().getResourceAsStream("/test.logging.properties");){
            LogManager.getLogManager().readConfiguration(cfgIS);
        }
        File logBase = new File(this.tempFolder.getRoot(), "test.log");
        Logging.configureLogFile((String)logBase.getPath());
        this.logFile = new File(logBase.getPath() + ".0");
        Assert.assertTrue((boolean)this.logFile.exists());
    }

    protected void initLogFormatter() {
        System.setProperty("logformatter.properties", JavaUtilLoggingCompatibilityTest.class.getResource("/test.logformatter.properties").toExternalForm());
    }

    @Test
    public void testJavaUtilLogging() throws IOException {
        Logger logger = Logger.getLogger(JavaUtilLoggingCompatibilityTest.class.getName());
        String javaRuntimeVersion = System.getProperty("java.runtime.name", "?") + " " + System.getProperty("java.runtime.version") + " by " + System.getProperty("java.vendor");
        String javaLoggingMessage = "Java runtime: ";
        String testMessage = "Test java.util.logging message";
        logger.fine(javaLoggingMessage + javaRuntimeVersion);
        logger.fine(testMessage);
        logger.log(DEBUG, "error", new IllegalArgumentException());
        logger.fine(testMessage);
        String content = JavaUtilLoggingCompatibilityTest.loadFile(this.logFile);
        Assert.assertTrue((String)("'" + javaLoggingMessage + "' not found in the log"), (boolean)content.contains(javaLoggingMessage));
        Assert.assertTrue((String)("'" + testMessage + "' not found in log file"), (boolean)content.contains(testMessage));
        Assert.assertTrue((String)"Exception not found in log file", (boolean)content.contains(IllegalArgumentException.class.getName()));
        Assert.assertTrue((String)"Exception stack trace not found in log file", (boolean)content.contains("\tat " + this.getClass().getName()));
    }

    @Test
    public void testDevexpertsLogging() throws IOException {
        Logging log = Logging.getLogging(JavaUtilLoggingCompatibilityTest.class);
        log.configureDebugEnabled(true);
        String testMessage = "Test com.devexperts.logging message";
        log.debug("Test com.devexperts.logging message");
        log.debug("error", (Throwable)new IllegalArgumentException());
        log.debug("Test com.devexperts.logging message");
        String content = JavaUtilLoggingCompatibilityTest.loadFile(this.logFile);
        Assert.assertTrue((String)"'Test com.devexperts.logging message' not found in log file", (boolean)content.contains("Test com.devexperts.logging message"));
        Assert.assertTrue((String)"Exception not found in log file", (boolean)content.contains(IllegalArgumentException.class.getName()));
        Assert.assertTrue((String)"Exception stack trace not found in log file", (boolean)content.contains("\tat " + this.getClass().getName()));
    }

    @Test
    public void testConfigureDebugEnabled() throws IOException {
        this.goTestConfigureDebugEnbled(true);
    }

    @Test
    public void testConfigureDebugDisabled() throws IOException {
        this.goTestConfigureDebugEnbled(false);
    }

    private void goTestConfigureDebugEnbled(boolean defaultDebugEnabled) throws IOException {
        Logger defaultLog = Logger.getLogger("default.test");
        Logger errorLog = Logger.getLogger("default.error");
        Logger traceLog = Logger.getLogger("default.trace");
        Assert.assertEquals((Object)DEBUG, (Object)this.getEffectiveLevel(defaultLog));
        Assert.assertEquals((Object)ERROR, (Object)errorLog.getLevel());
        Assert.assertEquals((Object)TRACE, (Object)traceLog.getLevel());
        List<Logger> loggers = Arrays.asList(defaultLog, errorLog, traceLog);
        List<Level> levels = Arrays.asList(ERROR, Level.WARNING, Level.INFO, DEBUG, TRACE);
        for (Logger logger : loggers) {
            Logging.getLogging((String)logger.getName()).configureDebugEnabled(defaultDebugEnabled);
            for (Level level : levels) {
                logger.log(level, logger.getName() + "-" + level.getName());
            }
        }
        String content = JavaUtilLoggingCompatibilityTest.loadFile(this.logFile);
        if (defaultDebugEnabled) {
            loggers.forEach(l -> Assert.assertTrue((String)("Debug disabled for " + l.getName()), (boolean)Logging.getLogging((String)l.getName()).debugEnabled()));
            this.checkLevelRange(defaultLog, levels, content, ERROR, DEBUG);
            this.checkLevelRange(errorLog, levels, content, ERROR, DEBUG);
            this.checkLevelRange(traceLog, levels, content, ERROR, TRACE);
        } else {
            loggers.forEach(l -> Assert.assertFalse((String)("Debug enabled for " + l.getName()), (boolean)Logging.getLogging((String)l.getName()).debugEnabled()));
            this.checkLevelRange(defaultLog, levels, content, ERROR, Level.INFO);
            this.checkLevelRange(errorLog, levels, content, ERROR, ERROR);
            this.checkLevelRange(traceLog, levels, content, ERROR, Level.INFO);
        }
    }

    private void checkLevelRange(Logger logger, List<Level> levels, String content, Level top, Level low) {
        Assert.assertTrue((String)"A less detailed level have greater weight", (top.intValue() >= low.intValue() ? 1 : 0) != 0);
        String name = logger.getName();
        for (Level level : levels) {
            boolean expected = level.intValue() <= top.intValue() && level.intValue() >= low.intValue();
            Assert.assertEquals((String)((expected ? "Expected" : "Unexpected") + " message of level " + level + " for logger " + name), (Object)expected, (Object)content.contains(logger.getName() + "-" + level.getName()));
        }
    }

    private Level getEffectiveLevel(Logger logger) {
        while (logger != null) {
            Level level = logger.getLevel();
            if (level != null) {
                return level;
            }
            logger = logger.getParent();
        }
        throw new IllegalStateException("Missing level in the root of Logger hierarchy");
    }
}

