/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.test;

import com.devexperts.logging.Logging;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.junit.Assert;

public class ThreadCleanCheck {
    private static final Logging log = Logging.getLogging(ThreadCleanCheck.class);
    private static final long WAIT_TIME = 60000L;
    private static final ThreadLocal<Data> BEFORE = new ThreadLocal();

    public static void before() {
        ThreadCleanCheck.before("test");
    }

    public static void before(String description) {
        Set<Thread> threads = ThreadCleanCheck.getThreads();
        log.info("======== Running " + description + " (" + threads.size() + " threads before) ========");
        BEFORE.set(new Data(description, threads));
    }

    public static void after() {
        Data before = BEFORE.get();
        log.info("======== Done " + before.description + " ========");
        Assert.assertNotNull((Object)before);
        long curTime = System.currentTimeMillis();
        long limitTime = curTime + 60000L;
        while (true) {
            Set<Thread> leaked = ThreadCleanCheck.getThreads();
            leaked.removeAll(before.threads);
            if (leaked.isEmpty()) {
                return;
            }
            long remTime = limitTime - curTime;
            if (remTime <= 0L) {
                for (Thread thread : leaked) {
                    Throwable t = new Throwable("Stack trace");
                    t.setStackTrace(thread.getStackTrace());
                    log.error("-------- Leaked thread " + thread, t);
                }
                Assert.fail((String)"Leaked threads");
            }
            try {
                leaked.iterator().next().join(remTime);
            }
            catch (InterruptedException e) {
                Assert.fail((String)"Wait interrupted");
            }
            curTime = System.currentTimeMillis();
        }
    }

    @Nonnull
    public static Set<Thread> getThreads() {
        Thread[] a = new Thread[Thread.activeCount()];
        int n = Thread.enumerate(a);
        LinkedHashSet<Thread> result = new LinkedHashSet<Thread>(Arrays.asList(a).subList(0, n));
        return result;
    }

    private static class Data {
        final String description;
        final Set<Thread> threads;

        Data(String description, Set<Thread> threads) {
            this.description = description;
            this.threads = threads;
        }
    }
}

