/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.MathUtil;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilTest {
    private static final long P14 = 100000000000000L;

    @Test
    public void testRoundDecimal() {
        int power;
        Assert.assertNotEquals((double)0.9, (double)0.9000000000000001, (double)0.0);
        Assert.assertEquals((double)0.9, (double)MathUtil.roundDecimal((double)0.9000000000000001), (double)0.0);
        this.checkRound(0.0);
        this.checkRound(1.0);
        this.checkRound(-1.0);
        this.checkRound(Double.NaN);
        this.checkRound(Double.POSITIVE_INFINITY);
        this.checkRound(Double.NEGATIVE_INFINITY);
        this.checkRound(Double.MAX_VALUE);
        this.checkRound(-1.7976931348623157E308);
        this.checkRound(1.11111111111E11);
        this.checkRound(9.9999999999999E13);
        this.checkRound(-9.9999999999999E13);
        this.checkRound(0.99999999999999);
        this.checkRound(-0.99999999999999);
        this.checkRound(12345.123456789);
        this.checkRound(-12345.123456789);
        Assert.assertEquals((double)12345.123456789, (double)MathUtil.roundDecimal((double)12345.1234567894), (double)0.0);
        Assert.assertEquals((double)12345.12345679, (double)MathUtil.roundDecimal((double)12345.1234567896), (double)0.0);
        Assert.assertEquals((double)0.0, (double)MathUtil.roundDecimal((double)Double.MIN_VALUE), (double)0.0);
        Assert.assertEquals((double)-0.0, (double)MathUtil.roundDecimal((double)-4.9E-324), (double)0.0);
        Random r = new Random(20090102L);
        for (power = 0; power <= 14; ++power) {
            this.checkMantissaPower(r, 100000000000000L, power);
            this.checkMantissaPower(r, 1L, power);
            this.checkMantissaPower(r, -100000000000000L, power);
            this.checkMantissaPower(r, -1L, power);
        }
        for (power = 0; power <= 14; ++power) {
            this.checkMantissaPower(r, 99999999999999L, power);
            this.checkMantissaPower(r, -99999999999999L, power);
        }
        for (int i = 0; i < 1000; ++i) {
            long mantissa = r.nextLong() % 100000000000000L;
            int power2 = r.nextInt(15);
            this.checkMantissaPower(r, mantissa, power2);
        }
    }

    private void checkMantissaPower(Random r, long mantissa, int power) {
        long divisor = 1L;
        for (int j = 0; j < power; ++j) {
            divisor *= 10L;
        }
        double v = (double)mantissa / (double)divisor;
        this.checkRound(v);
        if (mantissa / 10000000000000L != 0L) {
            Assert.assertEquals((double)v, (double)MathUtil.roundDecimal((double)(v + (double)(r.nextInt(9) - 4) * 0.1 / (double)divisor)), (double)0.0);
        }
    }

    private void checkRound(double x) {
        Assert.assertEquals((double)x, (double)MathUtil.roundDecimal((double)x), (double)0.0);
    }

    @Test
    public void testIntDivRem() {
        int[] numbers;
        for (int a : numbers = new int[]{Integer.MIN_VALUE, -5, 0x7FFFFFF5}) {
            for (int b : numbers) {
                for (int i = 0; i < 10; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        this.checkIntDivRem(a + i, b + j);
                    }
                }
            }
        }
    }

    @Test
    public void testLongDivRem() {
        long[] numbers;
        for (long a : numbers = new long[]{Long.MIN_VALUE, -2147483653L, -5L, 0x7FFFFFFAL, 0x7FFFFFFFFFFFFFF5L}) {
            for (long b : numbers) {
                for (long i = 0L; i < 10L; ++i) {
                    for (long j = 0L; j < 10L; ++j) {
                        this.checkLongDivRem(a + i, b + j);
                    }
                }
            }
        }
    }

    private void checkIntDivRem(int a, int b) {
        if (b == 0) {
            Assert.assertThrows(ArithmeticException.class, () -> MathUtil.div((int)a, (int)b));
            Assert.assertThrows(ArithmeticException.class, () -> MathUtil.rem((int)a, (int)b));
        } else {
            int d = MathUtil.div((int)a, (int)b);
            int r = MathUtil.rem((int)a, (int)b);
            if (a != Integer.MIN_VALUE || b != -1) {
                Assert.assertEquals((double)a, (double)((double)b * (double)d + (double)r), (double)0.0);
            }
            Assert.assertEquals((long)a, (long)(b * d + r));
            Assert.assertTrue((r >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((b == Integer.MIN_VALUE || r < Math.abs(b) ? 1 : 0) != 0);
        }
    }

    private void checkLongDivRem(long a, long b) {
        if (b == 0L) {
            Assert.assertThrows(ArithmeticException.class, () -> MathUtil.div((long)a, (long)b));
            Assert.assertThrows(ArithmeticException.class, () -> MathUtil.rem((long)a, (long)b));
        } else {
            long d = MathUtil.div((long)a, (long)b);
            long r = MathUtil.rem((long)a, (long)b);
            if (a != Long.MIN_VALUE || b != -1L) {
                Assert.assertTrue((Math.abs((double)b * (double)d + (double)r - (double)a) <= 5.0 ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)a, (long)(b * d + r));
            Assert.assertTrue((r >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((b == Long.MIN_VALUE || r < Math.abs(b) ? 1 : 0) != 0);
        }
    }
}

