/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io;

import com.devexperts.io.Marshalled;
import com.devexperts.io.StringPrefixSet;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StringPrefixSetTest {
    StringPrefixSet list;

    @Test
    public void testIllegalArgumentException() {
        this.throwAndCatchException("*.devexperts.rmi.RMIEndpoint");
        this.throwAndCatchException("*.devexperts.*");
        this.throwAndCatchException("com.*.rmi.RMIEndpoint");
        this.throwAndCatchException("*;com.*.rmi.RMIEndpoint");
        this.throwAndCatchException("*;com.this;*.devexperts.rmi.RMIEndpoint");
        this.throwAndCatchException("*;com.this;*.devexperts.*");
        this.throwAndCatchException("*;com.this;com.*.rmi.RMIEndpoint");
        this.throwAndCatchException("*.devexperts.rmi.RMIEndpoint;*;com.this");
        this.throwAndCatchException("*.devexperts.*;*;com.this");
        this.throwAndCatchException("com.*.rmi.RMIEndpoint;*;com.this");
        this.throwAndCatchException("*", "com.this", "*.devexperts.rmi.RMIEndpoint;*", "com.this");
        this.throwAndCatchException("*", "com.this", "*.devexperts.*;*", "com.this");
        this.throwAndCatchException("*", "com.this", "com.*.rmi.RMIEndpoint;*", "com.this");
    }

    private void throwAndCatchException(String ... classes) {
        block2: {
            try {
                StringPrefixSet.valueOf(Arrays.asList(classes));
                Assert.fail();
            }
            catch (RuntimeException e) {
                if (e instanceof IllegalArgumentException) break block2;
                Assert.fail();
            }
        }
    }

    @Test
    public void testAnythingAndNothing() {
        this.list = StringPrefixSet.valueOf((String)"*");
        Assert.assertEquals((Object)this.list, (Object)StringPrefixSet.ANYTHING_SET);
        this.list = StringPrefixSet.valueOf(Arrays.asList("com.this", "String", "*", "java.lang.Math", "com.devexperts.*"));
        Assert.assertEquals((Object)this.list, (Object)StringPrefixSet.ANYTHING_SET);
        Assert.assertTrue((boolean)this.list.accept(String.class.getName()));
        Assert.assertTrue((boolean)this.list.accept(List.class.getName()));
        Assert.assertTrue((boolean)this.list.accept(Marshalled.class.getName()));
        this.list = StringPrefixSet.valueOf(Arrays.asList("com.this", ""));
        Assert.assertNotEquals((Object)StringPrefixSet.NOTHING_SET, (Object)this.list);
        this.list = StringPrefixSet.valueOf((String)"");
        Assert.assertEquals((Object)StringPrefixSet.NOTHING_SET, (Object)this.list);
        Assert.assertFalse((boolean)this.list.accept(String.class.getName()));
        Assert.assertFalse((boolean)this.list.accept(List.class.getName()));
        Assert.assertFalse((boolean)this.list.accept(Marshalled.class.getName()));
    }

    @Test
    public void testFullNames() {
        this.list = StringPrefixSet.valueOf((String)String.class.getName());
        Assert.assertTrue((boolean)this.list.accept(String.class.getName()));
        Assert.assertFalse((boolean)this.list.accept(List.class.getName()));
        this.list = StringPrefixSet.valueOf((String)Marshalled.class.getName());
        Assert.assertTrue((boolean)this.list.accept(Marshalled.class.getName()));
        Assert.assertFalse((boolean)this.list.accept(String.class.getName()));
        this.list = StringPrefixSet.valueOf(Arrays.asList(String.class.getName(), Marshalled.class.getName(), Object.class.getName(), Marshalled[].class.getName()));
        Assert.assertTrue((boolean)this.list.accept(String.class.getName()));
        Assert.assertFalse((boolean)this.list.accept(List.class.getName()));
        Assert.assertTrue((boolean)this.list.accept(Marshalled.class.getName()));
        Assert.assertTrue((boolean)this.list.accept(Object.class.getName()));
    }

    @Test
    public void testPrefixes() {
        this.list = StringPrefixSet.valueOf((String)"com.devexperts.io.*");
        Assert.assertFalse((boolean)this.list.accept("java.lang.String"));
        Assert.assertFalse((boolean)this.list.accept("java.util.List"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.Marshalled"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.IOUtil"));
        Assert.assertFalse((boolean)this.list.accept("com.devexperts.util.SerialContextClass"));
        Assert.assertFalse((boolean)this.list.accept("com.devexperts.Something"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.pack.Class"));
        this.list = StringPrefixSet.valueOf((String)"com.devexperts.*");
        Assert.assertFalse((boolean)this.list.accept("java.lang.String"));
        Assert.assertFalse((boolean)this.list.accept("java.util.List"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.Marshalled"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.IOUtil"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.util.SerialContextClass"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.Something"));
        Assert.assertFalse((boolean)this.list.accept("com.All"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.pack.Class"));
        this.list = StringPrefixSet.valueOf((String)";", (String)"com.devexperts.io.*;com.devexperts.util.*");
        Assert.assertFalse((boolean)this.list.accept("java.lang.String"));
        Assert.assertFalse((boolean)this.list.accept("java.util.List"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.Marshalled"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.IOUtil"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.util.SerialContextClass"));
        Assert.assertFalse((boolean)this.list.accept("com.devexperts.Something"));
        Assert.assertFalse((boolean)this.list.accept("com.devexperts.annotation.Description"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.pack.Class"));
    }

    @Test
    public void testPrefixesAndFullNames() {
        this.list = StringPrefixSet.valueOf((String)";", (String)"com.devexperts.io.*;com.devexperts.util.*;java.util.List;java.lang.*;java.util.concurrent.Executor");
        Assert.assertTrue((boolean)this.list.accept("java.lang.String"));
        Assert.assertTrue((boolean)this.list.accept("java.util.List"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.Marshalled"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.IOUtil"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.util.SerialContextClass"));
        Assert.assertFalse((boolean)this.list.accept("com.devexperts.Something"));
        Assert.assertTrue((boolean)this.list.accept("com.devexperts.io.pack.Class"));
        Assert.assertTrue((boolean)this.list.accept("java.util.concurrent.Executor"));
        Assert.assertFalse((boolean)this.list.accept("java.util.concurrent.ExecutorService"));
    }
}

