/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.io.test;

import com.devexperts.io.ByteArrayInput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import com.devexperts.io.ChunkedInput;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.io.test.TrackingChunkPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChunksTest {
    private Random rnd;
    private final TrackingChunkPool pool = new TrackingChunkPool();

    @Before
    public void setUp() {
        this.rnd = new Random(12345L);
        this.pool.checkAndClearCounters(0, 0, 0, 0);
    }

    @Test
    public void testChunk1() {
        Object owner = new Object();
        byte[] bytes = this.randomByteArray(100);
        Chunk chunk = Chunk.wrap((byte[])bytes, (Object)owner);
        Assert.assertEquals((long)0L, (long)chunk.getOffset());
        Assert.assertEquals((long)100L, (long)chunk.getLength());
        Assert.assertEquals((Object)bytes, (Object)chunk.getBytes());
        Assert.assertFalse((boolean)chunk.isReadOnly());
        chunk.setLength(0, owner);
        Assert.assertEquals((long)0L, (long)chunk.getLength());
        chunk.setRange(10, 80, owner);
        Assert.assertEquals((long)10L, (long)chunk.getOffset());
        Assert.assertEquals((long)80L, (long)chunk.getLength());
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> chunk.setLength(91, owner));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> chunk.setLength(-1, owner));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> chunk.setRange(2000000000, 2000000000, owner));
        Object newOwner = new Object();
        chunk.handOver(owner, newOwner);
        Assert.assertThrows(IllegalStateException.class, () -> chunk.setLength(10, owner));
        Assert.assertThrows(IllegalStateException.class, () -> chunk.setRange(10, 10, null));
        Assert.assertThrows(IllegalStateException.class, () -> chunk.markReadOnly(owner));
        Assert.assertThrows(IllegalStateException.class, () -> chunk.recycle(owner));
        Assert.assertThrows(IllegalStateException.class, () -> chunk.handOver(owner, newOwner));
        chunk.recycle(newOwner);
        Assert.assertThrows(IllegalStateException.class, () -> chunk.recycle(newOwner));
        Assert.assertThrows(IllegalStateException.class, () -> chunk.handOver(newOwner, (Object)this));
        Assert.assertThrows(IllegalStateException.class, () -> chunk.setLength(10, newOwner));
    }

    @Test
    public void testChunk2() {
        Object owner = new Object();
        byte[] bytes = this.randomByteArray(100);
        Chunk chunk = Chunk.wrap((byte[])bytes, (int)10, (int)20, (Object)owner);
        Assert.assertFalse((boolean)chunk.isReadOnly());
        chunk.markReadOnly(owner);
        Assert.assertTrue((boolean)chunk.isReadOnly());
        chunk.getBytes();
        Assert.assertThrows(IllegalStateException.class, () -> chunk.setLength(42, owner));
        Assert.assertThrows(IllegalStateException.class, () -> chunk.setRange(1, 2, owner));
        chunk.markReadOnly((Object)this);
        chunk.recycle((Object)"Now everyone owns this chunk,");
        chunk.handOver((Object)"even these two strings.", (Object)12345);
    }

    private byte[] randomByteArray(int n) {
        byte[] result = new byte[n];
        this.rnd.nextBytes(result);
        return result;
    }

    @Test
    public void testChunkList() {
        Object owner = new Object();
        ChunkList list = new ChunkList(owner);
        Assert.assertTrue((boolean)list.isEmpty());
        list.addAll(ChunkList.wrap((byte[])this.randomByteArray(10), (Object)owner), owner);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)10L, (long)list.getTotalLength());
        list.addAll(new ChunkList(owner), owner);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)10L, (long)list.getTotalLength());
        try {
            list.add(null, owner);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            list.addAll(null, owner);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            list.addAll(list, owner);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            list.get(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            list.handOver((Object)this, (Object)123);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.recycle(new Object());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.markReadOnly(null);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Object anotherOwner = new Object();
        Chunk anothersChunk = this.randomChunk(anotherOwner);
        this.pool.checkAndClearCounters(1, 0, 0, 0);
        try {
            list.add(anothersChunk, owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.add(anothersChunk, anotherOwner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        list.recycle(owner);
        try {
            list.recycle(owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.handOver(owner, anotherOwner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.markReadOnly(owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.add(this.randomChunk(owner), owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.pool.checkAndClearCounters(1, 0, 0, 0);
        try {
            list.addAll(new ChunkList(owner), owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.poll(owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.pollLast(owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        list = new ChunkList(owner);
        Chunk chunk = this.randomChunk(owner);
        this.pool.checkAndClearCounters(1, 0, 0, 0);
        list.add(chunk, owner);
        int l = chunk.getLength();
        Assert.assertEquals((long)l, (long)list.getTotalLength());
        int N = 10000;
        list.addAll(this.pool.copyToChunkList(this.randomByteArray(10000), 0, 10000, owner), owner);
        int k = this.pool.gc;
        this.pool.checkAndClearCounters(-1, 0, 1, 1);
        Assert.assertEquals((long)(k + 1), (long)list.size());
        Assert.assertSame((Object)chunk, (Object)list.get(0));
        try {
            chunk.recycle(owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.pool.checkAndClearCounters(0, 1, 0, 0);
        list.poll(owner);
        Assert.assertEquals((long)k, (long)list.size());
        chunk.recycle(owner);
        this.pool.checkAndClearCounters(0, 1, 0, 0);
        list.handOver(owner, anotherOwner);
        Assert.assertFalse((boolean)list.isReadOnly());
        list.markReadOnly(anotherOwner);
        Assert.assertTrue((boolean)list.isReadOnly());
        for (Chunk c : list) {
            Assert.assertTrue((boolean)c.isReadOnly());
        }
        list.recycle((Object)"someone");
        list.markReadOnly((Object)"someone else");
        list.handOver((Object)"yet someone else", (Object)555);
        this.pool.checkAndClearCounters(0, 0, 0, 0);
        try {
            list.add(Chunk.wrap((byte[])new byte[0], (Object)anotherOwner), anotherOwner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            list.poll(owner);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ChunkList anotherList = this.pool.getChunkList(owner);
        this.pool.checkAndClearCounters(0, 0, 1, 0);
        anotherList.addAll(list, owner);
        Assert.assertEquals((long)k, (long)list.size());
        Assert.assertEquals((long)k, (long)anotherList.size());
        for (Chunk c : anotherList) {
            Assert.assertTrue((boolean)c.isReadOnly());
        }
        Assert.assertFalse((boolean)anotherList.isReadOnly());
        this.pool.checkAndClearCounters(0, 0, 0, 0);
        anotherList.recycle(owner);
        this.pool.checkAndClearCounters(0, 0, 0, 1);
    }

    @Test
    public void testChunkListAddPoll() {
        int N = 1000;
        Object owner = new Object();
        ChunkList list = this.pool.getChunkList(owner);
        this.pool.checkAndClearCounters(0, 0, 1, 0);
        LinkedList<Chunk> etalon = new LinkedList<Chunk>();
        int totalLen = 0;
        for (int counter = 0; counter < 1000; ++counter) {
            switch (this.rnd.nextInt(4)) {
                case 0: {
                    Chunk c = list.poll(owner);
                    if (c == null) {
                        Assert.assertTrue((boolean)etalon.isEmpty());
                        break;
                    }
                    Assert.assertSame(etalon.removeFirst(), (Object)c);
                    totalLen -= c.getLength();
                    c.recycle(owner);
                    this.pool.checkAndClearCounters(0, 1, 0, 0);
                    break;
                }
                case 1: {
                    Chunk c = list.pollLast(owner);
                    if (c == null) {
                        Assert.assertTrue((boolean)etalon.isEmpty());
                        break;
                    }
                    Assert.assertSame(etalon.removeLast(), (Object)c);
                    totalLen -= c.getLength();
                    c.recycle(owner);
                    this.pool.checkAndClearCounters(0, 1, 0, 0);
                    break;
                }
                default: {
                    Chunk c = this.randomChunk(owner);
                    list.add(c, owner);
                    etalon.add(c);
                    totalLen += c.getLength();
                    this.pool.checkAndClearCounters(1, 0, 0, 0);
                    break;
                }
            }
            Assert.assertEquals((long)etalon.size(), (long)list.size());
            Assert.assertEquals((long)totalLen, (long)list.getTotalLength());
            ChunksTest.assertHaveSameContents(etalon.iterator(), list.iterator());
        }
        Object anotherOwner = new Object();
        ChunkList anotherList = new ChunkList(anotherOwner);
        list.handOver(owner, anotherOwner);
        anotherList.addAll(list, anotherOwner);
        this.pool.checkAndClearCounters(0, 0, 0, 1);
        Assert.assertEquals((long)totalLen, (long)anotherList.getTotalLength());
        ChunksTest.assertHaveSameContents(etalon.iterator(), anotherList.iterator());
        anotherList.recycle(anotherOwner);
        this.pool.checkAndClearCounters(0, etalon.size(), 0, 0);
    }

    private static void assertHaveSameContents(Iterator<Chunk> i1, Iterator<Chunk> i2) {
        while (i1.hasNext()) {
            Assert.assertSame((Object)i1.next(), (Object)i2.next());
        }
        Assert.assertFalse((boolean)i2.hasNext());
    }

    private Chunk randomChunk(Object owner) {
        Chunk result = this.pool.getChunk(owner);
        int len = this.rnd.nextInt(result.getLength() + 1);
        int off = this.rnd.nextInt(result.getLength() + 1 - len);
        this.rnd.nextBytes(result.getBytes());
        result.setRange(off, len, owner);
        return result;
    }

    @Test
    public void testChunkedInputOutput() throws IOException {
        int N = 1000000;
        int K = 30;
        int M = 60;
        ChunkedOutput out = new ChunkedOutput((ChunkPool)this.pool);
        byte[] data = new byte[1000030];
        ArrayList<ChunkList> chunkLists = new ArrayList<ChunkList>();
        int curLen = 0;
        int totalLen = 0;
        block31: while (totalLen + curLen < 1000000) {
            int op = this.rnd.nextInt(7);
            switch (op) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int l = this.rnd.nextInt(31);
                    for (int i = 0; i < l; ++i) {
                        data[totalLen + curLen + i] = (byte)this.rnd.nextInt(256);
                    }
                    switch (op) {
                        case 0: {
                            out.write(data, totalLen + curLen, l);
                            break;
                        }
                        case 1: {
                            out.writeFromByteBuffer(ByteBuffer.wrap(data, totalLen + curLen, l));
                            break;
                        }
                        case 2: {
                            out.writeFromDataInput((DataInput)new ByteArrayInput(data, totalLen + curLen, l), (long)l);
                            break;
                        }
                        case 3: {
                            int decision = this.rnd.nextInt(3);
                            int baiLen = decision == 0 ? l + 1 : l;
                            int writeLim = decision == 1 ? l + 1 : l;
                            Assert.assertEquals((long)l, (long)out.writeFromInputStream((InputStream)new ByteArrayInput(data, totalLen + curLen, baiLen), (long)writeLim));
                        }
                    }
                    curLen += l;
                    continue block31;
                }
                case 4: {
                    long l = this.rnd.nextInt(31);
                    long res = out.discard(l);
                    Assert.assertEquals((long)Math.min(l, (long)curLen), (long)res);
                    curLen = (int)((long)curLen - res);
                    continue block31;
                }
                case 5: {
                    ChunkList output = out.getOutput((Object)this);
                    if (output == null) {
                        Assert.assertEquals((long)0L, (long)curLen);
                        continue block31;
                    }
                    chunkLists.add(output);
                    totalLen += curLen;
                    curLen = 0;
                    continue block31;
                }
                case 6: {
                    out.clear();
                    curLen = 0;
                    continue block31;
                }
            }
            throw new AssertionError((Object)"fix nextInt argument");
        }
        ChunkList output = out.getOutput((Object)this);
        if (output == null) {
            Assert.assertEquals((long)0L, (long)curLen);
        } else {
            chunkLists.add(output);
            totalLen += curLen;
        }
        Collections.reverse(chunkLists);
        Chunk emptyChunk = this.pool.getChunk(this);
        emptyChunk.setRange(10, 0, (Object)this);
        ((ChunkList)chunkLists.get(chunkLists.size() / 2)).add(emptyChunk, (Object)this);
        int roc = 0;
        int rol = 0;
        for (ChunkList chunks : chunkLists) {
            if (!this.rnd.nextBoolean()) continue;
            chunks.markReadOnly((Object)this);
            roc += chunks.size();
            ++rol;
        }
        ChunkedInput in = new ChunkedInput();
        Assert.assertTrue((boolean)in.markSupported());
        byte[] d = new byte[30];
        ByteBuffer bb = ByteBuffer.wrap(d);
        ByteArrayOutput bao = new ByteArrayOutput(0);
        bao.setBuffer(d);
        int position = 0;
        int limit = 0;
        boolean markState = false;
        int markPoint = 0;
        while (position < totalLen) {
            int op = this.rnd.nextInt(10);
            switch (op) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    int res;
                    int l = this.rnd.nextInt(31);
                    switch (op) {
                        case 0: {
                            res = in.read(d, 0, l);
                            if (res != -1) break;
                            res = 0;
                            break;
                        }
                        case 1: {
                            bb.clear();
                            bb.limit(l);
                            in.readToByteBuffer(bb);
                            res = bb.position();
                            break;
                        }
                        case 2: {
                            bao.clear();
                            bao.setLimit(l);
                            res = (int)in.readToDataOutput((DataOutput)bao, (long)l);
                            break;
                        }
                        case 3: {
                            bao.clear();
                            bao.setLimit(l);
                            res = (int)in.readToOutputStream((OutputStream)bao, (long)l);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    if (Math.min(l, limit - position) != res) {
                        Assert.fail((String)ChunksTest.makeDebugStr(op, position, limit, markState, markPoint, l, res));
                    }
                    for (int i = 0; i < res; ++i) {
                        if (data[position + i] == d[i]) continue;
                        Assert.fail((String)ChunksTest.makeDebugStr(op, position, limit, markState, markPoint, l, res));
                    }
                    position += res;
                    break;
                }
                case 4: {
                    int l = this.rnd.nextInt(31);
                    int res = (int)in.skip((long)l);
                    if (Math.min(l, limit - position) != res) {
                        Assert.fail((String)ChunksTest.makeDebugStr(op, position, limit, markState, markPoint, l, res));
                    }
                    position += res;
                    break;
                }
                case 5: {
                    int l = this.rnd.nextInt(31);
                    try {
                        in.rewind((long)l);
                        Assert.assertTrue((markState && position - l >= markPoint ? 1 : 0) != 0);
                        position -= l;
                    }
                    catch (IllegalStateException e) {
                        Assert.assertTrue((!markState || position - l < markPoint ? 1 : 0) != 0);
                    }
                    break;
                }
                case 6: {
                    if (markState) {
                        in.unmark();
                        markState = false;
                        markPoint = -1;
                        break;
                    }
                    in.mark();
                    markState = true;
                    markPoint = position;
                    break;
                }
                case 7: {
                    if (chunkLists.isEmpty()) break;
                    ChunkList chunks = (ChunkList)chunkLists.remove(chunkLists.size() - 1);
                    limit = (int)((long)limit + chunks.getTotalLength());
                    in.addAllToInput(chunks, (Object)this);
                    break;
                }
                case 8: {
                    in.clear();
                    position = limit;
                    markState = false;
                    break;
                }
                case 9: {
                    try {
                        in.reset();
                        Assert.assertTrue((boolean)markState);
                        position = markPoint;
                    }
                    catch (IllegalStateException e) {
                        Assert.assertFalse((boolean)markState);
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)"fix nextInt argument");
                }
            }
            if (position > limit) {
                Assert.fail((String)ChunksTest.makeDebugStr(op, position, limit, markState, markPoint, 0, 0));
            }
            if (in.available() != limit - position) {
                Assert.fail((String)ChunksTest.makeDebugStr(op, position, limit, markState, markPoint, 0, 0));
            }
            if (limit > position == in.hasAvailable()) continue;
            Assert.fail((String)ChunksTest.makeDebugStr(op, position, limit, markState, markPoint, 0, 0));
        }
        if (markState) {
            in.unmark();
        }
        Assert.assertEquals((long)this.pool.gc, (long)(this.pool.rc + roc));
        Assert.assertEquals((long)this.pool.gl, (long)(this.pool.rl + rol));
        this.pool.clearCounters();
    }

    private static String makeDebugStr(int op, int position, int limit, boolean markState, int markPoint, int l, int res) {
        return "op=" + op + " pos=" + position + " lim=" + limit + " ms=" + markState + " mp=" + markPoint + " l=" + l + " res=" + res;
    }
}

