/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.Base64;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class Base64Test {
    @Test
    public void testBase64() {
        Assert.assertThrows(Exception.class, () -> new Base64("short alphabet"));
        Assert.assertThrows(Exception.class, () -> new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789++="));
        Assert.assertThrows(Exception.class, () -> new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/+"));
        this.doTest(Base64.DEFAULT);
        this.doTest(Base64.URLSAFE);
        this.doTest(new Base64("EZ7KG_r4d0-SUQnzmiFawucD6YCpfVqWeo1T35OIxyMh9jsNvJAPkB2Lglt8XHRb+"));
    }

    private void doTest(Base64 basePadded) {
        char pad = basePadded.getAlphabet().charAt(64);
        Base64 baseUnpadded = new Base64(basePadded.getAlphabet().substring(0, 64));
        Random r = new Random();
        for (int i = 0; i < 1000; ++i) {
            byte[] unpadded;
            byte[] padded;
            byte[] src = new byte[r.nextInt(100)];
            r.nextBytes(src);
            String strPadded = basePadded.encode(src);
            String strUnpadded = baseUnpadded.encode(src);
            if (strUnpadded.indexOf(pad) >= 0) {
                Assert.fail((String)(basePadded.getAlphabet() + " for " + Arrays.toString(src) + ": " + strUnpadded + " contains pad"));
            }
            StringBuilder sb = new StringBuilder(strUnpadded);
            while (sb.length() < strPadded.length()) {
                sb.append(pad);
            }
            if (!strPadded.equals(sb.toString())) {
                Assert.fail((String)(basePadded.getAlphabet() + " for " + Arrays.toString(src) + ": " + strPadded + " does not extend " + strUnpadded));
            }
            if (!Arrays.equals(src, padded = basePadded.decode(strPadded))) {
                Assert.fail((String)(basePadded.getAlphabet() + " for " + Arrays.toString(src) + ": padded " + strPadded + " decodes to " + Arrays.toString(padded)));
            }
            if (Arrays.equals(src, unpadded = baseUnpadded.decode(strUnpadded))) continue;
            Assert.fail((String)(basePadded.getAlphabet() + " for " + Arrays.toString(src) + ": unpadded " + strUnpadded + " decodes to " + Arrays.toString(unpadded)));
        }
    }
}

