/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util.test;

import com.devexperts.util.DayUtil;
import com.devexperts.util.TimeUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class DayUtilTest {
    @Test
    public void testDayIds() {
        Assert.assertEquals((long)0L, (long)DayUtil.getDayIdByYearMonthDay((int)1970, (int)1, (int)1));
        Assert.assertEquals((long)0L, (long)DayUtil.getDayIdByYearMonthDay((int)19700101));
        Assert.assertEquals((long)19700101L, (long)DayUtil.getYearMonthDayByDayId((int)0));
        Random r = new Random(1L);
        int minYear = -9999;
        int maxYear = 9999;
        for (int i = 0; i < 100000; ++i) {
            int year = minYear + r.nextInt(maxYear - minYear + 1);
            int month = 1 + r.nextInt(12);
            GregorianCalendar cal = new GregorianCalendar(TimeUtil.getTimeZoneGmt());
            cal.setGregorianChange(new Date(Long.MIN_VALUE));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, 1);
            int day = 1 + r.nextInt(cal.getActualMaximum(5));
            cal.set(5, day);
            int yearSign = year < 0 ? -1 : 1;
            int ymd = yearSign * (Math.abs(year) * 10000 + month * 100 + day);
            String ymdString = "day " + ymd;
            long millis = cal.getTimeInMillis();
            Assert.assertEquals((long)year, (long)(cal.get(0) == 1 ? (long)cal.get(1) : (long)(1 - cal.get(1))));
            Assert.assertEquals((long)month, (long)(cal.get(2) + 1));
            Assert.assertEquals((long)day, (long)cal.get(5));
            Assert.assertEquals((long)0L, (long)(millis % 86400000L));
            int dayId = (int)(millis / 86400000L);
            Assert.assertEquals((String)ymdString, (long)dayId, (long)DayUtil.getDayIdByYearMonthDay((int)year, (int)month, (int)day));
            Assert.assertEquals((String)ymdString, (long)dayId, (long)DayUtil.getDayIdByYearMonthDay((int)ymd));
            Assert.assertEquals((String)ymdString, (long)ymd, (long)DayUtil.getYearMonthDayByDayId((int)dayId));
        }
    }
}

